/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.api.ProgressDisplayer;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.java.ProfilerTypeUtils;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.selector.api.SelectionTreeBuilderFactory;
import org.netbeans.modules.profiler.selector.api.SelectionTreeBuilderType;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.ui.RootSelectorTree;
import org.netbeans.modules.profiler.selector.ui.TreePathSearch;
import org.netbeans.modules.profiler.ui.ProfilerProgressDisplayer;
import org.netbeans.modules.profiler.ui.panels.Bundle;
import org.netbeans.modules.profiler.ui.panels.ProjectSelectorPanel;
import org.netbeans.modules.profiler.ui.panels.RootMethodsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class ProjectSelectRootMethodsPanel
extends JPanel
implements HelpCtx.Provider {
    private static final Logger LOG = Logger.getLogger(ProjectSelectRootMethodsPanel.class.getName());
    private static ProjectSelectRootMethodsPanel instance = null;
    protected static final Dimension PREFERRED_TOPTREE_DIMENSION = new Dimension(500, 250);
    private HTMLTextArea hintArea;
    private JButton okButton;
    private JComboBox treeBuilderList;
    private Lookup.Provider currentProject;
    private List<Lookup.Provider> additionalProjects = new ArrayList<Lookup.Provider>();
    private RequestProcessor rp = new RequestProcessor("SRM-UI Processor", 1);
    private RootSelectorTree pkgTreeView;
    private JButton additionalProjectsSelector;
    private volatile boolean changingBuilderList = false;
    private static final String HELP_CTX_KEY = "ProjectSelectRootMethodsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ProjectSelectRootMethodsPanel.HelpCtx");
    private static final String PROP_PROJECTLIST = "projectList";
    private static final String PROPS_FILE_NAME = "root_selector.properties";

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static synchronized ProjectSelectRootMethodsPanel getDefault() {
        if (instance == null) {
            Runnable initializer = new Runnable(){

                @Override
                public void run() {
                    instance = new ProjectSelectRootMethodsPanel();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                initializer.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(initializer);
                }
                catch (Exception e) {
                    initializer.run();
                }
            }
        }
        return instance;
    }

    private ProjectSelectRootMethodsPanel() {
        this.initComponents(this);
    }

    public static boolean canBeShown(Lookup ctx) {
        return RootSelectorTree.canBeShown((Lookup)ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientUtils.SourceCodeSelection[] getRootMethods(Lookup.Provider project, final ClientUtils.SourceCodeSelection[] currentSelection) {
        if (project == null) {
            return RootMethodsPanel.getSelectedRootMethods(currentSelection, project);
        }
        this.currentProject = project;
        this.unpersist();
        this.pkgTreeView.reset();
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProjectSelectRootMethodsPanel.this.refreshBuilderList();
            }
        };
        try {
            this.pkgTreeView.addPropertyChangeListener("SELECTION_TREE_VIEW_LIST", pcl);
            this.updateSelector(new Runnable(){

                @Override
                public void run() {
                    ProjectSelectRootMethodsPanel.this.pkgTreeView.setSelection(currentSelection, ProjectSelectRootMethodsPanel.this.getContext());
                }
            });
            if (this.pkgTreeView.getBuilderTypes().isEmpty()) {
                LOG.fine(Bundle.SelectRootMethodsPanel_NoSelectionProviders_MSG());
                ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = RootMethodsPanel.getSelectedRootMethods(currentSelection, project);
                return sourceCodeSelectionArray;
            }
            final DialogDescriptor dd = new DialogDescriptor((Object)this, Bundle.SelectRootMethodsPanel_Title(), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
            Object[] additionalOptions = this.getAdditionalOptions();
            if (additionalOptions != null && additionalOptions.length > 0) {
                dd.setAdditionalOptions(additionalOptions);
            }
            final Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            Cancellable c = new Cancellable(){

                public boolean cancel() {
                    dd.setValue(DialogDescriptor.CANCEL_OPTION);
                    d.setVisible(false);
                    ProjectSelectRootMethodsPanel.this.pkgTreeView.setCancelHandler(null);
                    return true;
                }
            };
            this.pkgTreeView.setCancelHandler(c);
            d.pack();
            d.setVisible(true);
            ClientUtils.SourceCodeSelection[] selection = this.pkgTreeView.getSelection();
            if (dd.getValue().equals(this.okButton)) {
                this.persist();
                ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = selection;
                return sourceCodeSelectionArray;
            }
            this.currentProject = null;
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = null;
            return sourceCodeSelectionArray;
        }
        finally {
            this.pkgTreeView.removePropertyChangeListener("SELECTION_TREE_VIEW_LIST", pcl);
        }
    }

    protected void initComponents(Container container) {
        this.additionalProjectsSelector = new JButton(Bundle.LBL_EditProjects());
        Mnemonics.setLocalizedText((AbstractButton)this.additionalProjectsSelector, (String)Bundle.LBL_EditProjects());
        this.okButton = new JButton(Bundle.SelectRootMethodsPanel_OkButtonText());
        ProfilerProgressDisplayer pd = ProfilerProgressDisplayer.getDefault();
        this.pkgTreeView = new RootSelectorTree((ProgressDisplayer)pd, new TreePathSearch.ClassIndex(){

            public List<SourceClassInfo> getClasses(String pattern, Lookup context) {
                Lookup.Provider project = (Lookup.Provider)context.lookup(Lookup.Provider.class);
                if (project != null) {
                    ArrayList srcClzs = new ArrayList(ProfilerTypeUtils.findClasses((String)pattern, EnumSet.of(SourcePackageInfo.Scope.SOURCE), (Lookup.Provider)project));
                    ArrayList libClzs = new ArrayList(ProfilerTypeUtils.findClasses((String)pattern, EnumSet.of(SourcePackageInfo.Scope.DEPENDENCIES), (Lookup.Provider)project));
                    Collections.sort(srcClzs, SourceClassInfo.COMPARATOR);
                    Collections.sort(libClzs, SourceClassInfo.COMPARATOR);
                    ArrayList<SourceClassInfo> scis = new ArrayList<SourceClassInfo>(srcClzs);
                    scis.addAll(libClzs);
                    return scis;
                }
                return Collections.EMPTY_LIST;
            }
        });
        this.additionalProjectsSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectSelectorPanel psp = new ProjectSelectorPanel(){

                    @Override
                    protected Lookup.Provider getCurrentProject() {
                        return ProjectSelectRootMethodsPanel.this.currentProject;
                    }
                };
                psp.setSelection(ProjectSelectRootMethodsPanel.this.additionalProjects);
                DialogDescriptor dd = new DialogDescriptor((Object)psp, Bundle.TIT_EditProjects());
                Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                d.setVisible(true);
                if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                    ProjectSelectRootMethodsPanel.this.additionalProjects = psp.getSelection();
                    ProjectSelectRootMethodsPanel.this.updateSelectorProjects();
                }
            }
        });
        this.treeBuilderList = new JComboBox();
        this.treeBuilderList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(final ItemEvent e) {
                if (ProjectSelectRootMethodsPanel.this.changingBuilderList) {
                    return;
                }
                if (e.getStateChange() == 1) {
                    ProjectSelectRootMethodsPanel.this.rp.post(new Runnable(){

                        @Override
                        public void run() {
                            ProjectSelectRootMethodsPanel.this.pkgTreeView.setBuilderType((SelectionTreeBuilderType)e.getItem());
                        }
                    });
                }
            }
        });
        container.setLayout(new GridBagLayout());
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        this.pkgTreeView.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.pkgTreeView.setPreferredSize(PREFERRED_TOPTREE_DIMENSION);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 10, 0, 10);
        container.add((Component)this.pkgTreeView, gridBagConstraints);
        JPanel comboPanel = new JPanel();
        comboPanel.setLayout(new BoxLayout(comboPanel, 0));
        JLabel label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)Bundle.SelectRootMethodsPanel_SelectViewLabel());
        label.setLabelFor(this.treeBuilderList);
        comboPanel.add(label);
        comboPanel.add(this.treeBuilderList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        container.add((Component)comboPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        container.add((Component)this.additionalProjectsSelector, gridBagConstraints);
        String hintString = this.getHintString();
        if (hintString != null && hintString.length() > 0) {
            Color panelBackground = UIManager.getColor("Panel.background");
            Color hintBackground = UIUtils.getSafeColor((int)(panelBackground.getRed() - 10), (int)(panelBackground.getGreen() - 10), (int)(panelBackground.getBlue() - 10));
            this.hintArea.setText(hintString);
            this.hintArea.setEnabled(false);
            this.hintArea.setDisabledTextColor(Color.darkGray);
            this.hintArea.setBackground(hintBackground);
            this.hintArea.setBorder((Border)BorderFactory.createMatteBorder(10, 10, 10, 10, hintBackground));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            container.add((Component)this.hintArea, gridBagConstraints);
        }
    }

    private Object[] getAdditionalOptions() {
        JButton button = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        final ClientUtils.SourceCodeSelection[] methods = RootMethodsPanel.getSelectedRootMethods(ProjectSelectRootMethodsPanel.this.pkgTreeView.getSelection(), ProjectSelectRootMethodsPanel.this.currentProject);
                        if (methods != null) {
                            ProjectSelectRootMethodsPanel.this.updateSelector(new Runnable(){

                                @Override
                                public void run() {
                                    ProjectSelectRootMethodsPanel.this.pkgTreeView.setSelection(methods, ProjectSelectRootMethodsPanel.this.getContext());
                                }
                            });
                        }
                    }
                });
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)button, (String)Bundle.SelectRootMethodsPanel_AdvancedButtonText());
        return new Object[]{button};
    }

    private String getHintString() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshBuilderList() {
        List builderTypes = this.pkgTreeView.getBuilderTypes();
        if (builderTypes == null || builderTypes.isEmpty()) {
            return;
        }
        try {
            this.changingBuilderList = true;
            this.treeBuilderList.setModel(new DefaultComboBoxModel<SelectionTreeBuilderType>(builderTypes.toArray(new SelectionTreeBuilderType[builderTypes.size()])));
            this.treeBuilderList.setSelectedIndex(0);
            this.pkgTreeView.setBuilderType((SelectionTreeBuilderType)this.treeBuilderList.getItemAt(0));
        }
        finally {
            this.changingBuilderList = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelector(Runnable updater) {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)Bundle.SelectRootMethodsPanel_ParsingProjectStructureMessage());
        CommonUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ph.setInitialDelay(500);
                ph.start();
            }
        });
        try {
            this.treeBuilderList.setEnabled(false);
            this.pkgTreeView.setEnabled(false);
            this.okButton.setEnabled(false);
            updater.run();
        }
        finally {
            ph.finish();
            this.okButton.setEnabled(true);
            this.pkgTreeView.setEnabled(true);
            this.treeBuilderList.setEnabled(true);
        }
    }

    private void updateSelectorProjects() {
        this.updateSelector(new Runnable(){

            @Override
            public void run() {
                ProjectSelectRootMethodsPanel.this.pkgTreeView.setContext(ProjectSelectRootMethodsPanel.this.getContext());
            }
        });
    }

    private Lookup getContext() {
        ArrayList builders = new ArrayList();
        if (this.currentProject != null) {
            builders.addAll(SelectionTreeBuilderFactory.buildersFor((Lookup.Provider)this.currentProject));
        }
        for (Lookup.Provider p : this.additionalProjects) {
            builders.addAll(SelectionTreeBuilderFactory.buildersFor((Lookup.Provider)p));
        }
        return Lookups.fixed((Object[])builders.toArray(new SelectionTreeBuilder[builders.size()]));
    }

    private void persist() {
        Properties props = this.loadProjectProperties();
        if (props != null) {
            StringBuilder sb = new StringBuilder();
            for (Lookup.Provider p : this.additionalProjects) {
                sb.append(ProjectUtilities.getProjectDirectory((Lookup.Provider)p).getPath()).append(File.pathSeparator);
            }
            props.setProperty(PROP_PROJECTLIST, sb.toString());
            this.saveProjectProperties(props);
            this.additionalProjects.clear();
        }
    }

    private void unpersist() {
        Properties props = this.loadProjectProperties();
        if (props != null) {
            this.additionalProjects.clear();
            String data = props.getProperty(PROP_PROJECTLIST, "");
            StringTokenizer st = new StringTokenizer(data, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String dir = st.nextToken();
                FileObject pDir = FileUtil.toFileObject((File)new File(dir));
                Lookup.Provider p = ProjectUtilities.getProject((FileObject)pDir);
                this.additionalProjects.add(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProjectProperties() {
        InputStream is = null;
        try {
            Properties p = new Properties();
            is = this.getProjectPropertiesFile().getInputStream();
            p.load(is);
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProjectProperties(Properties props) {
        OutputStream os = null;
        try {
            os = this.getProjectPropertiesFile().getOutputStream();
            props.store(os, "");
        }
        catch (IOException e) {
        }
        finally {
            try {
                os.close();
            }
            catch (Exception e) {}
        }
    }

    private FileObject getProjectPropertiesFile() throws IOException {
        FileObject propsFolder = ProjectStorage.getSettingsFolder((Lookup.Provider)this.currentProject, (boolean)true);
        FileObject propsFile = propsFolder.getFileObject(PROPS_FILE_NAME);
        if (propsFile == null) {
            propsFile = propsFolder.createData(PROPS_FILE_NAME);
        }
        return propsFile;
    }
}

