/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.io.IOException;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.TaskConfigurator;
import org.netbeans.modules.profiler.api.project.ProjectProfilingSupport;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.ui.panels.PIDSelectPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class ProfilingSupport {
    public static final String RERUN_PROP = "profiler.rerun";
    private static ProfilingSupport defaultInstance;
    private boolean profilingActionInvoked = false;

    private ProfilingSupport() {
    }

    public static synchronized ProfilingSupport getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfilingSupport();
        }
        return defaultInstance;
    }

    public boolean checkProfilingInProgress() {
        Profiler profiler = Profiler.getDefault();
        int state = profiler.getProfilingState();
        int mode = profiler.getProfilingMode();
        if (state == 8 || state == 4) {
            if (mode == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilingSupport_StopStartProfileSessionMessage(), (String)Bundle.CAPTION_Question())) {
                    return true;
                }
                profiler.stopApp();
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilingSupport_StopStartAttachSessionMessage(), (String)Bundle.CAPTION_Question())) {
                    return true;
                }
                profiler.detachFromApp();
            }
        }
        return false;
    }

    public int selectApplicationPid() {
        return PIDSelectPanel.selectPID();
    }

    public AttachSTPData selectTaskForAttach(Lookup.Provider project, SessionSettings sessionSettings) {
        TaskConfigurator.Configuration configuration = TaskConfigurator.getDefault().configureAttachProfilerTask(project);
        if (configuration == null) {
            return null;
        }
        return new AttachSTPData(configuration.getProfilingSettings(), configuration.getProject());
    }

    public ProfilingSettings selectTaskForProfiling(Lookup.Provider project, SessionSettings sessionSettings, FileObject profiledFile, boolean enableOverride) {
        TaskConfigurator.Configuration configuration = TaskConfigurator.getDefault().configureProfileProjectTask(project, profiledFile, enableOverride);
        if (configuration == null) {
            return null;
        }
        return configuration.getProfilingSettings();
    }

    public void setProfilingActionInvoked(boolean pai) {
        this.profilingActionInvoked = pai;
    }

    public boolean isProfilingActionInvoked() {
        return this.profilingActionInvoked;
    }

    void doAttach() {
        if (this.isProfilingActionInvoked()) {
            return;
        }
        this.setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (ProfilingSupport.this.checkProfilingInProgress()) {
                        return;
                    }
                    Lookup.Provider project = null;
                    Profiler profiler = Profiler.getDefault();
                    GlobalProfilingSettings gps = profiler.getGlobalProfilingSettings();
                    SessionSettings ss = new SessionSettings();
                    ss.setPortNo(gps.getPortNo());
                    ProjectProfilingSupport pps = ProjectProfilingSupport.get(project);
                    pps.setupProjectSessionSettings(ss);
                    boolean settingsAccepted = false;
                    ProfilingSettings ps = null;
                    while (!settingsAccepted) {
                        AttachSTPData asd = ProfilingSupport.this.selectTaskForAttach(project, ss);
                        if (asd == null) {
                            return;
                        }
                        project = asd.getProject();
                        ps = asd.getSettings();
                        ProfilerLogger.log((String)(">>> Project: " + project));
                        ProfilerLogger.log((String)(">>> Profiling settings: " + ps));
                        settingsAccepted = true;
                    }
                    ((NetBeansProfiler)profiler).setProfiledProject(project, null);
                    AttachSettings as = null;
                    try {
                        as = ProjectStorage.loadAttachSettings(project);
                    }
                    catch (IOException e) {
                        ProfilerDialogs.displayWarning((String)Bundle.ProfilingSupport_FailedLoadSettingsMsg(e.getMessage()));
                        ProfilerLogger.log((Exception)e);
                    }
                    ProfilerLogger.log((String)(">>> Attach settings: " + as));
                    if (as == null) {
                        as = AttachWizard.getDefault().configure(as);
                        if (as == null) {
                            return;
                        }
                        ProjectStorage.saveAttachSettings((Lookup.Provider)project, (AttachSettings)as);
                    }
                    if (!as.isRemote() && as.isDynamic16()) {
                        int pid = ProfilingSupport.this.selectApplicationPid();
                        if (pid == -1) {
                            return;
                        }
                        as.setPid(pid);
                    }
                    profiler.attachToApp(ps, as);
                }
                finally {
                    ProfilingSupport.this.setProfilingActionInvoked(false);
                }
            }
        });
    }

    void modifyProfiling() {
        if (this.isProfilingActionInvoked()) {
            return;
        }
        this.setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NetBeansProfiler profiler = NetBeansProfiler.getDefaultNB();
                TargetAppRunner targetAppRunner = profiler.getTargetAppRunner();
                try {
                    boolean attach = profiler.getProfilingMode() == 0;
                    targetAppRunner.getAppStatusHandler().pauseLiveUpdates();
                    ProfilingSettings settings = ProfilingSupport.this.selectTaskForProfiling(profiler.getProfiledProject(), null, profiler.getProfiledSingleFile(), attach);
                    if (settings == null) {
                        return;
                    }
                    profiler.modifyCurrentProfiling(settings);
                }
                finally {
                    ProfilingSupport.this.setProfilingActionInvoked(false);
                    targetAppRunner.getAppStatusHandler().resumeLiveUpdates();
                }
            }
        });
    }

    public static class AttachSTPData {
        private ProfilingSettings ps;
        private Lookup.Provider p;

        private AttachSTPData(ProfilingSettings ps, Lookup.Provider p) {
            this.ps = ps;
            this.p = p;
        }

        public Lookup.Provider getProject() {
            return this.p;
        }

        public ProfilingSettings getSettings() {
            return this.ps;
        }
    }
}

