/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class LoadSnapshotAction
extends AbstractAction {
    private static File importDir;

    public LoadSnapshotAction() {
        this.putValue("ShortDescription", Bundle.LoadSnapshotAction_ActionDescr());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.loadSnapshot(false);
    }

    public void loadSnapshotOrHeapdump() {
        this.loadSnapshot(true);
    }

    private void loadSnapshot(final boolean handleHeapdumps) {
        JFileChooser chooser = new JFileChooser();
        if (importDir != null) {
            chooser.setCurrentDirectory(importDir);
        }
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogType(0);
        chooser.setDialogTitle(handleHeapdumps ? Bundle.LoadSnapshotAction_OpenSnapshotHeapdumpDialogCaption() : Bundle.LoadSnapshotAction_OpenSnapshotDialogCaption());
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fname = f.getName();
                if (fname.endsWith(".nps")) {
                    return true;
                }
                if (fname.endsWith(".npss")) {
                    return true;
                }
                return handleHeapdumps && fname.endsWith(".hprof");
            }

            @Override
            public String getDescription() {
                return handleHeapdumps ? Bundle.LoadSnapshotAction_ProfilerSnapshotHeapdumpFileFilter("nps", "hprof") : Bundle.LoadSnapshotAction_ProfilerSnapshotFileFilter("nps");
            }
        });
        if (chooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            File[] files = chooser.getSelectedFiles();
            ArrayList<FileObject> snapshotsFOArr = new ArrayList<FileObject>();
            final ArrayList<File> heapdumpsFArr = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String fname = file.getName();
                if (fname.endsWith(".nps") || fname.endsWith(".npss")) {
                    snapshotsFOArr.add(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)));
                    continue;
                }
                if (!fname.endsWith(".hprof")) continue;
                heapdumpsFArr.add(file);
            }
            if (!snapshotsFOArr.isEmpty()) {
                LoadedSnapshot[] imported = ResultsManager.getDefault().loadSnapshots(snapshotsFOArr.toArray(new FileObject[snapshotsFOArr.size()]));
                ResultsManager.getDefault().openSnapshots(imported);
            } else if (!handleHeapdumps) {
                ProfilerDialogs.displayError((String)Bundle.LoadSnapshotAction_No_Snapshot_Selected());
            }
            if (!heapdumpsFArr.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        for (File heapDump : heapdumpsFArr) {
                            ResultsManager.getDefault().openSnapshot(heapDump);
                        }
                    }
                });
            }
            importDir = chooser.getCurrentDirectory();
        }
    }
}

