/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.MemoryDiffPanel;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.actions.FindAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public final class SnapshotsDiffWindow
extends ProfilerTopComponent {
    private static final String HELP_CTX_KEY_MEM = "MemoryDiff.HelpCtx";
    private static HelpCtx HELP_CTX = new HelpCtx("MemoryDiff.HelpCtx");
    private static final Image WINDOW_ICON_MEMORY = Icons.getImage((String)"ProfilerIcons.SnapshotsCompare");

    public SnapshotsDiffWindow() {
        throw new InternalError("This constructor should never be called");
    }

    public SnapshotsDiffWindow(ResultsSnapshot ls, LoadedSnapshot snapshot1, LoadedSnapshot snapshot2, int sortingColumn, boolean sortingOrder, Lookup.Provider project) {
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        if (ls instanceof AllocMemoryResultsDiff) {
            this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotDiffWindow_AllocAccessDescr());
            this.displayMemoryAllocDiff((MemoryResultsSnapshot)((AllocMemoryResultsDiff)ls), snapshot1, snapshot2, sortingColumn, sortingOrder, project);
        } else if (ls instanceof LivenessMemoryResultsDiff) {
            this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotDiffWindow_LivenessAccessDescr());
            this.displayMemoryLivenessDiff((MemoryResultsSnapshot)((LivenessMemoryResultsDiff)ls), snapshot1, snapshot2, sortingColumn, sortingOrder, project);
        }
    }

    public static synchronized SnapshotsDiffWindow get(ResultsSnapshot ls, LoadedSnapshot snapshot1, LoadedSnapshot snapshot2) {
        return SnapshotsDiffWindow.get(ls, snapshot1, snapshot2, -1, false, null);
    }

    public static synchronized SnapshotsDiffWindow get(ResultsSnapshot ls, LoadedSnapshot snapshot1, LoadedSnapshot snapshot2, int sortingColumn, boolean sortingOrder, Lookup.Provider project) {
        return new SnapshotsDiffWindow(ls, snapshot1, snapshot2, sortingColumn, sortingOrder, project);
    }

    public int getPersistenceType() {
        return 2;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void displayMemoryAllocDiff(MemoryResultsSnapshot diff, LoadedSnapshot snapshot1, LoadedSnapshot snapshot2, int sortingColumn, boolean sortingOrder, Lookup.Provider project) {
        MemoryDiffPanel allocDiffPanel = new MemoryDiffPanel(this.getLookup(), diff, snapshot1, snapshot2, sortingColumn, sortingOrder, project);
        this.updateFind(true, allocDiffPanel);
        this.add(allocDiffPanel, "Center");
        this.setName(Bundle.SnapshotDiffWindow_AllocCaption());
        this.setIcon(WINDOW_ICON_MEMORY);
    }

    private void displayMemoryLivenessDiff(MemoryResultsSnapshot diff, LoadedSnapshot snapshot1, LoadedSnapshot snapshot2, int sortingColumn, boolean sortingOrder, Lookup.Provider project) {
        MemoryDiffPanel livenessDiffPanel = new MemoryDiffPanel(this.getLookup(), diff, snapshot1, snapshot2, sortingColumn, sortingOrder, project);
        this.updateFind(true, livenessDiffPanel);
        this.add(livenessDiffPanel, "Center");
        this.setName(Bundle.SnapshotDiffWindow_LivenessCaption());
        this.setIcon(WINDOW_ICON_MEMORY);
    }

    private void updateFind(boolean enabled, final SnapshotResultsWindow.FindPerformer performer) {
        CallbackSystemAction globalFindAction = (CallbackSystemAction)SystemAction.get(FindAction.class);
        Object findActionKey = globalFindAction.getActionMapKey();
        if (enabled) {
            this.getActionMap().put(findActionKey, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    performer.performFind();
                }
            });
        } else {
            this.getActionMap().remove(findActionKey);
        }
    }
}

