/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.util.ResourceBundle;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.FilterSortSupport;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;

public class PresoObjAllocCCTNode
implements CCTNode {
    public static final String VM_ALLOC_CLASS = "org.netbeans.lib.profiler.server.ProfilerRuntimeMemory";
    public static final String VM_ALLOC_METHOD = "traceVMObjectAlloc";
    private static final String VM_ALLOC_TEXT = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.memory.Bundle").getString("PresoObjAllocCCTNode_VMAllocMsg");
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_ALLOC_OBJ_SIZE = 2;
    public static final int SORT_BY_ALLOC_OBJ_NUMBER = 3;
    protected static final char MASK_FILTERED_NODE = '\b';
    public long nCalls;
    public long totalObjSize;
    PresoObjAllocCCTNode parent;
    String className;
    String methodName;
    String methodSig;
    String nodeName;
    PresoObjAllocCCTNode[] children;
    int methodId;
    protected char flags;

    protected PresoObjAllocCCTNode(RuntimeMemoryCCTNode rtNode) {
        this.methodId = rtNode.methodId;
        if (rtNode instanceof RuntimeObjAllocTermCCTNode) {
            RuntimeObjAllocTermCCTNode rtTermNode = (RuntimeObjAllocTermCCTNode)rtNode;
            this.nCalls += rtTermNode.nCalls;
            this.totalObjSize += rtTermNode.totalObjSize;
        }
    }

    public static void getNamesForMethodIdsFromVM(ProfilerClient profilerClient, RuntimeMemoryCCTNode[] allStackRoots) throws ClientUtils.TargetAppOrVMTerminated {
        if (allStackRoots == null) {
            return;
        }
        for (int i = 0; i < allStackRoots.length; ++i) {
            if (allStackRoots[i] == null) continue;
            PresoObjAllocCCTNode.checkMethodIdForNodeFromVM(allStackRoots[i]);
        }
        JMethodIdTable.getDefault().getNamesForMethodIds(profilerClient);
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromSnapshot(MemoryResultsSnapshot snapshot, RuntimeMemoryCCTNode rootRuntimeNode, String classTypeName) {
        PresoObjAllocCCTNode rootNode = PresoObjAllocCCTNode.generateMirrorNode(rootRuntimeNode);
        PresoObjAllocCCTNode.assignNamesToNodesFromSnapshot(snapshot, rootNode, classTypeName);
        return rootNode;
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromVM(ProfilerClient profilerClient, RuntimeMemoryCCTNode rootRuntimeNode, String classTypeName) throws ClientUtils.TargetAppOrVMTerminated {
        PresoObjAllocCCTNode rootNode = PresoObjAllocCCTNode.generateMirrorNode(rootRuntimeNode);
        PresoObjAllocCCTNode.assignNamesToNodesFromVM(profilerClient, rootNode, classTypeName);
        return rootNode;
    }

    @Override
    public CCTNode getChild(int index) {
        if (index < this.children.length) {
            return this.children[index];
        }
        return null;
    }

    @Override
    public CCTNode[] getChildren() {
        return this.children;
    }

    @Override
    public int getIndexOfChild(Object child) {
        for (int i = 0; i < this.children.length; ++i) {
            if ((PresoObjAllocCCTNode)child != this.children[i]) continue;
            return i;
        }
        return -1;
    }

    public String[] getMethodClassNameAndSig() {
        return new String[]{this.className, this.methodName, this.methodSig};
    }

    @Override
    public int getNChildren() {
        if (this.children != null) {
            return this.children.length;
        }
        return 0;
    }

    public String getNodeName() {
        if (this.isFilteredNode()) {
            return FilterSortSupport.FILTERED_OUT_LBL;
        }
        if (this.methodId != 0) {
            return this.nodeName;
        }
        return this.className;
    }

    @Override
    public CCTNode getParent() {
        return this.parent;
    }

    public void sortChildren(int sortBy, boolean sortOrder) {
        int nChildren = this.getNChildren();
        if (nChildren == 0) {
            return;
        }
        for (int i = 0; i < nChildren; ++i) {
            this.children[i].sortChildren(sortBy, sortOrder);
        }
        if (nChildren > 1) {
            switch (sortBy) {
                case 1: {
                    this.sortChildrenByName(sortOrder);
                    break;
                }
                case 2: {
                    this.sortChildrenByAllocObjSize(sortOrder);
                    break;
                }
                case 3: {
                    this.sortChildrenByAllocObjNumber(sortOrder);
                }
            }
        }
    }

    public String toString() {
        return this.getNodeName();
    }

    public void setFilteredNode() {
        this.flags = (char)(this.flags | 8);
    }

    public void resetFilteredNode() {
        this.flags = (char)(this.flags & 0xFFFFFFF7);
    }

    public boolean isFilteredNode() {
        return (this.flags & 8) != 0;
    }

    void merge(PresoObjAllocCCTNode node) {
        this.nCalls += node.nCalls;
        this.totalObjSize += this.totalObjSize;
        if (node.children != null) {
            for (PresoObjAllocCCTNode ch : node.children) {
                ch.parent = this;
            }
            int chl = this.children == null ? 0 : this.children.length;
            int newchl = node.children.length;
            PresoObjAllocCCTNode[] newch = new PresoObjAllocCCTNode[chl + newchl];
            if (this.children != null) {
                System.arraycopy(this.children, 0, newch, 0, chl);
            }
            System.arraycopy(node.children, 0, newch, chl, newchl);
            this.children = newch;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof PresoObjAllocCCTNode)) {
            return false;
        }
        return this.getNodeName().equals(((PresoObjAllocCCTNode)o).getNodeName());
    }

    public int hashCode() {
        return this.getNodeName().hashCode();
    }

    protected static void assignNamesToNodesFromSnapshot(MemoryResultsSnapshot snapshot, PresoObjAllocCCTNode rootNode, String classTypeName) {
        rootNode.className = StringUtils.userFormClassName(classTypeName);
        rootNode.setFullClassAndMethodInfo(snapshot.getJMethodIdTable());
    }

    protected static void assignNamesToNodesFromVM(ProfilerClient profilerClient, PresoObjAllocCCTNode rootNode, String classTypeName) throws ClientUtils.TargetAppOrVMTerminated {
        JMethodIdTable.getDefault().getNamesForMethodIds(profilerClient);
        rootNode.className = StringUtils.userFormClassName(classTypeName);
        rootNode.setFullClassAndMethodInfo(JMethodIdTable.getDefault());
    }

    protected static PresoObjAllocCCTNode generateMirrorNode(RuntimeMemoryCCTNode rtNode) {
        PresoObjAllocCCTNode thisNode = new PresoObjAllocCCTNode(rtNode);
        Object nodeChildren = rtNode.children;
        if (nodeChildren != null) {
            if (nodeChildren instanceof RuntimeMemoryCCTNode) {
                PresoObjAllocCCTNode child;
                thisNode.children = new PresoObjAllocCCTNode[1];
                thisNode.children[0] = child = PresoObjAllocCCTNode.generateMirrorNode((RuntimeMemoryCCTNode)nodeChildren);
                child.parent = thisNode;
                thisNode.nCalls += child.nCalls;
                thisNode.totalObjSize += child.totalObjSize;
            } else {
                RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])nodeChildren;
                int nChildren = ar.length;
                if (nChildren > 0) {
                    thisNode.children = new PresoObjAllocCCTNode[nChildren];
                    for (int i = 0; i < nChildren; ++i) {
                        PresoObjAllocCCTNode child;
                        thisNode.children[i] = child = PresoObjAllocCCTNode.generateMirrorNode(ar[i]);
                        child.parent = thisNode;
                        thisNode.nCalls += child.nCalls;
                        thisNode.totalObjSize += child.totalObjSize;
                    }
                }
            }
        }
        return thisNode;
    }

    protected boolean setFullClassAndMethodInfo(JMethodIdTable methodIdTable) {
        if (this.methodId != 0) {
            JMethodIdTable.JMethodIdTableEntry entry = methodIdTable.getEntry(this.methodId);
            this.className = entry.className.replace('/', '.');
            this.methodName = entry.methodName;
            this.methodSig = entry.methodSig;
            this.nodeName = VM_ALLOC_CLASS.equals(this.className) && VM_ALLOC_METHOD.equals(this.methodName) ? VM_ALLOC_TEXT : MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(this.className, this.methodName, this.methodSig).toFormatted();
        }
        boolean thisNodeOk = !this.className.equals("org.netbeans.lib.profiler.server.ProfilerServer");
        boolean childrenOk = true;
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i].setFullClassAndMethodInfo(methodIdTable)) continue;
                childrenOk = false;
                this.children[i] = null;
            }
        }
        if (!childrenOk) {
            boolean hasNonNullChildren;
            int newLen = 0;
            for (int i = 0; i < this.children.length; ++i) {
                newLen += this.children[i] != null ? 1 : 0;
            }
            boolean bl = hasNonNullChildren = newLen > 0;
            if (!hasNonNullChildren) {
                this.children = null;
            } else {
                PresoObjAllocCCTNode[] newChildren = new PresoObjAllocCCTNode[newLen];
                int idx = 0;
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null) continue;
                    newChildren[idx++] = this.children[i];
                }
                this.children = newChildren;
            }
            if (this.methodName == null || this.methodName.equals("main") && this.methodSig.equals("([Ljava/lang/String;)V")) {
                return true;
            }
            return hasNonNullChildren;
        }
        return thisNodeOk;
    }

    protected static void checkMethodIdForNodeFromVM(RuntimeMemoryCCTNode rtNode) {
        Object nodeChildren;
        if (rtNode.methodId != 0) {
            JMethodIdTable.getDefault().checkMethodId(rtNode.methodId);
        }
        if ((nodeChildren = rtNode.children) != null) {
            if (nodeChildren instanceof RuntimeMemoryCCTNode) {
                PresoObjAllocCCTNode.checkMethodIdForNodeFromVM((RuntimeMemoryCCTNode)nodeChildren);
            } else {
                RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])nodeChildren;
                for (int i = 0; i < ar.length; ++i) {
                    PresoObjAllocCCTNode.checkMethodIdForNodeFromVM(ar[i]);
                }
            }
        }
    }

    protected void sortChildrenByAllocObjNumber(boolean sortOrder) {
        int len = this.children.length;
        long[] values = new long[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this.children[i].nCalls;
        }
        this.sortLongs(values, sortOrder);
    }

    protected void sortChildrenByAllocObjSize(boolean sortOrder) {
        int len = this.children.length;
        long[] values = new long[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this.children[i].totalObjSize;
        }
        this.sortLongs(values, sortOrder);
    }

    protected void sortChildrenByName(boolean sortOrder) {
        int len = this.children.length;
        String[] values = new String[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this.children[i].getNodeName();
        }
        this.sortStrings(values, sortOrder);
    }

    protected void sortFloats(float[] values, boolean sortOrder) {
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            for (int j = i; j > 0 && (!sortOrder ? values[j - 1] < values[j] : values[j - 1] > values[j]); --j) {
                float tmp = values[j];
                values[j] = values[j - 1];
                values[j - 1] = tmp;
                PresoObjAllocCCTNode tmpCh = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = tmpCh;
            }
        }
    }

    protected void sortInts(int[] values, boolean sortOrder) {
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            for (int j = i; j > 0 && (!sortOrder ? values[j - 1] < values[j] : values[j - 1] > values[j]); --j) {
                int tmp = values[j];
                values[j] = values[j - 1];
                values[j - 1] = tmp;
                PresoObjAllocCCTNode tmpCh = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = tmpCh;
            }
        }
    }

    protected void sortLongs(long[] values, boolean sortOrder) {
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            for (int j = i; j > 0 && (!sortOrder ? values[j - 1] < values[j] : values[j - 1] > values[j]); --j) {
                long tmp = values[j];
                values[j] = values[j - 1];
                values[j - 1] = tmp;
                PresoObjAllocCCTNode tmpCh = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = tmpCh;
            }
        }
    }

    protected void sortStrings(String[] values, boolean sortOrder) {
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            for (int j = i; j > 0 && (!sortOrder ? values[j - 1].compareTo(values[j]) < 0 : values[j - 1].compareTo(values[j]) > 0); --j) {
                String tmp = values[j];
                values[j] = values[j - 1];
                values[j - 1] = tmp;
                PresoObjAllocCCTNode tmpCh = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = tmpCh;
            }
        }
    }

    public void exportXMLData(ExportDataDumper eDD, String indent) {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer(indent + "<Node>" + newline);
        result.append(indent).append(" <Name>").append(this.replaceHTMLCharacters(this.getNodeName())).append("<Name>").append(newline);
        result.append(indent).append(" <Parent>").append(this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName())).append("<Parent>").append(newline);
        result.append(indent).append(" <Bytes_Allocated>").append(this.totalObjSize).append("</Bytes_Allocated>").append(newline);
        result.append(indent).append(" <Objects_Allocated>").append(this.nCalls).append("</Objects_Allocated>").append(newline);
        eDD.dumpData(result);
        if (this.children != null) {
            for (int i = 0; i < this.getNChildren(); ++i) {
                this.children[i].exportXMLData(eDD, indent + " ");
            }
        }
        result = new StringBuffer(indent + "</Node>");
        eDD.dumpData(result);
    }

    public void exportHTMLData(ExportDataDumper eDD, int depth) {
        int i;
        StringBuffer result = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">");
        for (i = 0; i < depth; ++i) {
            result.append(".");
        }
        result.append(this.replaceHTMLCharacters(this.getNodeName())).append("</pre></td><td class=\"right\">").append(this.totalObjSize).append("</td><td class=\"right\">").append(this.nCalls).append("</td><td class=\"parent\"><pre class=\"parent\">").append(this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName())).append("</pre></td></tr>");
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.children.length; ++i) {
                this.children[i].exportHTMLData(eDD, depth + 1);
            }
        }
    }

    private String replaceHTMLCharacters(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void exportCSVData(String separator, int depth, ExportDataDumper eDD) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        String indent = " ";
        result.append(quote);
        for (i = 0; i < depth; ++i) {
            result.append(indent);
        }
        result.append(this.nodeName == null ? this.className : this.nodeName).append(quote).append(separator);
        result.append(quote).append(this.totalObjSize).append(quote).append(separator);
        result.append(quote).append(this.nCalls).append(quote).append(separator);
        result.append(quote).append(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName()).append(newLine);
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.children.length; ++i) {
                this.children[i].exportCSVData(separator, depth + 1, eDD);
            }
        }
    }
}

