/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.FilterSortSupport;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.AllThreadsMergedCPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTClassContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.MethodIdMap;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeFree;

public class CPUResultsSnapshot
extends ResultsSnapshot {
    private static final String CPU_MSG = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.cpu.Bundle").getString("CPUResultsSnapshot_CpuMsg");
    public static final int METHOD_LEVEL_VIEW = 0;
    public static final int CLASS_LEVEL_VIEW = 1;
    public static final int PACKAGE_LEVEL_VIEW = 2;
    protected Map threadIdMap;
    protected CPUCCTContainer[] allThreadsMergedCCTContainers;
    protected String[][] instrMethodClassesViews;
    protected String[] instrMethodNames;
    protected String[] instrMethodSignatures;
    protected PrestimeCPUCCTNode[] rootNode;
    protected CPUCCTContainer[][] threadCCTContainers;
    protected boolean collectingTwoTimeStamps;
    protected int nInstrMethods;
    private final Map<CCTNode, FilterSortSupport.Configuration> sortInfos = new WeakHashMap<CCTNode, FilterSortSupport.Configuration>();

    public CPUResultsSnapshot() {
        this.threadIdMap = new HashMap();
    }

    public CPUResultsSnapshot(long beginTime, long timeTaken, CPUCCTProvider cctProvider, boolean collectingTwoTimestamps, String[] instrClassNames, String[] instrMethodNames, String[] instrMethodSigs, int nInstrMethods) throws NoDataAvailableException {
        super(beginTime, timeTaken);
        this.collectingTwoTimeStamps = collectingTwoTimestamps;
        this.instrMethodClassesViews = new String[3][];
        this.instrMethodClassesViews[0] = instrClassNames;
        this.instrMethodNames = instrMethodNames;
        this.instrMethodSignatures = instrMethodSigs;
        this.nInstrMethods = nInstrMethods;
        CPUCCTContainer[] methodLevelCCTs = cctProvider.createPresentationCCTs(this);
        if (methodLevelCCTs == null) {
            throw new NoDataAvailableException();
        }
        int len = methodLevelCCTs.length;
        if (len == 0) {
            throw new NoDataAvailableException();
        }
        this.threadIdMap = new HashMap(methodLevelCCTs.length);
        for (int i = 0; i < methodLevelCCTs.length; ++i) {
            this.threadIdMap.put(methodLevelCCTs[i].threadId, i);
        }
        this.threadCCTContainers = new CPUCCTContainer[3][];
        this.threadCCTContainers[0] = methodLevelCCTs;
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public boolean isCollectingTwoTimeStamps() {
        return this.collectingTwoTimeStamps;
    }

    public CPUCCTContainer getContainerForThread(int threadId, int view) {
        if (this.threadCCTContainers[view] == null) {
            this.generateDataForView(view);
        }
        return this.threadCCTContainers[view][this.getContainerIdForThreadId(threadId)];
    }

    public FlatProfileContainer getFlatProfile(int threadId, int view) {
        if (this.threadCCTContainers[view] == null) {
            this.generateDataForView(view);
        }
        if (threadId != -1) {
            return this.threadCCTContainers[view][this.getContainerIdForThreadId(threadId)].getFlatProfile();
        }
        return this.allThreadsMergedCCTContainers[view].getFlatProfile();
    }

    public String[] getInstrMethodClasses(int view) {
        return this.instrMethodClassesViews[view];
    }

    public String[] getInstrMethodNames() {
        return this.instrMethodNames;
    }

    public String[] getInstrMethodSignatures() {
        return this.instrMethodSignatures;
    }

    public String[] getMethodClassNameAndSig(int methodId, int view) {
        if (view == 0) {
            return new String[]{this.instrMethodClassesViews[0][methodId], this.instrMethodNames[methodId], this.instrMethodSignatures[methodId]};
        }
        return new String[]{this.instrMethodClassesViews[view][methodId], null, null};
    }

    public int getNInstrMethods() {
        return this.nInstrMethods;
    }

    public int getNThreads() {
        return this.threadCCTContainers[0].length;
    }

    public PrestimeCPUCCTNode getReverseCCT(int threadId, int methodId, int view) {
        if (this.threadCCTContainers[view] == null) {
            this.generateDataForView(view);
        }
        if (threadId >= 0) {
            return this.threadCCTContainers[view][this.getContainerIdForThreadId(threadId)].getReverseCCT(methodId);
        }
        if (threadId == -1) {
            return this.allThreadsMergedCCTContainers[view].getReverseCCT(methodId);
        }
        throw new IllegalArgumentException("!!! Cannot generate reverse CCT for threadId = " + threadId);
    }

    public PrestimeCPUCCTNode getRootNode(int view) {
        if (this.threadCCTContainers[view] == null) {
            this.generateDataForView(view);
        }
        return this.rootNode[view];
    }

    public FilterSortSupport.Configuration getFilterSortInfo(CCTNode node) {
        return this.sortInfo(node);
    }

    private FilterSortSupport.Configuration sortInfo(CCTNode node) {
        while (node.getParent() != null) {
            node = node.getParent();
        }
        FilterSortSupport.Configuration config = this.sortInfos.get(node);
        if (config == null) {
            config = new FilterSortSupport.Configuration();
            this.sortInfos.put(node, config);
        }
        return config;
    }

    public void filterForward(String filter, int filterType, PrestimeCPUCCTNodeBacked root) {
        FilterSortSupport.Configuration config = this.sortInfo(root);
        config.setFilterInfo(filter, filterType);
        if (!FilterSortSupport.passesFilter(config, root.getNodeName())) {
            root.setFilteredNode();
        } else {
            root.resetFilteredNode();
        }
        root.resetChildren();
    }

    public void filterReverse(String filter, int filterType, PrestimeCPUCCTNodeFree root, int view) {
        PrestimeCPUCCTNodeFree rev = (PrestimeCPUCCTNodeFree)this.getReverseCCT(root.getContainer().getThreadId(), root.getMethodId(), view);
        FilterSortSupport.Configuration config = this.sortInfo(root);
        config.setFilterInfo(filter, filterType);
        this.filter(config, rev);
        root.children = rev.children;
        if (root.children != null) {
            for (PrestimeCPUCCTNode ch : root.children) {
                ch.parent = root;
            }
            root.sortChildren(config.getSortBy(), config.getSortOrder());
        }
        if (!FilterSortSupport.passesFilter(config, root.getNodeName())) {
            root.setFilteredNode();
        } else {
            root.resetFilteredNode();
        }
    }

    private void filter(FilterSortSupport.Configuration config, PrestimeCPUCCTNodeFree node) {
        if (node.children != null) {
            PrestimeCPUCCTNodeFree filtered = null;
            ArrayList<PrestimeCPUCCTNodeFree> ch = new ArrayList<PrestimeCPUCCTNodeFree>();
            for (PrestimeCPUCCTNode n : node.children) {
                PrestimeCPUCCTNodeFree nn = (PrestimeCPUCCTNodeFree)n;
                if (FilterSortSupport.passesFilter(config, nn.getNodeName())) {
                    int i = ch.indexOf(nn);
                    if (i == -1) {
                        ch.add(nn);
                        continue;
                    }
                    ((PrestimeCPUCCTNodeFree)ch.get(i)).merge(nn);
                    continue;
                }
                if (filtered == null) {
                    nn.setFilteredNode();
                    filtered = nn;
                    ch.add(nn);
                    continue;
                }
                filtered.merge(nn);
            }
            if (ch.isEmpty()) {
                node.children = null;
            } else if (node.isFilteredNode() && filtered != null && ch.size() == 1) {
                PrestimeCPUCCTNodeFree n = (PrestimeCPUCCTNodeFree)ch.get(0);
                this.filter(config, n);
                node.children = n.children;
            } else {
                node.children = ch.toArray(new PrestimeCPUCCTNodeFree[ch.size()]);
            }
            if (node.children != null) {
                for (PrestimeCPUCCTNode n : node.children) {
                    this.filter(config, (PrestimeCPUCCTNodeFree)n);
                }
            }
        }
    }

    public int[] getThreadIds() {
        int[] ret = new int[this.threadCCTContainers[0].length];
        for (int i = 0; i < this.threadCCTContainers[0].length; ++i) {
            ret[i] = this.threadCCTContainers[0][i].threadId;
        }
        return ret;
    }

    public String getThreadNameForId(int threadId) {
        return this.getThreadNames()[this.getContainerIdForThreadId(threadId)];
    }

    public String[] getThreadNames() {
        String[] ret = new String[this.threadCCTContainers[0].length];
        for (int i = 0; i < this.threadCCTContainers[0].length; ++i) {
            ret[i] = this.threadCCTContainers[0][i].threadName;
        }
        return ret;
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        super.readFromStream(in);
        this.collectingTwoTimeStamps = in.readBoolean();
        this.nInstrMethods = in.readInt();
        this.instrMethodClassesViews = new String[3][];
        String[] classNames = new String[this.nInstrMethods];
        this.instrMethodClassesViews[0] = classNames;
        this.instrMethodNames = new String[this.nInstrMethods];
        this.instrMethodSignatures = new String[this.nInstrMethods];
        for (int i = 0; i < this.nInstrMethods; ++i) {
            classNames[i] = in.readUTF();
            this.instrMethodNames[i] = in.readUTF();
            this.instrMethodSignatures[i] = in.readUTF();
        }
        int nThreads = in.readInt();
        this.threadCCTContainers = new CPUCCTContainer[3][];
        CPUCCTContainer[] containers = new CPUCCTContainer[nThreads];
        this.threadCCTContainers[0] = containers;
        for (int i = 0; i < nThreads; ++i) {
            containers[i] = new CPUCCTContainer(this);
            containers[i].readFromStream(in);
            this.threadIdMap.put(containers[i].threadId, i);
        }
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public void saveSortParams(int sortBy, boolean sortOrder, CCTNode node) {
        FilterSortSupport.Configuration config = this.sortInfo(node);
        config.setSortInfo(sortBy, sortOrder);
    }

    @Override
    public String toString() {
        return MessageFormat.format(CPU_MSG, super.toString());
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        super.writeToStream(out);
        out.writeBoolean(this.collectingTwoTimeStamps);
        out.writeInt(this.nInstrMethods);
        String[] classNames = this.instrMethodClassesViews[0];
        for (int i = 0; i < this.nInstrMethods; ++i) {
            out.writeUTF(classNames[i]);
            out.writeUTF(this.instrMethodNames[i]);
            out.writeUTF(this.instrMethodSignatures[i]);
        }
        CPUCCTContainer[] containers = this.threadCCTContainers[0];
        int nThreads = containers.length;
        out.writeInt(nThreads);
        for (int i = 0; i < nThreads; ++i) {
            containers[i].writeToStream(out);
        }
    }

    private int getContainerIdForThreadId(int threadId) {
        Integer tid = threadId;
        Integer cId = null;
        if (this.threadIdMap.containsKey(tid)) {
            cId = (Integer)this.threadIdMap.get(tid);
        }
        return cId != null ? cId : 0;
    }

    protected PrestimeCPUCCTNode createRootNodeForAllThreads(int view) {
        CPUCCTContainer[] ccts = this.threadCCTContainers[view];
        int len = ccts.length;
        PrestimeCPUCCTNode[] threadNodes = new PrestimeCPUCCTNode[len];
        for (int i = 0; i < len; ++i) {
            PrestimeCPUCCTNode tRootNode = ccts[i].getRootNode();
            threadNodes[i] = !tRootNode.isThreadNode() ? new PrestimeCPUCCTNodeBacked(ccts[i], new PrestimeCPUCCTNode[]{tRootNode}) : tRootNode;
        }
        this.allThreadsMergedCCTContainers[view] = new AllThreadsMergedCPUCCTContainer(this, threadNodes, view);
        return this.allThreadsMergedCCTContainers[view].getRootNode();
    }

    private void debugValues() {
        LOGGER.log(Level.FINEST, "collectingTwoTimeStamps: {0}", this.collectingTwoTimeStamps);
        LOGGER.log(Level.FINEST, "threadCCTContainers.length: {0}", this.debugLength(this.threadCCTContainers));
        LOGGER.log(Level.FINEST, "allThreadsMergedCCTContainers.length: {0}", this.debugLength(this.allThreadsMergedCCTContainers));
        LOGGER.log(Level.FINEST, "rootNode.length: {0}", this.debugLength(this.rootNode));
        LOGGER.log(Level.FINEST, "instrMethodClassesViews.length: {0}", this.debugLength(this.instrMethodClassesViews));
        LOGGER.log(Level.FINEST, "instrMethodNames.length: {0}", this.debugLength(this.instrMethodNames));
        LOGGER.log(Level.FINEST, "instrMethodSignatures.length: {0}", this.debugLength(this.instrMethodSignatures));
        LOGGER.log(Level.FINEST, "nInstrMethods: {0}", this.nInstrMethods);
    }

    private void generateDataForView(int view) {
        if (this.threadCCTContainers[view] == null) {
            MethodIdMap methodIdMap = new MethodIdMap(this.instrMethodClassesViews[0], this.nInstrMethods, view);
            int len = this.threadCCTContainers[0].length;
            this.threadCCTContainers[view] = new CPUCCTContainer[len];
            for (int i = 0; i < len; ++i) {
                this.threadCCTContainers[view][i] = new CPUCCTClassContainer(this.threadCCTContainers[0][i], methodIdMap, view);
            }
            this.rootNode[view] = this.createRootNodeForAllThreads(view);
            this.instrMethodClassesViews[view] = methodIdMap.getInstrClassesOrPackages();
        }
    }

    public static class NoDataAvailableException
    extends Exception {
    }
}

