/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.ProfilingResultListener;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;

public abstract class BaseCallGraphBuilder
implements ProfilingResultListener,
CCTProvider {
    protected static final Logger LOGGER = Logger.getLogger(BaseCallGraphBuilder.class.getName());
    protected List afterBatchCommands = new ArrayList();
    protected ProfilingSessionStatus status;
    protected final Set cctListeners = new CopyOnWriteArraySet();
    protected WeakReference clientRef;
    protected boolean batchNotEmpty = false;

    @Override
    public void addListener(CCTProvider.Listener listener) {
        this.cctListeners.add(listener);
    }

    @Override
    public void onBatchStart() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Starting batch");
        }
        this.afterBatchCommands.clear();
        this.batchNotEmpty = false;
        this.doBatchStart();
    }

    @Override
    public void onBatchStop() {
        this.doBatchStop();
        if (this.batchNotEmpty) {
            this.fireCCTEstablished(false);
        } else {
            this.fireCCTEstablished(true);
        }
        if (!this.afterBatchCommands.isEmpty()) {
            Iterator iter = this.afterBatchCommands.iterator();
            while (iter.hasNext()) {
                ((Runnable)iter.next()).run();
            }
            this.afterBatchCommands.clear();
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Finishing batch");
        }
    }

    @Override
    public void profilingPoint(final int threadId, final int ppId, final long timeStamp) {
        ProfilerClient client = this.getClient();
        if (client == null) {
            return;
        }
        final ProfilingPointsProcessor ppp = TargetAppRunner.getDefault().getProfilingPointsProcessor();
        this.afterBatchCommands.add(new Runnable(){

            @Override
            public void run() {
                ppp.profilingPointHit(new RuntimeProfilingPoint.HitEvent(ppId, timeStamp, threadId));
            }
        });
    }

    @Override
    public void removeAllListeners() {
        this.cctListeners.clear();
    }

    @Override
    public void removeListener(CCTProvider.Listener listener) {
        this.cctListeners.remove(listener);
    }

    @Override
    public void reset() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Resetting CallGraphBuilder");
        }
        try {
            this.doReset();
            this.fireCCTReset();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
        }
    }

    @Override
    public void shutdown() {
        this.status = null;
        this.afterBatchCommands.clear();
        this.doShutdown();
    }

    @Override
    public void startup(ProfilerClient profilerClient) {
        this.status = profilerClient.getStatus();
        this.clientRef = new WeakReference<ProfilerClient>(profilerClient);
        this.doStartup(profilerClient);
    }

    protected abstract RuntimeCCTNode getAppRootNode();

    protected abstract void doBatchStart();

    protected abstract void doBatchStop();

    protected abstract void doReset();

    protected abstract void doShutdown();

    protected abstract void doStartup(ProfilerClient var1);

    protected ProfilerClient getClient() {
        if (this.clientRef == null) {
            return null;
        }
        return (ProfilerClient)this.clientRef.get();
    }

    private void fireCCTEstablished(boolean empty) {
        RuntimeCCTNode appNode = this.getAppRootNode();
        if (appNode == null) {
            return;
        }
        Iterator iter = this.cctListeners.iterator();
        while (iter.hasNext()) {
            ((CCTProvider.Listener)iter.next()).cctEstablished(appNode, empty);
        }
    }

    private void fireCCTReset() {
        Iterator iter = this.cctListeners.iterator();
        while (iter.hasNext()) {
            ((CCTProvider.Listener)iter.next()).cctReset();
        }
    }
}

