/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.utils.MiscUtils;

public class ClassPath {
    private JarLRUCache zipFileNameToFile;
    private PathEntry[] paths;
    private boolean isCP;

    public ClassPath(String classPath, boolean isCP) {
        this.isCP = isCP;
        ArrayList<PathEntry> vec = new ArrayList<PathEntry>();
        this.zipFileNameToFile = new JarLRUCache();
        StringTokenizer tok = new StringTokenizer(classPath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            File file;
            String path = tok.nextToken();
            if (path.equals("") || !(file = new File(path)).exists()) continue;
            if (file.isDirectory()) {
                vec.add(new Dir(file));
                continue;
            }
            vec.add(new Zip(file.getPath()));
        }
        this.paths = new PathEntry[vec.size()];
        vec.toArray(this.paths);
    }

    public DynamicClassInfo getClassInfoForClass(String className, int classLoaderId) throws IOException, ClassFormatError {
        String slashedClassName = className.replace('.', '/');
        String dirOrJar = this.getLocationForClass(slashedClassName);
        if (dirOrJar == null) {
            return null;
        }
        return new DynamicClassInfo(slashedClassName, classLoaderId, dirOrJar);
    }

    public String getLocationForClass(String slashedClassName) {
        String fileName = slashedClassName + (this.isCP ? ".class" : ".java");
        for (int i = 0; i < this.paths.length; ++i) {
            String location = this.paths[i].getLocationForClassFile(fileName);
            if (location == null) continue;
            return location;
        }
        return null;
    }

    public ZipFile getZipFileForName(String zipFileName) throws IOException {
        ZipFile zip = (ZipFile)this.zipFileNameToFile.get(zipFileName);
        if (zip == null) {
            zip = new ZipFile(zipFileName);
            this.zipFileNameToFile.put(zipFileName, zip);
        }
        return zip;
    }

    public void close() {
        Iterator it = this.zipFileNameToFile.values().iterator();
        while (it.hasNext()) {
            try {
                ((ZipFile)it.next()).close();
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.paths.length; ++i) {
            buf.append(this.paths[i] instanceof Dir ? ((Dir)this.paths[i]).dir.getAbsolutePath() : ((Zip)this.paths[i]).zipFilePath);
            buf.append(File.pathSeparatorChar);
        }
        return buf.toString();
    }

    private static class JarLRUCache
    extends LinkedHashMap {
        private static final int MAX_CAPACITY = 100;

        private JarLRUCache() {
            super(10, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            if (this.size() > 100) {
                try {
                    ((ZipFile)eldest.getValue()).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
    }

    private class Zip
    extends PathEntry {
        private String zipFilePath;

        Zip(String path) {
            this.zipFilePath = path;
            this.threshHits = 50 + this.r.nextInt(20);
        }

        @Override
        String getLocationForClassFile(String fileName) {
            ZipFile zip;
            if (this.entries != null) {
                if (this.entries.contains(fileName)) {
                    return this.zipFilePath;
                }
                return null;
            }
            if (++this.hits >= this.threshHits) {
                this.entries = new HashSet();
                MiscUtils.getAllClassesInJar(this.zipFilePath, false, this.entries);
                return this.getLocationForClassFile(fileName);
            }
            try {
                zip = ClassPath.this.getZipFileForName(this.zipFilePath);
            }
            catch (IOException ex) {
                System.err.println("Warning: CLASSPATH component " + this.zipFilePath + ": " + ex);
                return null;
            }
            ZipEntry entry = zip.getEntry(fileName);
            if (entry != null) {
                return this.zipFilePath;
            }
            return null;
        }
    }

    private static class Dir
    extends PathEntry {
        private File dir;

        Dir(File dirF) {
            this.dir = dirF;
            this.threshHits = 100 + this.r.nextInt(40);
        }

        @Override
        String getLocationForClassFile(String fileName) {
            if (this.entries != null) {
                if (this.entries.contains(fileName)) {
                    return this.dir.getAbsolutePath();
                }
                return null;
            }
            if (++this.hits >= this.threshHits) {
                this.entries = new HashSet();
                MiscUtils.getAllClassesInDir(this.dir.getAbsolutePath(), "", false, this.entries);
                return this.getLocationForClassFile(fileName);
            }
            File file = new File(this.dir, fileName);
            if (file.exists()) {
                return this.dir.getAbsolutePath();
            }
            return null;
        }
    }

    private static abstract class PathEntry {
        protected HashSet entries;
        protected int hits;
        protected int threshHits;
        protected final Random r = new Random(System.currentTimeMillis());

        private PathEntry() {
        }

        abstract String getLocationForClassFile(String var1);
    }
}

