/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sendopts;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.sendopts.DefaultProcessor;
import org.netbeans.spi.sendopts.Arg;
import org.netbeans.spi.sendopts.Description;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
final class OptionAnnotationProcessorImpl
extends LayerGeneratingProcessor {
    OptionAnnotationProcessorImpl() {
    }

    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add(Arg.class.getName());
        return set;
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        PrimitiveType boolType = this.processingEnv.getTypeUtils().getPrimitiveType(TypeKind.BOOLEAN);
        TypeMirror stringType = this.processingEnv.getElementUtils().getTypeElement("java.lang.String").asType();
        ArrayType stringArray = this.processingEnv.getTypeUtils().getArrayType(stringType);
        HashSet processors = new HashSet();
        for (Element element : roundEnv.getElementsAnnotatedWith(Arg.class)) {
            if (element.getModifiers().contains((Object)Modifier.STATIC)) {
                throw new LayerGenerationException("@Arg can be applied only to non-static fields", element);
            }
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                throw new LayerGenerationException("@Arg can be applied only to public fields", element);
            }
            if (element.getModifiers().contains((Object)Modifier.FINAL)) {
                throw new LayerGenerationException("@Arg can be applied only to non-final fields", element);
            }
            Arg arg = element.getAnnotation(Arg.class);
            if (arg.longName().isEmpty() && arg.shortName() == '\uffff') {
                throw new LayerGenerationException("At least one of longName or shortName attributes needs to be non-empty", element);
            }
            if (arg.implicit() && !((Object)element.asType()).equals(stringArray)) {
                throw new LayerGenerationException("implicit @Arg can only be applied to String[] fields", element);
            }
            processors.add(TypeElement.class.cast(element.getEnclosingElement()));
        }
        for (TypeElement typeElement : processors) {
            int cnt = 1;
            String typeName = this.processingEnv.getElementUtils().getBinaryName(typeElement).toString().replace('.', '-');
            LayerBuilder.File f = this.layer(new Element[]{typeElement}).file("Services/OptionProcessors/" + typeName + ".instance");
            f.methodvalue("instanceCreate", DefaultProcessor.class.getName(), "create");
            f.stringvalue("instanceOf", OptionProcessor.class.getName());
            f.stringvalue("class", this.processingEnv.getElementUtils().getBinaryName(typeElement).toString());
            for (Element element : typeElement.getEnclosedElements()) {
                Arg o = element.getAnnotation(Arg.class);
                if (o == null) continue;
                Description d = element.getAnnotation(Description.class);
                if (o.shortName() != '\uffff') {
                    f.charvalue(cnt + ".shortName", o.shortName());
                }
                if (!o.longName().isEmpty()) {
                    f.stringvalue(cnt + ".longName", o.longName());
                }
                if (boolType == element.asType()) {
                    f.stringvalue(cnt + ".type", "withoutArgument");
                } else if (stringType == element.asType()) {
                    if (o.defaultValue().equals("\u0000")) {
                        f.stringvalue(cnt + ".type", "requiredArgument");
                    } else {
                        f.stringvalue(cnt + ".type", "optionalArgument");
                    }
                } else {
                    if (!stringArray.equals(element.asType())) {
                        throw new LayerGenerationException("Field type has to be either boolean, String or String[]!", element);
                    }
                    f.stringvalue(cnt + ".type", "additionalArguments");
                }
                if (o.implicit()) {
                    f.boolvalue(cnt + ".implicit", true);
                }
                if (d != null) {
                    this.writeBundle(f, cnt + ".displayName", d.displayName(), element);
                    this.writeBundle(f, cnt + ".shortDescription", d.shortDescription(), element);
                }
                ++cnt;
            }
            f.write();
        }
        return true;
    }

    private void writeBundle(LayerBuilder.File f, String key, String value, Element e) throws LayerGenerationException {
        if (value.isEmpty()) {
            return;
        }
        this.layer(new Element[]{e}).file("dummy/file").bundlevalue(key, value);
        if (value.startsWith("#")) {
            Element referenceElement;
            for (referenceElement = e; referenceElement != null && referenceElement.getKind() != ElementKind.PACKAGE; referenceElement = referenceElement.getEnclosingElement()) {
            }
            if (referenceElement == null) {
                throw new LayerGenerationException("No reference element to determine package in '" + value + "'", e);
            }
            value = ((PackageElement)referenceElement).getQualifiedName() + ".Bundle" + value;
        }
        f.stringvalue(key, value);
    }
}

