/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.wizard;

import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.panels.AttachSettingsPanel;
import org.netbeans.modules.profiler.attach.panels.ManualIntegrationPanel;
import org.netbeans.modules.profiler.attach.panels.PerformIntegrationPanel;
import org.netbeans.modules.profiler.attach.panels.RemoteAttachSettingsPanel;
import org.netbeans.modules.profiler.attach.panels.ReviewAdditionalStepsPanel;
import org.netbeans.modules.profiler.attach.panels.ReviewSettingsPanel;
import org.netbeans.modules.profiler.attach.panels.SelectIntegrationTypePanel;
import org.netbeans.modules.profiler.attach.wizard.AbstractWizard;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.netbeans.modules.profiler.attach.wizard.Bundle;
import org.netbeans.modules.profiler.attach.wizard.WizardContext;
import org.netbeans.modules.profiler.attach.wizard.functors.ConditionalFunctor;
import org.netbeans.modules.profiler.attach.wizard.steps.CompositeWizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.ProxyWizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.SimpleWizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStep;

public class AttachWizardImpl
extends AbstractWizard {
    private AttachWizardContext context = null;
    private ProxyWizardStep proxy = null;
    private WizardStep wizardModel = null;

    public AttachSettings getAttachSettings() {
        return ((AttachWizardContext)this.getContext()).getAttachSettings();
    }

    public void init(AttachSettings as) {
        ((AttachWizardContext)this.getContext()).setAttachSettings(as);
        super.init();
    }

    @Override
    protected boolean isAutoWizard() {
        return true;
    }

    @Override
    protected boolean isContentDisplayed() {
        return true;
    }

    @Override
    protected WizardContext getContext() {
        if (this.context == null) {
            this.context = new AttachWizardContext();
        }
        return this.context;
    }

    @Override
    protected boolean isHelpDisplayed() {
        return true;
    }

    @Override
    protected boolean isNumbered() {
        return true;
    }

    @Override
    protected WizardStep getRootStep() {
        if (this.wizardModel == null) {
            this.wizardModel = this.buildWizardModel();
        }
        return this.wizardModel;
    }

    @Override
    protected String getTitle() {
        return Bundle.AttachWizard_AttachWizardCaption();
    }

    @Override
    protected String getTitleFormat() {
        return "{0}";
    }

    @Override
    protected void onUpdateWizardSteps() {
        this.proxy.setWizardStep(((AttachWizardContext)this.getContext()).getIntegrationProvider().getAttachedWizard());
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.wizardModel = null;
    }

    private boolean isAutomationAllowed(AttachWizardContext ctx) {
        if (!ctx.getIntegrationProvider().supportsAutomation()) {
            return false;
        }
        return ctx.getIntegrationProvider().supportsManual() && !ctx.getAttachSettings().isRemote();
    }

    private WizardStep buildWizardModel() {
        this.proxy = this.prepareProviderProxyStep();
        CompositeWizardStep rootStep = new CompositeWizardStep(this.getContext(), Bundle.AttachWizard_AttachWizardCaption());
        rootStep.addStep(Bundle.AttachWizard_SelectTargetTypeString(), new AttachSettingsPanel());
        rootStep.addStep(this.prepareAdditionalSettingsStep());
        rootStep.addStep(Bundle.AttachWizard_ReviewAttachSettingsString(), new ReviewSettingsPanel());
        rootStep.addStep(this.prepareIntegrationStep());
        return rootStep;
    }

    private WizardStep prepareAdditionalSettingsStep() {
        CompositeWizardStep additionalSettings = new CompositeWizardStep(this.getContext(), Bundle.AttachWizard_RefineAttachmentSettings(), new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext context) {
                AttachSettings settings = ((AttachWizardContext)context).getAttachSettings();
                return settings.isRemote() || !settings.isDirect() && !settings.isDynamic16();
            }
        });
        SimpleWizardStep remoteAttach = new SimpleWizardStep(this.getContext(), Bundle.AttachWizard_RemoteSystemString(), new RemoteAttachSettingsPanel(), new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext context) {
                AttachSettings settings = ((AttachWizardContext)context).getAttachSettings();
                return settings.isRemote();
            }
        });
        additionalSettings.addStep(remoteAttach);
        return additionalSettings;
    }

    private WizardStep prepareIntegrationStep() {
        CompositeWizardStep integrationStep = new CompositeWizardStep(this.getContext(), Bundle.AttachWizard_IntegrateProfiler(), new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext context) {
                AttachWizardContext ctx = (AttachWizardContext)context;
                AttachSettings settings = ctx.getAttachSettings();
                return ctx.getIntegrationProvider().supportsManual() || ctx.getIntegrationProvider().supportsAutomation();
            }
        });
        integrationStep.addStep(Bundle.AttachWizard_ChooseIntegrationTypeString(), new SelectIntegrationTypePanel(), new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext context) {
                AttachWizardContext ctx = (AttachWizardContext)context;
                return AttachWizardImpl.this.isAutomationAllowed(ctx);
            }
        });
        CompositeWizardStep automaticIntegration = new CompositeWizardStep(this.getContext(), Bundle.AttachWizard_AutomaticIntegrationStep(), new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext context) {
                AttachWizardContext ctx = (AttachWizardContext)context;
                return ctx.isAutomatic();
            }
        });
        automaticIntegration.addStep(this.proxy);
        automaticIntegration.addStep(Bundle.AttachWizard_PerformIntegrationString(), new PerformIntegrationPanel(), new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext context) {
                return true;
            }
        });
        automaticIntegration.addStep(Bundle.AttachWizard_ReviewAdditionalStepsString(), new ReviewAdditionalStepsPanel());
        integrationStep.addStep(automaticIntegration);
        integrationStep.addStep(this.prepareManualIntegrationStep());
        return integrationStep;
    }

    private WizardStep prepareManualIntegrationStep() {
        return new SimpleWizardStep(this.getContext(), Bundle.AttachWizard_ManualIntegrationStep(), new ManualIntegrationPanel(), new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext context) {
                AttachWizardContext ctx = (AttachWizardContext)context;
                return ctx.isManual();
            }
        });
    }

    private ProxyWizardStep prepareProviderProxyStep() {
        return new ProxyWizardStep(this.getContext(), Bundle.AttachWizard_ProviderSpecificSettings(), new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext context) {
                AttachWizardContext ctx = (AttachWizardContext)context;
                return ctx.isAutomatic();
            }
        }){

            @Override
            public void setNext() {
                super.setNext();
                if (this.canHandle()) {
                    ((AttachWizardContext)AttachWizardImpl.this.getContext()).getIntegrationProvider().getSettingsPersistor().storeSettings();
                }
            }
        };
    }
}

