/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.uisupport;

import com.sun.tools.visualvm.uisupport.SeparatorLine;
import com.sun.tools.visualvm.uisupport.UISupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public final class TransparentToolBar
extends JPanel {
    private static Boolean NEEDS_PANEL;
    private static int PREFERRED_HEIGHT;
    private static int BUTTON_HEIGHT;
    private final JToolBar toolbar;
    private final ItemListener listener = new ItemListener();

    public TransparentToolBar() {
        this.setOpaque(false);
        this.setBorder(TransparentToolBar.createToolBarBorder());
        if (TransparentToolBar.needsPanel()) {
            this.toolbar = null;
            this.setLayout(new BoxLayout(this, 2));
        } else {
            this.toolbar = TransparentToolBar.createToolBar();
            this.toolbar.setBorder(BorderFactory.createEmptyBorder());
            this.setLayout(new BorderLayout());
            this.add((Component)this.toolbar, "Center");
        }
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && TransparentToolBar.this.isShowing()) {
                    TransparentToolBar.this.removeHierarchyListener(this);
                    for (Component c : TransparentToolBar.this.getComponents()) {
                        if (!(c instanceof AbstractButton)) continue;
                        TransparentToolBar.this.listener.refresh((AbstractButton)c);
                    }
                }
            }
        });
    }

    public Dimension getPreferredSize() {
        Dimension dim = this.getPreferredSizeSuper();
        if (PREFERRED_HEIGHT == -1) {
            TransparentToolBar tb = new TransparentToolBar();
            Icon icon = new Icon(){

                public int getIconWidth() {
                    return 16;
                }

                public int getIconHeight() {
                    return 16;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                }
            };
            JButton b = new JButton("Button", icon);
            tb.addItem(b);
            JToggleButton t = new JToggleButton("Button", icon);
            tb.addItem(t);
            JComboBox<Object> c = new JComboBox<Object>();
            c.setEditor(new BasicComboBoxEditor());
            c.setRenderer(new BasicComboBoxRenderer());
            tb.addItem(c);
            tb.addSeparator();
            PREFERRED_HEIGHT = tb.getPreferredSizeSuper().height;
        }
        dim.height = Math.max(dim.height, PREFERRED_HEIGHT);
        return dim;
    }

    private Dimension getPreferredSizeSuper() {
        return super.getPreferredSize();
    }

    public Component addItem(Action action) {
        return this.addItem(this.createActionComponent(action));
    }

    public Component addItem(Component c) {
        return this.addItem(c, -1);
    }

    public Component addItem(Component c, int index) {
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(false);
        }
        if (c instanceof JButton) {
            ((JButton)c).setDefaultCapable(false);
        }
        if (UISupport.isAquaLookAndFeel() && c instanceof AbstractButton) {
            ((AbstractButton)c).putClientProperty("JButton.buttonType", "gradient");
        }
        if (this.toolbar != null) {
            this.toolbar.add(c, index);
        } else {
            this.add(c, index);
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                b.addMouseListener(this.listener);
                b.addChangeListener(this.listener);
                b.addFocusListener(this.listener);
                b.setRolloverEnabled(true);
                this.listener.refresh(b);
            }
        }
        this.repaint();
        return c;
    }

    public void removeItem(Component c) {
        if (this.toolbar != null) {
            this.toolbar.remove(c);
        } else {
            if (c instanceof AbstractButton) {
                c.removeMouseListener(this.listener);
                ((AbstractButton)c).removeChangeListener(this.listener);
                c.removeFocusListener(this.listener);
            }
            this.remove(c);
        }
        this.repaint();
    }

    public void removeItem(int index) {
        if (this.toolbar != null) {
            this.toolbar.remove(index);
        } else {
            this.removeItem(this.getComponent(index));
        }
    }

    public int getItemsCount() {
        if (this.toolbar != null) {
            return this.toolbar.getComponentCount();
        }
        return super.getComponentCount();
    }

    public void addSeparator() {
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(1);
        this.addItem(separator);
    }

    public void addSpace(int width) {
        JToolBar.Separator separator = new JToolBar.Separator(new Dimension(width, 0));
        separator.setOrientation(1);
        this.addItem(separator);
    }

    public void addFiller() {
        Dimension minDim = new Dimension(0, 0);
        Dimension maxDim = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        Box.Filler filler = new Box.Filler(minDim, minDim, maxDim){

            protected void paintComponent(Graphics g) {
            }
        };
        this.addItem(filler);
    }

    public static JComponent withSeparator(TransparentToolBar toolbar) {
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.setOpaque(false);
        panel.add((Component)toolbar, "Center");
        panel.add((Component)new SeparatorLine(true), "South");
        return panel;
    }

    private JButton createActionComponent(Action a) {
        JButton b = new JButton();
        if (a != null && (a.getValue("SmallIcon") != null || a.getValue("SwingLargeIconKey") != null)) {
            b.setHideActionText(true);
        }
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
        b.setAction(a);
        return b;
    }

    private static JToolBar createToolBar() {
        JToolBar tb = new JToolBar(){

            public void layout() {
                super.layout();
                if (BUTTON_HEIGHT == -1) {
                    BUTTON_HEIGHT = TransparentToolBar.getButtonHeight();
                }
                Insets i = this.getInsets();
                int height = this.getHeight() - i.top - i.bottom;
                for (Component comp : this.getComponents()) {
                    if (!comp.isVisible() || !(comp instanceof JButton) && !(comp instanceof JToggleButton)) continue;
                    Rectangle b = comp.getBounds();
                    b.height = BUTTON_HEIGHT;
                    b.y = i.top + (height - b.height) / 2;
                    comp.setBounds(b);
                }
            }
        };
        if (UISupport.isNimbusLookAndFeel()) {
            tb.setLayout(new BoxLayout(tb, 2));
        }
        tb.setBorderPainted(false);
        tb.setFloatable(false);
        tb.setRollover(true);
        tb.setOpaque(false);
        return tb;
    }

    private static Border createToolBarBorder() {
        if (UISupport.isAquaLookAndFeel()) {
            return BorderFactory.createEmptyBorder(-1, 2, -1, 2);
        }
        if (UISupport.isNimbusLookAndFeel()) {
            return BorderFactory.createEmptyBorder(1, 2, 1, 2);
        }
        return BorderFactory.createEmptyBorder(2, 2, 2, 2);
    }

    private static int getButtonHeight() {
        Icon icon = new Icon(){

            public int getIconWidth() {
                return 16;
            }

            public int getIconHeight() {
                return 16;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        };
        JButton b = new JButton("Button", icon);
        JToolBar tb = new JToolBar();
        tb.setBorder(BorderFactory.createEmptyBorder());
        tb.setBorderPainted(false);
        tb.add(b);
        int bsize = tb.getPreferredSize().height;
        JToggleButton t = new JToggleButton("Button", icon);
        tb = new JToolBar();
        tb.setBorder(BorderFactory.createEmptyBorder());
        tb.setBorderPainted(false);
        tb.add(t);
        int tbsize = tb.getPreferredSize().height;
        if (UISupport.isAquaLookAndFeel()) {
            return Math.max(bsize, tbsize) + 4;
        }
        if (UISupport.isMetalLookAndFeel()) {
            return Math.max(bsize, tbsize) - 2;
        }
        return Math.max(bsize, tbsize);
    }

    private static boolean needsPanel() {
        if (NEEDS_PANEL == null) {
            NEEDS_PANEL = UISupport.isGTKLookAndFeel();
        }
        return NEEDS_PANEL;
    }

    static {
        PREFERRED_HEIGHT = -1;
        BUTTON_HEIGHT = -1;
    }

    private static final class ItemListener
    extends MouseAdapter
    implements ChangeListener,
    FocusListener {
        private static final String PROP_HOVERED = "BUTTON_HOVERED";

        private ItemListener() {
        }

        public void mouseEntered(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            b.putClientProperty(PROP_HOVERED, Boolean.TRUE);
            this.refresh(b);
        }

        public void mouseExited(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            b.putClientProperty(PROP_HOVERED, Boolean.FALSE);
            this.refresh(b);
        }

        public void stateChanged(ChangeEvent e) {
            this.refresh((AbstractButton)e.getSource());
        }

        public void focusGained(FocusEvent e) {
            this.refresh((AbstractButton)e.getSource());
        }

        public void focusLost(FocusEvent e) {
            this.refresh((AbstractButton)e.getSource());
        }

        private void refresh(AbstractButton b) {
            b.setBackground(UISupport.getDefaultBackground());
            boolean hovered = Boolean.TRUE.equals(b.getClientProperty(PROP_HOVERED));
            boolean filled = b.isEnabled() && (hovered || b.isSelected() || b.isFocusOwner());
            b.setOpaque(filled);
            b.setContentAreaFilled(filled);
            b.repaint();
        }
    }
}

