/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.axis.AxisComponent;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.AxisMarksPainter;
import org.netbeans.lib.profiler.charts.axis.BytesAxisUtils;
import org.netbeans.lib.profiler.charts.axis.BytesMarksPainter;
import org.netbeans.lib.profiler.charts.axis.SimpleLongMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimeMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimelineMarksComputer;
import org.netbeans.lib.profiler.charts.swing.CrossBorderLayout;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.BytesXYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.CompoundXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.DecimalXYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemMarker;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYChart;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipOverlay;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipPainter;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.GraphsUI;
import org.netbeans.lib.profiler.ui.memory.ClassHistoryModels;

public final class AllocationsHistoryGraphPanel
extends GraphPanel {
    private ProfilerXYChart chart;
    private Action[] chartActions;
    private final ClassHistoryModels models;

    public static AllocationsHistoryGraphPanel createPanel(ClassHistoryModels models) {
        return new AllocationsHistoryGraphPanel(models);
    }

    private AllocationsHistoryGraphPanel(ClassHistoryModels models) {
        this.models = models;
        this.initComponents();
        models.getDataManager().addDataListener(new DataManagerListener(){

            public void dataChanged() {
                AllocationsHistoryGraphPanel.this.updateData();
            }

            public void dataReset() {
                AllocationsHistoryGraphPanel.this.resetData();
            }
        });
        this.resetData();
    }

    @Override
    public Action[] getActions() {
        return this.chartActions;
    }

    private void updateData() {
    }

    private void resetData() {
        this.chart.setScale(0.02, 1.0);
        this.chart.setOffset(0L, 0L);
        this.chart.setFitsWidth(false);
        this.chart.setInitialDataBounds(new LongRect(System.currentTimeMillis(), 0L, 2500L, 100L));
    }

    private void initComponents() {
        PaintersModel paintersModel = this.createAllocPaintersModel();
        this.chart = this.createChart(this.models.allocationsItemsModel(), paintersModel, false);
        this.chart.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        this.chart.setViewInsets(new Insets(10, 0, 0, 0));
        AxisComponent hAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new TimelineMarksComputer(this.models.allocationsItemsModel().getTimeline(), this.chart.getChartContext(), 0), (AxisMarksPainter)new TimeMarksPainter(), 5, 2);
        SynchronousXYItem allocObjectsItem = this.models.allocationsItemsModel().getItem(0);
        XYItemPainter allocObjectsPainter = (XYItemPainter)paintersModel.getPainter((ChartItem)allocObjectsItem);
        SimpleLongMarksPainter allocObjectsMarksPainter = new SimpleLongMarksPainter();
        allocObjectsMarksPainter.setForeground(GraphsUI.A_ALLOC_OBJECTS_PAINTER_LINE_COLOR);
        AxisComponent tAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)allocObjectsItem, allocObjectsPainter, this.chart.getChartContext(), 1), (AxisMarksPainter)allocObjectsMarksPainter, 7, 2);
        SynchronousXYItem allocBytesItem = this.models.allocationsItemsModel().getItem(1);
        XYItemPainter allocBytesPainter = (XYItemPainter)paintersModel.getPainter((ChartItem)allocBytesItem);
        BytesMarksPainter allocBytesMarksPainter = new BytesMarksPainter();
        allocBytesMarksPainter.setForeground(GraphsUI.A_ALLOC_BYTES_PAINTER_LINE_COLOR);
        AxisComponent cAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new BytesXYItemMarksComputer((XYItem)allocBytesItem, allocBytesPainter, this.chart.getChartContext(), 1), (AxisMarksPainter)allocBytesMarksPainter, 3, 0);
        JPanel chartPanel = new JPanel((LayoutManager)new CrossBorderLayout());
        chartPanel.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        chartPanel.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, GraphsUI.CHART_BACKGROUND_COLOR));
        chartPanel.add((Component)((Object)this.chart), new Integer[]{0});
        chartPanel.add((Component)hAxis, new Integer[]{5, 6, 4});
        chartPanel.add((Component)tAxis, new Integer[]{7, 6});
        chartPanel.add((Component)cAxis, new Integer[]{3, 4});
        ProfilerXYTooltipPainter tooltipPainter = new ProfilerXYTooltipPainter(2.1f, GraphsUI.TOOLTIP_OVERLAY_LINE_COLOR, GraphsUI.TOOLTIP_OVERLAY_FILL_COLOR, this.getTooltipModel());
        this.chart.addOverlayComponent(new ProfilerXYTooltipOverlay((ChartComponent)this.chart, tooltipPainter));
        JScrollBar hScrollBar = new JScrollBar(0);
        this.chart.attachHorizontalScrollBar(hScrollBar);
        JPanel chartContainer = new JPanel(new BorderLayout());
        chartContainer.setBorder(BorderFactory.createEmptyBorder());
        chartContainer.add((Component)chartPanel, "Center");
        chartContainer.add((Component)hScrollBar, "South");
        JLabel allocObjectsBig = new JLabel(GraphsUI.A_ALLOC_OBJECTS_NAME, new ColorIcon(GraphsUI.A_ALLOC_OBJECTS_PAINTER_LINE_COLOR, Color.BLACK, 18, 9), 10);
        allocObjectsBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JLabel allocBytesBig = new JLabel(GraphsUI.A_ALLOC_BYTES_NAME, new ColorIcon(GraphsUI.A_ALLOC_BYTES_PAINTER_LINE_COLOR, Color.BLACK, 18, 9), 10);
        allocBytesBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JPanel bigLegendPanel = new JPanel(new FlowLayout(4, 7, 8));
        bigLegendPanel.add(allocObjectsBig);
        bigLegendPanel.add(allocBytesBig);
        JPanel legendContainer = new JPanel(new BorderLayout(0, 0));
        legendContainer.add((Component)UIUtils.createHorizontalLine(legendContainer.getBackground()), "North");
        legendContainer.add((Component)bigLegendPanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)chartContainer, "Center");
        this.add((Component)legendContainer, "South");
        this.chartActions = new Action[]{this.chart.zoomInAction(), this.chart.zoomOutAction(), this.chart.toggleViewAction()};
    }

    @Override
    protected ProfilerXYTooltipModel createTooltipModel() {
        return new ProfilerXYTooltipModel(){

            @Override
            public String getTimeValue(long timestamp) {
                return GraphPanel.DATE_FORMATTER.format(new Date(timestamp));
            }

            @Override
            public int getRowsCount() {
                return 2;
            }

            @Override
            public String getRowName(int index) {
                switch (index) {
                    case 0: {
                        return GraphsUI.A_ALLOC_OBJECTS_NAME;
                    }
                    case 1: {
                        return GraphsUI.A_ALLOC_BYTES_NAME;
                    }
                }
                return null;
            }

            @Override
            public Color getRowColor(int index) {
                switch (index) {
                    case 0: {
                        return GraphsUI.A_ALLOC_OBJECTS_PAINTER_LINE_COLOR;
                    }
                    case 1: {
                        return GraphsUI.A_ALLOC_BYTES_PAINTER_LINE_COLOR;
                    }
                }
                return null;
            }

            @Override
            public String getRowValue(int index, long itemValue) {
                return GraphPanel.INT_FORMATTER.format(itemValue);
            }

            @Override
            public String getRowUnits(int index, long itemValue) {
                switch (index) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return BytesAxisUtils.UNITS_B;
                    }
                }
                return null;
            }

            @Override
            public int getExtraRowsCount() {
                return this.getRowsCount();
            }

            @Override
            public String getExtraRowName(int index) {
                return AllocationsHistoryGraphPanel.this.getMaxValueString(this.getRowName(index));
            }

            @Override
            public Color getExtraRowColor(int index) {
                return this.getRowColor(index);
            }

            @Override
            public String getExtraRowValue(int index) {
                SynchronousXYItem item = AllocationsHistoryGraphPanel.this.models.allocationsItemsModel().getItem(index);
                return GraphPanel.INT_FORMATTER.format(item.getMaxYValue());
            }

            @Override
            public String getExtraRowUnits(int index) {
                return this.getRowUnits(index, -1L);
            }
        };
    }

    private PaintersModel createAllocPaintersModel() {
        SynchronousXYItemPainter allocObjectsPainter = SynchronousXYItemPainter.absolutePainter((float)3.0f, (Color)GraphsUI.A_ALLOC_OBJECTS_PAINTER_LINE_COLOR, (Color)GraphsUI.A_ALLOC_OBJECTS_PAINTER_FILL_COLOR);
        SynchronousXYItemMarker allocObjectsMarker = SynchronousXYItemMarker.absolutePainter((int)5, (float)0.75f, (Color)GraphsUI.A_ALLOC_OBJECTS_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.A_ALLOC_OBJECTS_MARKER_LINE2_COLOR, (Color)GraphsUI.A_ALLOC_OBJECTS_MARKER_FILL_COLOR);
        CompoundXYItemPainter aop = new CompoundXYItemPainter((XYItemPainter)allocObjectsPainter, (XYItemPainter)allocObjectsMarker);
        SynchronousXYItemPainter allocatedBytesPainter = SynchronousXYItemPainter.relativePainter((float)3.0f, (Color)GraphsUI.A_ALLOC_BYTES_PAINTER_LINE_COLOR, (Color)GraphsUI.A_ALLOC_BYTES_PAINTER_FILL_COLOR, (int)10);
        SynchronousXYItemMarker allocatedBytesMarker = SynchronousXYItemMarker.relativePainter((int)5, (float)0.75f, (Color)GraphsUI.A_ALLOC_BYTES_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.A_ALLOC_BYTES_MARKER_LINE2_COLOR, (Color)GraphsUI.A_ALLOC_BYTES_MARKER_FILL_COLOR, (int)10);
        CompoundXYItemPainter abp = new CompoundXYItemPainter((XYItemPainter)allocatedBytesPainter, (XYItemPainter)allocatedBytesMarker);
        SynchronousXYItemsModel items = this.models.allocationsItemsModel();
        PaintersModel.Default model = new PaintersModel.Default(new ChartItem[]{items.getItem(0), items.getItem(1)}, (ItemPainter[])new XYItemPainter[]{aop, abp});
        return model;
    }
}

