/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.logging.NbFormatter;
import org.netbeans.core.startup.logging.NbLogging;
import org.netbeans.core.startup.logging.PrintStreamLogger;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

public final class TopLogging {
    private static boolean disabledConsole = !Boolean.getBoolean("netbeans.logger.console");
    private static final PrintStream OLD_ERR = System.err;
    private static File previousUser;
    private static Handler streamHandler;
    private static Handler defaultHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopLogging() {
        AWTHandler.install();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        LinkedList<Logger> keep = new LinkedList<Logger>();
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            String key;
            Object objKey = e.getKey();
            if (!(objKey instanceof String) || "sun.os.patch.level".equals(key = (String)objKey) || !(e.getValue() instanceof String)) continue;
            String v = (String)e.getValue();
            if (!key.endsWith(".level")) continue;
            ps.print(key);
            ps.print('=');
            ps.println(v);
            keep.add(Logger.getLogger(key.substring(0, key.length() - 6)));
        }
        ps.close();
        try {
            StartLog.unregister();
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(os.toByteArray()));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            StartLog.register();
        }
        Logger logger = Logger.getLogger("");
        Handler[] old = logger.getHandlers();
        for (int i = 0; i < old.length; ++i) {
            logger.removeHandler(old[i]);
        }
        logger.addHandler(TopLogging.defaultHandler());
        if (!disabledConsole) {
            logger.addHandler(TopLogging.streamHandler());
        }
        logger.addHandler(new LookupDel());
    }

    public static void initializeQuietly() {
        TopLogging.initialize(false);
    }

    public static void printStackTrace(Throwable t, PrintWriter pw) {
        NbFormatter.printStackTrace(t, pw);
    }

    static final void initialize() {
        TopLogging.initialize(true);
    }

    private static void initialize(boolean verbose) {
        block11: {
            AWTHandler.install();
            if (previousUser == null || previousUser.equals(Places.getUserDirectory())) {
                streamHandler = null;
                defaultHandler = null;
            }
            if (System.getProperty("java.util.logging.config.file") != null) {
                return;
            }
            String v = System.getProperty("java.util.logging.config.class");
            String p = TopLogging.class.getName();
            if (v != null && !v.equals(p)) {
                return;
            }
            new TopLogging();
            System.setProperty("java.util.logging.config.class", p);
            if (verbose) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(os);
                TopLogging.printSystemInfo(ps);
                ps.close();
                try {
                    Logger logger = Logger.getLogger(TopLogging.class.getName());
                    logger.log(Level.INFO, os.toString("utf-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError();
                }
            }
        }
        if (!Boolean.getBoolean("netbeans.logger.noSystem")) {
            if (!PrintStreamLogger.isLogger(System.err)) {
                System.setErr(PrintStreamLogger.create("stderr"));
                if (NbLogging.DEBUG != null) {
                    NbLogging.DEBUG.println("initializing stderr");
                }
            }
            if (!PrintStreamLogger.isLogger(System.out)) {
                System.setErr(PrintStreamLogger.create("stderr"));
                if (NbLogging.DEBUG != null) {
                    NbLogging.DEBUG.println("initializing stdout");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printSystemInfo(PrintStream ps) {
        String cp;
        DateFormat df = DateFormat.getDateTimeInstance(0, 0, Locale.US);
        Date date = new Date();
        ps.println("-------------------------------------------------------------------------------");
        ps.println(">Log Session: " + df.format(date));
        ps.println(">System Info: ");
        ArrayList<File> clusters = new ArrayList<File>();
        String nbdirs = System.getProperty("netbeans.dirs");
        if (nbdirs != null) {
            StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                File dir = FileUtil.normalizeFile((File)new File(tok.nextToken()));
                if (!dir.isDirectory()) continue;
                clusters.add(dir);
            }
        }
        String buildNumber = System.getProperty("netbeans.buildnumber");
        String currentVersion = NbBundle.getMessage(TopLogging.class, (String)"currentVersion", (Object)buildNumber);
        System.setProperty("netbeans.productversion", currentVersion);
        ps.print("  Product Version         = " + currentVersion);
        block6: for (File cluster : clusters) {
            File buildInfo = new File(cluster, "build_info");
            if (!buildInfo.isFile()) continue;
            try {
                FileReader r = new FileReader(buildInfo);
                try {
                    String line;
                    BufferedReader b = new BufferedReader(r);
                    Pattern p = Pattern.compile("Hg ID:    ([0-9a-f]{12})");
                    while ((line = b.readLine()) != null) {
                        Matcher m = p.matcher(line);
                        if (!m.matches()) continue;
                        ps.print(" (#" + m.group(1) + ")");
                        break block6;
                    }
                }
                finally {
                    ((Reader)r).close();
                }
            }
            catch (IOException x) {
                x.printStackTrace(ps);
            }
            break;
        }
        ps.println();
        ps.println("  Operating System        = " + System.getProperty("os.name", "unknown") + " version " + System.getProperty("os.version", "unknown") + " running on " + System.getProperty("os.arch", "unknown"));
        ps.println("  Java; VM; Vendor        = " + System.getProperty("java.version", "unknown") + "; " + System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "") + "; " + System.getProperty("java.vendor", "unknown"));
        ps.println("  Runtime                 = " + System.getProperty("java.runtime.name", "unknown") + " " + System.getProperty("java.runtime.version", ""));
        ps.println("  Java Home               = " + System.getProperty("java.home", "unknown"));
        ps.print("  System Locale; Encoding = " + Locale.getDefault());
        String branding = NbBundle.getBranding();
        if (branding != null) {
            ps.print(" (" + branding + ")");
        }
        ps.println("; " + System.getProperty("file.encoding", "unknown"));
        ps.println("  Home Directory          = " + System.getProperty("user.home", "unknown"));
        ps.println("  Current Directory       = " + System.getProperty("user.dir", "unknown"));
        ps.print("  User Directory          = ");
        ps.println(CLIOptions.getUserDir());
        ps.println("  Cache Directory         = " + Places.getCacheDirectory());
        ps.print("  Installation            = ");
        for (File cluster : clusters) {
            ps.print(cluster + "\n                            ");
        }
        ps.println(CLIOptions.getHomeDir());
        ps.println("  Boot & Ext. Classpath   = " + TopLogging.createBootClassPath());
        ClassLoader l = Lookup.class.getClassLoader();
        if (l == ClassLoader.getSystemClassLoader()) {
            cp = System.getProperty("java.class.path", "unknown");
        } else {
            StringBuilder sb = new StringBuilder("loaded by ");
            if (l instanceof URLClassLoader) {
                sb.append("URLClassLoader");
                for (URL u : ((URLClassLoader)l).getURLs()) {
                    sb.append(' ').append(u);
                }
            } else {
                sb.append(l);
            }
            cp = sb.toString();
        }
        ps.println("  Application Classpath   = " + cp);
        ps.println("  Startup Classpath       = " + System.getProperty("netbeans.dynamic.classpath", "unknown"));
        ps.println("-------------------------------------------------------------------------------");
    }

    private static String createBootClassPath() {
        String boot = System.getProperty("sun.boot.class.path");
        StringBuffer sb = boot != null ? new StringBuffer(boot) : new StringBuffer();
        TopLogging.findBootJars(System.getProperty("java.ext.dirs"), sb);
        TopLogging.findBootJars(System.getProperty("java.endorsed.dirs"), sb);
        return sb.toString();
    }

    private static void findBootJars(String extensions, StringBuffer sb) {
        if (extensions != null) {
            StringTokenizer st = new StringTokenizer(extensions, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                File[] entries = dir.listFiles();
                if (entries == null) continue;
                for (int i = 0; i < entries.length; ++i) {
                    String name = entries[i].getName().toLowerCase(Locale.US);
                    if (!name.endsWith(".zip") && !name.endsWith(".jar")) continue;
                    if (sb.length() > 0) {
                        sb.append(File.pathSeparatorChar);
                    }
                    sb.append(entries[i].getPath());
                }
            }
        }
    }

    static Handler createStreamHandler(PrintStream pw) {
        StreamHandler s = new StreamHandler(pw, NbFormatter.FORMATTER);
        return NbLogging.createDispatchHandler(s, 50);
    }

    private static synchronized Handler streamHandler() {
        if (streamHandler == null) {
            StreamHandler sth = new StreamHandler(OLD_ERR, NbFormatter.FORMATTER);
            sth.setLevel(Level.ALL);
            streamHandler = NbLogging.createDispatchHandler(sth, 500);
        }
        return streamHandler;
    }

    private static synchronized Handler defaultHandler() {
        if (defaultHandler != null) {
            return defaultHandler;
        }
        File home = Places.getUserDirectory();
        if (home != null && !CLIOptions.noLogging) {
            File dir = new File(new File(home, "var"), "log");
            dir.mkdirs();
            Handler h = NbLogging.createMessagesHandler(dir);
            defaultHandler = NbLogging.createDispatchHandler(h, 5000);
        }
        if (defaultHandler == null) {
            defaultHandler = TopLogging.streamHandler();
            disabledConsole = true;
        }
        return defaultHandler;
    }

    static void flush(boolean clear) {
        Handler d;
        System.err.flush();
        Handler s = streamHandler;
        if (s != null) {
            s.flush();
        }
        if ((d = defaultHandler) != null) {
            d.flush();
        }
        if (clear) {
            streamHandler = null;
            defaultHandler = null;
        }
    }

    static void close() {
        NbLogging.close(streamHandler);
        NbLogging.close(defaultHandler);
    }

    static void exit(int exit) {
        TopLogging.flush(false);
        TopSecurityManager.exit((int)exit);
    }

    private static final class AWTHandler
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler delegate;
        private final Logger g;

        private AWTHandler(Thread.UncaughtExceptionHandler delegate) {
            this.delegate = delegate;
            this.g = Logger.getLogger("global");
        }

        static void install() {
            if (Thread.getDefaultUncaughtExceptionHandler() instanceof AWTHandler) {
                return;
            }
            Thread.setDefaultUncaughtExceptionHandler(new AWTHandler(Thread.getDefaultUncaughtExceptionHandler()));
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (this.delegate != null) {
                this.delegate.uncaughtException(t, e);
            }
            if (e.getClass().getName().endsWith(".ExitSecurityException")) {
                return;
            }
            if (e instanceof ThreadDeath) {
                return;
            }
            this.g.log(Level.SEVERE, null, e);
        }
    }

    private static final class LookupDel
    extends Handler
    implements LookupListener {
        private Lookup.Result<Handler> handlers = Lookup.getDefault().lookupResult(Handler.class);
        private Collection<? extends Handler> instances = this.handlers.allInstances();

        public LookupDel() {
            this.instances.size();
            this.handlers.addLookupListener((LookupListener)this);
        }

        @Override
        public void publish(LogRecord record) {
            for (Handler handler : this.instances) {
                handler.publish(record);
            }
        }

        @Override
        public void flush() {
            for (Handler handler : this.instances) {
                handler.flush();
            }
        }

        @Override
        public void close() throws SecurityException {
            for (Handler handler : this.instances) {
                handler.close();
            }
        }

        public void resultChanged(LookupEvent ev) {
            this.instances = this.handlers.allInstances();
        }
    }
}

