/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.Events;
import org.netbeans.Module;
import org.netbeans.Util;
import org.netbeans.core.startup.Bundle;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.NbProblemDisplayer;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopLogging;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

final class NbEvents
extends Events {
    private static final Logger logger = Logger.getLogger(NbEvents.class.getName());
    private int moduleCount;
    private int counter;

    NbEvents() {
    }

    protected void logged(String message, Object[] args) {
        if (message.equals("perfTick")) {
            StartLog.logProgress((String)args[0]);
        } else if (message.equals("perfStart")) {
            StartLog.logStart((String)args[0]);
        } else if (message.equals("perfEnd")) {
            StartLog.logEnd((String)args[0]);
        } else if (message.equals("startCreateBootModule")) {
            Splash.getInstance().increment(1);
        } else if (message.equals("startLoadBootModules")) {
            NbEvents.setStatusText(Bundle.MSG_start_load_boot_modules());
            StartLog.logStart("ModuleSystem.loadBootModules");
        } else if (message.equals("startLoad")) {
            StartLog.logStart("NbInstaller.load");
        } else if (message.equals("finishLoadBootModules")) {
            NbEvents.setStatusText(Bundle.MSG_finish_load_boot_modules());
            StartLog.logEnd("ModuleSystem.loadBootModules");
        } else if (message.equals("finishLoad")) {
            StartLog.logEnd("NbInstaller.load");
        } else if (message.equals("startAutoRestore")) {
            Set modules = (Set)args[0];
            if (!modules.isEmpty()) {
                NbEvents.setStatusText(Bundle.MSG_start_auto_restore());
            }
        } else if (message.equals("finishAutoRestore")) {
            NbEvents.setStatusText(Bundle.MSG_finish_auto_restore());
        } else if (message.equals("startEnableModules")) {
            NbEvents.setStatusText(Bundle.MSG_start_enable_modules());
        } else if (message.equals("finishEnableModules")) {
            List modules = NbCollections.checkedListByCopy((List)((List)args[0]), Module.class, (boolean)true);
            if (!modules.isEmpty()) {
                logger.log(Level.INFO, Bundle.TEXT_finish_enable_modules());
                this.dumpModulesList(modules);
            }
            NbEvents.setStatusText(Bundle.MSG_finish_enable_modules());
            StartLog.logEnd("ModuleManager.enable");
        } else if (message.equals("startDisableModules")) {
            NbEvents.setStatusText(Bundle.MSG_start_disable_modules());
        } else if (message.equals("finishDisableModules")) {
            List modules = NbCollections.checkedListByCopy((List)((List)args[0]), Module.class, (boolean)true);
            if (!modules.isEmpty()) {
                logger.log(Level.INFO, Bundle.TEXT_finish_disable_modules());
                this.dumpModulesList(modules);
            }
            NbEvents.setStatusText(Bundle.MSG_finish_disable_modules());
        } else if (message.equals("startDeployTestModule")) {
            String msg = Bundle.TEXT_start_deploy_test_module((File)args[0]);
            NbEvents.setStatusText(msg);
        } else if (message.equals("finishDeployTestModule")) {
            NbEvents.setStatusText(Bundle.TEXT_finish_deploy_test_module());
        } else if (message.equals("failedInstallNew")) {
            Set modules = NbCollections.checkedSetByCopy((Set)((Set)args[0]), Module.class, (boolean)true);
            StringBuilder buf = new StringBuilder(Bundle.MSG_failed_install_new());
            NbProblemDisplayer.problemMessagesForModules(buf, modules, false);
            buf.append('\n');
            logger.log(Level.INFO, buf.toString());
            buf = new StringBuilder(Bundle.MSG_failed_install_new());
            NbProblemDisplayer.problemMessagesForModules(buf, modules, true);
            String msg = buf.toString();
            this.notify(msg, true);
            NbEvents.setStatusText("");
        } else if (message.equals("failedInstallNewUnexpected")) {
            Module m = (Module)args[0];
            ArrayList<Module> modules = new ArrayList<Module>();
            modules.add(m);
            modules.addAll(NbCollections.checkedSetByCopy((Set)((Set)args[1]), Module.class, (boolean)true));
            StringBuilder buf = new StringBuilder(Bundle.MSG_failed_install_new_unexpected(m.getDisplayName()));
            NbProblemDisplayer.problemMessagesForModules(buf, modules, false);
            buf.append('\n');
            logger.log(Level.INFO, buf.toString());
            this.notify(NbProblemDisplayer.messageForProblem(m, m.getProblems().iterator().next(), true), true);
            NbEvents.setStatusText("");
        } else if (message.equals("startRead")) {
            NbEvents.setStatusText(Bundle.MSG_start_read());
            StartLog.logStart("ModuleList.readInitial");
        } else if (message.equals("modulesFileScanned")) {
            this.moduleCount = (Integer)args[0];
            Splash.getInstance().addToMaxSteps(Math.max(this.moduleCount + this.moduleCount / 2 - 100, 0));
        } else if (message.equals("modulesFileProcessed")) {
            Splash.getInstance().increment(1);
            if (StartLog.willLog()) {
                StartLog.logProgress("module " + args[0] + " processed");
            }
        } else if (message.equals("finishRead")) {
            if (this.moduleCount < 100) {
                Splash.getInstance().increment(this.moduleCount - 100);
            }
            NbEvents.setStatusText(Bundle.MSG_finish_read());
            StartLog.logEnd("ModuleList.readInitial");
        } else if (message.equals("restore")) {
            NbEvents.setStatusText(Bundle.MSG_restore());
            if (++this.counter < this.moduleCount / 2) {
                Splash.getInstance().increment(1);
            }
        } else if (message.equals("install")) {
            NbEvents.setStatusText(Bundle.MSG_install(((Module)args[0]).getDisplayName()));
            logger.log(Level.INFO, Bundle.TEXT_install(((Module)args[0]).getDisplayName()));
        } else if (message.equals("update")) {
            NbEvents.setStatusText(Bundle.MSG_update(((Module)args[0]).getDisplayName()));
            logger.log(Level.INFO, Bundle.TEXT_update(((Module)args[0]).getDisplayName()));
        } else if (message.equals("uninstall")) {
            NbEvents.setStatusText(Bundle.MSG_uninstall(((Module)args[0]).getDisplayName()));
        } else if (message.equals("loadSection")) {
            NbEvents.setStatusText(Bundle.MSG_load_section());
            if (++this.counter < this.moduleCount / 4) {
                Splash.getInstance().increment(1);
            }
        } else if (message.equals("loadLayers")) {
            NbEvents.setStatusText(Bundle.MSG_load_layers());
        } else if (message.equals("wrongClassLoader")) {
            if (!Boolean.getBoolean("netbeans.moduleitem.dontverifyclassloader") && Util.err.isLoggable(Level.WARNING)) {
                Class clazz = (Class)args[1];
                StringBuilder b = new StringBuilder();
                b.append("The module ").append(((Module)args[0]).getDisplayName()).append(" loaded the class ").append(clazz.getName()).append("\n");
                b.append("from the wrong classloader. The expected classloader was ").append(args[2]).append("\n");
                b.append("whereas it was actually loaded from ").append(clazz.getClassLoader()).append("\n");
                b.append("Usually this means that some classes were in the startup classpath.\n");
                b.append("To suppress this message, run with: -J-Dnetbeans.moduleitem.dontverifyclassloader=true");
                Util.err.warning(b.toString());
            }
        } else if (message.equals("extensionMultiplyLoaded")) {
            logger.log(Level.WARNING, "The extension {0} may be multiply loaded by modules: {1}; see: http://www.netbeans.org/download/dev/javadoc/org-openide-modules/org/openide/modules/doc-files/classpath.html#class-path", new Object[]{(File)args[0], (Set)args[1]});
        } else if (message.equals("missingJarFile")) {
            File jar = (File)args[0];
            Level level = Boolean.FALSE.equals(args[1]) ? Level.FINE : Level.INFO;
            logger.log(level, Bundle.TEXT_missing_jar_file(jar.getAbsolutePath()));
        } else if (message.equals("cantDeleteEnabledAutoload")) {
            Module m = (Module)args[0];
            logger.log(Level.INFO, Bundle.TEXT_cant_delete_enabled_autoload(m.getDisplayName()));
        } else if (message.equals("miscPropMismatch")) {
            Module m = (Module)args[0];
            String prop = (String)args[1];
            Object onDisk = args[2];
            Object inMem = args[3];
            logger.log(Level.INFO, Bundle.TEXT_misc_prop_mismatch(m.getDisplayName(), prop, onDisk, inMem));
        } else if (message.equals("patch")) {
            File f = (File)args[0];
            logger.log(Level.INFO, Bundle.TEXT_patch(f.getAbsolutePath()));
        }
    }

    private void dumpModulesList(Collection<Module> modules) {
        if (modules.isEmpty()) {
            throw new IllegalArgumentException();
        }
        StringBuilder buf = new StringBuilder(modules.size() * 100 + 1);
        String lineSep = System.getProperty("line.separator");
        for (Module m : modules) {
            String bv;
            String iv;
            buf.append('\t');
            buf.append(m.getCodeName());
            buf.append(" [");
            SpecificationVersion sv = m.getSpecificationVersion();
            if (sv != null) {
                buf.append(sv);
            }
            if ((iv = m.getImplementationVersion()) != null) {
                buf.append(' ');
                buf.append(iv);
            }
            if ((bv = m.getBuildVersion()) != null && !bv.equals(iv)) {
                buf.append(' ');
                buf.append(bv);
            }
            buf.append(']');
            buf.append(lineSep);
        }
        logger.log(Level.INFO, buf.toString());
    }

    private void notify(String text, boolean warn) {
        if (GraphicsEnvironment.isHeadless() || Boolean.getBoolean("netbeans.full.hack")) {
            logger.log(Level.WARNING, "{0}\n", text);
        } else {
            new Notifier(text, warn).show();
        }
    }

    private static void setStatusText(String msg) {
        Main.setStatusText(msg);
    }

    private static final class Notifier
    implements Runnable {
        private static boolean showDialog = true;
        private boolean warn;
        private String text;
        private static RequestProcessor RP = new RequestProcessor("Notify About Module System");

        public Notifier(String text, boolean type) {
            this.warn = type;
            this.text = text;
        }

        void show() {
            if (showDialog) {
                showDialog = false;
                if (EventQueue.isDispatchThread()) {
                    this.run();
                } else {
                    RP.post((Runnable)this, 0, 1).waitFinished();
                }
            }
        }

        @Override
        public void run() {
            int ret;
            JComponent sp;
            int type = this.warn ? 2 : 1;
            String msg = this.warn ? Bundle.MSG_warning() : Bundle.MSG_info();
            Splash out = Splash.getInstance();
            Component c = out.getComponent() == null ? null : out.getComponent();
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.INFO, null, ex);
            }
            catch (InstantiationException ex) {
                logger.log(Level.INFO, null, ex);
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.INFO, null, ex);
            }
            catch (UnsupportedLookAndFeelException ex) {
                logger.log(Level.INFO, null, ex);
            }
            JTextPane tp = new JTextPane();
            tp.setContentType("text/html");
            this.text = this.text.replace("\n", "<br>");
            tp.setEditable(false);
            tp.setOpaque(false);
            tp.setEnabled(true);
            tp.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hlevt) {
                    if (HyperlinkEvent.EventType.ACTIVATED == hlevt.getEventType()) {
                        assert (hlevt.getURL() != null);
                        try {
                            Desktop.getDesktop().browse(hlevt.getURL().toURI());
                        }
                        catch (Exception ex) {
                            logger.log(Level.INFO, null, ex);
                        }
                    }
                }
            });
            tp.setText(this.text);
            if (tp.getPreferredSize().width > 600 || tp.getPreferredSize().height > 400) {
                tp.setPreferredSize(new Dimension(600, 400));
                sp = new JScrollPane(tp);
            } else {
                sp = tp;
            }
            final JOptionPane op = new JOptionPane(sp, type, 0, null);
            JButton continueButton = new JButton(Bundle.MSG_continue());
            continueButton.setDisplayedMnemonicIndex(0);
            continueButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    op.setValue(0);
                }
            });
            JButton exitButton = new JButton(Bundle.MSG_exit());
            exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    op.setValue(1);
                }
            });
            Object[] options = new JButton[]{continueButton, exitButton};
            op.setOptions(options);
            op.setInitialValue(options[1]);
            JDialog d = op.createDialog(c, msg);
            d.setResizable(true);
            d.setVisible(true);
            Object res = op.getValue();
            if (res instanceof Integer && ((ret = ((Integer)res).intValue()) == 1 || ret == -1)) {
                TopLogging.exit(1);
            }
        }
    }
}

