/***************************< vis2u.c >*********************************/
/*** Purpose: Convert a VISCII file to 2 versions of Unicode file    ***/
/*** Author:  07/05/98:  Van Ho - Original author                    ***/
/*** ------   07/06/98:  Van Le - Combine vis2u + revend into one    ***/
/***                     and make it can be compiled in Unix env.    ***/
/***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
 
unsigned int tabviscii[256] =
{   0x0000, 0x0001, 0x1EB2, 0x0003, 0x0004, 0x1EB4, 0x1EAA, 0x0007,
    0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
    0x0010, 0x0011, 0x0012, 0x0013, 0x1EF6, 0x0015, 0x0016, 0x0017,
    0x0018, 0x1EF8, 0x001a, 0x001b, 0x001c, 0x001d, 0x1EF4, 0x001f,
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f,
    0x1EA0, 0x1EAE, 0x1EB0, 0x1EB6, 0x1EA4, 0x1EA6, 0x1EA8, 0x1EAC,
    0x1EBC, 0x1EB8, 0x1EBE, 0x1EC0, 0x1EC2, 0x1EC4, 0x1EC6, 0x1ED0,
    0x1ED2, 0x1ED4, 0x1ED6, 0x1ED8, 0x1EE2, 0x1EDA, 0x1EDC, 0x1EDE,
    0x1ECA, 0x1ECE, 0x1ECC, 0x1EC8, 0x1EE6, 0x0168, 0x1EE4, 0x1EF2,
    0x00D5, 0x1EAF, 0x1EB1, 0x1EB7, 0x1EA5, 0x1EA7, 0x1EA9, 0x1EAD,
    0x1EBD, 0x1EB9, 0x1EBF, 0x1EC1, 0x1EC3, 0x1EC5, 0x1EC7, 0x1ED1,
    0x1ED3, 0x1ED5, 0x1ED7, 0x1EE0, 0x01A0, 0x1ED9, 0x1EDD, 0x1EDF,
    0x1ECB, 0x1EF0, 0x1EE8, 0x1EEA, 0x1EEC, 0x01A1, 0x1EDB, 0x01AF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x1EA2, 0x0102, 0x1EB3, 0x1EB5,
    0x00C8, 0x00C9, 0x00CA, 0x1EBA, 0x00CC, 0x00CD, 0x0128, 0x1EF3,
    0x0110, 0x1EE9, 0x00D2, 0x00D3, 0x00D4, 0x1EA1, 0x1EF7, 0x1EEB,
    0x1EED, 0x00D9, 0x00DA, 0x1EF9, 0x1EF5, 0x00DD, 0x1EE1, 0x01B0,
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x1EA3, 0x0103, 0x1EEF, 0x1EAB,
    0x00E8, 0x00E9, 0x00EA, 0x1EBB, 0x00EC, 0x00ED, 0x0129, 0x1EC9,
    0x0111, 0x1EF1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x1ECF, 0x1ECD,
    0x1EE5, 0x00F9, 0x00FA, 0x0169, 0x1EE7, 0x00FD, 0x1EE3, 0x1EEE
};
 
/***********************************************************************/
/*** Function: main()                                                ***/
/*** Purpose:                                                        ***/
/***********************************************************************/
void main(int argc, char *argv[]) {
     FILE *fin;
     int fout1, fout2, er, x;
     unsigned char c, outc[2];
 
     /******* Check syntax ********************/
     if (argc != 4) {
         fprintf (stderr, "VIS2U viscii_input_file unicode_output_file1 unicode_output_file2\n");
         exit(1);
     }
     /******* Open all necessary files ********/
     fin = fopen(argv[1],"rt");
     if (fin == NULL) er = 1;
     else { int mask;
            mask = O_CREAT | O_TRUNC | O_WRONLY;
#ifdef O_BINARY
            mask = mask | O_BINARY;
#endif
            fout1 = open(argv[2],mask, S_IREAD | S_IWRITE);
            if (fout1 == -1) er = 2;
            else { fout2 = open(argv[3],mask, S_IREAD | S_IWRITE);
                   if (fout2 == -1) er = 3;
                   else             er = 0;
            }
     }
     if (er) {
         fprintf(stderr,"Unable to access file %s.\n",argv[er]);
         exit(1);
     }
     /******* Start conversion ****************/
     x = 0xFEFF;
     while (!feof(fin)) {
         c = x & 0xFF;
         outc[0] = c;
         outc[1] = x >> 8;
         if (write(fout1,outc,2) != 2) { er = 2; break; }
         outc[0] = outc[1];
         outc[1] = c;
         if (write(fout2,outc,2) != 2) { er = 3; break; }
         c = getc(fin);
         x = tabviscii[c];
     }
     if (er) fprintf(stderr,"Error writing to file %s.\n",argv[er]);
     close(fout2);
     close(fout1);
     fclose(fin);
}
