unit UDFSel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, vStrip,
  StdCtrls, ComCtrls;

type
  TUDFSelector = class(TForm)
    TreeViewFiles: TTreeView;
    ComboBoxDrives: TComboBox;
    ButtonScan: TButton;
    ListBoxFiles: TListBox;
    ButtonOK: TButton;
    ButtonCancel: TButton;
    ButtonClear: TButton;
    ButtonRemove: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ButtonScanClick(Sender: TObject);
    procedure ComboBoxDrivesChange(Sender: TObject);
    procedure TreeViewFilesDblClick(Sender: TObject);
    procedure ButtonOKClick(Sender: TObject);
    procedure ButtonCancelClick(Sender: TObject);
    procedure ButtonClearClick(Sender: TObject);
    procedure ButtonRemoveClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Drives: array['C'..'Z'] of Cardinal;
    DrivesFound: Cardinal;
    procedure udf_traverse(address: Cardinal; f: tp_udf_file; parent: TTreeNode; tv: TTreeView);
  public
    { Public-Deklarationen }
  end;

implementation

{$R *.DFM}

procedure TUDFSelector.FormCreate(Sender: TObject);
begin
  ButtonScanClick(Nil);
end;

procedure TUDFSelector.ButtonScanClick(Sender: TObject);
var
  i: Char;
  address, secsize, maxsec: Cardinal;
  f: tp_udf_file;
begin
  DrivesFound := 0;
  TreeViewFiles.Items.Clear();
  ComboBoxDrives.Items.BeginUpdate();
  ComboBoxDrives.Items.Clear();
  for i := Low(Drives) to High(Drives) do begin
    Drives[i] := $ffffffff;
    if (aspi_GetDriveAddress(i, address) and aspi_GetSectorInfo(address, secsize, maxsec) and (secsize = fio_SECTOR_SIZE)) then begin
      f := udf_get_root(address, 0, True);
      if (f <> Nil) then begin
        Drives[i] := address;
        Inc(DrivesFound);
        ComboBoxDrives.Items.Add(i + ':\ [' + f^.name + ']');
        udf_free(f);
      end;
    end;
  end;
  ComboBoxDrives.Items.EndUpdate();
  if (DrivesFound = 1) then begin
    ComboBoxDrives.ItemIndex := 0;
    ComboBoxDrivesChange(Nil);
  end
end;

procedure TUDFSelector.udf_traverse(address: Cardinal; f: tp_udf_file; parent: TTreeNode; tv: TTreeView);
var
  name: String;
  i: Cardinal;
  fs: tp_udf_file;
  startlba, endlba: Cardinal;
  node: TTreeNode;
begin
  while (udf_get_next(address, f) <> Nil) do begin
    if (not f^.is_parent) then begin
      name := f^.name;
      i := 0;
      if (not f^.is_dir) then begin
        i := Length(name);
        if (udf_get_lba(address, f, startlba, endlba)) then
          name := name + ' [' + IntToStr((endlba - startlba) shl 1) + ' kb]';
      end;
      node := tv.Items.AddChildObject(parent, name, Pointer(i));
      if (f^.is_dir) then begin
	fs := udf_get_sub(address, f);
	if (fs <> Nil) then begin
          udf_traverse(address, fs, node, tv);
          udf_free(fs);
        end;
      end;
    end;
  end;
end;

procedure TUDFSelector.ComboBoxDrivesChange(Sender: TObject);
var
  address: Cardinal;
  f: tp_udf_file;
begin
  TreeViewFiles.Items.BeginUpdate();
  TreeViewFiles.Items.Clear();
  if ((DrivesFound > 0) and (ComboBoxDrives.ItemIndex >= 0)) then begin
    address := Drives[ComboBoxDrives.Items[ComboBoxDrives.ItemIndex][1]];
    if (address <> $ffffffff) then begin
      f := udf_get_root(address, 0, True);
      if (f <> Nil) then begin
        udf_traverse(address, f, Nil, TreeViewFiles);
        udf_free(f);
      end;
    end;
  end;
  TreeViewFiles.Items.EndUpdate();
end;

procedure TUDFSelector.TreeViewFilesDblClick(Sender: TObject);
var
  item: TTreeNode;
  fname: String;
begin
  item := TreeViewFiles.Selected;
  if ((item <> Nil) and (Integer(item.Data) > 0)) then begin
    fname := Copy(item.Text, 0, Integer(item.Data));
    item := item.Parent;
    while (item <> Nil) do begin
      fname := item.Text + '\' + fname;
      item := item.Parent;
    end;
    fname := Copy(ComboBoxDrives.Items[ComboBoxDrives.ItemIndex], 0, 3) + fname;
    ListBoxFiles.Items.Add(fname);
  end;
end;

procedure TUDFSelector.ButtonOKClick(Sender: TObject);
begin
  if (ListBoxFiles.Items.Count > 0) then
    ModalResult := ListBoxFiles.Items.Count
  else
    ModalResult := -1;
end;

procedure TUDFSelector.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := -1;
end;

procedure TUDFSelector.ButtonClearClick(Sender: TObject);
begin
  ListBoxFiles.Items.Clear();
end;

procedure TUDFSelector.ButtonRemoveClick(Sender: TObject);
begin
  if (ListBoxFiles.ItemIndex <> -1) then
    ListBoxFiles.Items.Delete(ListBoxFiles.ItemIndex);
end;

end.
