// WorldMain.cpp: implementation of the CWorldMain class.
//
//////////////////////////////////////////////////////////////////////

#include "uox3.h"
#include "worldmain.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CWorldMain::CWorldMain()
{
	announce(false/*0*/);
}

CWorldMain::~CWorldMain()
{

}


//o---------------------------------------------------------------------------o
//|	Class		:	CWorldMain::savenewworld(char x)
//|	Date		:	Unknown
//|	Programmer	:	Unknown		(Moved from uox3.cpp by EviLDeD - Dec 22, 1998)
//o---------------------------------------------------------------------------o
//| Purpose		:	Save current world state. Stores all values in an easily
//|					readable script file "*.wsc". This stores all world items
//|					and NPC/PC character information for a given shard
//o---------------------------------------------------------------------------o
void CWorldMain::savenewworld(char x)
{
	int j;
	unsigned int i;
	// Dupois - If shard op has defined an ARCHIVEPATH in SERVER.SCP
	//          then archive the WSC to the directory specified.
	// Added Oct 29, 1998
	if (strlen(server_data.archivepath)>1)
		fileArchive("uox3.wsc", server_data.archivepath);
	// End - Dupois

	//	EviLDeD -	Put in the ability to toggle the display of WorldState
	//				for those operators that dont like it
	//	December 22, 1998
	if(announce())	sysbroadcast("World Saving.[TEXT]");
	//	EviLDeD	-	END

	tempeffectsoff();
	gcollect();
	wscfile=fopen("uox3.wsc", "w");
	if (wscfile) {
	fprintf(wscfile, "// UOX3 World Script (WSC)[TEXT]\n");
	fprintf(wscfile, "// Generated by UOX3 Version %s\n\n[TEXT]",VER);
	fprintf(wscfile, "// This file replaces the function of the *.UOX files in pre-0.50 versions[TEXT]\n\n");
	for (i=0;i<charcount;i++)
	{
		if (chars[i].free==0)
		{
			fprintf(wscfile, "SECTION CHARACTER %i\n", i);
			fprintf(wscfile, "{\n");
			fprintf(wscfile, "SERIAL %i\n", (chars[i].ser1*16777216)+(chars[i].ser2*65536)+(chars[i].ser3*256)+chars[i].ser4);
			fprintf(wscfile, "NAME %s\n", chars[i].name);
			fprintf(wscfile, "TITLE %s\n", chars[i].title);
			fprintf(wscfile, "ACCOUNT %i\n", chars[i].account);
			if (chars[i].x)
				fprintf(wscfile, "X %i\n", chars[i].x);
			if (chars[i].y)
				fprintf(wscfile, "Y %i\n", chars[i].y);
			if (chars[i].z)
				fprintf(wscfile, "Z %i\n", chars[i].z);
			if (chars[i].dispz)
				fprintf(wscfile, "DISPZ %i\n", chars[i].dispz);
			if (chars[i].oldx)
				fprintf(wscfile, "OLDX %i\n", chars[i].oldx);
			if (chars[i].oldy)
				fprintf(wscfile, "OLDY %i\n", chars[i].oldy);
			if (chars[i].oldz)
				fprintf(wscfile, "OLDZ %i\n", chars[i].oldz);
			if (chars[i].dir)
				fprintf(wscfile, "DIR %i\n", chars[i].dir);
			if ((chars[i].id1*256)+chars[i].id2)
				fprintf(wscfile, "BODY %i\n", (chars[i].id1*256)+chars[i].id2);
			if ((chars[i].xid1*256)+chars[i].xid2)
				fprintf(wscfile, "XBODY %i\n", (chars[i].xid1*256)+chars[i].xid2);
			if ((chars[i].skin1*256)+chars[i].skin2)
				fprintf(wscfile, "SKIN %i\n", (chars[i].skin1*256)+chars[i].skin2);
			if ((chars[i].xskin1*256)+chars[i].xskin2)
				fprintf(wscfile, "XSKIN %i\n", (chars[i].xskin1*256)+chars[i].xskin2);
			if (chars[i].priv)
				fprintf(wscfile, "PRIV %i\n", chars[i].priv);
			if (chars[i].priv2)
				fprintf(wscfile, "ALLMOVE %i\n", chars[i].priv2);
			if (chars[i].fonttype)
				fprintf(wscfile, "FONT %i\n", chars[i].fonttype);
			if ((chars[i].saycolor1*256)+chars[i].saycolor2)
				fprintf(wscfile, "SAY %i\n", (chars[i].saycolor1*256)+chars[i].saycolor2);
			if ((chars[i].emotecolor1*256)+chars[i].emotecolor2)
				fprintf(wscfile, "EMOTE %i\n", (chars[i].emotecolor1*256)+chars[i].emotecolor2);
			if (chars[i].st)
				fprintf(wscfile, "STRENGTH %i\n", chars[i].st);
			if (chars[i].st2)
				fprintf(wscfile, "STRENGTH2 %i\n", chars[i].st2);
			if (chars[i].dx)
				fprintf(wscfile, "DEXTERITY %i\n", chars[i].dx);
			if (chars[i].dx2)
				fprintf(wscfile, "DEXTERITY2 %i\n", chars[i].dx2);
			if (chars[i].in)
				fprintf(wscfile, "INTELLIGENCE %i\n", chars[i].in);
			if (chars[i].in2)
				fprintf(wscfile, "INTELLIGENCE2 %i\n", chars[i].in2);
			if (chars[i].hp)
				fprintf(wscfile, "HITPOINTS %i\n", chars[i].hp);
			if (chars[i].stm)
				fprintf(wscfile, "STAMINA %i\n", chars[i].stm);
			if (chars[i].mn)
				fprintf(wscfile, "MANA %i\n", chars[i].mn);
			if (chars[i].npc)
				fprintf(wscfile, "NPC %i\n", chars[i].npc);
			if (chars[i].shop)
				fprintf(wscfile, "SHOP %i\n", chars[i].shop);
			if ((chars[i].own1*16777216)+(chars[i].own2*65536)+(chars[i].own3*256)+chars[i].own4)
				fprintf(wscfile, "OWN %i\n", (chars[i].own1*16777216)+(chars[i].own2*65536)+(chars[i].own3*256)+chars[i].own4);
			if ((chars[i].robe1*16777216)+(chars[i].robe2*65536)+(chars[i].robe3*256)+chars[i].robe4)
				fprintf(wscfile, "ROBE %i\n", (chars[i].robe1*16777216)+(chars[i].robe2*65536)+(chars[i].robe3*256)+chars[i].robe4);
			if (chars[i].karma)
				fprintf(wscfile, "KARMA %i\n", chars[i].karma);
			if (chars[i].fame)
				fprintf(wscfile, "FAME %i\n", chars[i].fame);
			if (chars[i].kills)
				fprintf(wscfile, "KILLS %i\n", chars[i].kills);
			if (chars[i].deaths)
				fprintf(wscfile, "DEATHS %i\n", chars[i].deaths);
			if (chars[i].dead)
				fprintf(wscfile, "DEAD %i\n", chars[i].dead);
			if (chars[i].packitem)
				fprintf(wscfile, "PACKITEM %i\n", chars[i].packitem);
			if (chars[i].fixedlight)
				fprintf(wscfile, "FIXEDLIGHT %i\n", chars[i].fixedlight);
			if (chars[i].speech)
				fprintf(wscfile, "SPEECH %i\n", chars[i].speech);
			if (chars[i].trigger)
				fprintf(wscfile, "TRIGGER %i\n", chars[i].trigger);
			if (strlen(chars[i].trigword))
				fprintf(wscfile, "TRIGWORD %s\n", chars[i].trigword);
			if (chars[i].disabled)
				fprintf(wscfile, "DISABLED %i\n", chars[i].disabled);
			
			for (j=0;j<TRUESKILLS;j++)
			{
				// Don't save the default value given by initchar
				if ((chars[i].baseskill[j] != 10)&&(chars[i].baseskill[j]>1)) 
					fprintf(wscfile, "SKILL%i %i\n", j, chars[i].baseskill[j]);
			}
			for (j=0;j<ALLSKILLS;j++)
			{
				// Don't save the default value given by initchar
				if (chars[i].cantrain==0)
				fprintf(wscfile, "NOTRAIN\n");
			}

			if (chars[i].cell)
				fprintf(wscfile, "RESERVED1 %i\n", chars[i].cell);
			if (chars[i].att)
				fprintf(wscfile, "ATT %i\n", chars[i].att);
			if (chars[i].def)
				fprintf(wscfile, "DEF %i\n", chars[i].def);
			if (chars[i].lodamage)
				fprintf(wscfile, "LODAMAGE %i\n", chars[i].lodamage);
			if (chars[i].hidamage)
				fprintf(wscfile, "HIDAMAGE %i\n", chars[i].hidamage);
			if (chars[i].war)
				fprintf(wscfile, "WAR %i\n", chars[i].war);
			if (chars[i].npcWander)
				fprintf(wscfile, "NPCWANDER %i\n", chars[i].npcWander);
			if (chars[i].oldnpcWander)
				fprintf(wscfile, "OLDNPCWANDER %i\n", chars[i].oldnpcWander);
			if (chars[i].fx1)
				fprintf(wscfile, "FX1 %i\n", chars[i].fx1);
			if (chars[i].fy1)
				fprintf(wscfile, "FY1 %i\n", chars[i].fy1);
			if (chars[i].fz1)
				fprintf(wscfile, "FZ1 %i\n", chars[i].fz1);
			if (chars[i].fx2)
				fprintf(wscfile, "FX2 %i\n", chars[i].fx2);
			if (chars[i].fy2)
				fprintf(wscfile, "FY2 %i\n", chars[i].fy2);
			if ((chars[i].spawn1*16777216)+(chars[i].spawn2*65536)+(chars[i].spawn3*256)+chars[i].spawn4)
				fprintf(wscfile, "SPAWN %i\n", (chars[i].spawn1*16777216)+(chars[i].spawn2*65536)+(chars[i].spawn3*256)+chars[i].spawn4);
			if (chars[i].hidden)
				fprintf(wscfile, "HIDDEN %i\n", chars[i].hidden);
			if (chars[i].hunger)
				fprintf(wscfile, "HUNGER %i\n", chars[i].hunger);
			if (chars[i].npcaitype)
				fprintf(wscfile, "NPCAITYPE %i\n", chars[i].npcaitype);
			if (chars[i].spattack)
				fprintf(wscfile, "SPATTACK %i\n", chars[i].spattack);
			if (chars[i].spadelay)
				fprintf(wscfile, "SPADELAY %i\n", chars[i].spadelay);
			if (chars[i].taming)
				fprintf(wscfile, "TAMING %i\n", chars[i].taming);
			if (chars[i].summontimer)
				fprintf(wscfile, "SUMMONTIMER %i\n", chars[i].summontimer);
			if (chars[i].town)
				fprintf(wscfile, "TOWN %i\n", chars[i].town);
			if ((chars[i].townvote1*16777216)+(chars[i].townvote2*65536)+(chars[i].townvote3*256)+chars[i].townvote4)
				fprintf(wscfile, "TOWNVOTE %i\n", (chars[i].townvote1*16777216)+(chars[i].townvote2*65536)+(chars[i].townvote3*256)+chars[i].townvote4);
			if (chars[i].towntitle)
				fprintf(wscfile, "TOWNTITLE %i\n", chars[i].towntitle);
			if (chars[i].townpriv)
				fprintf(wscfile, "TOWNPRIV %i\n", chars[i].townpriv);
			if (chars[i].advobj)
				fprintf(wscfile, "ADVOBJ %i\n", chars[i].advobj);
			if (chars[i].poison)
				fprintf(wscfile, "POISON %i\n", chars[i].poison);
			if (chars[i].poisoned)
				fprintf(wscfile, "POISONED %i\n", chars[i].poisoned);
			if (chars[i].fleeat)
				fprintf(wscfile, "FLEEAT %i\n", chars[i].fleeat);
			if (chars[i].reattackat)
				fprintf(wscfile, "REATTACKAT %i\n", chars[i].reattackat);  
			if (chars[i].split)
				fprintf(wscfile, "SPLIT %i\n", chars[i].split);
			if (chars[i].splitchnc)
				fprintf(wscfile, "SPLITCHANCE %i\n", chars[i].splitchnc);  
			fprintf(wscfile, "}\n\n");
		}
	}
	for (i=0;i<itemcount;i++)
	{
		if (items[i].free==0)
		{
			fprintf(wscfile, "SECTION WORLDITEM %i\n", i);
			fprintf(wscfile, "{\n");
			fprintf(wscfile, "SERIAL %i\n", (items[i].ser1*16777216)+(items[i].ser2*65536)+(items[i].ser3*256)+items[i].ser4);
			fprintf(wscfile, "NAME %s\n", items[i].name);
			if (items[i].type == 15)
				fprintf(wscfile, "NAME2 %s\n", items[i].name2);
			fprintf(wscfile, "ID %i\n", (items[i].id1*256)+items[i].id2);
			if (items[i].x)
				fprintf(wscfile, "X %i\n", items[i].x);
			if (items[i].y)
				fprintf(wscfile, "Y %i\n", items[i].y);
			if (items[i].z)
				fprintf(wscfile, "Z %i\n", items[i].z);
			if ((items[i].color1*256)+items[i].color2)
				fprintf(wscfile, "COLOR %i\n", (items[i].color1*256)+items[i].color2);
			if ((items[i].cont1*16777216)+(items[i].cont2*65536)+(items[i].cont3*256)+items[i].cont4)
				fprintf(wscfile, "CONT %i\n", (items[i].cont1*16777216)+(items[i].cont2*65536)+(items[i].cont3*256)+items[i].cont4);
			if (items[i].layer)
				fprintf(wscfile, "LAYER %i\n", items[i].layer);
			if (items[i].type)
				fprintf(wscfile, "TYPE %i\n", items[i].type);
			if (items[i].type2)
				fprintf(wscfile, "TYPE2 %i\n", items[i].type2);
			if (items[i].offspell)
				fprintf(wscfile, "OFFSPELL %i\n", items[i].offspell);
			if ((items[i].more1*16777216)+(items[i].more2*65536)+(items[i].more3*256)+items[i].more4) //; 
				fprintf(wscfile, "MORE %i\n", (items[i].more1*16777216)+(items[i].more2*65536)+(items[i].more3*256)+items[i].more4);
			if ((items[i].moreb1*16777216)+(items[i].moreb2*65536)+(items[i].moreb3*256)+items[i].moreb4)
				fprintf(wscfile, "MORE2 %i\n", (items[i].moreb1*16777216)+(items[i].moreb2*65536)+(items[i].moreb3*256)+items[i].moreb4);
			if (items[i].morex)
				fprintf(wscfile, "MOREX %i\n", items[i].morex);
			if (items[i].morey)
				fprintf(wscfile, "MOREY %i\n", items[i].morey);
			if (items[i].morez)
				fprintf(wscfile, "MOREZ %i\n", items[i].morez);
			if (items[i].amount)
				fprintf(wscfile, "AMOUNT %i\n", items[i].amount);
			if (items[i].pileable)
				fprintf(wscfile, "PILEABLE %i\n", items[i].pileable);
			if (items[i].doordir)
				fprintf(wscfile, "DOORFLAG %i\n", items[i].doordir);
			if (items[i].dye)
				fprintf(wscfile, "DYEABLE %i\n", items[i].dye);
			if (items[i].corpse)
				fprintf(wscfile, "CORPSE %i\n", items[i].corpse);
			if (items[i].att)
				fprintf(wscfile, "ATT %i\n", items[i].att);
			if (items[i].def)
				fprintf(wscfile, "DEF %i\n", items[i].def);
			if (items[i].hidamage)
				fprintf(wscfile, "HIDAMAGE %i\n", items[i].hidamage);
			if (items[i].lodamage)
				fprintf(wscfile, "LODAMAGE %i\n", items[i].lodamage);
			if (items[i].st)
				fprintf(wscfile, "ST %i\n", items[i].st);
			if (items[i].hp)
				fprintf(wscfile, "HP %i\n", items[i].hp);
			if (items[i].st2)
				fprintf(wscfile, "ST2 %i\n", items[i].st2);
			if (items[i].dx)
				fprintf(wscfile, "DX %i\n", items[i].dx);
			if (items[i].dx2)
				fprintf(wscfile, "DX2 %i\n", items[i].dx2);
			if (items[i].in)
				fprintf(wscfile, "IN %i\n", items[i].in);
			if (items[i].in2)
				fprintf(wscfile, "IN2 %i\n", items[i].in2);
			if (items[i].spd)
				fprintf(wscfile, "SPD %i\n", items[i].spd);
			if (items[i].wipe)
				fprintf(wscfile, "WIPE %i\n", items[i].wipe);
			if (items[i].magic)
				fprintf(wscfile, "MOVABLE %i\n", items[i].magic);
			if ((items[i].owner1*16777216)+(items[i].owner2*65536)+(items[i].owner3*256)+items[i].owner4)
				fprintf(wscfile, "OWNER %i\n", (items[i].owner1*16777216)+(items[i].owner2*65536)+(items[i].owner3*256)+items[i].owner4);
			if (items[i].visible)
				fprintf(wscfile, "VISIBLE %i\n", items[i].visible);
			if ((items[i].spawn1*16777216)+(items[i].spawn2*65536)+(items[i].spawn3*256)+items[i].spawn4)
				fprintf(wscfile, "SPAWN %i\n", (items[i].spawn1*16777216)+(items[i].spawn2*65536)+(items[i].spawn3*256)+items[i].spawn4);
			if (items[i].dir)
				fprintf(wscfile, "DIR %i\n", items[i].dir);
			if (items[i].priv)
				fprintf(wscfile, "PRIV %i\n", items[i].priv);
			if (items[i].value)
				fprintf(wscfile, "VALUE %i\n", items[i].value);
			if (items[i].restock)
				fprintf(wscfile, "RESTOCK %i\n", items[i].restock);
			if (items[i].trigger)
				fprintf(wscfile, "TRIGGER %i\n", items[i].trigger);
			if (items[i].trigtype)
				fprintf(wscfile, "TRIGTYPE %i\n", items[i].trigtype);
			if (items[i].disabled)
				fprintf(wscfile, "DISABLED %i\n", items[i].disabled);
			if (items[i].tuses)
				fprintf(wscfile, "USES %i\n", items[i].tuses);
			fprintf(wscfile, "}\n\n");
		}
	}
	fprintf(wscfile, "EOF\n\n");
	fclose(wscfile);
	} else {
		printf("UOX3: Could not open world file for saving!\n");
		keeprun=0;error=1;
	}
	//	EviLDeD -	Put in the ability to toggle the display of WorldState
	//				for those operators that dont like it
	//	December 22, 1998
	if ((x==1)&&(announce())) {
		printf("UOX3: World data saved.(Manual)\n");
		sprintf(temp, "Manual Server data save.\n");
	} else if (announce()) {
		printf("UOX3: World data saved.(AUTO)\n");
		sprintf(temp,"Automatic Server data save.\n");
	} else {
		sprintf(temp,"Server data save.\n");
	}
	savelog(temp,"server.log");
/*	if (x==1) 
		if(announce()) printf("UOX3: World data saved[TEXT].(Manual)\n");
	else 
		if(announce()) printf("UOX3: World data saved[TEXT].(AUTO)\n");*/
	//	EviLDeD	-	END

	tempeffectson();
	//towninit();
	if(announce())	sysbroadcast("World Saved[TEXT].");
}

int CWorldMain::announce()
{
	return DisplayWorldSaves;
}

void CWorldMain::announce(int choice)
{
	if(choice<1)
		DisplayWorldSaves=0;
	else
		DisplayWorldSaves=1;
}
