/* 
 *  UOX3 Skills
 */
 
#include "uox3.h"
#include "debug.h"
int goldsmithing;

#define DBGFILE "skills.cpp"

void tailoring(int s)
{
 int i, packnum, amt, serial;

 packnum=packitem(currchar[s]);
       
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
    if (((items[i].id1==0x0f)&&((items[i].id2>=0x95)&&(items[i].id2<=0x9c)))||((items[i].id1==0x17)&&((items[i].id2>=0x5d)&&(items[i].id2<=0x64))) ||
        ((items[i].id1==0x10)&&(items[i].id2==0x78)))
    {
      if (items[i].contserial!=items[packnum].serial)
      {
        sysmessage(s,"You can't use material outside your backpack");
      }           
      else
      {
        itemmake[s].has=amt=getamount(currchar[s], items[i].id1, items[i].id2);    
        if(amt<1)
        { 
          sysmessage(s,"You don't have enough material to make anything.");
          return;
        }
        itemmake[s].materialid1=items[i].id1;
        itemmake[s].materialid2=items[i].id2; 
        if (items[i].id1==0x10 && items[i].id2==0x78) makemenu(s,40,TAILORING);
        else makemenu(s,30,TAILORING);
      }
      return;
    }
  }
  sysmessage(s,"You cannot use that material for tailoring.");
}   

void fletching(int s)
{
 int i, packnum,serial;

  packnum=packitem(currchar[s]);

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
    if (((itemmake[s].materialid2>=0xD4 && itemmake[s].materialid2<=0xD6) && (items[i].id1==0x1B && (items[i].id2>=0xD1 && items[i].id2<=0xD3))) ||
       ((itemmake[s].materialid2>=0xD1 && itemmake[s].materialid2<=0xD3) && (items[i].id1==0x1B && (items[i].id2>=0xD4 && items[i].id2<=0xD6))))
    {
      if (items[i].contserial!=items[packnum].serial)
      {
        sysmessage(s,"You can't use items outside your backpack.");
      }
      else
      {
        itemmake[s].materialid1b=items[i].id1;
        itemmake[s].materialid2b=items[i].id2;
        itemmake[s].has=getamount(currchar[s], itemmake[s].materialid1, itemmake[s].materialid2); 
        itemmake[s].has2=getamount(currchar[s], itemmake[s].materialid1b, itemmake[s].materialid2b);
        makemenu(s,60,BOWCRAFT);
      }
      return;
    }
  }
  sysmessage(s,"You cannot use that for fletching.");
}

void bowcraft(int s)
{
 int i, packnum, amt,serial;

 packnum=packitem(currchar[s]);

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
    if((items[i].id1==0x1B) && ((items[i].id2==0xDD) || items[i].id2==0xE0))
    {
      if (items[i].contserial!=items[packnum].serial)
    {
     sysmessage(s,"You can't carve logs outside your backpack");
     return;
    }           
    else
    {
     itemmake[s].has=amt=getamount(currchar[s], items[i].id1, items[i].id2);    
     if(amt<2)
     { 
      sysmessage(s,"You don't have enough material to make anything.");
     }
     else 
     {
      itemmake[s].materialid1=items[i].id1;
      itemmake[s].materialid2=items[i].id2;
      makemenu(s,65,BOWCRAFT);
     }
     return;
    }
   } 
  }
}

void carpentry(int s)
{
 int i, packnum, amt,serial;

 packnum=packitem(currchar[s]);
       
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
    if(items[i].id1==0x1B && items[i].id2==0xDD)
    {
      if (items[i].contserial!=items[packnum].serial)
    {
     sysmessage(s,"You can't use lumber outside your backpack");
    }           
    else
    {
     itemmake[s].has=amt=getamount(currchar[s], 0x1B, 0xDD);    
     if(amt<9)
     { 
      sysmessage(s,"You don't have enough logs to make anything.");
      return;
     }
     makemenu(s,20,CARPENTRY);
    }
    return;
   }
 }
 sysmessage(s,"You cannot use that material for carpentry.");
}

void smith(int s)
{
 int i, packnum,serial;

 packnum=packitem(currchar[s]);
       
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
    if(items[i].id1==0x1B && (items[i].id2==0xEF||items[i].id2==0xF2))
    {
      if (items[i].contserial!=items[packnum].serial)
    {
     sysmessage(s,"You can't smith ore outside your backpack");
    }           
    else anviltarget(s,i);
    return;
   }
 }
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
    if((items[i].id1==0x1B && items[i].id2==0xEC))
    {
      if (items[i].contserial!=items[packnum].serial)
    {
     sysmessage(s,"You can't smith Gold ingots outside your backpack");
    }           
    else anviltargetgold(s,i);
    return;
   }
 }
 sysmessage(s,"You cannot use that material for blacksmithing.");
}

void anviltarget(int s,int m)
{
 unsigned int i;
	int amt;

 for (i=0;i<itemcount;i++)
 {
  if((items[i].id1==0x0F && items[i].id2==0xAF) ||
     (items[i].id1==0x0F && items[i].id2==0xB0))
  {
   if(iteminrange(s,i,3))
   {
    itemmake[s].has=amt=getamount(currchar[s], 0x1B, 0xF2);     
    if(amt<3)
    { 
     sysmessage(s,"You don't have enough ingots to make anything.");
     return;
    }
    makemenu(s,1,BLACKSMITHING);
    return;
   }
  }
 }
 sysmessage(s,"The anvil is too far away.");
}

void anviltargetgold(int s,int m)
{
 unsigned int i;
	int amt;

 for (i=0;i<itemcount;i++)
 {
  if((items[i].id1==0x0F && items[i].id2==0xAF) ||
     (items[i].id1==0x0F && items[i].id2==0xB0))
  {
   if(iteminrange(s,i,3))
   {
    itemmake[s].has=amt=getamount(currchar[s], 0x1B, 0xEC);     
    if(amt<1)
    { 
     sysmessage(s,"You don't have enough gold ingots to make anything.");
     return;
    }
    goldsmithing=1;
        makemenu(s,50,BLACKSMITHING);
    return;
   }
  }
 }
 sysmessage(s,"The anvil is too far away.");
}

//o---------------------------------------------------------------------------o
//|   Function    :  void makemenutarget(int s,int x,int skill)
//|   Date        :  Unknown
//|   Programmer  :  Unknown
//o---------------------------------------------------------------------------o
//|   Purpose     :  create a specified menuitem target.(Can someone elaborate 
//|                  here please (EviLDeD)
//o---------------------------------------------------------------------------o
void makemenutarget(int s, int x, int skill)
{
   int c;

   //chars[currchar[s]].making=0;
   if(chars[currchar[s]].making==999) {}
   else 
   if(!checkskill(currchar[s],skill, itemmake[s].minskill, itemmake[s].maxskill)) 
   {
      switch(skill) 
      {
         case BLACKSMITHING: 
            if (goldsmithing==0) delequan(currchar[s], 0x1B, 0xF2, itemmake[s].needs/2);
                if (goldsmithing==1) delequan(currchar[s], 0x1B, 0xEC, itemmake[s].needs/2);
                soundeffect(s,0x00,0x2a);
                goldsmithing=0;
                sysmessage(s,"You fail to create the item.");
                break;
         case CARPENTRY:     
            delequan(currchar[s], 0x1B, 0xDD, itemmake[s].needs/2);  
                soundeffect(s,0x02,0x3d);
                sysmessage(s,"You fail to create the item.");
                break;
         case INSCRIPTION:
                delequan(currchar[s], 0x0E, 0x34, 1);
                sysmessage(s,"You fail to inscribe the spell");
                break;
         case TAILORING:     
                delequan(currchar[s], itemmake[s].materialid1, itemmake[s].materialid2, itemmake[s].needs/2);  
                soundeffect(s,0x02,0x48);
                sysmessage(s,"You fail to create the item.");
                break;
         case COOKING:     
                delequan(currchar[s], 0x17, 0x5D, itemmake[s].needs/2);  
                soundeffect(s,0x02,0x25);
                sysmessage(s,"You fail to create the item.");
            break;
         case BOWCRAFT:      
            if (itemmake[s].has<2) delequan(currchar[s], itemmake[s].materialid1, itemmake[s].materialid2, 1);
                else delequan(currchar[s], itemmake[s].materialid1, itemmake[s].materialid2, itemmake[s].needs/2);
                if (itemmake[s].has2<2) delequan(currchar[s], itemmake[s].materialid1b, itemmake[s].materialid2b, 1);
                else delequan(currchar[s], itemmake[s].materialid1b, itemmake[s].materialid2b, itemmake[s].needs/2);
                soundeffect(s,0x00,0x4A);
                sysmessage(s,"You fail to create the item.");
                itemmake[s].has=0;
                itemmake[s].has2=0;
                break;
         case TINKERING:
            delequan(currchar[s], itemmake[s].materialid1, itemmake[s].materialid2, itemmake[s].needs/2);
                soundeffect(s, 0x00, 0x2A);
                sysmessage(s, "You fail to create the item.");
                break;
      }
      return;
   }  
 
   if (goldsmithing==0) if (skill==BLACKSMITHING) delequan(currchar[s], 0x1B, 0xF2, itemmake[s].needs);
   if (goldsmithing==1) if (skill==BLACKSMITHING) delequan(currchar[s], 0x1B, 0xEC, itemmake[s].needs);
   goldsmithing=0;
   if (skill==CARPENTRY) delequan(currchar[s], 0x1B, 0xDD, itemmake[s].needs); 
   if (skill==COOKING) delequan(currchar[s], 0x09, 0xF1, itemmake[s].needs); 
   if (skill==INSCRIPTION) delequan(currchar[s], 0x0E, 0x34, 1);
   if (skill==TAILORING) delequan(currchar[s], itemmake[s].materialid1,itemmake[s].materialid2, itemmake[s].needs);   
   if (skill==TINKERING) delequan(currchar[s], itemmake[s].materialid1, itemmake[s].materialid2, itemmake[s].needs);
   if (skill==BOWCRAFT)
   {
      delequan(currchar[s], itemmake[s].materialid1, itemmake[s].materialid2, itemmake[s].needs);
      delequan(currchar[s], itemmake[s].materialid1b, itemmake[s].materialid2b, itemmake[s].needs);
   }

   itemmake[s].materialid1=0;
   itemmake[s].materialid2=0;
   
   c=SpawnItemBackpack2(s, x, 0);
   if (c==-1)
   {
      printf("[1]SKILLS.CPP:makemenutarget() bad script item # %d(Item Not found).\n", x);
      return;  //invalid script item
   }
   if(chars[currchar[s]].making==999) chars[currchar[s]].making=c; // store item #
   else chars[currchar[s]].making=0;
   if (skill==BLACKSMITHING) soundeffect(s,0x00,0x2a);
   if (skill==CARPENTRY) soundeffect(s,0x02,0x3d);
   if (skill==INSCRIPTION) soundeffect(s,0x02,0x49);
   if (skill==TAILORING) soundeffect(s,0x02,0x48);
   if (skill==TINKERING) soundeffect(s,0x00,0x2A);
   if (skill==COOKING) soundeffect(s,0x02,0x25);
   
   // EviLDeD  -  I noticed that when there was a success there were 2
   //          of the intended item created. Going to comment this out
   //          until another time, or someone says that it should be there
   // December 26, 1998
   //c=SpawnItemBackpack2(s, x, 0);
   //if (c==-1)
   //{
   // printf("[2]SKILLS.CPP:makemenutarget() bad script item # %d.\n", x);
   // return;  //invalid script item
   //}
   if(!chars[currchar[s]].making) sysmessage(s,"You create the item and place it in your backpack.");
   itemmake[s].has=0;
   itemmake[s].has2=0;
   statwindow(s,currchar[s]);
}

void makemenu(int s, int m, int skill) // Menus for playermade objects
{ // s - character online #, m - menu to use, skill - skill being used
 int total, i;
 char lentext;
 char sect[512];
 char gmtext[30][257];
 int gmid[30];
 int gmnumber=0;
 int gmindex;

 chars[currchar[s]].making=skill;

 openscript("create.scp");
 sprintf(sect, "MAKEMENU %i", m);
 if (!create_script.find(sect)) 
 {
  closescript();
  return;
 }
 gmindex=m;
 read1();
 sprintf(gmtext[0], "%s", script1);
 do
 {
  read2();
  if (script1[0]!='}')
  {
   gmnumber++;
   gmid[gmnumber]=hstr2num(script1);
   sprintf(gmtext[gmnumber], "%s", script2);
   read2();
   itemmake[s].needs=str2num(script2);
   read2();
   itemmake[s].minskill=str2num(script2);
   itemmake[s].maxskill=itemmake[s].minskill*5;
   if (itemmake[s].maxskill<200) itemmake[s].maxskill=200;
   if ((itemmake[s].has<itemmake[s].needs) || ((itemmake[s].has2) &&
       (itemmake[s].has2<itemmake[s].needs)) || (chars[currchar[s]].skill[skill]<itemmake[s].minskill))
        gmnumber--;
   read1();      
   //printf("gmnumber is %i\nneed = %i\t have = %i\nskillneed = %i, skillhave = %i\n",gmnumber,itemmake[s].needs,itemmake[s].has,itemmake[s].minskill,chars[currchar[s]].skill[skill]);
  }
 }
 while (script1[0]!='}');
 closescript();
 if (!gmnumber) 
 {
  sysmessage(s,"You aren't skilled enough to make anything with what you have.");
  return; 
 }
 sprintf(temp, "%i: %s", m, gmtext[0]);
 lentext=sprintf(gmtext[0], "%s", temp);
 total=9+1+lentext+1;
 for (i=1;i<=gmnumber;i++)
 {
  total+=4+1+strlen(gmtext[i]);
 }
 gmprefix[1]=total/256;
 gmprefix[2]=total%256;
 gmprefix[3]=chars[currchar[s]].ser1;
 gmprefix[4]=chars[currchar[s]].ser2;
 gmprefix[5]=chars[currchar[s]].ser3;
 gmprefix[6]=chars[currchar[s]].ser4;
 gmprefix[7]=(gmindex+MAKEMENUOFFSET)/256;
 gmprefix[8]=(gmindex+MAKEMENUOFFSET)%256;
 xsend(s, gmprefix, 9, 0);
 xsend(s, &lentext, 1, 0);
 xsend(s, gmtext[0], lentext, 0);
 lentext=gmnumber;
 xsend(s, &lentext, 1, 0);
 for (i=1;i<=gmnumber;i++)
 {
  gmmiddle[0]=gmid[i]/256;
  gmmiddle[1]=gmid[i]%256;
  xsend(s, gmmiddle, 4, 0);
  lentext=strlen(gmtext[i]);
  xsend(s, &lentext, 1, 0);
  xsend(s, gmtext[i], lentext, 0);
 }
 targetok[s]=1; 
}


void mine(int s)
{
   int px,py,cx,cy,asdf,randnum1;
   char floor=0;
   char mountain=0;

   if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) 
      return; // Test if use canceled the mining request

   asdf=(rand()%100);
   randnum1=rand()%100;

  // check if gravesight - added by Genesis
   if(((buffer[s][0x10]<=28))&&(buffer[s][0x11]==14)&&
      ((buffer[s][0x12]==0xd3)||(buffer[s][0x12]==0xdf)||(buffer[s][0x12]==0xe0)||(buffer[s][0x12]==0xe1)||(buffer[s][0x12]==0xe2)||(buffer[s][0x12]==0xe8)))
   {
      gravedig(s);
      return;
   }
    
  // check if cave floor  
   else if (((buffer[s][0x10]==0)&&(buffer[s][0x11]==0x05)&&(((buffer[s][0x12]>=0x3b)&&(buffer[s][0x12]<=0x4f))||
         ((buffer[s][0x12]>=0x51)&&(buffer[s][0x12]<=0x53))||(buffer[s][0x12]==0x6a)))&&(!((buffer[s][0x11]==0x02)&&
         (((buffer[s][0x12]>=0x5c)&&(buffer[s][0x12]<=0x76))||((buffer[s][0x12]>=0x7d)&&(buffer[s][0x12]<=0x80)))))) 
         floor=1;
  // check if mountain 
   else if (((buffer[s][0x10]>=1)&&(buffer[s][0x10]<=50))&&(buffer[s][0x11]==0)&&(buffer[s][0x12]==0)) 
      mountain=1; // can be adjusted 1 to 53  (1=ground - 53=top of mountain) this isn't really true but the higher the number the higher up the mountain you are 'usually'.
  // all else thrown out
   px=((buffer[s][0x0b]*256)+(buffer[s][0x0c]%256));
   py=((buffer[s][0x0d]*256)+(buffer[s][0x0e]%256));
   // amount=world_resource_check(px,py,4,1); working... but not finished
   cx=abs(chars[currchar[s]].x-px);
   cy=abs(chars[currchar[s]].y-py);
   if(!((cx<=5)&&(cy<=5)))
   {
      sysmessage(s,"You are to far away to reach that");
      return;
   }
   /*else if(amount<=0) //working... but not finished
   {
      sysmessage(s,"There are no ore deposits in the area.");
      return;
   }*/
  
   if (((!(floor))&&(!(mountain)))||
      ((server_data.minecheck==1)&&(!(floor)))||
      ((server_data.minecheck==2)&&(!((chars[currchar[s]].region==1)||(chars[currchar[s]].region==2)))))
    {
      sysmessage(s,"You can't dig there!");
      return;
    }

   if (chars[currchar[s]].onhorse)
      action(s,0x1A);
   else
      action(s,0x0b);
      soundeffect(s,0x01,0x25); 
   
   if(!checkskill(currchar[s],MINING, 0, 1000)) 
   {
      sysmessage(s,"You sifted thru the dirt and rocks, but found nothing useable.");
      return;
   }

   if ((buffer[s][1]==1)&&(buffer[s][2]==0)&&
      (buffer[s][3]==1)&&(buffer[s][4]==0))
      {
      
      if (asdf<=5)
         {
          asdf=rand()%20;
          switch(asdf)
          {
         case 1:
            if(checkskill(currchar[s],MINING,850,1000))
            {
               SpawnRandomItem(s,1,"necro.scp","ITEMLIST","999"); 
               sysmessage(s,"You place a gem in your pack.");      
            }  
            break;
         case 6:
            SpawnItem(s,1,"Silver Ore",1,0x19,0xb8, 0x03, 0x8A,1,1);
            sysmessage(s,"You place some silver ore in your pack.");
            break;
         case 10: 
            SpawnItem(s,1,"Gold Ore",1,0x19,0xb8, 0x09, 0x6D,1,1);
                sysmessage(s,"You place some gold ore in your pack.");
            break;
         case 14: 
            SpawnItem(s,1,"Mythril Ore",1,0x19,0xb8, 0x01, 0x91,1,1);
                sysmessage(s,"You place some mythril ore in your pack.");
            break;
         case 18: 
            SpawnItem(s,1,"Adamantium Ore",1,0x19,0xb8, 0x03, 0x86,1,1);
                sysmessage(s,"You place some adamantium ore in your pack.");
            break;
         default:
            SpawnItem(s,1,"Copper Ore",1,0x19,0xb8, 0x00, 0xf3,1,1);
                sysmessage(s,"You place some copper ore in your pack.");
            break;
          }
      }
      else
      {
            asdf=rand()%20;
            if (asdf==10)
            {
               SpawnItem(s,5,"Iron Ore",1,0x19,0xba, 0, 0,1,1);
              sysmessage(s,"You place some iron ore in your pack.");
            }
            else
            {
                SpawnItem(s,1,"Iron Ore",1,0x19,0xb7, 0, 0,1,1);
                sysmessage(s,"You place some iron ore in your pack.");
            }
      }
   }
}

void gravedig(int s) // added by Genesis 11-4-98
{
   int   nAmount, nFame, nItemID, nCharID;
   char iID=0;
   
   nCharID=currchar[s];
   Karma(nCharID,-1,-2000); // Karma loss no lower than the -2 pier
   
   if(chars[currchar[s]].onhorse)
      action(s,0x1A);
   else
      action(s,0x0b);
   soundeffect(s,0x01,0x25);
   if(!checkskill(currchar[s],MINING, 0, 800)) 
   {
      sysmessage(s,"You sifted through the dirt and found nothing.");
      return;
   }

   nFame = chars[nCharID].fame;
   if(chars[nCharID].onhorse)
      action(s,0x1A);
   else  
      action(s,0x0b);
   soundeffect(s,0x01,0x25);     
   int nRandnum=rand()%13;
   switch(nRandnum)
   {
   case 2:
      SpawnRandomMonster(s,"necro.scp","UNDEADLIST","1000"); // Low level Undead - Random
      sysmessage(s,"You have disturbed the rest of a vile undead creature.");
      break;
   case 4:
      nItemID=SpawnRandomItem(s,1,"necro.scp","ITEMLIST","1001"); // Armor and shields - Random
      if((nItemID>=7026)&&(nItemID<=7035))
         sysmessage(s,"You unearthed an old shield and placed it in your pack");
      else
         sysmessage(s,"You have found an old piece armor and placed it in your pack.");
      break;
   case 5:
      //Random treasure between gems and gold
      nRandnum=rand()%2;
      if(nRandnum)
      {  // randomly create a gem and place in backpack
         SpawnRandomItem(s,1,"necro.scp","ITEMLIST","999");
         sysmessage(s,"You place a gem in your pack.");
      }
      else
      {  // Create between 1 and 15 goldpieces and place directly in backpack
         nAmount=1+(rand()%15);
         addgold(nCharID,nAmount);
         goldsfx(s,nAmount);
         if (nAmount==1)
            sprintf(temp,"You unearthed %i gold coin.", nAmount);
         else
            sprintf(temp,"You unearthed %i gold coins.", nAmount);
         sysmessage(s,temp);
      }
      break;
   case 6:
      if(nFame<500)
         SpawnRandomMonster(s,"necro.scp","UNDEADLIST","1000"); // Low level Undead - Random
      else
         SpawnRandomMonster(s,"necro.scp","UNDEADLIST","1001"); // Med level Undead - Random
      sysmessage(s,"You have disturbed the rest of a vile undead creature.");
      break;
   case 8:
      SpawnRandomItem(s,1,"necro.scp","ITEMLIST","1000");
      sysmessage(s,"You unearthed a old weapon and placed it in your pack.");
      break;
   case 10:
      if(nFame<1000)
         SpawnRandomMonster(s,"necro.scp","UNDEADLIST","1001"); // Med level Undead - Random
      else
         SpawnRandomMonster(s,"necro.scp","UNDEADLIST","1002"); // High level Undead - Random
      sysmessage(s,"You have disturbed the rest of a vile undead creature.");
      break;
   case 12:
      if(nFame>1000)
         SpawnRandomMonster(s,"necro.scp","UNDEADLIST","1002"); // High level Undead - Random
      else
         SpawnRandomMonster(s,"necro.scp","UNDEADLIST","1001"); // Med level Undead - Random
      sysmessage(s,"You have disturbed the rest of a vile undead creature.");
      break;
   default:
      nRandnum=rand()%2;
      switch(nRandnum)
      {  
      case 1:
         nRandnum=rand()%12;
         switch(nRandnum)
         {
         case 0: iID=0x11; break;
         case 1: iID=0x12; break;
         case 2: iID=0x13; break;
         case 3: iID=0x14; break;
         case 4: iID=0x15; break;
         case 5: iID=0x16; break;
         case 6: iID=0x17; break;
         case 7: iID=0x18; break;
         case 8: iID=0x19; break;
         case 9: iID=0x1A; break;
         case 10: iID=0x1B; break;
         case 11: iID=0x1C; break;
         }
         SpawnItem(s,1,NULL,0,0x1b,iID,0x00,0x00,1,1);
         sysmessage(s,"You have unearthed some old bones and placed them in your pack.");       
         break;
      default: // found an empty grave
         sysmessage(s,"This grave seems to be empty.");
      }
   }
}


void smeltore(int s)
{
 int i,numore=1,serial;
     
 int smelting=0;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
   {
      if((items[i].id1==0x0F && items[i].id2==0xB1)||(items[i].id1==0x19 && 
         ((items[i].id2==0x7A)||(items[i].id2==0xA9)||(items[i].id2==0x7e)||
          (items[i].id2==0x82)||(items[i].id2==0x86)||(items[i].id2==0x8a)||
          (items[i].id2==0x8e)||(items[i].id2==0x92)||(items[i].id2==0x96)||
          (items[i].id2==0x9a)||(items[i].id2==0xa6)||(items[i].id2==0xa2)||
           (items[i].id2==0x9e))))
      {
         if(iteminrange(s,i,3))  
         {
            if (!checkskill(currchar[s],MINING, 0, 1000)) 
            {
               if (items[chars[currchar[s]].smeltitem].amount==1)
               {
               sysmessage(s,"Your hand slips and the last of your materials are destroyed.");
               deleitem(chars[currchar[s]].smeltitem);
                  }
                  else
                  {
                     sysmessage(s,"Your hand slips and some of your materials are destroyed.");
                     items[chars[currchar[s]].smeltitem].amount=items[chars[currchar[s]].smeltitem].amount/2;
                  }
                  return;  
               }
            sysmessage(s,"You have smelted your ore.");
               if ((items[chars[currchar[s]].smeltitem].color1)==0x00 && (items[chars[currchar[s]].smeltitem].color2==0x00))
                {
                  numore=items[chars[currchar[s]].smeltitem].amount*2;
                  SpawnItem(s,numore,"Iron Ingot",1,0x1b,0xf2, 0, 0,1,1);
            sysmessage(s,"You place some Iron Ingots in your pack.");
                }
               else if ((items[chars[currchar[s]].smeltitem].color1)==0x09 && (items[chars[currchar[s]].smeltitem].color2==0x6d))
                {
                  numore=items[chars[currchar[s]].smeltitem].amount;
                  SpawnItem(s,numore,"Gold Ingot",1,0x1b,0xec, 0, 0,1,1);
              sysmessage(s,"You place some Gold Ingots in your pack.");
                }
               else if ((items[chars[currchar[s]].smeltitem].color1)==0x00 && (items[chars[currchar[s]].smeltitem].color2==0xf3))
                {
                  numore=items[chars[currchar[s]].smeltitem].amount;
                  SpawnItem(s,numore,"Copper Ingot",1,0x1b,0xe6, 0, 0,1,1);
            sysmessage(s,"You place some Copper Ingots in your pack.");
                }
               else if ((items[chars[currchar[s]].smeltitem].color1)==0x03 && (items[chars[currchar[s]].smeltitem].color2==0x8a))
                {
                  numore=items[chars[currchar[s]].smeltitem].amount;
                  SpawnItem(s,numore,"Silver Ingot",1,0x1b,0xf8, 0, 0,1,1);
                  sysmessage(s,"You place some Silver Ingots in your pack.");
                }
               else if ((items[chars[currchar[s]].smeltitem].color1)==0x03 && (items[chars[currchar[s]].smeltitem].color2==0x86))
                {
                  if ((items[chars[currchar[s]].smeltitem].amount)<2)
                  {
                     sysmessage(s,"You do not have enough adamantium ore to smelt.");
                     return;
                  }
                  numore=(items[chars[currchar[s]].smeltitem].amount)/2;
                  SpawnItem(s,numore,"Adamantium Ingot",1,0x1b,0xf8, 0x03, 0x86,1,1);
                   sysmessage(s,"You place some Adamantium Ingots in your pack.");
                }
               else 
                {
                  if ((items[chars[currchar[s]].smeltitem].amount)<4)
                     {
                     sysmessage(s,"You do not have enough Mythril ore to smelt.");
                     return;
                     }
                  numore=(items[chars[currchar[s]].smeltitem].amount)/4;
                  SpawnItem(s,numore,"Mythril Ingot",1,0x1b,0xf8, 0x01, 0x91,1,1);
              sysmessage(s,"You place some Mythril Ingots in your pack.");
                }
         deleitem(chars[currchar[s]].smeltitem);
        smelting=1;
    }
   }     
 } 
 
 chars[currchar[s]].smeltitem=-1;        
 if(!smelting) sysmessage(s,"You cant smelt here.");
  // chars[currchar[s]].weight=calcweight(currchar[s]);
  // statwindow(s,currchar[s]);
}

void wheel(int s, int mat)
{
	unsigned int m;
 int i,serial;
     
 int tailme=0;
     
 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&itemsp[serial%256], serial, 0);
 if (i!=-1)
  {
   if((items[i].id1==0x10 && items[i].id2==0xA4)||
      (items[i].id1==0x10 && ((items[i].id2>=0xA5)||(items[i].id2<=0xA6))))
   {
    if(iteminrange(s,i,3))  
    {
     if (!checkskill(currchar[s],TAILORING, 0, 1000)) 
     {
      sysmessage(s,"You failed to spin your material.");
      return;
     }   
     sysmessage(s,"You have successfully spun your material.");

     if (mat==YARN)
     {
      sprintf(items[chars[currchar[s]].tailitem].name,"#");
      items[chars[currchar[s]].tailitem].id1=0x0E;
      items[chars[currchar[s]].tailitem].id2=0x1D;
      items[chars[currchar[s]].tailitem].amount=items[chars[currchar[s]].tailitem].amount*4;
     }
     else if (mat==THREAD)
     {
      sprintf(items[chars[currchar[s]].tailitem].name,"#");
      items[chars[currchar[s]].tailitem].id1=0x0F;
      items[chars[currchar[s]].tailitem].id2=0xA0;
      items[chars[currchar[s]].tailitem].amount=items[chars[currchar[s]].tailitem].amount*4;
     }
     for (m=0;m<now;m++) if (perm[m]) 
     {
       items[chars[currchar[s]].tailitem].priv=items[chars[currchar[s]].tailitem].priv|0x01;
       senditem(m,chars[currchar[s]].tailitem);
     }
     tailme=1;
    }
   }     
 }   
 chars[currchar[s]].tailitem=-1;        
 if(!tailme) sysmessage(s,"You cant tailor here.");
}

void loom(int s)
{
	unsigned int m;
 int i,serial;

 int tailme=0;
     
 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&itemsp[serial%256], serial, 0);
 if (i!=-1)
  {
   if((items[i].id1==0x10 && items[i].id2==0x5F)||
      (items[i].id1==0x10 && ((items[i].id2>=0x60)||(items[i].id2<=0x61))))
   {
    if(iteminrange(s,i,3))  
    {
     if (!checkskill(currchar[s],TAILORING, 0, 1000)) 
     {
      sysmessage(s,"You failed to make cloth.");
      return;
     }   
     sysmessage(s,"You have made your cloth.");

     sprintf(items[chars[currchar[s]].tailitem].name,"#");
     items[chars[currchar[s]].tailitem].id1=0x17;
     items[chars[currchar[s]].tailitem].id2=0x5D;
     items[chars[currchar[s]].tailitem].priv=items[chars[currchar[s]].tailitem].priv|0x01;
     items[chars[currchar[s]].tailitem].amount=items[chars[currchar[s]].tailitem].amount*2;
 
     for (m=0;m<now;m++) if (perm[m]) 
     {
      senditem(m,chars[currchar[s]].tailitem);
     }       
     tailme=1;
    }
   }     
 }   
 chars[currchar[s]].tailitem=-1;        
 if(!tailme) sysmessage(s,"You cant tailor here.");
}

void cookmeat(int s)
{
	unsigned int m;
 int i,serial;
     
 int tailme=0;
     
 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&itemsp[serial%256], serial, 0);
 if (i!=-1)
  {
    if((items[i].id1==0x0D && (items[i].id2>=0xE3 && items[i].id2<=0xE9)||
       (items[i].id1==0x0F && items[i].id2==0xAC)||
       (items[i].id1==0x0F && items[i].id2==0xB1))||
       (items[i].id1==0x19 && (items[i].id2>=0x7A && items[i].id2<=0xB6))||
       (items[i].id1==0x04 && (items[i].id2>=0x61 && items[i].id2<=0x80))||
       (items[i].id1==0x0E && (items[i].id2>=0x31 && items[i].id2<=0x33))||
       (items[i].id1==0x19 && items[i].id2==0xBB)||
       (items[i].id1==0x1F && items[i].id2==0x2B)||(items[i].id1==0x09 && (items[i].id2>=0x2B &&
        items[i].id2<=0x34)||(items[i].id2>=0x37 && items[i].id2<=0x42)||(items[i].id2>=0x45 && items[i].id2<=0x50)||
       (items[i].id2>=0x53 && items[i].id2<=0x5E)||(items[i].id2>=0x61 && items[i].id2<=0x6C))) 
   {
    if(iteminrange(s,i,3))  
    {
     if (!checkskill(currchar[s],COOKING, 0, 1000)) 
     {
      sysmessage(s,"You failed to cook the meat and drop some into the ashes.");
      items[chars[currchar[s]].tailitem].amount -= 1+(rand() % (items[chars[currchar[s]].tailitem].amount));
      if (items[chars[currchar[s]].tailitem].amount <=0) deleitem(chars[currchar[s]].tailitem);
      else {for (m=0;m<now;m++) if (perm[m]) senditem(m,chars[currchar[s]].tailitem);}
      return;
     }   
     sysmessage(s,"You have cooked the meat,and it smells great.");

     sprintf(items[chars[currchar[s]].tailitem].name,"#");
     
     items[chars[currchar[s]].tailitem].id1=0x09;
     items[chars[currchar[s]].tailitem].id2=0xF2;
     items[chars[currchar[s]].tailitem].type=14;
     items[chars[currchar[s]].tailitem].priv=items[chars[currchar[s]].tailitem].priv|0x01; 
     items[chars[currchar[s]].tailitem].amount=items[chars[currchar[s]].tailitem].amount*1;
 
     for (m=0;m<now;m++) if (perm[m]) 
     {
      senditem(m,chars[currchar[s]].tailitem);
     }       
     tailme=1;
    }
   }     
 }   
 chars[currchar[s]].tailitem=-1;        
 if(!tailme) sysmessage(s,"You cant cook here.");
}

void makedough(int s)
{
	unsigned int m;
 int i,serial;

 int tailme=0;
     
 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&itemsp[serial%256], serial, 0);
 if (i!=-1)
  {
   if((items[i].id1==0x10 && items[i].id2==0x3A))
      
   {
    if(iteminrange(s,i,3))  
    {
     if (!checkskill(currchar[s],COOKING, 0, 1000)) 
     {
      sysmessage(s,"You failed to mix, and spilt your water.");
      return;
     }   
     sysmessage(s,"You have mixed very well to make your dough.");

     sprintf(items[chars[currchar[s]].tailitem].name,"#");
     
     items[chars[currchar[s]].tailitem].id1=0x10;
     items[chars[currchar[s]].tailitem].id2=0x3D;
     items[chars[currchar[s]].tailitem].priv=items[chars[currchar[s]].tailitem].priv|0x01;
     items[chars[currchar[s]].tailitem].amount=items[chars[currchar[s]].tailitem].amount*2;
 
     for (m=0;m<now;m++) if (perm[m]) 
     {
      senditem(m,chars[currchar[s]].tailitem);
     }       
     tailme=1;
    }
   }     
 }   
 chars[currchar[s]].tailitem=-1;        
 if(!tailme) sysmessage(s,"You cant mix here.");
}

void makepizza(int s)
{
	unsigned int m;
 int i,serial;

 int tailme=0;
     
 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   if((items[i].id1==0x10 && items[i].id2==0x3D))
   {
    if(iteminrange(s,i,3))  
    {
     if (!checkskill(currchar[s],COOKING, 0, 1000)) 
     {
      sysmessage(s,"You failed to mix.");
      deleitem(i);
          return;
     }   
     sysmessage(s,"You have made your uncooked pizza, ready to place in oven.");

     sprintf(items[chars[currchar[s]].tailitem].name,"#");
     
     items[chars[currchar[s]].tailitem].id1=0x10;
     items[chars[currchar[s]].tailitem].id2=0x83;
     items[chars[currchar[s]].tailitem].priv=items[chars[currchar[s]].tailitem].priv|0x01;
     items[chars[currchar[s]].tailitem].amount=items[chars[currchar[s]].tailitem].amount*2;
 
     for (m=0;m<now;m++) if (perm[m]) 
     {
      senditem(m,chars[currchar[s]].tailitem);
     }       
     tailme=1;
    
    }
   }     
 }   
 chars[currchar[s]].tailitem=1;        
 if(!tailme) sysmessage(s,"You cant mix here.");
}

void hide(int s)
{
 if (chars[currchar[s]].attacker!=-1)
 {
  sysmessage(s,"You cannot hide while fighting.");
  return;
 }
 if (!checkskill(currchar[s],HIDING, 0, 1000)) 
 {
  sysmessage(s,"You are unable to hide here.");
  return;
 }   
 sysmessage(s,"You have hidden yourself well.");
 chars[currchar[s]].hidden=1;
 updatechar(currchar[s]);
}

void treetarget(int s)
{
  int c;
  int lumber=0;
  int packnum;
 
  packnum=packitem(currchar[s]);

  if (chars[currchar[s]].onhorse) action(s,0x1C);
  else action(s,0x0D);
  soundeffect(s,0x01,0x3E);

  if (!checkskill(currchar[s],LUMBERJACKING, 0, 1000)) 
  {
    sysmessage(s,"You chop for a while, but fail to produce any usable wood.");
    return;
  } 

  if ((buffer[s][1]==1 || buffer[s][1]==0)&&(buffer[s][2]==0)
     &&(buffer[s][3]==1)&&(buffer[s][4]==0))
  {
    c=SpawnItem(s,10,"#",1,0x1B,0xDD,0,0,1,1);
    if (items[c].amount>10) sysmessage(s,"You place more logs in your pack.");
    else sysmessage(s,"You place some logs in your pack.");
 
    lumber=1;
  }
}

/*
 * I decided to base this on how OSI will be changing detect hidden. 
 * The greater your skill, the more of a range you can detect from target position.
 * Hiders near the center of the detect circle are easier to detect than ones near
 * the edges of the detect circle. Also low skill detecters cannot find high skilled
 * hiders as easily as low skilled hiders.
 */

void detecthidden(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;

	unsigned int i;
 int x,y,z,dx,dy,k,j,low;
 double c,range;         //int is too restricting

 x=(buffer[s][11]*256)+buffer[s][12];
 y=(buffer[s][13]*256)+buffer[s][14];
 z=buffer[s][16];

 j=chars[currchar[s]].skill[DETECTINGHIDDEN];

 range = (j*j/1.0E6)*VISRANGE;     // this seems like an ok formula

 for (i=0;i<charcount;i++)
 {
  if (chars[i].hidden==1) // do not detect invis people only hidden ones
  {
   dx=abs(chars[i].x-x);
   dy=abs(chars[i].y-y);
#ifdef __NT__
   c=sqrt(dx*dx+dy*dy);
#else
   c=hypot(dx, dy);
#endif
   low = (int)(chars[i].skill[HIDING]*chars[i].skill[HIDING]/1E3 - (range*50/VISRANGE)*(range-c)/range);
   if (low<0) low=0;
   if (low>1000) low=1000;

   if ((checkskill(currchar[s],DETECTINGHIDDEN,low,1000))&&(c<=range))
   {
    chars[i].hidden=0;
    updatechar(i);
    k=calcSocketFromChar(i);
    if ((k!=-1)&&(perm[k])) sysmessage(k,"You were revealed!");
   }
   else sysmessage(s,"You fail to find anyone.");
  }
 }
}

void peacemaking(int s)
{
	unsigned int i;
 int inst, res1, res2, j;
 inst=getinstrument(s);
 if (inst==-1) 
 {
  sysmessage(s, "You do not have an instrument to play on!");
  return;
 }
 res1=checkskill(currchar[s], PEACEMAKING, 0, 1000);
 res2=checkskill(currchar[s], MUSICIANSHIP, 0, 1000);
 if (res1 && res2)
 {
  playinstrumentwell(s, inst);
  sysmessage(s, "You play your hypnotic music, stopping the battle.");
  for (i=0;i<charcount;i++)
  {
   if (inrange1p(i, currchar[s]) && chars[i].war)
   {
    j=calcSocketFromChar(i);
    if ((j!=-1)&&perm[j]) sysmessage(j, "You hear some lovely music, and forget about fighting.");
    npcToggleCombat(i);
    chars[i].targ=-1;
    chars[i].attacker=-1;
    chars[i].attackfirst=0;
   }
  }
 } else 
 {
  playinstrumentpoor(s, inst);
  sysmessage(s, "You attempt to calm everyone, but fail.");
 }
}

void playinstrumentwell(int s, int i)
{
  switch(items[i].id2)
  {
  case 0x9C:
          soundeffect2(currchar[s], 0x00, 0x38);
          break;
  case 0x9D:
  case 0x9E:
          soundeffect2(currchar[s], 0x00, 0x52);
          break;
  case 0xB1:
  case 0xB2:
          soundeffect2(currchar[s], 0x00, 0x45);
          break;
  case 0xB3:
  case 0xB4:
          soundeffect2(currchar[s], 0x00, 0x4C);
          break;
  }
}

void playinstrumentpoor(int s, int i)
{
  switch(items[i].id2)
  {
  case 0x9C:
          soundeffect2(currchar[s], 0x00, 0x39);
          break;
  case 0x9D:
  case 0x9E:
          soundeffect2(currchar[s], 0x00, 0x53);
          break;
  case 0xB1:
  case 0xB2:
          soundeffect2(currchar[s], 0x00, 0x46);
          break;
  case 0xB3:
  case 0xB4:
          soundeffect2(currchar[s], 0x00, 0x4D);
          break;
  }
}

int getinstrument(int s)
{
 int i, x,serial,serhash,ci;
 x=packitem(currchar[s]);
 serial=items[x].serial;
 serhash=serial%256;
 for (ci=0;ci<contsp[serhash].max;ci++)
 {
   i=contsp[serhash].pointer[ci];

  if ((i!=-1) && (items[i].contserial==items[x].serial) &&
      (items[i].id1==0x0E) && (items[i].id2==0x9C || items[i].id2==0x9D || 
       items[i].id2==0x9E || items[i].id2==0xB1 || items[i].id2==0xB2 || 
       items[i].id2==0xB3 || items[i].id2==0xB4)) 
  {
   return i;
  }
 }
 return -1;
}

void provocationtarget1(int s)
{
 int inst;
 inst=getinstrument(s);
 if (inst==-1) 
 {
  sysmessage(s, "You do not have an instrument to play on!");
  return;
 }
 addid1[s]=buffer[s][7];
 addid2[s]=buffer[s][8];
 addid3[s]=buffer[s][9];
 addid4[s]=buffer[s][10];
 
 if (calcSocketFromChar(calcCharFromSer(addid1[s], addid2[s], addid3[s], addid4[s]))!=-1)
 {
  sysmessage(s, "You cannot provoke other players.");
 }
 else
 {
  target(s, 0, 1, 0, 80, "You play your music, inciting anger, and your target begins to look furious.  Whom do you wish it to attack?");
  playinstrumentwell(s, inst);
 }
}

void enticementtarget1(int s)
{
 int inst;
 inst=getinstrument(s);
 if (inst==-1) 
 {
  sysmessage(s, "You do not have an instrument to play on!");
  return;
 }
 addid1[s]=buffer[s][7];
 addid2[s]=buffer[s][8];
 addid3[s]=buffer[s][9];
 addid4[s]=buffer[s][10];
 if (calcSocketFromChar(calcCharFromSer(addid1[s], addid2[s], addid3[s], addid4[s]))!=-1)
 {
  sysmessage(s, "You cannot entice other players.");
 }
 else
 {
  target(s, 0, 1, 0, 82, "You play your music, luring them near.  Whom do you wish them to follow?");
  playinstrumentwell(s, inst);
 }
}

void enticementtarget2(int s)
{
 int inst, target, res1, res2;
 inst=getinstrument(s);
 if (inst==-1) 
 {
  sysmessage(s, "You do not have an instrument to play on!");
  return;
 }
 res1=checkskill(currchar[s], ENTICEMENT, 0, 1000);
 res2=checkskill(currchar[s], MUSICIANSHIP, 0, 1000);
 if (res1 && res2)
 {
  target = calcCharFromSer(addid1[s], addid2[s], addid3[s], addid4[s]);
  chars[target].ftarg=calcCharFromSer(buffer[s][7], buffer[s][8], buffer[s][9], buffer[s][10]);
  chars[target].npcWander=1;
  sysmessage(s, "You play your hypnotic music, luring them near your target.");
  playinstrumentwell(s, inst);
 }
 else 
 {
  sysmessage(s, "Your music fails to attract them.");
  playinstrumentpoor(s, inst);
 }
}

void provocationtarget2(int s)
{
 int inst, target, target2, res1, res2;
	unsigned int i;

 inst=getinstrument(s);
 if (inst==-1) 
 {
  sysmessage(s, "You do not have an instrument to play on!");
  return;
 }
 target=calcCharFromSer(addid1[s], addid2[s], addid3[s], addid4[s]);
 target2=calcCharFromSer(buffer[s][7], buffer[s][8], buffer[s][9], buffer[s][10]);
 if (target==target2)
 {
  sysmessage(s, "Silly bard!  You can't get something to attack itself.");
  return;
 }
 res1=checkskill(currchar[s], PROVOCATION, 0, 1000);
 res2=checkskill(currchar[s], MUSICIANSHIP, 0, 1000);
 if (res2)
 {
  playinstrumentwell(s, inst);
  if (res1)
  {
   sysmessage(s, "Your music succeeds as you start a fight.");
   chars[target].targ=target2;
   chars[target2].targ=target;
   if ((chars[target].hidden)&&(!(chars[target].priv2&8)))
   {
    chars[target].hidden=0;
    updatechar(target);
   }
   if ((chars[target].hidden)&&(!(chars[target].priv2&8)))
   {
    chars[target].hidden=0;
    updatechar(target);
   }
   chars[target].attackfirst=1;
   chars[target2].attackfirst=0;
   chars[target].attacker=target2;
   chars[target2].attacker=target;
   if (chars[target].npc)
   {
    if (!(chars[target].war)) npcToggleCombat(target);
    chars[target].npcmovetime=(int)((getclock()+(NPCSPEED*CLOCKS_PER_SEC)));
   }
   if (chars[target2].npc)
   {
    if (!(chars[target2].war)) npcToggleCombat(target2);
    chars[target2].npcmovetime=(int)((getclock()+(NPCSPEED*CLOCKS_PER_SEC)));
   }
   sprintf(temp, "* You see %s attacking %s *", chars[target].name, chars[target2].name);
   for (i=0;i<now;i++)
   {
    if (inrange1p(currchar[i], target)&&perm[i])
    {
     itemmessage(i, temp, chars[target].ser1, chars[target].ser2,
                          chars[target].ser3, chars[target].ser4);
    }
   }
  }
  else 
  {
   sysmessage(s, "Your music fails to incite enough anger.");
   target2=currchar[s];
   chars[target].targ=target2;
   chars[target2].targ=target;
   if ((chars[target].hidden)&&(!(chars[target].priv2&8)))
   {
    chars[target].hidden=0;
    updatechar(target);
   }
   if ((chars[target].hidden)&&(!(chars[target].priv2&8)))
   {
    chars[target].hidden=0;
    updatechar(target);
   }
   chars[target].attackfirst=1;
   chars[target2].attackfirst=0;
   chars[target].attacker=target2;
   chars[target2].attacker=target;
   if (chars[target].npc)
   {
    if (!(chars[target].war)) npcToggleCombat(target);
    chars[target].npcmovetime=(int)(getclock()+(NPCSPEED*CLOCKS_PER_SEC));
   }
   if (chars[target2].npc)
   {
    if (!(chars[target2].war)) npcToggleCombat(target2);
    chars[target2].npcmovetime=(int)(getclock()+(NPCSPEED*CLOCKS_PER_SEC));
   }
   sprintf(temp, "* You see %s attacking %s *", chars[target].name, chars[target2].name);
   for (i=0;i<now;i++)
   {
    if (inrange1p(currchar[i], target)&&perm[i])
    {
     itemmessage(i, temp, chars[target].ser1, chars[target].ser2,
                          chars[target].ser3, chars[target].ser4);
    }
   }
  }
 }
 else
 {
  playinstrumentpoor(s, inst);
  sysmessage(s, "You play rather poorly and to no effect.");
 }
}

void alchemytarget(int s)
{
 int i, type,serial;
 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&itemsp[serial%256], serial, 0);
 if (i!=-1)
  {
   type=(items[i].id1*256)+items[i].id2;
   switch (type)
   {
   case 0x0F7B: // Agility,
           itemmenu(s, 991);
           break;
   case 0x0F84: // Cure, Garlic
           itemmenu(s, 992);
           break;
   case 0x0F8C: // Explosion, Sulfurous Ash
           itemmenu(s, 993);
           break;
   case 0x0F85: // Heal, Ginseng
           itemmenu(s, 994);
           break;
   case 0x0F8D: // Night sight
           itemmenu(s, 995);
           break;
   case 0x0F88: // Poison, Nightshade
           itemmenu(s, 996);
           break;
   case 0x0F7A: // Refresh, 
           itemmenu(s, 997);
       break;
   case 0x0F86: // Strength,
           itemmenu(s, 998);
           break;
   case 0x0E9B: // Mortar
           break;
   default:
      if((items[i].id1==0x1B)&&((items[i].id2>=0x11)&&(items[i].id2<=0x1C)))
      {
         MakeNecroReg(s,i,items[i].id1,items[i].id2);
         sysmessage(s,"You grind some bone into powder.");
         break;
      }
          sysmessage(s, "That is not a valid reagent.");
   }
 }
}

void dopotion(int s, int type, int sub, int mortar)
{
 int success=0, nochoice=0;

 switch((type*256)+sub)
 {
 case 0x0101://agility
         if (getamount(currchar[s], 0x0F, 0x7B)>=1)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some blood moss in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x7B, 1);
         }
         break;
 case 0x0102://greater agility
         if (getamount(currchar[s], 0x0F, 0x7B)>=3)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some blood moss in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x7B, 3);
         }
         break;
 case 0x0201://lesser cure
         if (getamount(currchar[s], 0x0F, 0x84)>=1)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some garlic in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x84, 1);
         }
         break;
 case 0x0202://cure
         if (getamount(currchar[s], 0x0F, 0x84)>=3)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some garlic in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x84, 3);
         }
         break;
 case 0x0203://greater cure
         if (getamount(currchar[s], 0x0F, 0x84)>=6)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some garlic in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x84, 6);
         }
         break;
 case 0x0301://lesser explosion
         if (getamount(currchar[s], 0x0F, 0x8C)>=3)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some sulfurous ash in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x8C, 3);
         }
         break;
 case 0x0302://explosion
         if (getamount(currchar[s], 0x0F, 0x8C)>=5)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some sulfurous ash in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x8C, 5);
         }
         break;
 case 0x0303://greater explosion
         if (getamount(currchar[s], 0x0F, 0x8C)>=10)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some sulfurous ash in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x8C, 10);
         }
         break;
 case 0x0401://lesser heal
         if (getamount(currchar[s], 0x0F, 0x85)>=1)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some ginseng in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x85, 1);
         }
         break;
 case 0x0402://heal
         if (getamount(currchar[s], 0x0F, 0x85)>=3)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some ginseng in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x85, 3);
         }
         break;
 case 0x0403://greater heal
         if (getamount(currchar[s], 0x0F, 0x85)>=7)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some ginseng in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x85, 7);
         }
         break;
 case 0x0501://night sight
         if (getamount(currchar[s], 0x0F, 0x8D)>=1)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some spider's silk in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x8D, 1);
         }
         break;
 case 0x0601://lesser poison
         if (getamount(currchar[s], 0x0F, 0x88)>=1)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some nightshade in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x88, 1);
         }
         break;
 case 0x0602://poison
         if (getamount(currchar[s], 0x0F, 0x88)>=2)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some nightshade in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x88, 2);
         }
         break;
 case 0x0603://greater poison
         if (getamount(currchar[s], 0x0F, 0x88)>=4)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some nightshade in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x88, 4);
         }
         break;
 case 0x0604://deadly poison
         if (getamount(currchar[s], 0x0F, 0x88)>=8)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some nightshade in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x88, 8);
         }
         break;
 case 0x0701://refresh
         if (getamount(currchar[s], 0x0F, 0x7A)>=1)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some black pearl in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x7A, 1);
         }
         break;
 case 0x0702://total refreshment
         if (getamount(currchar[s], 0x0F, 0x7A)>=5)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some black pearl in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x7A, 5);
         }
         break;
 case 0x0801://strength
         if (getamount(currchar[s], 0x0F, 0x86)>=2)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some mandrake in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x86, 2);
         }
         break;
 case 0x0802://greater strength
         if (getamount(currchar[s], 0x0F, 0x86)>=5)
         {
          success=1;
          sprintf(temp, "*%s starts grinding some mandrake in the mortar.*", chars[currchar[s]].name);
          delequan(currchar[s], 0x0F, 0x86, 5);
         }
         break;
 default:
         nochoice=1;
 }
 if (success==0)
 {
  if (!nochoice) sysmessage(s, "You do not have enough reagents for that potion.");
 } 
 else 
 {
  npcemoteall(currchar[s], temp);
  tempeffect(currchar[s], currchar[s], 9, 0, 0, 0);
  tempeffect(currchar[s], currchar[s], 9, 0, 3, 0);
  tempeffect(currchar[s], currchar[s], 9, 0, 6, 0);
  tempeffect(currchar[s], currchar[s], 9, 0, 9, 0);
  tempeffect2(currchar[s], mortar, 10, type, sub, 0);
 }
}

void createpotion(int s, char type, char sub, int mortar)
{
 int success=0;
         
 switch((256*type)+sub)
 {
 case 0x0101://agility
         success=checkskill(s, ALCHEMY, 151, 651);
     break;
 case 0x0102://greater agility
         success=checkskill(s, ALCHEMY, 351, 851);
         break;
 case 0x0201://lesser cure
         success=checkskill(s, ALCHEMY, 0, 500);
         break;
 case 0x0202://cure
         success=checkskill(s, ALCHEMY, 251, 751);
         break;
 case 0x0203://greater cure
         success=checkskill(s, ALCHEMY, 651, 1151);
         break;
 case 0x0301://lesser explosion
         success=checkskill(s, ALCHEMY, 51, 551);
         break;
 case 0x0302://explosion
         success=checkskill(s, ALCHEMY, 351, 851);
         break;
 case 0x0303://greater explosion
         success=checkskill(s, ALCHEMY, 651, 1151);
         break;
 case 0x0401://lesser heal
         success=checkskill(s, ALCHEMY, 0, 500);
         break;
 case 0x0402://heal
         success=checkskill(s, ALCHEMY, 151, 651);
         break;
 case 0x0403://greater heal
         success=checkskill(s, ALCHEMY, 551, 1051);
         break;
 case 0x0501://night sight
         success=checkskill(s, ALCHEMY, 0, 500);
         break;
 case 0x0601://lesser poison
         success=checkskill(s, ALCHEMY, 0, 500);
         break;
 case 0x0602://poison
         success=checkskill(s, ALCHEMY, 151, 651);
         break;
 case 0x0603://greater poison
         success=checkskill(s, ALCHEMY, 551, 1051);
         break;
 case 0x0604://deadly poison
         success=checkskill(s, ALCHEMY, 901, 1401);
         break;
 case 0x0701://refresh
         success=checkskill(s, ALCHEMY, 0, 500);
         break;
 case 0x0702://total refreshment
         success=checkskill(s, ALCHEMY, 251, 751);
         break;
 case 0x0801://strength
         success=checkskill(s, ALCHEMY, 251, 751);
         break;
 case 0x0802://greater strength
         success=checkskill(s, ALCHEMY, 451, 951);
         break;
 }
 if (success==0)
 {
  sprintf(temp, "*%s tosses the failed mixture from the mortar, unable to create a potion from it.*", chars[s].name);
  npcemoteall(s, temp);
  return;
 }
 items[mortar].type=17;
 items[mortar].more1=type;
 items[mortar].more2=sub;
 items[mortar].morex=chars[s].skill[ALCHEMY];

 if (!(getamount(s, 0x0F, 0x0E)>=1))
 {
  target(calcSocketFromChar(s), 0, 1, 0, 109, "Where is an empty bottle for your potion?");
 }
 else
 {
  // Dupois - Added pouring potion sfx
  // Added Oct 09, 1998
  soundeffect(s, 0x02, 0x40);  // Liquid sfx
  sprintf(temp, "*%s pours the completed potion into a bottle.*", chars[s].name);
  npcemoteall(s, temp);
  delequan(s, 0x0F, 0x0E, 1);
  potiontobottle(s, mortar);
 } 
}

void bottletarget(int s)
{
 int i,  mortar,serial;
	unsigned int j;

 mortar=calcItemFromSer(addid1[s], addid2[s], addid3[s], addid4[s]);
 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&itemsp[serial%256], serial, 0);
 if ((i!=-1) && (items[i].id1==0x0F)&&(items[i].id2==0x0E))
  {
   if (items[i].amount==1) 
   {
    deleitem(i);
   }
   else 
   {
    items[i].amount--;
    for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
   }
   if (items[mortar].type==17) 
   {
    sprintf(temp, "*%s pours the completed potion into a bottle.*", chars[currchar[s]].name);
    npcemoteall(currchar[s], temp);
    potiontobottle(currchar[s], mortar);
   }
 }
 return;
}

void potiontobottle(int s, int mortar)
{
	unsigned int i;
 int c, p, x, y;
 x=rand()%80;
 y=rand()%80;
 p=packitem(s);

 c=SpawnItem(calcSocketFromChar(s),1,"#",0,0x09,0x15,0,0,1,0);
 items[c].type=19;
 items[c].morex=items[mortar].morex;
 items[c].morey=items[mortar].more1;
 items[c].morez=items[mortar].more2;
 switch((256*items[mortar].more1)+items[mortar].more2)
 {
 case 0x0101:
  sprintf(items[c].name, "an agility potion");
  items[c].id1=0x0F;
  items[c].id2=0x08;
  break;
 case 0x0102:
  sprintf(items[c].name, "a greater agility potion");
  items[c].id1=0x0F;
  items[c].id2=0x08;
  break;
 case 0x0201:
  sprintf(items[c].name, "a lesser cure potion");
  items[c].id1=0x0F;
  items[c].id2=0x07;
  break;
 case 0x0202:
  sprintf(items[c].name, "a cure potion");
  items[c].id1=0x0F;
  items[c].id2=0x07;
  break;
 case 0x0203:
  sprintf(items[c].name, "a greater cure potion");
  items[c].id1=0x0F;
  items[c].id2=0x07;
  break;
 case 0x0301:
  sprintf(items[c].name, "a lesser explosion potion");
  items[c].id1=0x0F;
  items[c].id2=0x0D;
  break;
 case 0x0302:
  sprintf(items[c].name, "an explosion potion");
  items[c].id1=0x0F;
  items[c].id2=0x0D;
  break;
 case 0x0303:
  sprintf(items[c].name, "a greater explosion potion");
  items[c].id1=0x0F;
  items[c].id2=0x0D;
  break;
 case 0x0401:
  sprintf(items[c].name, "a lesser heal potion");
  items[c].id1=0x0F;
  items[c].id2=0x0C;
  break;
 case 0x0402:
  sprintf(items[c].name, "a heal potion");
  items[c].id1=0x0F;
  items[c].id2=0x0C;
  break;
 case 0x0403:
  sprintf(items[c].name, "a greater heal potion");
  items[c].id1=0x0F;
  items[c].id2=0x0C;
  break;
 case 0x0501:
  sprintf(items[c].name, "a night sight potion");
  items[c].id1=0x0F;
  items[c].id2=0x06;
  break;
 case 0x0601:
  sprintf(items[c].name, "a lesser poison potion");
  items[c].id1=0x0F;
  items[c].id2=0x0A;
  break;
 case 0x0602:
  sprintf(items[c].name, "a poison potion");
  items[c].id1=0x0F;
  items[c].id2=0x0A;
  break;
 case 0x0603:
  sprintf(items[c].name, "a greater poison potion");
  items[c].id1=0x0F;
  items[c].id2=0x0A;
  break;
 case 0x0604:
  sprintf(items[c].name, "a deadly poison potion");
  items[c].id1=0x0F;
  items[c].id2=0x0A;
  break;
 case 0x0701:
  sprintf(items[c].name, "a refresh potion");
  items[c].id1=0x0F;
  items[c].id2=0x0B;
  break;
 case 0x0702:
  sprintf(items[c].name, "a total refreshment potion");
  items[c].id1=0x0F;
  items[c].id2=0x0B;
  break;
 case 0x0801:
  sprintf(items[c].name, "a strength potion");
  items[c].id1=0x0F;
  items[c].id2=0x09;
  break;
 case 0x0802:
  sprintf(items[c].name, "a greater strength potion");
  items[c].id1=0x0F;
  items[c].id2=0x09;
  break;
 }
 for(i=0;i<now;i++) if (perm[i]) senditem(i, c);
 items[mortar].type=0;
 return;
}

char checkskill(int s,unsigned short int sk, int low, int high)
{
   char skillused=0;
   float range=800.00, randnum1, randnum, charrange;

   if(high>1200) high=1200;
   charrange= (float) (chars[s].skill[sk]-low);
   if(charrange<0) charrange=0;
   randnum1=(range/(high-low));
   randnum=(randnum1*charrange)+100;
   if (randnum>900) randnum=900;
   if (randnum>=rand()%1000) skillused=1;

   if(chars[s].baseskill[sk]<high)
   {
      if (sk!=MAGERY || (sk==MAGERY && currentSpellType[currchar[s]]==0))
      {
         if(advanceskill(s, sk, skillused))
         {
            updateSkillLevel(s, sk); 
            updateskill(calcSocketFromChar(s), sk);
         }
      }
   }
   return skillused;
}          

char advanceskill(int s, int sk, char skillused)
{
   int i=0, retval, incval;
   while (advance[1+i+skill[sk].advance_index].skill==sk && 
        advance[1+i+skill[sk].advance_index].base<=chars[s].baseskill[sk])
   {
      i++;
   }
   if(skillused)
   {
      incval=(advance[i+skill[sk].advance_index].success)*10;
   }
   else
   {
      incval=(advance[i+skill[sk].advance_index].failure)*10;
   }
   retval=0;
   if (incval>rand()%1000)
   {
      retval=1;
      chars[s].baseskill[sk]++;
   }
   if (retval)
   {
      advancestats(s, sk);
   }
   return retval;
}

void advancestats(int s, int sk)
{
 int i,j;
 int update=0;
 if (skill[sk].st>rand()%250)
 {
  i=0;
  while (advance[1+i+skill[STR].advance_index].skill==STR &&  
         advance[1+i+skill[STR].advance_index].base<=chars[s].st)
  {
   i++;
  }
  chars[s].st2=chars[s].st2+advance[i+skill[STR].advance_index].success;
  if (chars[s].st2>100)
  {
   chars[s].st2=chars[s].st2-100;
   chars[s].st=chars[s].st+1;
   update=1;
  }
 }

 if (skill[sk].dx>rand()%250)
 {
  i=0;
  while (advance[1+i+skill[DEX].advance_index].skill==DEX &&
         advance[1+i+skill[DEX].advance_index].base<=chars[s].dx)
  {
   i++;
  }
  chars[s].dx2=chars[s].dx2+advance[i+skill[DEX].advance_index].success;
  if (chars[s].dx2>100)
  {
   chars[s].dx2=chars[s].dx2-100;
   chars[s].dx=chars[s].dx+1;
   update=1;
  }
 }
 if (skill[sk].in>rand()%250)
 {
  i=0;
  while (advance[1+i+skill[INT].advance_index].skill==INT &&
         advance[1+i+skill[INT].advance_index].base<=chars[s].in)
  {
   i++;
  }
  chars[s].in2=chars[s].in2+advance[i+skill[INT].advance_index].success;
  if (chars[s].in2>100)
  {
   chars[s].in2=chars[s].in2-100;
   chars[s].in=chars[s].in+1;
   update=1;
  }
 }

 if (update)
 {
  if ((j=calcSocketFromChar(s))!=-1)
  {
   statwindow(j, s);
   for (i=0; i<ALLSKILLS; i++)
   {
     updateSkillLevel(s, i);
   }
  }
 }
}


void createbandagetarget(int s)
{
 int i,c,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if ((i!=-1) &&
     ((items[i].id1==0x0f)&&((items[i].id2>=0x95)&&(items[i].id2<=0x9c)))||
     ((items[i].id1==0x17)&&((items[i].id2>=0x5d)&&(items[i].id2<=0x64))))
  {
    soundeffect(s,0x02,0x48);        
    if(!checkskill(currchar[s],TAILORING, 0, 1000)) 
    {
      sysmessage(s,"You were unable to cut bandages.");
    }
    else
    {
      sysmessage(s,"You cut some cloth into a bandage, and put it in your backpack");
      c=SpawnItem(s,1,"clean bandages",1,0x0E,0x21,0,0,1,1);
      items[c].att=9;
     //  EviLDeD  -  If this was a bolt of cloth then make sure to leave 49 cutcloth :)
     //  December 24, 1998
     if( items[i].id1==0x0f && ( (items[i].id2>=0x95)&&(items[i].id2<=0x9c) ) )
     {
        c=SpawnItem(s,49,"Cut Cloth",1,0x17,0x5F,0,0,1,1);
     }
     //  EviLDeD  -  End
    }
    if(items[i].amount==1)
    {
      deleitem(i);
    }
    else
    {
      items[i].amount--;
    }
    return;
  }
  sysmessage(s,"You cannot cut bandages from that item.");
}

void healingSkillTarget(int s)
{
 int i,j,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
if ((chars[i].dead==1) && (chars[s].baseskill[HEALING]>=800))
    {
      if(!checkskill(currchar[s],HEALING,800,1000))
      {
        sysmessage(s,"You failed to resurrect the ghost");
        return;
      }
      resurrecttarget(s);
      sysmessage(s,"Because of your skill, you were able to resurrect the ghost.");
      return;
    }

    if ((chars[i].dead==1) && (800>chars[s].baseskill[HEALING]))
    {
      sysmessage(s,"You are not skilled enough to resurrect");
      return;
    }

    if ((chars[i].poisoned>0) && (chars[s].baseskill[HEALING]>=600))
    {
      if(!checkskill(currchar[s],HEALING,600,1000))
      {
        sysmessage(s,"You fail to counter the poison");
        if(items[npcshape[0]].amount>1)
        {
          items[npcshape[0]].amount-=1;
        }
        else deleitem(npcshape[0]);
        return;
      }
      chars[i].poisoned=0;
      sysmessage(s,"Because of your skill, you were able to counter the poison.");
      if(items[npcshape[0]].amount>1)
      {
        items[npcshape[0]].amount-=1;
      }
      else deleitem(npcshape[0]);
      return;
    }

    if ((chars[i].poisoned>0) && (600>chars[s].baseskill[HEALING]))
    {
      sysmessage(s,"You are not skilled enough to cure poison.");
      sysmessage(s,"The poison in your target's system counters the bandage's effect.");
      return;
    }
    if(chars[i].hp==chars[i].st)
    {
      sysmessage(s,"That being is undamaged");
      return;
    }
    if(!(npcinrange(s,i,1)))
    {
      sysmessage(s,"You are not close enough to apply the bandages.");
      return;
    }
    if((chars[i].id1==0x01) && ((chars[i].id2==0x90) || (chars[i].id2==0x91))) //Used on human
    {
      if (!checkskill(currchar[s],HEALING,0,1000))
      {
        sysmessage(s,"You are not skilled enough to heal that person.");
      }
      j=chars[i].hp+((3*chars[currchar[s]].skill[HEALING])/100) + rand()%6;
      chars[i].hp=min(chars[i].st, j);
      updatestats(i, 0);
      sysmessage(s,"You apply the bandages and the patient looks a bit healthier.");
      if(items[npcshape[0]].amount>1)
      {
        items[npcshape[0]].amount-=1;
      }
      else deleitem(npcshape[0]);
    }
    else //Bandages used on a non-human
    {
      if (!checkskill(currchar[s],VETERINARY,0,1000))
      {
        sysmessage(s,"You are not skilled enough to heal that creature.");
      }
      j=chars[i].hp+((3*chars[currchar[s]].skill[VETERINARY])/100) + rand()%6;
      chars[i].hp=min(chars[i].st, j);
      updatestats(i, 0);
      sysmessage(s,"You apply the bandages and the creature looks a bit healthier.");
      if(items[npcshape[0]].amount>1)
      {
        items[npcshape[0]].amount-=1;
      }
      else deleitem(npcshape[0]);
    }
  }
}

void spiritspeak(int s)  // spirit speak time, on a base of 30 seconds + skill[SPIRITSPEAK]/50 + INT
{
//      Unsure if spirit speaking should they attempt again?
//      Suggestion: If they attempt the skill and the timer is !0 do not have it raise the skill

// if(chars[currchar[s]].spiritspeaktimer>0)
// {
//  chars[i].spiritspeaktimer=0;
//  return;
// }

 if(!checkskill(currchar[s],SPIRITSPEAK, 0, 1000))
 {
  sysmessage(s,"You fail your attempt at contacting the netherworld.");

// if they try again and fail should that set the current spiritspeaktimer counter? 
// This may pervent people from macroing the skill and force people to wait until it is done to attempt again.....

//  chars[i].spiritspeaktimer=0;

  return;
 }

 impaction(s,0x11);     // I heard there is no action...but I decided to add one
 soundeffect(s,0x02,0x4A); // only get the sound if you are successful
 sysmessage(s,"You establish a connection to the netherworld.");

 chars[currchar[s]].spiritspeaktimer=spiritspeak_data.spiritspeaktimer+chars[currchar[s]].skill[SPIRITSPEAK]/50+chars[currchar[s]].in; // spirit speak duration
}

void armsloretarget(int s)
{
 int i, total,serial;
 float totalhp;
 char temp2[60];

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {                                                                                             
     if ((items[i].def==0)||(items[i].pileable))
     if ((items[i].lodamage==0)&&(items[i].hidamage==0))
     {
       sysmessage(s, "That does not appear to be a weapon.");
       return;
     }
    if(chars[currchar[s]].priv&1)
    {
      sprintf(temp, "Attack [%i] Defense [%i] Lodamage [%i] Hidamage [%i]", items[i].att, items[i].def, items[i].lodamage, items[i].hidamage);
      sysmessage(s, temp);
    }
    else
    {
      if (!checkskill(currchar[s],ARMSLORE, 0, 250)) sysmessage(s,"You are not certain...");
      else
      {
        if( items[i].maxhp==0)
        {
	sysmessage(s," Sorry this is a old item and it doesn't have maximum hp");
        }
        else {
        totalhp= (float) ((items[i].hp)/items[i].maxhp);

        sprintf(temp,"This items ");
        if      (totalhp>0.9) sprintf(temp2,"is brand new."); 
        else if (totalhp>0.8) sprintf(temp2,"is almost new.");
        else if (totalhp>0.7) sprintf(temp2,"is barely used, with a few nicks and scrapes.");
        else if (totalhp>0.6) sprintf(temp2,"is in fairly good condition.");
        else if (totalhp>0.5) sprintf(temp2,"suffered some wear and tear.");
        else if (totalhp>0.4) sprintf(temp2,"is well used.");
        else if (totalhp>0.3) sprintf(temp2,"is rather battered.");
        else if (totalhp>0.2) sprintf(temp2,"is somewhat badly damaged.");
        else if (totalhp>0.1) sprintf(temp2,"is flimsy and not trustworthy.");
        else                  sprintf(temp2,"is falling apart.");
        strcat(temp,temp2);
	}
        if (checkskill(currchar[s],ARMSLORE, 250, 500))
        {
          if (items[i].hidamage)
          {
            total = (items[i].hidamage + items[i].lodamage)/2;
            if      ( total > 26) sprintf(temp2," Would be extraordinarily deadly.");
            else if ( total > 21) sprintf(temp2," Would be a superior weapon.");
            else if ( total > 16) sprintf(temp2," Would inflict quite a lot of damage and pain."); 
            else if ( total > 11) sprintf(temp2," Would probably hurt your opponent a fair amount.");
            else if ( total > 6)  sprintf(temp2," Would do some damage.");
            else if ( total > 3)  sprintf(temp2," Would do minimal damage.");
            else                  sprintf(temp2," Might scratch your opponent slightly.");
            strcat(temp,temp2);

            if (checkskill(currchar[s], ARMSLORE, 500, 750))
            {
              if      (items[i].spd > 35) sprintf(temp2," And is very fast.");
              else if (items[i].spd > 25) sprintf(temp2," And is fast.");
              else if (items[i].spd > 15) sprintf(temp2," And is slow.");
              else                        sprintf(temp2," And is very slow.");
              strcat(temp,temp2);
            }
          }
          else
          {
            if      ( items[i].def> 12 ) sprintf(temp2," Is superbly crafted to provide maximum protection.");
            else if ( items[i].def> 10 ) sprintf(temp2," Offers excellent protection.");
            else if ( items[i].def> 8  ) sprintf(temp2," Is a superior defense against attack.");
            else if ( items[i].def> 6  ) sprintf(temp2," Serves as a sturdy protection.");
            else if ( items[i].def> 4  ) sprintf(temp2," Offers some protection against blows.");
            else if ( items[i].def> 2  ) sprintf(temp2," Provides very little protection.");
            else if ( items[i].def> 0  ) sprintf(temp2," Provides almost no protection.");
            else                         sprintf(temp2," Offers no defense against attackers.");
            strcat(temp,temp2);
          }
        }
        sysmessage(s, temp);
      }
    }
  }
}

void itemidtarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   if (!checkskill(currchar[s], ITEMID, 0, 250))
   {
        sysmessage(s, "You can't quite tell what this item is...");
   }
   else
   {
    sprintf(temp, "This item appears to be called: %s", items[i].name);
    sysmessage(s, temp);
    if (!checkskill(currchar[s], ITEMID, 250, 500))
    {
     sysmessage(s, "You can't tell if it is magical or not.");
    }
    else
    {
     if(items[i].type!=15)
     {
      sysmessage(s, "This item has no hidden magical properties.");
     }
     else
     {
      if (!checkskill(currchar[s], ITEMID, 500, 1000))
      {
       sysmessage(s,"This item is enchanted with a spell, but you cannot determine which");
      }
      else
      {
       if (!checkskill(currchar[s], ITEMID, 750, 1100))
       {
        sprintf(temp, "It is enchanted with the spell %s, but you cannot determine how many charges remain.",spellname[(8*(items[i].morex-1))+items[i].morey-1]);
        sysmessage(s,temp);       
       }
       else
       {
        sprintf(temp, "It is enchanted with the spell %s, and has %d charges remaining.",spellname[(8*(items[i].morex-1))+items[i].morey-1],items[i].morez);
        sysmessage(s,temp);
       }
      }
     }
    }
   }
  }
}

void evaluate_int_target(int s)
{
  int i, serial;
  char buf[75];

  if (!checkskill(currchar[s],EVALUATINGINTEL, 0, 1000)) 
  {
    sysmessage(s,"You are not certain..");
    return;
  }
  else 
  {
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
    if ((chars[i].in == 0)) 
    sysmessage(s, "That does not appear to be a living being.");
    else
    {
      if (chars[i].in <= 10)
        sprintf(buf,"slightly less intelligent than a rock");
      else if (chars[i].in <= 20)
        sprintf(buf,"fairly stupid");
      else if (chars[i].in <= 30)
        sprintf(buf,"not the brightest");
      else if (chars[i].in <= 40)
        sprintf(buf,"about average");
      else if (chars[i].in <= 50)
        sprintf(buf,"moderately intelligent");
      else if (chars[i].in <= 60)
        sprintf(buf,"very intelligent");
      else if (chars[i].in <= 70)
        sprintf(buf,"extraordinarily intelligent");
      else if (chars[i].in <= 80)
        sprintf(buf,"like a formidable intellect, well beyond the ordinary");
      else if (chars[i].in <=90)
        sprintf(buf,"like a definite genius");
      else if (chars[i].in > 90)
        sprintf(buf,"superhumanly intelligent in a manner you cannot comprehend");
      sprintf(temp,"That person looks %s.", buf);
      sysmessage(s, temp);
    }
  }
 }
}

void anatomytarget(int s)
{
 int i,serial;
 char buf[125];
 char buf2[125];

 if (!checkskill(currchar[s],ANATOMY, 0, 1000)) 
   {
    sysmessage(s,"You are not certain..");
    return;
   }   
 else 
 {
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   if ((chars[i].st == 0) && (chars[i].dx == 0)) 
   sysmessage(s, "That does not appear to be a living being.");
   else
   {
    if (chars[i].st <= 10)
    sprintf(buf,"rather feeble");
    else if (chars[i].st <= 20)
    sprintf(buf,"somewhat weak");
    else if (chars[i].st <= 30)
    sprintf(buf,"to be of normal strength");
    else if (chars[i].st <= 40)
    sprintf(buf,"somewhat strong"); 
    else if (chars[i].st <= 50)
    sprintf(buf,"very strong");
    else if (chars[i].st <= 60)
    sprintf(buf,"extremely strong"); 
    else if (chars[i].st <= 70)
    sprintf(buf,"extraordinarily strong");
    else if (chars[i].st <= 80)
    sprintf(buf,"as strong as an ox");
    else if (chars[i].st <= 90)
    sprintf(buf,"like one of the strongest people you have ever seen");
    else if (chars[i].st > 90)
    sprintf(buf,"superhumanly strong"); 
    if (chars[i].dx <= 10) 
    sprintf(buf2,"very clumsy");
    else if (chars[i].dx <= 20)
    sprintf(buf2,"somewhat uncoordinated");
    else if (chars[i].dx <= 30)
    sprintf(buf2,"moderately dexterous");
    else if (chars[i].dx <= 40)
    sprintf(buf2,"somewhat agile");
    else if (chars[i].dx <= 50)
    sprintf(buf2,"very agile");
    else if (chars[i].dx <= 60)
    sprintf(buf2,"extremely agile");
    else if (chars[i].dx <= 70)
    sprintf(buf2,"extraordinarily agile");
    else if (chars[i].dx <= 80)
    sprintf(buf2,"like they move like quicksilver");
    else if (chars[i].dx <= 90)
    sprintf(buf2,"like one of the fastest people you have ever seen");
    else if (chars[i].dx > 90) 
    sprintf(buf2, "superhumanly agile");
    sprintf(temp,"That person looks %s and %s.", buf, buf2); 
    sysmessage(s, temp);
   }
 }
 }
}

void tametarget(int s)
{
 int i,tamed=0,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if ((i!=-1) && (chars[i].npc==1))
  {
    if (chars[i].taming>1000)
    {
      sysmessage(s, "You can't tame that creature.");
      return;
    }
    if ((!checkskill(currchar[s],TAMING, 0, 1000))||
        (chars[currchar[s]].skill[TAMING]<chars[i].taming)) 
    {
      sysmessage(s,"You were unable to tame it.");
      return;
    }   
    sprintf(temp,"You tame %s.",chars[i].name);
    sysmessage(s,temp);
    tamed=1;
    /*chars[i].own1=chars[currchar[s]].ser1;
    chars[i].own2=chars[currchar[s]].ser2;
    chars[i].own3=chars[currchar[s]].ser3;
    chars[i].own4=chars[currchar[s]].ser4;*/
    setserial(i,currchar[s], 5);
    chars[i].npcWander=0;
    chars[i].npcaitype=0;
  }
  if (tamed==0) sysmessage(s,"You can't tame that!");
}

void fishtarget(int s)
{
 //int randbuf,m, k;
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF)
   return;

 if(buffer[s][0x11]==0x17 && buffer[s][0x12]==0x98 || buffer[s][0x11]==0x17 && buffer[s][0x12]==0x9B || buffer[s][0x11]==0x17 && buffer[s][0x12]==0x9C || buffer[s][0x11]==0x17 && buffer[s][0x12]==0x99 || buffer[s][0x11]==0x17 && buffer[s][0x12]==0x97 || buffer[s][0x11]==0x17 && buffer[s][0x12]==0x9A)
  {
   action(s,0x0b);              
   if ((buffer[s][1]==1 || buffer[s][1]==0)&&(buffer[s][2]==0)&&(buffer[s][3]==1)&&(buffer[s][4]==0))
     chars[currchar[s]].fishingtimer=rand()%fishing_data.randomtime+fishing_data.basetime;
     soundeffect(s,0x02,0x3F);
  }
  else
    sysmessage(s,"You need to be closer to the water to fish!");
}

void fish(unsigned int i)
{
 int c;
 int idnum=0xCF;
 int s=calcSocketFromChar(i);
 if(!checkskill(currchar[s],FISHING, 0, 1000)) 
 {
  sysmessage(s,"You fish for a while, but fail to catch anything.");
  return;
 }   
 i=rand()%3;
 if(i==0) idnum=0xCC;
 if(i==1) idnum=0xCD;
 if(i==2) idnum=0xCE;

 c=SpawnItem(s,1,"#",0,0x09,idnum,0,0,0,0);
 items[c].type=14;
 items[c].x=chars[currchar[s]].x;
 items[c].y=chars[currchar[s]].y;
 items[c].z=chars[currchar[s]].z;
 for(i=0;i<now;i++) if(perm[i]) senditem(i,c);
 sysmessage(s,"You pull out a nice fish!");
}

int getcombatskill(int i)
{
 int j,serial,serhash,ci;
 int skillused = WRESTLING;

  serial=chars[i].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    j=contsp[serhash].pointer[ci];
    if ((j!=-1) && (items[j].contserial==chars[i].serial) && ((items[j].layer==1)||(items[j].layer==2)))
  {
   if (((items[j].id1==0x13)&&(items[j].id2>=0xB5)&&(items[j].id2<=0xBA)) || 
       ((items[j].id1==0x0F)&&(items[j].id2>=0x43)&&(items[j].id2<=0x4E)) ||
       ((items[j].id1==0x0F)&&(items[j].id2>=0x5E)&&(items[j].id2<=0x61)) ||
       ((items[j].id1==0x13)&&(items[j].id2==0xB0))                                       || //war axe
       ((items[j].id1==0x13)&&(items[j].id2==0xFA)||(items[j].id2==0xFB)) ||
       ((items[j].id1==0x14)&&(items[j].id2>=0x3E)&&(items[j].id2<=0x43)) ||
       ((items[j].id1==0x13)&&(items[j].id2==0xFE)||(items[j].id2==0xFF)) ||
       ((items[j].id1==0x0E)&&(items[j].id2>=0xC1)&&(items[j].id2<=0xC5))  )
           {
             skillused = SWORDSMANSHIP;
             break;
           }
   if (((items[j].id1==0x13)&&(items[j].id2==0xB3)||(items[j].id2==0xB4)) ||
       ((items[j].id1==0x0F)&&(items[j].id2==0x5C)||(items[j].id2==0x5D)) ||
       ((items[j].id1==0x0F)&&(items[j].id2==0xB4)||(items[j].id2==0xB5)) || 
       ((items[j].id1==0x13)&&(items[j].id2==0xAF))                                               ||
       ((items[j].id1==0x13)&&(items[j].id2==0xE3)||(items[j].id2==0xE4)) ||
       ((items[j].id1==0x13)&&(items[j].id2==0xF4)||(items[j].id2==0xF5)) ||
       ((items[j].id1==0x13)&&(items[j].id2==0xF8)||(items[j].id2==0xF9)) ||
       ((items[j].id1==0x14)&&(items[j].id2>=0x38)&&(items[j].id2<=0x3D)) ||
       ((items[j].id1==0x14)&&(items[j].id2==0x06)||(items[j].id2==0x07)) ||
       ((items[j].id1==0x0E)&&(items[j].id2==0x89)||(items[j].id2==0x8A)) ||
       ((items[j].id1==0x0D)&&(items[j].id2>=0xF0)&&(items[j].id2<=0xF5)) ||
       ((items[j].id1==0x0E)&&(items[j].id2==0x81)||(items[j].id2==0x82))  )
           {
             skillused = MACEFIGHTING;
             break;
           }
   if (((items[j].id1==0x0F)&&(items[j].id2==0x51)||(items[j].id2==0x52)) ||
       ((items[j].id1==0x0F)&&(items[j].id2==0x62)||(items[j].id2==0x63)) ||
       ((items[j].id1==0x14)&&(items[j].id2<=0x05)) ||
       ((items[j].id1==0x0E)&&(items[j].id2==0x87)||(items[j].id2==0x88))  )
           {
             skillused = FENCING;
             break;
           }
   if (((items[j].id1==0x13)&&(items[j].id2==0xB2)||(items[j].id2==0xFD)) ||
       ((items[j].id1==0x0F)&&(items[j].id2==0x4F))                                                ) 
           {
             skillused = ARCHERY;
             break;
           }
  }
 }
 return(skillused);
}

int getshield(int i)
{
 int j,serial,serhash,ci;

  serial=chars[i].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    j=contsp[serhash].pointer[ci];
    if ((j!=-1) && (items[j].contserial==chars[i].serial) && (items[j].layer==2))
    {
      if ((items[j].id1==0x1B)&&(items[j].id2>=0x72)&&(items[j].id2<=0x7B)) return(j);
      if ((items[j].id1==0x1B)&&(items[j].id2>=0xC3)&&(items[j].id2<=0xC5)) return(j);
    }
  }
  return(-1);
}

void skilluse(int s, int x) // Skill is clicked on the skill list
{
 if (chars[currchar[s]].dead)
 {
  sysmessage(s,"You cannot do that as a ghost.");
  return;
 }
 if ((chars[currchar[s]].hidden)&&(!(chars[currchar[s]].priv2&8)))
 {
  chars[currchar[s]].hidden=0;
  updatechar(currchar[s]);
 }
 if((chars[currchar[s]].skilldelay<=getclock()) || (chars[currchar[s]].priv&1))
  switch(x)
  {
   case ARMSLORE:
    target(s, 0, 1, 0, 29, "What item do you wish to get information about?");
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case ANATOMY:
    target(s, 0, 1, 0, 37, "Whom shall I examine?");
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case ITEMID:
    target(s, 0, 1, 0, 40, "What do you wish to appraise and identify?");
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case EVALUATINGINTEL:
    target(s, 0, 1, 0, 41, "What would you like to evaluate?");
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case TAMING:
    target(s, 0, 1, 0, 42, "Tame which animal?");
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case HIDING:
    hide(s);
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case DETECTINGHIDDEN:
    target(s, 0, 1, 0, 77, "Where do you wish to search for hidden characters?");
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case PEACEMAKING:
    peacemaking(s);
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case PROVOCATION:
    target(s, 0, 1, 0, 79, "Whom do you wish to incite?");
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case ENTICEMENT:
    target(s, 0, 1, 0, 81, "Whom do you wish to entice?");
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case SPIRITSPEAK:
    spiritspeak(s);
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case STEALING:
	if (server_data.rogue)
	{
		target(s,0,1,0,205, "What do you wish to steal?");
		chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
		return;
	} else {
		sysmessage(s, "That skill has not been implemented yet.");
		return;
	}
   case INSCRIPTION:
    target(s, 0, 1, 0, 160, "What do you wish to place a spell on?");
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case TRACKING:
    trackingmenu(s,TRACKINGMENUOFFSET);
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case BEGGING:
    target(s, 0, 1, 0, 152, "Whom do you wish to annoy?");
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   case ANIMALLORE:
    target(s, 0, 1, 0, 153, "What animal do you wish to get information about?");
    chars[currchar[s]].skilldelay=getclock()+(server_data.skilldelay*CLOCKS_PER_SEC);
    return;
   default:
    sysmessage(s, "That skill has not been implemented yet.");
    return;
  }
 else
  sysmessage(s, "You must wait a few moments before using another skill.");
}

void stealingtarget(int s)
{
	int item, serial, pack, skill, npc, x, cont;
	serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
	if (buffer[s][7]<0x40)
	{
		sysmessage(s,"Kidnapping is not allowed!");
		return;
	}
	item=findbyserial(&itemsp[serial%256], serial,0);
	x=item;
	cont=items[item].contserial; //calcserial(items[serial].cont1,items[serial].cont2,items[serial].cont3,items[serial].cont4);
	//x=calcItemFromSer(items[serial].cont1,items[serial].cont2,items[serial].cont3,items[serial].cont4);
//	if ((items[item].layer==0) || (!(items[item].priv&2)) || (cont!=-1)) {
	if ((items[item].layer==0) && (!(items[item].priv&2)) && (cont!=-1)) {
		do {
			x=findbyserial(&itemsp[items[x].contserial%256], items[x].contserial, 0); //calcItemFromSer(items[x].cont1,items[x].cont2,items[x].cont3,items[x].cont4);	
			//printf("Repeat: %i\n",z);
			//z++;
		} while (items[x].cont1>=0x40);
		npc=findbyserial(&charsp[items[x].contserial%256], items[x].contserial, 1); //calcCharFromSer(items[x].cont1,items[x].cont2,items[x].cont3,items[x].cont4);
	} else {
		sysmessage(s,"You cannot steal that.");
		return;
	}

	if (npc==currchar[s]) {
		sysmessage(s,"You catch yourself red handed.");
		return;
	}
	skill=checkskill(currchar[s],STEALING,0,999);
	if (npcinrange(s,npc,1))
	{
		if (skill)
		{
			pack=packitem(currchar[s]);
			removefromptr(&contsp[items[item].contserial%256], item); //remove from old container pointer
			setserial(item, pack, 1);
			sysmessage(s,"You successfully steal that item.");
			all_items(s);
		} else sysmessage(s, "You failed to steal that item.");

		if (((!(skill))&&(rand()%16==7)) || (chars[currchar[s]].skill[STEALING]<rand()%1001))
		{
			sysmessage(s,"You have been cought!");
			
			if (chars[npc].npc) npctalkall(npc, "Guards!! A thief is amoung us!");

			if (region[chars[currchar[s]].region].priv&0x01)
				spawnguard(currchar[s],currchar[s],chars[currchar[s]].x+2,chars[currchar[s]].y,chars[currchar[s]].z);
			
			if (items[serial].name!="#")
			{
				sprintf(temp,"You notice %s trying to steal %s from you!",chars[currchar[s]].name,items[serial].name);
			} else {
				sprintf(temp,"You notice %s trying to steal something from you!",chars[currchar[s]].name);
			}
			sysmessage(calcSocketFromChar(npc),temp);
		}
	} else sysmessage(s, "You are too far away to steal that item.");
}

void tracking(int s,int selection)
{
 chars[currchar[s]].trackingtarget=chars[currchar[s]].trackingtargets[selection]; // sets trackingtarget that was selected in the gump
 chars[currchar[s]].trackingtimer=tracking_data.basetimer+chars[currchar[s]].skill[TRACKING]/25+chars[currchar[s]].in+chars[currchar[s]].dx;
 sprintf(temp,"You are now tracking %s.",chars[chars[currchar[s]].trackingtarget].name);
 sysmessage(s,temp);
 track(currchar[s]);
}

void createtrackingmenu(int s,int m)
{
 unsigned int i;
 int total;
 char lentext;
 char sect[512];
 char gmtext[30][257];
 int gmid[30];
 //int gmnumber;
 int id;
 int d;
 int id1=62; // default tracking animals
 int id2=399;
 int icon=8404; // currently everthing shows as deer :)
 char type[40]="You see no signs of any animals.";
unsigned int MaxTrackingTargets=0;
 unsigned int distance=tracking_data.baserange+chars[currchar[s]].skill[TRACKING]/50;

 if(m==(2+TRACKINGMENUOFFSET))
 {
  id1=1;
  id2=61;
  icon=8425;
  strcpy(type,"You see no signs of any creatures.");
 }
 if(m==(3+TRACKINGMENUOFFSET))
 {
  id1=400;
  id2=402;
  icon=8454;
  strcpy(type,"You see no signs of anyone.");
 }

 openscript("tracking.scp");
 sprintf(sect, "TRACKINGMENU %i", m);
 if(!tracking_script.find(sect)) 
 {
  closescript();
  return;
 }

 read1();
 lentext=sprintf(gmtext[0], "%s", script1);

 for (i=0;i<charcount;i++)
 {
  d=chardist(i,currchar[s]);
  id=chars[i].id1;
  id=id<<8;
  id=id|chars[i].id2;
  if((chardist(i,currchar[s])<=distance)&&(chars[i].dead==0)&&(id>=id1&&id<=id2)&&calcSocketFromChar(i)!=s&&(online(i)||chars[i].npc))
  {     
   chars[currchar[s]].trackingtargets[MaxTrackingTargets]=i;
   MaxTrackingTargets++;
   switch(trackingdirection(s,i))
   {
    case NORTH:
                    sprintf(temp,"to the North");
                    break;
    case NORTHWEST:
                    sprintf(temp,"to the Northwest");
                    break;
    case NORTHEAST:
                    sprintf(temp,"to the Northeast");
                    break;
    case SOUTH:
                    sprintf(temp,"to the South");
                    break;
    case SOUTHWEST:
                    sprintf(temp,"to the Southwest");
                    break;
    case SOUTHEAST:
                    sprintf(temp,"to the Southeast");
                    break;
    case WEST:
                    sprintf(temp,"to the West");
                    break;
    case EAST:
                    sprintf(temp,"to the East");
                    break;
    default:
                    sprintf(temp,"right next to you");
                    break;
   }
                        
   sprintf(gmtext[MaxTrackingTargets], "%s %s",chars[i].name,temp);
// gmid[MaxTrackingTargets]=id;  // hmmm may need to add icon attribute to characters so i get the right image
   gmid[MaxTrackingTargets]=icon; 
  }
  if(MaxTrackingTargets==tracking_data.maxtargets)
  {
   sysmessage(s,"Max # of trackable targets reached.");
   i=charcount+1;
  }
 }

 if(MaxTrackingTargets==0)
 {
  sysmessage(s,type);
  return;
 }

 total=9+1+lentext+1;
 for (i=1;i<=MaxTrackingTargets;i++) total+=4+1+strlen(gmtext[i]);
 gmprefix[1]=total/256;
 gmprefix[2]=total%256;
 gmprefix[3]=chars[currchar[s]].ser1;
 gmprefix[4]=chars[currchar[s]].ser2;
 gmprefix[5]=chars[currchar[s]].ser3;
 gmprefix[6]=chars[currchar[s]].ser4;
 gmprefix[7]=(m+TRACKINGMENUOFFSET)/256;
 gmprefix[8]=(m+TRACKINGMENUOFFSET)%256;
 xsend(s, gmprefix, 9, 0);
 xsend(s, &lentext, 1, 0);
 xsend(s, gmtext[0], lentext, 0);
 xsend(s, &MaxTrackingTargets, 1, 0);
 for (i=1;i<=MaxTrackingTargets;i++)
 {
  gmmiddle[0]=gmid[i]/256;
  gmmiddle[1]=gmid[i]%256;
  xsend(s, gmmiddle, 4, 0);
  lentext=strlen(gmtext[i]);
  xsend(s, &lentext, 1, 0);
  xsend(s, gmtext[i], lentext, 0);
 }
}

void trackingmenu(int s,int gmindex)
{
 int total, i;
 char lentext;
 char sect[512];
 char gmtext[30][257];
 int gmid[30];
 int gmnumber=0;
 openscript("tracking.scp");
 sprintf(sect, "TRACKINGMENU %i",gmindex);
 if (!tracking_script.find(sect)) 
 {
  closescript();
  return;
 }
 read1();
 lentext=sprintf(gmtext[0], "%s", script1);
 do
 {
  read2();
  if (script1[0]!='}')
  {
   gmnumber++;
   gmid[gmnumber]=hstr2num(script1);
   sprintf(gmtext[gmnumber], "%s", script2);
   read1();
  }
 }
 while (script1[0]!='}');
 closescript();
 total=9+1+lentext+1;
 for (i=1;i<=gmnumber;i++) total+=4+1+strlen(gmtext[i]);
 gmprefix[1]=total>>8;
 gmprefix[2]=total%256;
 gmprefix[3]=chars[currchar[s]].ser1;
 gmprefix[4]=chars[currchar[s]].ser2;
 gmprefix[5]=chars[currchar[s]].ser3;
 gmprefix[6]=chars[currchar[s]].ser4;
 gmprefix[7]=(gmindex+TRACKINGMENUOFFSET)/256;
 gmprefix[8]=(gmindex+TRACKINGMENUOFFSET)%256;
 xsend(s, gmprefix, 9, 0);
 xsend(s, &lentext, 1, 0);
 xsend(s, gmtext[0], lentext, 0);
 lentext=gmnumber;
 xsend(s, &lentext, 1, 0);
 for (i=1;i<=gmnumber;i++)
 {
  gmmiddle[0]=gmid[i]>>8;
  gmmiddle[1]=gmid[i]%256;
  xsend(s, gmmiddle, 4, 0);
  lentext=strlen(gmtext[i]);
  xsend(s, &lentext, 1, 0);
  xsend(s, gmtext[i], lentext, 0);
 }
}

void track(int i)
{
 int tl;
 int s=calcSocketFromChar(i);
 int direction=5;
 if((chars[currchar[s]].y-direction)>=chars[chars[currchar[s]].trackingtarget].y)  // North
 {
  sprintf(temp,"%s is to the North",chars[chars[currchar[s]].trackingtarget].name);
  if((chars[currchar[s]].x-direction)>chars[chars[currchar[s]].trackingtarget].x)
   sprintf(temp,"%s is to the Northwest",chars[chars[currchar[s]].trackingtarget].name);
  if((chars[currchar[s]].x+direction)<chars[chars[currchar[s]].trackingtarget].x)
   sprintf(temp,"%s is to the Northeast",chars[chars[currchar[s]].trackingtarget].name);
 }
 else if((chars[currchar[s]].y+direction)<=chars[chars[currchar[s]].trackingtarget].y)  // South
 {
  sprintf(temp,"%s is to the South",chars[chars[currchar[s]].trackingtarget].name);
  if((chars[currchar[s]].x-direction)>chars[chars[currchar[s]].trackingtarget].x)
    sprintf(temp,"%s is to the Southwest",chars[chars[currchar[s]].trackingtarget].name);
  if((chars[currchar[s]].x+direction)<chars[chars[currchar[s]].trackingtarget].x)
    sprintf(temp,"%s is to the Southeast",chars[chars[currchar[s]].trackingtarget].name);
 }
 else if((chars[currchar[s]].x-direction)>=chars[chars[currchar[s]].trackingtarget].x)  // West
 {
  sprintf(temp,"%s is to the West",chars[chars[currchar[s]].trackingtarget].name);
 }
 else if((chars[currchar[s]].x+direction)<=chars[chars[currchar[s]].trackingtarget].x)  // East
 {
  sprintf(temp,"%s is to the East",chars[chars[currchar[s]].trackingtarget].name);
 }
 else sprintf(temp,"%s is right next to you",chars[chars[currchar[s]].trackingtarget].name);

 tl=44+strlen(temp)+1;
 talk[1]=tl/256;
 talk[2]=tl%256;
 talk[3]=chars[currchar[s]].ser1;
 talk[4]=chars[currchar[s]].ser2;
 talk[5]=chars[currchar[s]].ser3;
 talk[6]=chars[currchar[s]].ser4;
 talk[7]=chars[currchar[s]].id1;
 talk[8]=chars[currchar[s]].id2;
 talk[9]=2; // Type
 talk[10]=chars[currchar[s]].emotecolor1;
 talk[11]=chars[currchar[s]].emotecolor2;
 talk[12]=0;
 talk[13]=chars[currchar[s]].fonttype;
 xsend(s, talk, 14, 0);
 xsend(s, chars[currchar[s]].name, 30, 0);
 xsend(s, temp, strlen(temp)+1, 0);
}

int trackingdirection(int s,int i)
{
 int direction=5;
 if((chars[currchar[s]].y-direction)>=chars[i].y)  // North
 {
  if((chars[currchar[s]].x-direction)>chars[i].x)
    return NORTHWEST;
  if((chars[currchar[s]].x+direction)<chars[i].x)
    return NORTHEAST;
  return NORTH;
 }
 else if((chars[currchar[s]].y+direction)<=chars[i].y)  // South
 {
  if((chars[currchar[s]].x-direction)>chars[i].x)
    return SOUTHWEST;
  if((chars[currchar[s]].x+direction)<chars[i].x)
    return SOUTHEAST;
  return SOUTH;
 }
 else if((chars[currchar[s]].x-direction)>=chars[i].x)  // West
   return WEST;
 else if((chars[currchar[s]].x+direction)<=chars[i].x)  // East
   return EAST;
 else return 0;
}

void beggingtarget(int s)
{
  int i,serial;
  addid1[s]=buffer[s][7];
  addid2[s]=buffer[s][8];
  addid3[s]=buffer[s][9];
  addid4[s]=buffer[s][10];
  serial=calcserial(addid1[s],addid2[s],addid3[s],addid4[s]);
  if(calcSocketFromChar(calcCharFromSer(addid1[s], addid2[s], addid3[s], addid4[s]))!=-1)
  {
    sysmessage(s,"Maybe you should just ask.");
    return;
  }
  i=findbyserial(&charsp[serial%256],serial,1);
  if (i!=-1)
  {
    if(chardist(i,currchar[s])>=begging_data.range)
    {
      sysmessage(s,"You are not close enough to beg.");
      return;
    }
    if((chars[i].id1==0x01)&&((chars[i].id2==0x90)||(chars[i].id2==0x91))&&(chars[i].in != 0)) //Used on human
    {
      npctalkall(currchar[s], begging_data.text[rand()%3]); // npcemoteall?
      if (!checkskill(currchar[s],BEGGING, 0, 1000))
          sysmessage(s,"They seem to ignore your begging plees.");
      else
      {
        npctalkall(i,"Ohh thou lookest so poor, Here is some gold I hope this will assist thee."); // zippy
        addgold(s,(10+(rand()%chars[currchar[s]].skill[BEGGING])/10)); 
        sysmessage(s,"Some gold is placed in your pack.");
      }
    }
    else
       sysmessage(s, "That would be foolish.");
  }
}

void animalloretarget(int s)
{
 int i,serial;
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256],serial,1);
  if (i!=-1)
 {
   if(chars[i].priv&0x81)
   {
    sysmessage(s,"Little is known of these robed gods.");
    return;
   }
   if((chars[i].id1==0x01) && ((chars[i].id2==0x90) || (chars[i].id2==0x91))) //Used on human
   {
    sysmessage(s,"The human race should use dvorak!");
    return;
   }
   else // Lore used on a non-human
   {
    if (checkskill(currchar[s], ANIMALLORE, 0, 1000))
    {
     sprintf(temp, "Attack [%i] Defense [%i] Taming [%i] Hit Points [%i]", chars[i].att,chars[i].def,chars[i].taming/10,chars[i].hp);
     npcemote(s,i,temp);
     return;
    }
    else
    {
     sysmessage(s,"You can not think of anything relevant at this time.");
     return;
    }
   }
  }
}

void tellscroll( char *menu_name, int player, long item_param )
{
 inscribe(player,item_param);
 return;
}
 
int inscribe(int s,long snum) 
{
  
 /* this will be the main inscribe/engrave section */
	unsigned x,cir,spl;
 int i,k,part,serial;
 int clickitem=-1;
 
 
 if(snum>0) // if 0 then its the first time
 {
  i=chars[currchar[s]].making; // lets re-grab the item they clicked on
  chars[currchar[s]].making=0;          //clear it out now that we are done with it.
  cir=(int)((snum-800)*.1);
  spl=(((snum-800)-(cir*10))+1);
  k=packitem(currchar[s]);
  for (x=0;x<itemcount;x++)
   if (((items[x].type==9)&&
      (items[x].cont1==items[k].ser1)&&(items[x].cont2==items[k].ser2)&&
      (items[x].cont3==items[k].ser3)&&(items[x].cont4==items[k].ser4))||
      ((items[x].layer==1)&&
      (items[x].cont1==chars[currchar[s]].ser1)&&(items[x].cont2==chars[currchar[s]].ser2)&&
      (items[x].cont3==chars[currchar[s]].ser3)&&(items[x].cont4==chars[currchar[s]].ser4)&&(items[x].type==9)))
   {
       //printf("%d%d%d%d\n",items[x].cont1,items[x].cont2,items[x].cont3,items[x].cont4);
       if (!checkBook( cir, spl-1, x))
       {
          sysmessage(s,"You don't have this spell in your spell book!");
          return 0;
       }
   }
          
  if ((items[i].id1=='\x0E')&&(items[i].id2=='\x34'))  //is it a scroll?
  {
   itemmake[s].minskill=(snum-810);itemmake[s].maxskill=(snum-490); //set range values based on scroll level
   makemenutarget(s,snum,INSCRIPTION); //put it in your pack
  }
  else if ((items[i].att>0)||(items[i].def>0)||(items[i].hidamage)) //or is it an item?
  {
   
   part=0;
        switch(cir)
                 {
                 case 1:
                        part += checkskill(currchar[s], INSCRIPTION, 11, 401);
                        part += checkskill(currchar[s], MAGERY, 11, 401);
                        part += checkskill(currchar[s], TINKERING, 11, 401);
                        break;
                case 2:
                        part += checkskill(currchar[s], INSCRIPTION, 61, 501);
                        part += checkskill(currchar[s], MAGERY, 61, 501);
                        part += checkskill(currchar[s], TINKERING, 61, 501);
                        break;
                case 3:
                        part += checkskill(currchar[s], INSCRIPTION, 161, 601);
                        part += checkskill(currchar[s], MAGERY, 161, 601);
                        part += checkskill(currchar[s], TINKERING, 161, 601);
                        break;
                 case 4:
                    part += checkskill(currchar[s], INSCRIPTION, 261, 701);
                    part += checkskill(currchar[s], MAGERY, 261, 701);
                        part += checkskill(currchar[s], TINKERING, 261, 701);
                         break;
                case 5:
                    part += checkskill(currchar[s], INSCRIPTION, 361, 801);
                        part += checkskill(currchar[s], MAGERY, 361, 801);
                        part += checkskill(currchar[s], TINKERING, 361, 801);
                         break;
                case 6:
                        part += checkskill(currchar[s], INSCRIPTION, 461 , 901);
                        part += checkskill(currchar[s], MAGERY, 461, 901);
                        part += checkskill(currchar[s], TINKERING, 461, 901);
                        break;
                 case 7:
                        part += checkskill(currchar[s], INSCRIPTION, 661, 1101);
                        part += checkskill(currchar[s], MAGERY, 661, 1101);
                        part += checkskill(currchar[s], TINKERING, 661, 1101);
                         break;
                case 8:
                        part += checkskill(currchar[s], INSCRIPTION, 761, 1201);
                        part += checkskill(currchar[s], MAGERY, 761, 1201);
                        part += checkskill(currchar[s], TINKERING, 761, 1201);
                        break;
                }

        switch(part) 
   {
    case 0:
            sysmessage(s,"Your hand jerks and you punch a hole in the item");
            items[i].hp=items[i].hp-3;
            if(items[i].hp<1) items[i].hp=1;
            break;
    case 1:
            sysmessage(s,"Your hand slips and you dent the item");
            items[i].hp=items[i].hp-2;
            if(items[i].hp<1) items[i].hp=1;
            break;
    case 2:
            sysmessage(s,"Your hand cramps and you scratch the item");
            items[i].hp--;
            if(items[i].hp<1) items[i].hp=1;
            break;
    case 3:
            if (!( items[i].morez == 0 ||(items[i].morex == cir && items[i].morey == spl))  )
            {
               sysmessage(s,"This item have already a spell!");
            }
            else
            if ( items[i].morex == 1 && items[i].morez == 16 )
            {
              sysmessage(s,"Item at max charges!");
            }
            else
            if ( items[i].morex == 2  && items[i].morez == 14 )
            {
              sysmessage(s,"Item at max charges!");
            }
            else
            if ( items[i].morex == 3 && items[i].morez == 12 )
            {
              sysmessage(s,"Item at max charges!");
            }
            else
            if ( items[i].morex == 4 && items[i].morez == 10 )
            {
               sysmessage(s,"Item at max charges!");
            }
            else
            if ( items[i].morex == 5 && items[i].morez == 8 )
            {
              sysmessage(s,"Item at max charges!");
            }
            else
            if ( items[i].morex == 6 && items[i].morez == 6 )
            {
               sysmessage(s,"Item at max charges!");
            }
            else
            if ( items[i].morex == 7 && items[i].morez == 4 )
            {
               sysmessage(s,"Item at max charges!");
            }
            else
            if ( items[i].morex == 8 && items[i].morez == 2 )
            {
              sysmessage(s,"Item at max charges!");
            }
            else
            if (items[i].morex == cir && items[i].morey == spl  ) 
            {
              if(engraveaction(s, i, cir, spl ))
              {
                items[i].morez++;
                sysmessage(s,"Item successfully Engraved");
              }
              else sysmessage(s,"You fail to engrave the spell!");
            }
            else
            if (engraveaction(s, i, cir, spl))
            {
              items[i].type2=items[i].type; //kept type of item for returning to this type when item remain no charge 
              items[i].type=15;  //make it magical
              items[i].morex=cir;//spell circle
              items[i].morey=spl;//spell number
              items[i].morez++;  // charges
              sysmessage(s,"Item successfully Engraved");
            }
            else sysmessage(s,"You fail to engrave the spell!");
            break;
   }
  }
  return(0);
 }

  // - Find what they clicked on
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   clickitem=i;
  }
 
 if (clickitem==-1) 
 {
  sysmessage(s,"You could not possibly engrave on that!");
  chars[currchar[s]].making=0;
  return(0);
 }

 chars[currchar[s]].making=clickitem;  //we gotta remember what they clicked on!
 if (((items[clickitem].id1=='\x0E')&&(items[clickitem].id2=='\x34'))||  //its a scroll
     ((items[clickitem].att>0)||(items[clickitem].def>0)||(items[i].hidamage>0)))               // its something else
 {
  /* select spell gump menu system here, must return control to UOX so we dont
     freeze the game. when returning to this routine, use snum to determine where to go
     and snum is also the value of what they selected. */

  im_sendmenu( "InscribeMenu", s );  //this is in im.cpp file using inscribe.gmp
  return(0);
 }
return(0);
}

int engraveaction(int s, int i, int cir, int spl)
{
 int ash=0, drake=0, garlic=0, ginsing=0, moss=0, pearl=0, shade=0, silk=0, mana=0;
 char mantra[25];
 char sect[512];
 int action=0;
 int num=(8*(cir-1))+spl;
 
 openscript("spells.scp");
 sprintf(sect, "SPELL %d", num);
 if (!spells_script.find(sect)) 
 {
  closescript();
  return 0;
 }
 do
 {
  read2();
  if (script1[0]!='}')
  {
   if (!(strcmp("MANA",script1)))
   {
      mana=str2num(script2);
   }
   if (!(strcmp("MANTRA",script1)))
   {
      strcpy(mantra, script2);
   }
   if (!(strcmp("ACTION",script1)))
   {
      action=hstr2num(script2);
   }
   if (!(strcmp("ASH", script1)))
   { 
      ash=str2num(script2);
   }
   if (!(strcmp("DRAKE", script1)))
   {
      drake=str2num(script2);
   }
   if (!(strcmp("GARLIC", script1)))
   {
      garlic=str2num(script2);
   }
   if (!(strcmp("GINSING",script1)))
   {
      ginsing=str2num(script2);
   }
   if (!(strcmp("MOSS", script1)))
   {
      moss=str2num(script2);
   }
   if (!(strcmp("PEARL",script1)))
   {
      pearl=str2num(script2);
   }
   if (!(strcmp("SHADE",script1)))
   {
      shade=str2num(script2);
   }
   if (!(strcmp("SILK",script1)))
   {
      silk=str2num(script2);
   }
  }
 }
 while (script1[0]!='}');
 closescript();

	if (action) impaction(s, action); // Should have a default action instead
  npctalkall(currchar[s],mantra);

  if(!checkreagents(currchar[s], ash, drake, garlic, ginsing, moss, pearl, shade, silk))
    if (!checkmana(currchar[s], mana)) 
    {
      spellfail(s);
      return 0;
    }

  delereagents(currchar[s], ash, drake, garlic, ginsing, moss, pearl, shade, silk);
  subtractmana(currchar[s], mana);

  switch(cir)
  {
    case 1:
      {
        switch(spl)
        {
          case 1: // Clumsy
            {
              char source[]=" of Clumsy with";
              strcpy(items[i].name2, source);
              items[i].offspell=1;
              break;      
            }
          case 2: // Create Food
            { 
              char source[]=" of Create Food with";
              strcpy(items[i].name2, source); 
              break;   
            }
          case 3: // Feeblemind
            {
              char source[]=" of Feeblemind with";
              strcpy(items[i].name2, source); 
              items[i].offspell=2;
              break;     
            }
          case 4: // Heal
            {
              char source[]=" of Heal with";
              strcpy(items[i].name2, source); 
              break;
            }
          case 5: // Magic Arrow
            {
              char source[]=" of Magic Arrow with";
              strcpy(items[i].name2, source); 
              items[i].offspell=3;
              break;
            }       
          case 6: // Night Sight
            {
              char source[]=" of Night Sight with";
              strcpy(items[i].name2, source); 
              break;
            }
          case 7: // Reactive Armor
            {
              sysmessage(s, "Sorry this spell is not implemented!");
              return 0;
            }
          case 8: // Weaken
            {
              char source[]=" of Weaken with";
              strcpy(items[i].name2, source); 
              items[i].offspell=4;
              break;
            }
        }
        break;
      }
    case 2:
      {
        switch(spl)
        {
          case 1: // Agility
            {
              char source[]=" of Agility with";
              strcpy(items[i].name2, source); 
              break;
            } 
          case 2:// Cunning
            {
              char source[]=" of Cunning with";
              strcpy(items[i].name2, source); 
              break;
            }   
          case 3:// Cure
            {
              sysmessage(s, "Sorry this spell is not implemented!");
              return 0;
            }
          case 4:// Harm
            {
              char source[]=" of Harm with";
              strcpy(items[i].name2, source); 
              items[i].offspell=5;
              break;
            }    
          case 5:// Magic Trap
            {
              sysmessage(s, "Sorry this spell is not implemented!");
              return 0;
            }
          case 6:// Magic Untrap
            {
              sysmessage(s, "Sorry this spell is not implemented!");
              return 0;
            }
          case 7:// Protection
            {
              sysmessage(s, "Sorry this spell is not implemented!");
              return 0;
            }
          case 8:// Strength
            {
              char source[]=" of Strength with";
              strcpy(items[i].name2, source); 
              break;
            }
        }
        break;
      }
    case 3:
    {
      switch (spl)
      {
      case 1:// Bless
  {
    char source[]=" of Bless with";
    strcpy(items[i].name2, source); 
    break;
  }    
      case 2:// Fireball
  {
    char source[]=" of Daemon's Breath with";
    strcpy(items[i].name2, source); 
     items[i].offspell=6;
    break;
  }      
      case 3: //Magic lock
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      case 4: //Poison
  {
    char source[]=" of Poison with";
    strcpy(items[i].name2, source);
  }
      case 5: //Telekinesis
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      case 6:// Teleport
  {
    char source[]=" of Teleport with";
    strcpy(items[i].name2, source); 
    break;
  }      
      case 7:// Unlock
  {
    char source[]=" of Unlock with";
    strcpy(items[i].name2, source); 
    break;
  }     
      case 8:// Wall of Stone
  {
    char source[]=" of Wall of Stone with";
    strcpy(items[i].name2, source); 
    break;
  }       
      }
      break;
    }
    case 4:
    {
      switch (spl)
      {       
      case 1:// Arch Cure
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      case 2:// Arch Protection
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      case 3:// Curse
  {
    char source[]=" of Evil's Eye with";
    strcpy(items[i].name2, source); 
     items[i].offspell=8;
    break;
  }       
      case 4:// Fire Field
  {
    char source[]=" of Fire Field with";
    strcpy(items[i].name2, source); 
    break;
  }       
      case 5:// Greater Heal
  {
    char source[]=" of Greater Heal with";
    strcpy(items[i].name2, source); 
    break;
  } 
      case 6:// Lightning
  {
    char source[]=" of Lightning with";
    strcpy(items[i].name2, source); 
     items[i].offspell=9;
    break;
  } 
      case 7://Mana Drain
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      case 8:// Recall
  {
    char source[]=" of Recall with";
    strcpy(items[i].name2, source); 
    break;
  }
      }
    break;
    }       
    case 5:
    {
      switch(spl)
      {
      case 1://Blade Spirit
  {
    char source[]=" of Blade Spirit with";
    strcpy(items[i].name2, source); 
    break;
  } 
      case 2://Dispel Field
  {
    char source[]=" of Dispel Field with";
    strcpy(items[i].name2, source); 
    break;
  } 
      case 3://Incognito
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      case 4://Magic Reflection
  {
    char source[]=" of Magic Reflection with";
    strcpy(items[i].name2, source); 
    break;
  } 
      case 5://Mind Blast
  {
    char source[]=" of Mind Blast with";
    strcpy(items[i].name2, source); 
     items[i].offspell=11;
    break;
  } 
      case 6://Paralyse
  {
    char source[]=" of Ghoul's Touch with";
    strcpy(items[i].name2, source); 
     items[i].offspell=12;
    break;
  } 
      case 7://Poison Field
  {
    char source[]=" of Poison Field with";
    strcpy(items[i].name2, source); 
    break;
  } 
      case 8://Summon Creature
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      }
    break;
    }
    case 6:
    {
      switch(spl)
      {
      case 1://Dispel
  {       
    char source[]=" of Dispel with";
    strcpy(items[i].name2, source); 
    break;
  } 
      case 2://Energy Bolt
  {       
    char source[]=" of Energy Bolt with";
    strcpy(items[i].name2, source); 
    items[i].offspell=13;
    break;  
  }      
      case 3://Explosion
  {       
    char source[]=" of Explosion with";
    strcpy(items[i].name2, source); 
     items[i].offspell=14;
    break;
  }      
      case 4://Invisibility
  {       
    char source[]=" of Invisibility with";
    strcpy(items[i].name2, source); 
    break;
  }    
      case 5://Mark
  {       
    char source[]=" of Mark with";
    strcpy(items[i].name2, source); 
    break;
  }      
      case 6://Mass Curse
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      case 7:// Paralyze Field
  {       
    char source[]=" of Paralyse Field with";
    strcpy(items[i].name2, source); 
    break;
  }    
      case 8://Reveal
  {       
    char source[]=" of Reveal with";
    strcpy(items[i].name2, source); 
    break;
  }
      }
    break ;
    }
    case 7:
    {
      switch(spl)
      {
      case 1://Chain Lightning
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      case 2://Energy Field
  {       
    char source[]=" of Energy Field with";
    strcpy(items[i].name2, source); 
    break;
  }       
      case 3://FlameStrike
  {       
    char source[]=" of Flamestrike with";
    strcpy(items[i].name2, source); 
     items[i].offspell=15;
    break;
  }       
      case 4://Gate Travel
  {       
    char source[]=" of Gate Travel with";
    strcpy(items[i].name2, source); 
    break;
  }    
      case 5:// Mana Vampire
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      case 6:// Mass Dispel
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      case 7:// Meteor Storm
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      case 8:// Polymorph
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      }
    break ;
    }
    case 8:
    {
      switch(spl)
      {
      case 1:// Earthquake
  {
    sysmessage(s, "Sorry this spell is not implemented!");
    return 0;
  }
      case 2://Energy Vortex
  {       
    char source[]=" of Energy Vortex with";
    strcpy(items[i].name2, source); 
    break;
  }    
      case 3://Resurrection
  {       
    char source[]=" of Resurrection with";
    strcpy(items[i].name2, source); 
    break;
  }    
      case 4:// Summon Air Elemental
  {       
    char source[]=" of Summon Air Elemental with";
    strcpy(items[i].name2, source); 
    break;
  }
    
      case 5://Summon Daemon
  {       
    char source[]=" of Summon Daemon with";
    strcpy(items[i].name2, source); 
    break;
  }    
      case 6:// Summon Earth Elemental
  {       
    char source[]=" of Summon earth Elemental with";
    strcpy(items[i].name2, source); 
    break;
  }    
      case 7:// Summon Fire Elemental
  {       
    char source[]=" of Summon Fire Elemental with";
    strcpy(items[i].name2, source); 
    break;
  }
      case 8:// Summon Water Elemental
  {       
    char source[]=" of Summon Water Elemental with";
    strcpy(items[i].name2, source); 
    break;
  }
      }
    break;
    }
  }
  return 1;
}

// Calculate the skill of this character based on the characters baseskill and stats
void updateSkillLevel(int c, int s)
{
  int temp = (((skill[s].st * chars[c].st) / 100 +
               (skill[s].dx * chars[c].dx) / 100 +
               (skill[s].in * chars[c].in) / 100)
                *(1000-chars[c].baseskill[s]))/1000+chars[c].baseskill[s];

  chars[c].skill[s] = max(chars[c].baseskill[s], temp);
}

void lockpick(int s)
{
  int i, success,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256],serial,0);

  if(items[i].type==1 || items[i].type==12 || items[i].type==63) 
  {
    sysmessage(s, "That is not locked.");
    return;
  }

  if(items[i].type==8 || items[i].type==13 || items[i].type==64)
  {
    if(items[i].more1==0 && items[i].more2==0 && items[i].more3==0 && items[i].more4==0)
    { //Make sure it isn't an item that has a key (i.e. player house, chest..etc)
      if(addmitem[s]==-1) 
      {
        if (currentSpellType[s] !=2)              // not a wand cast
        {
          success=subtractmana(currchar[s], 5);  // subtract mana on scroll or spell
          if (currentSpellType[s] == 0)             // del regs on normal spell
              delereagents(currchar[s], 1, 0, 0, 0, 1, 0, 0, 0);
        }
        switch(items[i].type)
        {
          case 8: items[i].type=1; break;
          case 13: items[i].type=12; break;
          case 64: items[i].type=63; break;
        }
        soundeffect3(i, 0x01, 0xFF);
        sysmessage(s, "You manage to pick the lock.");
      } else
      if(checkskill(currchar[s], LOCKPICKING, 0, 1000))
      {
        switch(items[i].type)
        {
          case 8: items[i].type=1; break;
          case 13: items[i].type=12; break;
          case 64: items[i].type=63; break;
        }
        soundeffect3(i, 0x01, 0xFF);
        sysmessage(s, "You manage to pick the lock.");
      } else
      {
        if((rand()%100)>50) 
        {
          sysmessage(s, "You broke your lockpick!");
          deleitem(addmitem[s]);
        } else
        {
          sysmessage(s, "You fail to open the lock.");
        }
      }
    } else
    {
      sysmessage(s, "That cannot be unlocked without a key.");
    }
  }
}

void tdummy(int s)
{
	unsigned int i;
    int j,serial,hit;
    int type=getbowtype(currchar[s]);
    
    if (type > 0)
       {
           sysmessage(s, "Practice archery on archery buttes !");
           return;
       }    
    int skillused = getcombatskill(currchar[s]);
    
    if (chars[currchar[s]].onhorse)
        combatonhorse(currchar[s]);
    else
        combatonfoot(currchar[s]);
        
    hit=rand()%3;
    switch(hit)
         {
             case 0: soundeffect(s, 0x01, 0x3B);
                      break;
             case 1: soundeffect(s, 0x01, 0x3C);
                      break;        
             case 2: soundeffect(s, 0x01, 0x3D);
                      break;
         }            
    serial=calcserial((buffer[s][1]&0x7F),buffer[s][2],buffer[s][3],buffer[s][4]);
    j=findbyserial(&itemsp[serial%256], serial, 0);
    if (j!=-1)
    {
      if (items[j].id2==0x70) items[j].id2=0x71;
      if (items[j].id2==0x74) items[j].id2=0x75;
      tempeffect2(0, j, 14, 0, 0, 0);
      for (i=0;i<now;i++) if (perm[i]) senditem(i,j);
     }
     if(chars[currchar[s]].skill[skillused] < 300)
     {
       checkskill(currchar[s],skillused, 0, 1000);
       if(chars[currchar[s]].skill[TACTICS] < 300)
       checkskill(currchar[s],TACTICS, 0, 250);  //Dupois - Increase tactics but only by a fraction of the normal rate
     }
     else
        sysmessage(s, "You feel you would gain no more from using that.");   
}                           
                                                            
                                                                
void newdummy(unsigned int currenttime)
{
 unsigned int i,j;
 for (i=0;i<itemcount;i++)
 {
  if(((items[i].id1==0x10) && (items[i].id2==0x71)) && (items[i].gatetime<=currenttime)) 
  {
     items[i].id2=0x70;
     items[i].gatetime=0;
     for (j=0;j<now;j++) if (perm[j]) senditem(j,i);    
  } else
  if(((items[i].id1==0x10) && (items[i].id2==0x75)) && (items[i].gatetime<=currenttime)) 
  {
     items[i].id2=0x74;
     items[i].gatetime=0;
     for (j=0;j<now;j++) if (perm[j]) senditem(j,i); 
  } 
 }
}    

/*void buttetarget(int s)   // Is this even used anymore??
{
int j, k;
int n=0;
int type=0;
int arrows=0; 
type=getbowtype(currchar[s]);

if (type==1)
arrows=getamount(currchar[s], 0x0F, 0x3F);
else if (type>1) 
arrows=getamount(currchar[s], 0x1B, 0xFB);
if (arrows>0) 
n=1;
if(n)
{
if (type==1)
{
for (j=0;j<itemcount;j++)
{
if (((buffer[s][1]&0x7F)==items[j].ser1)
&& (buffer[s][2]==items[j].ser2)
&& (buffer[s][3]==items[j].ser3)
&& (buffer[s][4]==items[j].ser4))
items[j].morex=items[j].morex+1;
}
delequan(currchar[s], 0x0F, 0x3F, 1);
action(s, 0x12);
movingeffect(s, j, 0x0F, 0x42, 0x08, 0x00, 0x00);
soundeffect(s, 0x2, 0x34);
if(chars[currchar[s]].skill[ARCHERY] > 300)
{
sysmessage(s, "You feel you would gain no more from using that.");
sysmessage(s, "Bullseye !"); return;
} else
if(checkskill(currchar[s],ARCHERY, 0, 1000))
sysmessage(s, "Bullseye !");
else
sysmessage(s, "You hit the outer ring."); 
}
else
{
for (j=0;j<itemcount;j++)
{
if (((buffer[s][1]&0x7F)==items[j].ser1)
&& (buffer[s][2]==items[j].ser2)
&& (buffer[s][3]==items[j].ser3)
&& (buffer[s][4]==items[j].ser4))
items[j].morey=items[j].morey+1;
}
delequan(currchar[s], 0x1B, 0xFB, 1);
action(s, 0x13);
movingeffect(s, j, 0x1B, 0xFE, 0x08, 0x00, 0x00);
soundeffect(s, 0x2, 0x34);
if(chars[currchar[s]].skill[ARCHERY] > 300)
{
sysmessage(s, "You feel you would gain no more from using that.");
sysmessage(s, "Bullseye !"); return;
} else 
if(checkskill(currchar[s],ARCHERY, 0, 1000))
sysmessage(s, "Bullseye !");
else
sysmessage(s, "You hit the outer ring.");
}
} else 
if(!type) sysmessage(s, "You need to have a bow equiped to use that."); 
} */

void collectammo(int s, int a, int b)
{
  int c; 

  if (a)
  {
    c=SpawnItem(s,a,"#",1,0x0F,0x3F,0,0,1,1);
    items[c].att=0;
    sysmessage(s,"You collect the arrows.");
  }

  if (b)
  {
    c=SpawnItem(s,b,"#",1,0x1B,0xFB,0,0,1,1);
    items[c].att=0;
    sysmessage(s,"You collect the bolts.");
  }
}

void tinkering(int s)
{
  int i, packnum, amt, serial;

  packnum=packitem(currchar[s]);

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
    {
      if(((items[i].id1==0x1B)&&((items[i].id2==0xEF)||(items[i].id2==0xF2)))||
         ((items[i].id1==0x1B)&&((items[i].id2==0xDD)||(items[i].id2==0xE0))))
      {
        if (items[i].contserial!=items[packnum].serial)
        {
          sysmessage(s,"You can't use material outside your backpack");
        }           
        else
        {
          itemmake[s].has=amt=getamount(currchar[s], items[i].id1, items[i].id2);    
          if(amt<2)
          { 
            sysmessage(s,"You don't have enough ingots to make anything.");
            return;
          }
          itemmake[s].materialid1=items[i].id1;
          itemmake[s].materialid2=items[i].id2; 
          if ((items[i].id1==0x1B)&&(items[i].id2==0xDD)||(items[i].id2==0xE0))
          {
            if (amt<4)
            {
              sysmessage(s,"You don't have enough log's to make anything.");
              return;
            } 
            else makemenu(s,70,TINKERING);
          }
          else makemenu(s,80,TINKERING);
        }
        return;
      }
    }     
  sysmessage(s,"You cannot use that material for tinkering.");
}

void AButte(int s1, int x)
{
int v1,p,i,c;
int arrowsquant=0;
int type=getbowtype(currchar[s1]);

if(items[x].id2==0x0a)
 { // East Facing Butte
 if ((items[x].x>chars[currchar[s1]].x)||(items[x].y!=chars[currchar[s1]].y))
    v1=-1;
 else v1=chars[currchar[s1]].x-items[x].x;
 }
else
 { // South Facing Butte
 if ((items[x].y>chars[currchar[s1]].y)||(items[x].x!=chars[currchar[s1]].x))
    v1=-1;
 else v1=chars[currchar[s1]].y-items[x].y;
 }

  if(v1==1)
  {
    p=packitem(currchar[s1]);
    if(items[x].more1>0)
    {
      c=SpawnItem(s1,items[x].more1,"#",1,0x0F,0x3F,0,0,1,0);
      sendbpitem(s1,c); // Send Item to Client (i.e. Characters Pack)
    }

    if(items[x].more2>0)
    {
      c=SpawnItem(s1,items[x].more2,"#",1,0x1B,0xFB,0,0,1,0);
      sendbpitem(s1,c); // Send Item to Client (i.e. Characters Pack)
    }

 i=0;
 if(items[x].more1>0) i++;
 if(items[x].more2>0) i+=2;

 switch(i)
  {
  case 0:
        sprintf(temp,"This target is empty");
        break;
  case 1:
        sprintf(temp,"You pull %d arrows from the target",items[x].more1);
        break;
  case 2:
        sprintf(temp,"You pull %d bolts from the target",items[x].more2);
        break;
  case 3:
        sprintf(temp,"You pull %d arrows and %d bolts from the target",items[x].more1,items[x].more2);
        break;
  }
 sysmessage(s1,temp);
 items[x].more1=0;
 items[x].more2=0;
 }

if((v1>=5)&&(v1<=8))
 {
 if (type == 0)
  {
  sysmessage(s1, "You need to equip a bow to use this.");
  return;
  } 
 if ((items[x].more1+items[x].more2)>99)
  {
  sysmessage(s1, "You should empty the butte first!");
  return;
  }
 if (type==1) arrowsquant=getamount(currchar[s1], 0x0F, 0x3F);
 else arrowsquant=getamount(currchar[s1], 0x1B, 0xFB);
 if (arrowsquant==0) 
  {
  sysmessage(s1, "You have nothing to fire!");
  return;
  }
 if (type==1) 
  {
  delequan(currchar[s1], 0x0F, 0x3F, 1);
  items[x].more1++;
  //add moving effect here to item, not character
  }
 else
  {
  delequan(currchar[s1], 0x1B, 0xFB, 1);
  items[x].more2++;
  //add moving effect here to item, not character
  } 
 if (chars[currchar[s1]].onhorse) combatonhorse(currchar[s1]);
 else combatonfoot(currchar[s1]);

 if (chars[currchar[s1]].skill[ARCHERY] < 350)
    checkskill(currchar[s1],ARCHERY, 0, 1000);
 else
    sysmessage(s1, "You learn nothing from practicing here");

 switch((chars[currchar[s1]].skill[ARCHERY]+((rand()%200)-100))/100)
  {
  case -1:
  case 0:
  case 1:
        sysmessage(s1, "You miss the target");
        soundeffect(s1, 0x02, 0x38);
        break;
  case 2:
  case 3:
        sysmessage(s1, "You hit the outer ring!");
        soundeffect(s1, 0x02, 0x34);
        break;
  case 4:
  case 5:
  case 6:
        sysmessage(s1, "You hit the middle ring!");
        soundeffect(s1, 0x02, 0x34);
        break;
  case 7:
  case 8:
  case 9:
        sysmessage(s1, "You hit the inner ring!");
        soundeffect(s1, 0x02, 0x34);
        break;
  case 10:
  case 11:
        sysmessage(s1, "You hit the bullseye!!");
        soundeffect(s1, 0x02, 0x34);
        break;
  default:
         break;
  }
 }
if(v1!=6&&v1!=1) sysmessage(s1, "You cant use that from here.");
}

void tinkeraxel(int s)
{
 int i,c,serial;

 int tailme=0;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   if((items[i].id1==0x10)&&(items[i].id2==0x53)||(items[i].id2==0x54)||
      (items[i].id1==0x10)&&(items[i].id2==0x5B)||(items[i].id2==0x5C))
   {
    if(iteminrange(s,i,3))  
    {
     if (!checkskill(currchar[s],TINKERING, 0, 1000)) 
     {
      sysmessage(s,"You failed to combine the parts.");
     }
     else
     {
      sysmessage(s,"You combined the parts");

      c=SpawnItem(s,1,"an axle with gears",0,0x10,0x51,0,0,1,1);
     }
     if(items[i].amount==1)
     {
      deleitem(i);
     }
     tailme=1;
    }
   }     
  } 
 chars[currchar[s]].tailitem=-1;        
 if(!tailme) sysmessage(s,"You can't combine these.");
}

void tinkerawg(int s)
{
  int i,c,packnum,serial;
  char id2;

  packnum=packitem(currchar[s]);

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
    {
      if (((items[i].id1==0x10) && (items[i].id2==0x51 || items[i].id2==0x52)) &&
          ((itemmake[s].materialid1==0x10) && (itemmake[s].materialid2==0x5D || itemmake[s].materialid2==0x5E)) ||
          ((items[i].id1==0x10) && (items[i].id2==0x5D || items[i].id2==0x5E)) &&
          ((itemmake[s].materialid1==0x10) && (itemmake[s].materialid2==0x51 || itemmake[s].materialid2==0x52)))
            id2=0x4F;
      else if (((items[i].id1==0x10) && (items[i].id2==0x51 || items[i].id2==0x52)) &&
               ((itemmake[s].materialid1==0x10) && (itemmake[s].materialid2==0x55 || itemmake[s].materialid2==0x56)) ||
               ((items[i].id1==0x10) && (items[i].id2==0x55 || items[i].id2==0x56)) &&
               ((itemmake[s].materialid1==0x10) && (itemmake[s].materialid2==0x51 || itemmake[s].materialid2==0x52)))
                 id2=0x59;
      else
      {
         sysmessage(s,"You can't combine these.");
         return;
      }
      if (items[i].contserial!=items[packnum].serial)
      {
        sysmessage(s,"You can't combine items outside your backpack");
        return;
      }
      else if (!checkskill(currchar[s],TINKERING, 0, 1000))
      {
        sysmessage(s,"Your fingers slip and you break one of the parts.");
        delequan(currchar[s], items[i].id1, items[i].id2, 1);
        return;
      }
      else
      {
        if (id2==0x4F) sprintf(temp,"clock parts");
        if (id2==0x59) sprintf(temp,"sextant parts");
        c=SpawnItem(s,1,temp,0,0x10,id2,0,0,1,1);
        sysmessage(s,"You combined the parts");
      }
      delequan(currchar[s], itemmake[s].materialid1, itemmake[s].materialid2, 1);
      delequan(currchar[s], items[i].id1, items[i].id2, 1);
    }
}

void tinkerclock(int s)
{
 int i,c,serial;
     
 int tailme=0;
     
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   if((items[i].id1==0x10)&&(items[i].id2==0x4D)||(items[i].id2==0x4E)||
          (items[i].id1==0x10)&&(items[i].id2==0x4F)||(items[i].id2==0x50))
   {
    if(iteminrange(s,i,3))  
    {
     if (!checkskill(currchar[s],TINKERING, 0, 1000)) 
     {
      sysmessage(s,"You failed to combine the parts.");
     }
         else
    {
     sysmessage(s,"You combined the parts");

     c=SpawnItem(s,1,"clock",0,0x10,0x4B,0,0,1,1);
    }
    if(items[i].amount==1)
    {
     deleitem(i);
    }
     tailme=1;
   }
  } 
 }   
 chars[currchar[s]].tailitem=-1;        
 if(!tailme) sysmessage(s,"You can't combine these.");
}
