
// One entry in the cache
struct ScriptEntry {
    char *name;
    unsigned long offset;
    
    ScriptEntry(const char *_name, unsigned long _offset) : name(strdup(_name)), offset(_offset) {}
    ~ScriptEntry() { free(name); }
};

struct Script {
public:
    Script(const char *_filename);
    char find(const char *section);
    char isin(const char *section);
    ~Script() { delete entries; }
        
    
private:
    void reload();
    
    List<ScriptEntry, 1> *entries;
    time_t last_modification;
    char *filename;
};
