// - Tauriel experimental pointer array *crap*
//
// -- pointer.cpp  Item specific routines (add, delete change) in preperation for
//               going to a pointer based system
//
#include "uox3.h"
#include "debug.h"

#define DBGFILE "pointer.cpp"

//
// - Sets an item into the array, reallocating space if needed
//   Usage: setptr(&itemsp[serial%256], item#);
//          setptr(&charsp[serial%256], char#);
//   NOTE: can be used to set other pointer arrays too (like regions)
void setptr(lookuptr_st *ptr, int item) //set item in pointer array
{
  int i;
  for (i=0;i<(ptr->max);i++)
  {
    if (ptr->pointer[i]==-1)
    {
      ptr->pointer[i]=item;
      return;
    }
  }
  // Must be out of slots, so reallocate some and set item
  if ((ptr->pointer=(int *)realloc(ptr->pointer, (ptr->max + 25)*sizeof(int)))==NULL)
  {
    printf("Error reallocating memory\n");
    error=1;
    keeprun=0;  //shutdown
    return;
  }

  for (i=ptr->max;i<(ptr->max+25);i++) ptr->pointer[i]=-1;
  ptr->pointer[ptr->max]=item;
  ptr->max+=25;
  return;
}

// - Find a specific item/char by serial number.
//   Usage: item=findbyserial(&itemsp[serial%256], serial, 0);
//          char=findbyserial(&charsp[serial%256], serial, 1);
//          if (item==-1) printf("Couldn't find by serial: %d\n", serial);
int findbyserial(lookuptr_st *ptr, int nSerial, int nType)
{ 
  if (nSerial<0) return-1;  //prevent errors from some clients being slower than the server clicking on nolonger valid items

	int cnt=0;
  for (int i=0;i<(ptr->max);i++)
  { 
    cnt++;
    if ((nType==0) && (ptr->pointer[i]!= -1) && 
        (items[ptr->pointer[i]].serial==nSerial))
    {
      //printf("Found item %d out of %d in %d hits.\n",ptr->pointer[i],itemcount,cnt);
      return ptr->pointer[i];
    }
    if ((nType==1) && (ptr->pointer[i]!= -1) && 
        (chars[ptr->pointer[i]].serial==nSerial))
    {
     // printf("Found char %d out of %d in %d hits.\n",ptr->pointer[i],charcount,cnt);
      return ptr->pointer[i];
    }
  }
  return -1;
}

// - Remove an item/char from a pointer array
//   (Ok, just mark it as a free slot ;P )
//   Usage: if (!removefromptr(&itemsp[serial%256], item))
//            printf "Error removing item/char %d from pointer array\n",item);
int removefromptr(lookuptr_st *ptr, int nItem)
{
  int i;
  for (i=0;i<(ptr->max);i++)
  {
    if (ptr->pointer[i]==nItem)
    {
      /*if (nType==0 && items[nItem].serial==serial) ok=1;
      else if (nType==1 && chars[nItem].serial==serial) ok=1;
      if (ok)
      {*/
      ptr->pointer[i]=-1;
      return 1;
    }
  }
  return 0;
}

void setserial(int nChild, int nParent, int nType)
{ // Sets the serial #'s and adds to pointer arrays
  // types: 1-item container, 2-item spawn, 3-Item's owner 4-container is PC/NPC
  //        5-NPC's owner, 6-NPC spawned
  if (nType==1)  //Set the item's container
  {
    items[nChild].cont1=items[nParent].ser1;
    items[nChild].cont2=items[nParent].ser2;
    items[nChild].cont3=items[nParent].ser3;
    items[nChild].cont4=items[nParent].ser4;
    items[nChild].contserial=items[nParent].serial;
    setptr(&contsp[items[nChild].contserial%256], nChild);
  }
  else if (nType==2)  //Set the item's spawner
  {
    items[nChild].spawn1=items[nParent].ser1;
    items[nChild].spawn2=items[nParent].ser2;
    items[nChild].spawn3=items[nParent].ser3;
    items[nChild].spawn4=items[nParent].ser4;
    items[nChild].spawnserial=items[nParent].serial;
    setptr(&spawnsp[items[nChild].spawnserial%256], nChild);
  }
  else if (nType==3)  //Set the item's owner
  {
    items[nChild].owner1=chars[nParent].ser1;
    items[nChild].owner2=chars[nParent].ser2;
    items[nChild].owner3=chars[nParent].ser3;
    items[nChild].owner4=chars[nParent].ser4;
    items[nChild].ownserial=chars[nParent].serial;
    setptr(&ownsp[items[nChild].ownserial%256], nChild);
  }
  else if (nType==4)  //Set the Container to a character
  {
    items[nChild].cont1=chars[nParent].ser1;
    items[nChild].cont2=chars[nParent].ser2;
    items[nChild].cont3=chars[nParent].ser3;
    items[nChild].cont4=chars[nParent].ser4;
    items[nChild].contserial=chars[nParent].serial;
    setptr(&contsp[items[nChild].contserial%256], nChild);
  }
  else if (nType==5)  //Set the character's owner
  {
    chars[nChild].own1=chars[nParent].ser1;
    chars[nChild].own2=chars[nParent].ser2;
    chars[nChild].own3=chars[nParent].ser3;
    chars[nChild].own4=chars[nParent].ser4;
    chars[nChild].ownserial=chars[nParent].serial;
    setptr(&cownsp[chars[nChild].ownserial%256], nChild);
  }
  else if (nType==6)  // Set the character's spawner
  {
    chars[nChild].spawn1=items[nParent].ser1;
    chars[nChild].spawn2=items[nParent].ser2;
    chars[nChild].spawn3=items[nParent].ser3;
    chars[nChild].spawn4=items[nParent].ser4;
    chars[nChild].spawnserial=items[nParent].serial;
    setptr(&cspawnsp[chars[nChild].spawnserial%256], nChild);
  }
}
