/*  
 *   UOX3 Magic stuff
 */

#include "uox3.h"
#include "debug.h"

#define DBGFILE "magic.cpp"

void spellbook(int s)
{
 int i, j, scount, item, x,serial,serhash,ci;
 int spells[70];
 char sbookstart[8]="\x24\x40\x01\x02\x03\xFF\xFF";
 char sbookinit[6]="\x3C\x00\x3E\x00\x03";
 char sbookspell[20]="\x40\x01\x02\x03\x1F\x2E\x00\x00\x01\x00\x48\x00\x7D\x40\x01\x02\x03\x00\x00";
  
 item=-1;
 x=packitem(currchar[s]);
 serial=items[x].serial;
 serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (((items[i].type==9)&&(items[i].contserial==serial)) ||
        ((items[i].layer==1)&&(items[i].contserial==chars[currchar[s]].serial)&&(items[i].type==9))))
 /*for (i=0;i<itemcount;i++)
 if (((items[i].type==9)&&(items[i].cont1==items[x].ser1)&&(items[i].cont2==items[x].ser2)&&
      (items[i].cont3==items[x].ser3)&&(items[i].cont4==items[x].ser4))||
     ((items[i].layer==1)&&(items[i].cont1==chars[currchar[s]].ser1)&&(items[i].cont2==chars[currchar[s]].ser2)&&
      (items[i].cont3==chars[currchar[s]].ser3)&&(items[i].cont4==chars[currchar[s]].ser4)&&(items[i].type==9)))*/
    {
      item=i;
      break;
    }
  }
 if (item==-1)
 {
  sysmessage(s, "In order to open spellbook, it must be equipped or in backpack and not in any containers.");
  return;
 }

 if (items[item].layer!=1) senditem(s,item); // prevents crash if pack not open

// xsend(s, pause, 2, 0);
 sbookstart[1]=items[item].ser1;
 sbookstart[2]=items[item].ser2;
 sbookstart[3]=items[item].ser3;
 sbookstart[4]=items[item].ser4;
 xsend(s, sbookstart, 7, 0);
 scount=0;
 for (i=0;i<70;i++) {
         spells[i]=0;
 }
/* for (j=0;j<itemcount;j++)
 {
  if (items[item].ser1==items[j].cont1 && items[item].ser2==items[j].cont2 &&
      items[item].ser3==items[j].cont3 && items[item].ser4==items[j].cont4)*/
  serial=items[item].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    j=contsp[serhash].pointer[ci];
    if ((j!=-1) && (items[j].contserial==serial))
    {
      if (items[j].id1==0x1F && items[j].id2>=0x2D && items[j].id2<=0x72) 
      {
        spells[items[j].id2-0x2D]=1;
      }
    }
  }
 // Fix for Reactive Armor/Bird's Eye dumbness. :)
 i=spells[0];
 spells[0]=spells[1];
 spells[1]=spells[2];
 spells[2]=spells[3];
 spells[3]=spells[4];
 spells[4]=spells[5];
 spells[5]=spells[6]; // Morac is right! :)
 spells[6]=i;
 // End fix.
 if (spells[64])
 {
   for (i=0;i<70;i++)
     spells[i]=1;
     spells[64]=0;
 }
 spells[64]=spells[65];
 spells[65]=0;
 for (i=0;i<70;i++)
 {
   if (spells[i]) scount++;
 }
 sbookinit[1]=((scount*19)+5)/256;
 sbookinit[2]=((scount*19)+5)%256;
 sbookinit[3]=scount/256;
 sbookinit[4]=scount%256;
 if (scount>0) xsend(s, sbookinit, 5, 0);
 for (i=0;i<70;i++)
  if (spells[i])
  {
   sbookspell[0]=0x41;
   sbookspell[1]=0x00;
   sbookspell[2]=0x00;
   sbookspell[3]=i+1;
   sbookspell[8]=i+1;
   sbookspell[13]=items[item].ser1;
   sbookspell[14]=items[item].ser2;
   sbookspell[15]=items[item].ser3;
   sbookspell[16]=items[item].ser4;
   xsend(s, sbookspell, 19, 0);
  } 
// xsend(s, restart, 2, 0);
}

void recall(int s)
{
	int i,serial;
	int recalled=0;

	serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
	i=findbyserial(&itemsp[serial%256], serial, 0);
	if ((i!=-1) && (items[i].type==50))
	{
		if (items[i].morex==0 && items[i].morey==0 && items[i].morez==0)
		{
			sysmessage(s,"That rune has not been marked yet!");
		}
		soundeffect(s, 0x01, 0xFC);
    chars[currchar[s]].x=items[i].morex;
    chars[currchar[s]].y=items[i].morey;
    chars[currchar[s]].dispz=chars[currchar[s]].z=items[i].morez;
    teleport(currchar[s]);
    sysmessage(s,"You have recalled from the rune.");
    recalled=1;
	}
	if(!recalled) sysmessage(s,"That item is not a recall rune.");
}

void mark(int s)
{
 int i,serial;
 int marked=0;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&itemsp[serial%256], serial, 0);
 if ((i!=-1) && (items[i].type==50))
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,items[i].x,items[i].y,items[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  { 
    soundeffect(s, 0x01, 0xFA);
    items[i].morex=chars[currchar[s]].x;
    items[i].morey=chars[currchar[s]].y;
    items[i].morez=chars[currchar[s]].z;
    sysmessage(s,"Recall rune marked."); 
    marked=1;
  }
  else
  {
   sysmessage(s, "** Wishing I could see it so I COULD mark it **");
   marked=1;
  }
 }
 if(!marked) sysmessage(s,"That item is not a recall rune.");
} 

char gate(int s)
{
	int i,n,c,serial;
	unsigned int j;
	char gated=0;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&itemsp[serial%256], serial, 0);
 if ((i!=-1) && (items[i].type==50))
 {
    gatex[gatecount][0]=chars[currchar[s]].x+1;
    gatey[gatecount][0]=chars[currchar[s]].y+1;
    gatez[gatecount][0]=chars[currchar[s]].z;

    gatex[gatecount][1]=items[i].morex;
    gatey[gatecount][1]=items[i].morey;
    gatez[gatecount][1]=items[i].morez;
    gated=1;
 }

 if(!gated)
 {
  sysmessage(s,"You cannot gate from that item.");
  return(0);
 } 
 soundeffect(s, 0x02, 0x0E);
 for (n=0;n<2;n++)  
 {

  sprintf(temp,"a blue moongate");
  c=SpawnItem(s,1,"#",0,0x0f,0x6c,0,0,0,0);
  items[c].type=51+n;
  items[c].x=gatex[gatecount][n];
  items[c].y=gatey[gatecount][n];
  items[c].z=gatez[gatecount][n];
  items[c].gatetime=(getclock()+(server_data.gatetimer*CLOCKS_PER_SEC));
  items[c].gatenumber=gatecount;
  items[c].dir=1;
  for (j=0;j<now;j++) if (perm[j]) senditem(j,c);
  if (n==1)
  {
   gatecount++;
   if (gatecount>MAXGATES) gatecount=0;
  }
  addid1[s]=0;
  addid2[s]=0;
 }

 return(1);
}

char gatecollision(int s)
{
 unsigned int i,n;

 for (i=0;i<itemcount;i++)
 {
  if ((items[i].type==51) || (items[i].type==52))
  {
   if (items[i].type==51) n=1;
   else n=0;
   if ((chars[s].x==items[i].x)&&
       (chars[s].y==items[i].y)&&
       (chars[s].z>=items[i].z))
   {
    chars[s].x=gatex[items[i].gatenumber][n]+1;
    chars[s].y=gatey[items[i].gatenumber][n];
    chars[s].dispz=chars[s].z=gatez[items[i].gatenumber][n];
    teleport(s);
   }
  }
 }

 return(1);
}

void gatedestruction(unsigned int currenttime)
{
 unsigned int i,k;

 for (i=0;i<itemcount;i++)
 {
  if((items[i].type==51)) 
  {
   if(items[i].gatetime<=currenttime)
   {
    for (k=0;k<2;k++) deleitem(i); 
   }
  }
 }
}

void heal(int s)
{
 int i,serial;

/* for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))*/
 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {  
   soundeffect2(i, 0x01, 0xF2);
   staticeffect(i, 0x37, 0x6A, 0x09, 0x06);
   chars[i].hp=chars[i].st;
   updatestats(i, 0);  
  }
   else
   {
	sysmessage(s, "No matter how hard you try, there are too many things in the way!");
   }
  return;
 }
 sysmessage(s,"That is not a person.");
}

//Tauriel 10-03-98 rewrite to use spells.scp
int castspell(int s, int num, int type, int Numitem)
{
 int i,success=1, circle, enabled=0, mana=0, delay, sclo=0, schi=0;
 int ash=0, drake=0, garlic=0, ginsing=0, moss=0, pearl=0, shade=0, silk=0, loskill=0, hiskill=0;
 char mantra[25];
 char sect[512];
 int action=0;

 currentSpellType[s] = type;      // global used in other routines

 if ((chars[currchar[s]].cell !=0) && (!chars[currchar[s]].priv&0x01))
 {
  sysmessage(s,"You are in jail and cannot cast spells");
  return 0;
 }
// Read in spell information from spells.scp
 openscript("spells.scp");
 sprintf(sect, "SPELL %d", num);
 if (!spells_script.find(sect)) 
 {
  closescript();
  return 0;
 }
 do
 {
  read2();
  if (script1[0]!='}')
  {
   if (!(strcmp("ENABLE",script1)))
   {
      enabled=str2num(script2);
   }
   if (!(strcmp("CIRCLE",script1)))
   {
      circle=str2num(script2);
   }
   if (!(strcmp("MANA",script1)))
   {
      mana=str2num(script2);
   }
   if (!(strcmp("LOSKILL",script1)))
   {
      loskill=str2num(script2);
   }
   if (!(strcmp("HISKILL",script1)))
   {
      hiskill=str2num(script2);
   }
   if (!(strcmp("SCLO",script1)))
   {
      sclo=str2num(script2);
   }
   if (!(strcmp("SCHI",script1)))
   {
      schi=str2num(script2);
   }
   if (!(strcmp("MANTRA",script1)))
   {
      strcpy(mantra, script2);
   }
   if (!(strcmp("ACTION",script1)))
   {
      action=hstr2num(script2);
   }
   if (!(strcmp("DELAY",script1)))
   {
      delay=str2num(script2);
   }
   if (!(strcmp("ASH", script1)))
   { 
      ash=str2num(script2);
   }
   if (!(strcmp("DRAKE", script1)))
   {
      drake=str2num(script2);
   }
   if (!(strcmp("GARLIC", script1)))
   {
      garlic=str2num(script2);
   }
   if (!(strcmp("GINSING",script1)))
   {
      ginsing=str2num(script2);
   }
   if (!(strcmp("MOSS", script1)))
   {
      moss=str2num(script2);
   }
   if (!(strcmp("PEARL",script1)))
   {
      pearl=str2num(script2);
   }
   if (!(strcmp("SHADE",script1)))
   {
      shade=str2num(script2);
   }
   if (!(strcmp("SILK",script1)))
   {
      silk=str2num(script2);
   }
  }
 }
 while (script1[0]!='}');
closescript();

if (!enabled)
{
   impaction(s,0x11);   // Unimplemented Spells
	sysmessage(s,"Sorry,that spell is not implemented.");
	return 0;
}

//Cut the casting requirment on scrolls
if (type==1)
{
   loskill=sclo;
   hiskill=schi;
}

 // The following loop checks to see if any item is currently equipped (if not a GM)
if (!chars[currchar[s]].priv&0x01)
{
  int serial,serhash,ci;
  serial=chars[currchar[s]].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial))
    {
	    if ( Numitem==0 )     
				if (items[i].layer==2||(items[i].layer==1 && items[i].type!=9))
				{
					sysmessage(s,"You cannot cast with a weapon equipped.");
					return 0;
				}
	    if ( Numitem>0 )  // to see if is same item we click on in case of spell type = 2
				if (!((items[Numitem].contserial==chars[currchar[s]].serial) &&
			      (items[Numitem].layer==2||items[Numitem].layer==1 )))
				{
					sysmessage(s,"You cannot cast with a weapon equipped.");
					return 0;
				}
    }
  }
}

 if ((chars[currchar[s]].hidden)&&(!(chars[currchar[s]].priv2&8)))
 {
  chars[currchar[s]].hidden=0;
  updatechar(currchar[s]);
 }

// Mana not necessary if wand or staff or GM otherwise check mana
 if (type != 2)
 {
   if ((chars[currchar[s]].mn < mana) && !(chars[currchar[s]].priv2&0x01))
   {
      success=0;
      sysmessage(s, "You have insufficient mana to cast that spell.");
   }
 }
 else
   success=1;

if (!success) return 0;

//Check for enough reagents
if (type==0 && (!checkreagents(currchar[s], ash, drake, garlic, ginsing, moss, pearl, shade, silk)))
{
   return 0;
}

//Only speak if not a rod/staff/wand
if (type!=2)
{
    impaction(s, action);
	npctalkall(currchar[s], mantra);
}

//Use Reagents Use them regarless of success or failure
if (type==0)
{
   delereagents(currchar[s], ash, drake, garlic, ginsing, moss, pearl, shade, silk);
}

//Check success of casting Except for GM's
if (type!=2 && !(chars[currchar[s]].priv2&0x01) && !checkskill(currchar[s], MAGERY, loskill, hiskill))
{
   spellfail(s);
   return 0;
}

//subtract mana we know they have enough mana at this point
if (success && type!=2) success=subtractmana(currchar[s], mana);

//spell section for implementation specific stuff to get the spell to work
switch (num)
 {
 case 1: // Clumsy
     target(s,0,1,0,100,"Select target for clumsy.");
	  break;
 case 2: // Create Food
	  target(s,0,1,0,54,"Select location for food."); 
	  break;

 case 3: // Feeblemind
	  target(s,0,1,0,101,"Select target for feeblemind."); 
	  break;
 case 4: // Heal
     target(s,0,1,0,83,"Select person to heal.");
	  break;
 case 5: // Magic Arrow
     target(s,0,1,0,68,"Select target for magic arrow.");
	  break;
 case 6: // Night Sight
	  target(s,0,1,0,99,"Select target for night sight.");
	  break;
 case 7: // Reactive Armor
	  reactivearmortarget(s);
	  break;
 case 8: // Weaken
	  target(s,0,1,0,102,"Select target for weaken.");
	  break;
 case 9: // Agility
	  target(s,0,1,0,103,"Select target for agility.");
	  break;
 case 10:// Cunning
	  target(s,0,1,0,104,"Select target for cunning.");
	  break;
 case 11:// Cure
	  target(s,0,1,0,182,"Select target to cure.");
	  break; 
 case 12:// Harm
	  target(s,0,1,0,85,"Select target for harm.");
	  break; 
 case 13://Magic Trap
	  target(s,0,1,0,196,"Select item to set magic trap.");
	  break;
 case 14://Magic Untrap
	  target(s,0,1,0,197,"Select item to untrap.");
	  break;
 case 16: // Strength
	  target(s,0,1,0,105,"Select target for strength.");
	  break;
 case 17:// Bless
	  target(s,0,1,0,124,"Select target for bless.");
	  break;
 case 18:// Fireball
	  target(s,0,1,0,74,"Select target for fireball.");
	  break; 
 case 19://Magic Lock
	  target(s,0,1,0,195,"Select item to lock.");
	  break;
 case 20:// Poison
	  target(s,0,1,0,181,"Select target to Poison.");
	  break;
 case 22:// Teleport
	  target(s,0,1,0,2,"Select target for teleport.");
	  break;
 case 23:// Unlock
	  addmitem[s]= -1;
	  target(s,0,1,0,162,"What do you want to unlock?");
	  break;
 case 24:// Wall of Stone
	  target(s,0,1,0,92,"Select location for wall of stone.");
	  break;
 case 25://Arch Cure
	  target(s,0,1,0,192,"Select location for Arch Cure.");
	  break;
 case 27:// Curse
	  target(s,0,1,0,125,"Select target for curse.");
	  break;
 case 28:// Fire Field
	  target(s,0,1,0,91,"Select location for fire field."); 
	  break;
 case 29:// Greater Heal
	  target(s,0,1,0,84,"Select person to heal.");
	  break;
 case 30:// Lightning
	  target(s,0,1,0,73,"Select target for lightning.");
	  break;
 case 31://Mana drain
	  target(s,0,1,0,188,"Select target for Mana Drain.");
	  break;
 case 32:// Recall
	  if (!(region[chars[currchar[s]].region].priv&0x08))
	  {
   	   sysmessage(s, "You may not cast recall in this region.");
         if (chars[s].priv2&0x10)
         {
            success=1;
            break;
         }
         chars[s].mn+=mana;
	      success=0;
	  }
	  else target(s,0,1,0,38,"Select rune from which to recall.");
	  break;
 case 33:// Blade Spirits
	  target(s,0,1,0,70, "Select location for blade spirits.");
	  break;
 case 34:// Dispel Field
	  target(s,0,1,0,95, "Select field to dispel.");
	  break;
 case 36:// Magic Reflection
	  magicreflectiontarget(s);
	  break;
 case 37:// Mind Blast
	  target(s,0,1,0,97, "Select target for mind blast.");
	  break;
 case 38:// Paralyze
	  target(s,0,1,0,96, "Select target for paralyze.");
	  break;
 case 39:// Poison Field
	  target(s,0,1,0,98 , "Select location for poison field.");
	  break;
 case 41:// Dispel
	  target(s,0,1,0,90,"Select target to dispel.");
	  break;
 case 42:// Energy Bolt
	  target(s,0,1,0,75,"Select target for energy bolt.");
	  break; 
 case 43://Explosion
	  target(s,0,1,0,72, "Select target for explosion");
	  break;
 case 44:// Invisibility
	  target(s,0,1,0,67,"Select character to make invisible.");
	  break;
 case 45:// Mark
	  if (!(region[chars[currchar[s]].region].priv&0x02))
	  {
	   sysmessage(s, "You may not cast mark in this region.");
         if (chars[s].priv2&0x10)
         {
            success=0;
            break;
         }
         chars[s].mn+=mana;
	      success=0;
	  }
	  else target(s,0,1,0,39,"Select rune to mark."); 
	  break;
 case 46:// Mass curse
	  target(s,0,1,0,193,"Select location for Mass Curse.");
	  break;
 case 47:// Paralyze Field
	  target(s,0,1,0,93,"Select location for paralyze field.");
	  break;
 case 48:// Reveal
	  target(s,0,1,0,78,"Select area to reveal."); 
	  break;
 case 49:// Chain Lightning
	  target(s,0,1,0,191,"Select location for Chain Lightning."); 
	  break;
 case 50:// Energy Field
	  target(s,0,1,0,94,"Select location for energy field.");
	  break;
 case 51:// Flamestrike
	  target(s,0,1,0,71,"Select player to flamestrike.");
	  break;
 case 52:// Gate Travel
	  if (!(region[chars[currchar[s]].region].priv&0x04))
	  {
	   sysmessage(s, "You may not cast gate travel in this region.");
	      if (chars[s].priv2&0x10)
         {
            success=0;
            break;
         }
         chars[s].mn+=mana;
	      success=0;
	  }
	  else target(s,0,1,0,43,"Select rune from which to gate.");//gate(s);
	  break;              
 
 case 53://Mana Vampire
	  target(s,0,1,0,189,"Select target for Mana Vampire.");
	  break;
 case 54://Mass Dispel
	  target(s,0,1,0,194,"Select location for Mass Dispel.");
	  break;
 case 55://Meteor Swarm
	  target(s,0,1,0,190,"Select location for Meteor Swarm.");
	  break;
case 58:// Energy Vortex
	  target(s,0,1,0,69,"Select location for energy vortex.");
	  break;
 case 59:// Resurrection
	  target(s,0,1,0,21,"Select ghost to resurrect."); //resurrect(s);
	  break;
 case 60:// Summon Air Elemental
	  summonmonster(s, 0x00, 0x0d, "air");
	  break;
 case 61:// Summon Daemon
	  summonmonster(s, 0x00, 0x0A, "daemon"); 
	  break;
 case 62:// Summon Earth Elemental
     summonmonster(s, 0x00, 0x0e, "earth");
	  break;
 case 63:// Summon Fire Elemental
	  summonmonster(s, 0x00, 0x0f, "fire");
	  break;
 case 64:// Summon Water Elemental
	  summonmonster(s, 0x00, 0x10, "water");
	  break;
 case 65:// Summon Hero
	  summonmonster(s, 0x01, 0x90, "Death Knight");
	  break; 
 
 case 66://Cannon Firing
	  target(s,0,1,0,169, "Aye Aye Sir cannon is loaded, please select your target");
	  break;
 default:
	  impaction(s,0x11);   // Unimplemented Spells
 }
 if (success) return 1;
 if (!success)  spellfail(s);
 return 0;
}

void summonmonster(int s, char id1, char id2, char * monstername, char color1, char color2, int
x, int y, int z)
{
 int i;
	unsigned int c;

 c=memcharfree ();
 
 i=(id1*256)+id2;
 initchar(c);
 switch(i)
 {
 case 0x000D: // Energy Vortex & Air elemental
                   if (color1==0x00 && color2==0x75)
                  {
                soundeffect(s, 0x02, 0x16); // EV
               chars[c].def=22;
               chars[c].lodamage=20;
               chars[c].hidamage=30;
               //chars[c].spattack=8191; // 1-7 level spells
               chars[c].baseskill[MAGERY]=950; // 95 magery
               chars[c].baseskill[TACTICS]=800; // 80 tactics
               chars[c].skill[MAGICRESISTANCE]=750;
               chars[c].st=chars[c].hp=600;
               chars[c].dx=chars[c].stm=160;
               chars[c].in=chars[c].mn=180;
               chars[c].npcWander=2;
			   chars[c].npcaitype=30;
			   chars[c].poison=3;
//             chars[c].npcaitype=0x08;
              } else
              {
               soundeffect(s, 0x02, 0x17); // AE
               chars[c].def=19;
               chars[c].lodamage=5;
               chars[c].hidamage=13;
               chars[c].spattack=4095; // 1-6 level spells
               chars[c].baseskill[MAGERY]=750; // 75 magery
               chars[c].baseskill[TACTICS]=700; // 70 tactics               
               chars[c].skill[MAGICRESISTANCE]=450;
               chars[c].st=chars[c].hp=125;
               chars[c].dx=chars[c].stm=100;
               chars[c].in=chars[c].mn=80;
              }
              break;
 case 0x000A: // Daemon
              soundeffect(s, 0x02, 0x16);
              chars[c].def=20;
              chars[c].lodamage=10;
              chars[c].hidamage=45;
              chars[c].spattack=8191; // 1-7 level spells
              chars[c].baseskill[MAGERY]=900; // 90 magery
              chars[c].baseskill[TACTICS]=700; // 70 tactics 
              chars[c].skill[MAGICRESISTANCE]=650;
              chars[c].st=chars[c].hp=600;
              chars[c].dx=chars[c].stm=70;
              chars[c].in=chars[c].mn=100;
              break;
 case 0x000E: //Earth
              soundeffect(s, 0x02, 0x17);
              chars[c].def=15;
              chars[c].lodamage=3;
              chars[c].hidamage=18;
              chars[c].baseskill[TACTICS]=850; // 85 tactics 
              chars[c].skill[MAGICRESISTANCE]=350;
              chars[c].st=chars[c].hp=125;
              chars[c].dx=chars[c].stm=90;
              chars[c].in=chars[c].mn=70;
              break;
 case 0x000F: //Fire
 case 0x0010: //Water
              soundeffect(s, 0x02, 0x17);
              chars[c].def=19;
              chars[c].lodamage=4;
              chars[c].hidamage=12;
              chars[c].spattack=4095; // 1-6 level spells
              chars[c].baseskill[MAGERY]=800; // 80 magery
              chars[c].baseskill[TACTICS]=800; // 80 tactics 
              chars[c].skill[MAGICRESISTANCE]=450;
              chars[c].st=chars[c].hp=120;
              chars[c].dx=chars[c].stm=95;
              chars[c].in=chars[c].mn=70;
              break;
 case 0x023E: //Blade Spirits
              soundeffect(s, 0x02, 0x12); // I don't know if this is the right effect...
              chars[c].def=24;
              chars[c].lodamage=5;
              chars[c].hidamage=10;
              chars[c].baseskill[TACTICS]=950; // 95 tactics 
              chars[c].skill[MAGICRESISTANCE]=650;
              chars[c].st=chars[c].hp=200;
              chars[c].dx=chars[c].stm=95;
              chars[c].in=chars[c].mn=70;
              chars[c].npcWander=2;
              chars[c].npcaitype=30;
			  chars[c].poison=1;
                  break;
 case 0x0190: // Death Knight
              soundeffect(s, 0x02, 0x46);
              chars[c].def=20;
              chars[c].lodamage=10;
              chars[c].hidamage=45;
              chars[c].spattack=4095; // 1-7 level spells
              chars[c].baseskill[MAGERY]=500; // 90 magery
              chars[c].baseskill[TACTICS]=1000; // 70 tactics 
              chars[c].baseskill[SWORDSMANSHIP]=1000;
			  chars[c].baseskill[PARRYING]=1000;
			  chars[c].skill[MAGICRESISTANCE]=650;
              chars[c].st=chars[c].hp=600;
              chars[c].dx=chars[c].stm=70;
              chars[c].in=chars[c].mn=100;
              chars[c].fame=-10000;
              chars[c].karma=-10000;
			  break;
 
 
 
 default:
              soundeffect(s, 0x02, 0x15);
 }
 sprintf(chars[c].name, monstername);
 chars[c].id1=id1;
 chars[c].id2=id2;
 chars[c].xid1=id1;
 chars[c].xid2=id2;
 chars[c].skin1=color1;
 chars[c].skin2=color2;
 chars[c].xskin1=color1;
 chars[c].xskin2=color2;
 chars[c].priv2=0x20;
 chars[c].npc=1;
 if (i!=0x023E && !(i==0x000d && color1==0 && color2==0x75))  // don't own BS or EV.
/* chars[c].own1=chars[currchar[s]].ser1;
 chars[c].own2=chars[currchar[s]].ser2;
 chars[c].own3=chars[currchar[s]].ser3;
 chars[c].own4=chars[currchar[s]].ser4;*/
 setserial(c, currchar[s], 5);

 if (x==0)
 {
  chars[c].x=chars[currchar[s]].x-1;
  chars[c].y=chars[currchar[s]].y;
  chars[c].dispz=chars[c].z=chars[currchar[s]].z;
 } else
 {
  chars[c].x=x;
  chars[c].y=y;
  chars[c].dispz=chars[c].z=z;
 }
 chars[c].spadelay=10;
 chars[c].summontimer=(getclock()+((chars[currchar[s]].skill[MAGERY]/10)*(CLOCKS_PER_SEC*2)));//60)));
 if (c==charcount)
  {
  charcount++;
  charcount2++;
  }
 updatechar(c);
 npcaction(c, 0x0C);
}

int checkBook(int circle, int spell, int i)
{
 int j, spellnum, raflag=0,serial,serhash,ci;

 spellnum=spell+(circle-1)*8;
 // Fix for OSI stupidity. :) 
 if (spellnum==6) raflag=1;
 if (spellnum>=0 && spellnum<6) spellnum++;
 if (raflag) spellnum=0;
  serial=items[i].serial;
  serhash=serial%256;
  //j=findbyserial(&itemsp[serial%256], serial,0);
  /*for (j=0;j<itemcount;j++)
  {
  if (items[i].ser1==items[j].cont1 && items[i].ser2==items[j].cont2 && items[i].ser3==items[j].cont3 &&
      items[i].ser4==items[j].cont4) 
  {*/
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    j=contsp[serhash].pointer[ci];
    if((j!=-1) && (items[j].id1==0x1F && items[j].id2==(0x2D+spellnum) ||
        items[j].id2==0x6D))
    {
      return 1;
    }
  }
  return 0;
}

void invistarget(int s)
{
 int i,serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   soundeffect2(i, 0x02, 0x03);
   chars[i].hidden=2;
   updatechar(i);
   chars[i].invistimeout=getclock()+(server_data.invisibiliytimer*CLOCKS_PER_SEC);
  }
   else
   {
	sysmessage(s, "You need to be able to see the target first before you can make it invisible.");
   }
  return;
 }
 sysmessage(s,"That is not a person.");
}

void reveal(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;

 int x,y,z,i,dx,dy,dz,success,j,range;
 double c;           // int is to restricting


 x=(buffer[s][11]*256)+buffer[s][12];
 y=(buffer[s][13]*256)+buffer[s][14];
 z=buffer[s][16];
 if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z, x, y, z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
     (chars[currchar[s]].priv&0x01)))
 { 
  j=chars[currchar[s]].skill[MAGERY]; 
  range=(((j-261)*(15))/739)+5;
 /*
 If the caster has a Magery of 26.1 (min to cast reveal w/ scroll), range  radius is
 5 tiles, if magery is maxed out at 100.0 (except for gms I suppose), range is 20
 */
 
  for (i=0;i<charcount;i++)
  {
   if ((chars[i].hidden==2) || (chars[i].hidden==1)) //  does reveal hidden people as well now :)
   {
    dx=abs(chars[i].x-x);
    dy=abs(chars[i].y-y);
    dz=abs(chars[i].z-z);  // new--difference in z coords
#ifdef __NT__
    c=sqrt(dx*dx+dy*dy);
#else
    c=hypot(dx, dy);
#endif
    if ((c<=range)&&(dz<=15)) //char to reveal is within radius or range and no more than 15 z coords away
    {
     chars[i].hidden=0;
     updatechar(i);
    }
   }
  }
  soundeffect(s,0x01,0xFD);
 }
  else
  {
   sysmessage(s, "You would like to see if anything was there, but there is too much stuff in the way.");
  }
}
 
void magicarrowtarget(int s)
{
 int i, src, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   npcattacktarget(i, currchar[s]);
   if (checkmagicreflect(i)) 
   {
    src=i;
    i=currchar[s];
   }
   else
   {
    src=currchar[s];
   }
   movingeffect(src, i, 0x36, 0xE4, 0x05, 0x00, 0x01); 
   soundeffect2(src, 0x1, 0xE5);
   if (checkresist(i, 1))
   {
    magicdamage(i, (1+(rand()%1)+1)*(chars[src].skill[MAGERY]/2000+1));
   }
   else 
   {
    magicdamage(i, (1+(rand()%1)+2)*(chars[src].skill[MAGERY]/1500+1));
   }
  }
   else
   {
	sysmessage(s, "You'll have to find a clearer path.");
   }
   return;
 }
 sysmessage(s,"That is not a person.");
}

void evtarget(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;

 summonmonster(s, 0x00, 0x0d, "an energy vortex", 0x00, 0x75, 
	      (buffer[s][11]*256)+buffer[s][12],
              (buffer[s][13]*256)+buffer[s][14],
               buffer[s][16]);
}

void bstarget(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;
 if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,(buffer[s][11]*256)+buffer[s][12],
	  (buffer[s][13]*256)+buffer[s][14],buffer[s][16],WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
     (chars[currchar[s]].priv&0x01)))
 {
   summonmonster(s, 0x02, 0x3E, "a blade spirit", 0x00, 0x00, 
	          (buffer[s][11]*256)+buffer[s][12],
              (buffer[s][13]*256)+buffer[s][14],
               buffer[s][16]);
 }
  else
  {
   sysmessage(s, "You do not have a clear view of the area.");
  }
}

void flamestriketarget(int s)
{
 int i, serial;
 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  { 
   npcattacktarget(i, currchar[s]);
   if (checkmagicreflect(i)) i=currchar[s];
   staticeffect(i, 0x37, 0x09, 0x09, 0x19);
   soundeffect2(i, 0x02, 0x08);     
   if (checkresist(i, 7))
   {
	magicdamage(i, chars[currchar[s]].skill[MAGERY]/80);
    //magicdamage(i, (2+(rand()%8)+1)*(chars[currchar[s]].skill[MAGERY]/2000+1));
   }
   else 
   {
	magicdamage(i, chars[currchar[s]].skill[MAGERY]/40+RandomNum(1,25));
    //magicdamage(i, (7+(rand()%10)+2)*(chars[currchar[s]].skill[MAGERY]/1500+1));
   }
  }
   else
   {
    sysmessage(s, "Operation Flame Strike is a failure because target cannot be seen!");
   }
   return;
  }
}

void explosiontarget(int s)
{
	int i, serial;
	unsigned int j;

	serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   if (checkmagicreflect(i)) i=currchar[s];
   staticeffect(i, 0x36, 0xB0, 0x09, 0x09);
   soundeffect2(i, 0x02, 0x07);   
   for (j=0;j<charcount;j++)
   {
    if (chars[j].x==chars[i].x && chars[j].y==chars[i].y && chars[j].z==chars[i].z)
    {
     npcattacktarget(j, currchar[s]);
     if (checkresist(j, 6))
	 {
	  magicdamage(i, chars[currchar[s]].skill[MAGERY]/120+RandomNum(1,5));
	  //magicdamage(i, (1+(rand()%2)+1)*(chars[currchar[s]].skill[MAGERY]/2000+1));
	 }
     else 
	 {
	  magicdamage(i, chars[currchar[s]].skill[MAGERY]/40+RandomNum(1,10));
      //magicdamage(i, (5+(rand()%4)+2)*(chars[currchar[s]].skill[MAGERY]/1500+1));
	 }
	}
   }
  }
   else
   {
	sysmessage(s, "There seems to be something in the way.");
   }
  return;
 }
}

void cannontarget(int s)
{
	int i, serial;
	unsigned int j;

	serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  { 
   if (checkmagicreflect(i)) i=currchar[s];
   staticeffect(i, 0x36, 0xB0, 0x09, 0x09);
   soundeffect2(i, 0x02, 0x07);       
   for (j=0;j<charcount;j++)
   {
    if (chars[j].x==chars[i].x && chars[j].y==chars[i].y && chars[j].z==chars[i].z)
    {
     npcattacktarget(j, currchar[s]);
     if (checkparry(j, 6))
	 {	
	  magicdamage(j, chars[currchar[s]].skill[TACTICS]/50);
     }
      else
      {
       magicdamage(j, chars[currchar[s]].skill[TACTICS]/25);
	  }
	}
   }
  }
  sprintf(temp, "You can't get a clear shot!");
  sysmessage(s, temp);
  return;
  }
}

void lightningtarget(int s)
{
 int i, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   npcattacktarget(i, currchar[s]);
   if (checkmagicreflect(i)) i=currchar[s];
   bolteffect(i);
   soundeffect2(i, 0x00, 0x29);
   if (checkresist(i, 4))
   {
	magicdamage(i, chars[currchar[s]].skill[MAGERY]/180+RandomNum(1,2));
    //magicdamage(i, (2+(rand()%2)+1)*(chars[currchar[s]].skill[MAGERY]/2000+1));
   }
   else 
   {
	magicdamage(i, chars[currchar[s]].skill[MAGERY]/90+RandomNum(1,5));
    //magicdamage(i, (2+(rand()%3)+2)*(chars[currchar[s]].skill[MAGERY]/1500+1));
   }
  }
   else
   {
	sysmessage(s, "You cannot see the target clearly.");
   }
  return;
 }
}

void fireballtarget(int s)
{
 int i, src, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   npcattacktarget(i, currchar[s]);
   if (checkmagicreflect(i))
   {
    src=i;
    i=currchar[s];
   }
   else 
   {
    src=currchar[s];
   }
   movingeffect(src, i, 0x36, 0xD5, 0x07, 0x00, 0x01);
   soundeffect2(src, 0x1, 0x5E);
   if (checkresist(i, 3))
   {
	magicdamage(i, chars[currchar[s]].skill[MAGERY]/280+1);
    //magicdamage(i, (1+(rand()%2)+1)*(chars[src].skill[MAGERY]/2000+1));
   }
   else 
   {
	magicdamage(i, chars[currchar[s]].skill[MAGERY]/140+RandomNum(1,4));
    //magicdamage(i, (1+(rand()%2)+2)*(chars[src].skill[MAGERY]/1500+1));
   }
  }
  else
  {
   sysmessage(s, "Even you cannot burn through everything in the way.");
  }
  return;
 }
 sysmessage(s,"That is not a person.");
}

void ebolttarget(int s)
{
	int i, src, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   npcattacktarget(i, currchar[s]);
   if (checkmagicreflect(i))
   {
    src=i;
    i=currchar[s];
   }
   else 
   {
    src=currchar[s];
   }
   movingeffect(src, i, 0x37, 0x9F, 0x07, 0x00, 0x01);
   soundeffect2(src, 0x2, 0x0A);
   if (checkresist(i, 6)) 
   {
	magicdamage(i, chars[currchar[s]].skill[MAGERY]/120);
    //magicdamage(i, (2+(rand()%2)+1)*(chars[currchar[s]].skill[MAGERY]/2000+8));
   }
   else 
   {
	magicdamage(i, chars[currchar[s]].skill[MAGERY]/35+RandomNum(1,10));
    //magicdamage(i, (4+(rand()%4)+2)*(chars[currchar[s]].skill[MAGERY]/1500+8));
   }
  }
  else
  {
   sysmessage(s,"There seems to be something in the way.");
  }
  return;
 }
 sysmessage(s,"That is not a person.");
}

void healtarget(int s)
{
	int i, j, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  { 
   soundeffect2(i, 0x01, 0xF2);
   staticeffect(i, 0x37, 0x6A, 0x09, 0x06);
   j=chars[i].hp+(chars[currchar[s]].skill[MAGERY]/100) + rand()%6;
   chars[i].hp=min(chars[i].st, j);
   updatestats(i, 0);
  }
   else
   {
	sysmessage(s, "No matter how hard you try, there are too many things in the way!");
   }
  return;
 }
 sysmessage(s,"That is not a person.");
}

void greaterhealtarget(int s)
{
	int i,j,serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   soundeffect2(i, 0x02, 0x02);
   staticeffect(i, 0x37, 0x6A, 0x09, 0x06);
   //j=chars[i].hp+((3*chars[currchar[s]].skill[MAGERY])/100) + rand()%6;
   j=chars[i].hp+(chars[currchar[s]].skill[MAGERY]/30+RandomNum(1,12));
   chars[i].hp=min(chars[i].st, j);
   updatestats(i, 0);        
  }
   else
   {
	sysmessage(s, "There seems to be something in the way.");
   }
  return;
 }
 sysmessage(s,"That is not a person.");
}

void harmtarget(int s)
{
	int i,serial;

	serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   npcattacktarget(i, currchar[s]);
   if (checkmagicreflect(i)) i=currchar[s];
   staticeffect(i, 0x37, 0x4A, 0x09, 0x07);//06
   soundeffect2(i, 0x01, 0xF1);     
   if (checkresist(i, 2))
   {
	magicdamage(i, chars[currchar[s]].skill[MAGERY]/500+1);
	//magicdamage(i, (1+(rand()%2)+1)*(chars[currchar[s]].skill[MAGERY]/2000+1));
   }
   else 
   {
	magicdamage(i, chars[currchar[s]].skill[MAGERY]/250+RandomNum(1,2));
    //magicdamage(i, (1+(rand()%2)+2)*(chars[currchar[s]].skill[MAGERY]/1500+1));
   }
  }
   else
   {
	sysmessage(s, "There is something in the way.");
   }
  return;
 }
}

void sbopencontainer(int s)
{
 int i,serial;

/* for (i=0;i<itemcount;i++)
 {
  if ((items[i].ser1==buffer[s][7])&&(items[i].ser2==buffer[s][8])&&
      (items[i].ser3==buffer[s][9])&&(items[i].ser4==buffer[s][10])&&(items[i].type==9))*/
 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&itemsp[serial%256], serial, 0);
 if ((i!=-1) && (items[i].type==9))
 {
   backpack(s,buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 }
 sysmessage(s,"That is not a spellbook.");
}

char checkmana(int s, int circle)
{
 char retval=0;
 int p;

 if (chars[s].priv2&0x10)
   return 1;
 switch (circle)
 {
  case 1:
  	  if (chars[s].mn >=4) retval=1;
          else retval=0;
	  break;
  case 2:
	  if (chars[s].mn >=6) retval=1;
          else retval=0;
	  break;
  case 3:
	  if (chars[s].mn >=9) retval=1;
          else retval=0;
 	  break;
  case 4:
	  if (chars[s].mn >=11) retval=1;
          else retval=0;
	  break;
  case 5:
	  if (chars[s].mn >=14) retval=1;
          else retval=0;
	  break;
  case 6:
	  if (chars[s].mn >=20) retval=1;
          else retval=0;
	  break;
  case 7:
	  if (chars[s].mn >=40) retval=1;
          else retval=0;
	  break;
  case 8:
	  if (chars[s].mn >=50) retval=1;
	  else retval=0;
	  break;
 }
 if (retval == 0)
 {
  p=calcSocketFromChar(s);
  if (p!=-1) sysmessage(p, "You have insufficient mana to cast that spell.");
 }
 return retval;
}

char subtractmana(int s, int mana)
{
 int p;
 char retval=1;

 if (chars[s].priv2&0x10)
   return 1;

 chars[s].mn-=mana;

 p=calcSocketFromChar(s);
 if (p!=-1) updatestats(p, 1);

 return retval;
}

void magicreflectiontarget(int s)
{
	staticeffect(currchar[s], 0x37, 0x3A, 0, 15);
	soundeffect2(currchar[s], 0x01, 0xE9);
	chars[currchar[s]].priv2=chars[currchar[s]].priv2|0x40;
}

void reactivearmortarget(int s)
{	
	 staticeffect(currchar[s], 0x37, 0x3a, 0, 15); 
     tempeffect(currchar[s],currchar[s], 15, chars[currchar[s]].skill[MAGERY]/100, 0, 0);
     soundeffect2(currchar[s], 0x01, 0xEE);
     chars[currchar[s]].ra=1;
}

void wallofstonetarget(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;

 int c, x, y, z, x1, y1, z1, x2, y2, z2;
	unsigned int k;
 
 x=(buffer[s][11]*256)+buffer[s][12];
 y=(buffer[s][13]*256)+buffer[s][14];
 z=buffer[s][16];
 if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z, x, y, z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
     (chars[currchar[s]].priv&0x01)))
 {
  k=fielddir(s, x, y, z);
  if (k)
  {
   x1=x;
   y1=y-1;
   z1=z;
   x2=x;
   y2=y+1;
   z2=z;
  } 
  else 
  {
   x1=x-1;
   y1=y;
   z1=z;
   x2=x+1;
   y2=y;
   z2=z;
  }

  soundeffect(s, 0x01, 0xF6);

  if (!checkforchar(x, y, z))
  {
   c=SpawnItem(s,1,"#",0,0x00,0x80,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/10)*CLOCKS_PER_SEC);
   items[c].x=x;
   items[c].y=y;
   items[c].z=z;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if ((!checkforchar(x1, y1, z1)) && z==height(x1, y1, z1))
  {
   c=SpawnItem(s,1,"#",0,0x00,0x80,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/10)*CLOCKS_PER_SEC);
   items[c].x=x1;
   items[c].y=y1;
   items[c].z=z1;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if ((!checkforchar(x2, y2, z2)) && z==height(x2, y2, z2))
  {
   c=SpawnItem(s,1,"#",0,0x00,0x80,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/10)*CLOCKS_PER_SEC);
   items[c].x=x2;
   items[c].y=y2;
   items[c].z=z2;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }
 }
  else
  {
   sysmessage(s, "There seems to be something in the way.");
  }
}

void parafieldtarget(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;

 int c, x, y, z, x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4;
 char id1, id2;
	unsigned int k;

 x=(buffer[s][11]*256)+buffer[s][12];
 y=(buffer[s][13]*256)+buffer[s][14];
 z=buffer[s][16];

 if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z, x, y, z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
     (chars[currchar[s]].priv&0x01)))
 { 
  k=fielddir(s, x, y, z);
  if (k)
  {
   id1=0x39;
   id2=0x79;
   x1=x;
   y1=y-1;
   z1=z;
   x2=x;
   y2=y+1;
   z2=z;
   x3=x;
   y3=y-2;
   z3=z;
   x4=x;
   y4=y+2;
   z4=z;
  } 
  else 
  {
   id1=0x39;
   id2=0x67;
   x1=x-1;
   y1=y;
   z1=z;
   x2=x+1;
   y2=y;
   z2=z;
   x3=x-2;
   y3=y;
   z3=z;
   x4=x+2;
   y4=y;
   z4=z;
  } 

  soundeffect(s, 0x02, 0x0B);

  if (1)
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x;
   items[c].y=y;
   items[c].z=z;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  } 

  if (z==height(x1, y1, z1))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x1;
   items[c].y=y1;
   items[c].z=z1;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  } 

  if (z==height(x2, y2, z2))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x2;
   items[c].y=y2;
   items[c].z=z2;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if (z==height(x3, y3, z3))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x3;
   items[c].y=y3;
   items[c].z=z3;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if (z==height(x4, y4, z4))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x4;
   items[c].y=y4;
   items[c].z=z4;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }
 }
  else
  {
   sysmessage(s, "You cannot see the area well enough.");
  }
}

void energyfieldtarget(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;

 int c, x, y, z, x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4;
 char id1, id2;
	unsigned int k;

 x=(buffer[s][11]*256)+buffer[s][12];
 y=(buffer[s][13]*256)+buffer[s][14];
 z=buffer[s][16];
 if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z, x, y, z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
     (chars[currchar[s]].priv&0x01)))
 { 
  k=fielddir(s, x, y, z);
  if (k)
  {
   id1=0x39;
   id2=0x56;
   x1=x;
   y1=y-1;
   z1=z;
   x2=x;
   y2=y+1;
   z2=z;
   x3=x;
   y3=y-2;
   z3=z;
   x4=x;
   y4=y+2;
   z4=z;
  } 
  else 
  {
   id1=0x39;
   id2=0x46;
   x1=x-1;
   y1=y;
   z1=z;
   x2=x+1;
   y2=y;
   z2=z;
   x3=x-2;
   y3=y;
   z3=z;
   x4=x+2;
   y4=y;
   z4=z;
  }

  soundeffect(s, 0x02, 0x10);

  if (1)
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x;
   items[c].y=y;
   items[c].z=z;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  } 

  if (z==height(x1, y1, z1))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x1;
   items[c].y=y1;
   items[c].z=z1;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if (z==height(x2, y2, z2))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x2;
   items[c].y=y2;
   items[c].z=z2;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  } 

  if (z==height(x3, y3, z3))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x3;
   items[c].y=y3;
   items[c].z=z3;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if (z==height(x4, y4, z4))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x4;
   items[c].y=y4;
   items[c].z=z4;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }
 }
  else
  {
   sysmessage(s, "The field cannot be established for there is no clear path");
  }
}

void firefieldtarget(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;

 int c, x, y, z, x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4;
 char id1, id2;
	unsigned int k;

 x=(buffer[s][11]*256)+buffer[s][12];
 y=(buffer[s][13]*256)+buffer[s][14];
 z=buffer[s][16];
 if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z, x, y, z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
 {
  k=fielddir(s, x, y, z);
  if (k)
  {
   id1=0x39;
   id2=0x96;
   x1=x;
   y1=y-1;
   z1=z;
   x2=x;
   y2=y+1;
   z2=z;
   x3=x;
   y3=y-2;
   z3=z;
   x4=x;
   y4=y+2;
   z4=z;
  }  
  else 
  {
   id1=0x39;
   id2=0x8C;
   x1=x-1;
   y1=y;
   z1=z;
   x2=x+1;
   y2=y;
   z2=z;
   x3=x-2;
   y3=y;
   z3=z;
   x4=x+2;
   y4=y;
   z4=z;
  }
 
  soundeffect(s, 0x02, 0x0C);

  if (1)
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x;
   items[c].y=y;
   items[c].z=z;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if (z==height(x1, y1, z1))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x1;
   items[c].y=y1;
   items[c].z=z1;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if (z==height(x2, y2, z2))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x2;
   items[c].y=y2;
   items[c].z=z2;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if (z==height(x3, y3, z3))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x3;
   items[c].y=y3;
   items[c].z=z3;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if (z==height(x4, y4, z4))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x4;
   items[c].y=y4;
   items[c].z=z4;
   items[c].dir=29;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }
 }
  else
  {
   sysmessage(s, "There seems to be something in the way.");
  }
}

void poisonfieldtarget(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;

 int  c, x, y, z, x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4;
 char id1, id2;
	unsigned int k;

 x=(buffer[s][11]*256)+buffer[s][12];
 y=(buffer[s][13]*256)+buffer[s][14];
 z=buffer[s][16];
 if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z, x, y, z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
 {
  k=fielddir(s, x, y, z);
  if (k)
  {
   id1=0x39;
   id2=0x20;
   x1=x;
   y1=y-1;
   z1=z;
   x2=x;
   y2=y+1;
   z2=z;
   x3=x;
   y3=y-2;
   z3=z;
   x4=x;
   y4=y+2;
   z4=z;
  } 
  else 
  {
   id1=0x39;
   id2=0x15;
   x1=x-1;
   y1=y;
   z1=z;
   x2=x+1;
   y2=y;
   z2=z;
   x3=x-2;
   y3=y;
   z3=z;
   x4=x+2;
   y4=y;
   z4=z;
  } 

  soundeffect(s, 0x02, 0x0c);

  if (1)
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x;
   items[c].y=y;
   items[c].z=z;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if (z==height(x1, y1, z1))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x1;
   items[c].y=y1;
   items[c].z=z1;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if (z==height(x2, y2, z2))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x2;
   items[c].y=y2;
   items[c].z=z2;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if (z==height(x3, y3, z3))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x3;
   items[c].y=y3;
   items[c].z=z3;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }

  if (z==height(x4, y4, z4))
  {
   c=SpawnItem(s,1,"#",0,id1,id2,0,0,0,0);
   items[c].priv=items[c].priv|0x05;
   items[c].decaytime=getclock()+((chars[currchar[s]].skill[MAGERY]/5)*CLOCKS_PER_SEC);
   items[c].x=x4;
   items[c].y=y4;
   items[c].z=z4;
   for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  }
 }
  else
  {
   sysmessage(s, "There seems to be something in the way.");
  }
}

void dispelfieldtarget(int s)
{
 int i, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&itemsp[serial%256], serial, 0);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,items[i].x,items[i].y,items[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   if (items[i].priv&0x04) deleitem(i);
   soundeffect2(i, 0x02, 0x01); 
  }
   else
   {
	sysmessage(s, "There seems to be something in the way.");
   }
 }
}

void paralyzetarget(int s)
{
 int i, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   npcattacktarget(i, currchar[s]);
   if (checkmagicreflect(i)) i=currchar[s];
   //staticeffect(currchar[s], 0x37, 0x35, 0, 30); //No effect for paralyze?
   soundeffect2(i, 0x02, 0x04);     
   if (checkresist(i, 7)) return;
   tempeffect(currchar[s], i, 1, 0, 0, 0);
  }
   else
   {
	sysmessage(s, "There is something in the way.");
   }
  return;
 }
}

void mindblasttarget(int s)
{
 int i, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   npcattacktarget(i, currchar[s]);
   if (checkmagicreflect(i))
   {
    //Reflected
    staticeffect(s, 0x37, 0x4A, 0, 15);
    soundeffect2(currchar[s], 0x02, 0x13);
    if (checkresist(currchar[s], 5))
    {
     magicdamage(currchar[s], abs(chars[currchar[s]].in-chars[i].in)/4);
    }
    else
    {
     magicdamage(currchar[s], abs(chars[currchar[s]].in-chars[i].in)/2);
    }
    return;
   } 
    else 
    {
    //Not Reflected
     staticeffect(i, 0x37, 0x4A, 0, 15);
     soundeffect2(i, 0x02, 0x13);
     if (chars[currchar[s]].in>chars[i].in)
     {
      if (checkresist(i, 5))
      {
       magicdamage(i, (chars[currchar[s]].in-chars[i].in)/4);
      }
       else
       {
        magicdamage(i, (chars[currchar[s]].in-chars[i].in)/2);
       }
     }
      else
      {
       if (checkresist(currchar[s], 5))
       {
        magicdamage(currchar[s], (chars[i].in-chars[currchar[s]].in)/4);
       }
        else
		{
         magicdamage(currchar[s], (chars[i].in-chars[currchar[s]].in)/2);
		}
	  }
	}
  }
   else
   {
    sysmessage(s, "There seems to be something in the way.");
   }
  return;
 }
}

void dispeltarget(int s)
{
 int i, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   checkmagicreflect(i);
   if (chars[i].priv2&0x20) deathstuff(i);
   //staticeffect(currchar[s], 0x37, 0x35, 0, 30);
   soundeffect2(i, 0x02, 0x04);
  }
   else
   {
    sysmessage(s, "There seems to be something in the way.");
   }
  return;
 }

 i=findbyserial(&itemsp[serial%256], serial, 0);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,items[i].x,items[i].y,items[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   if (items[i].priv&0x04) deleitem(i);
   soundeffect2(i, 0x02, 0x01);  
  }
   else
   {
	sysmessage(s, "There seems to be something in the way.");
   }
 }
}

void nightsighttarget(int s)
{
 int i, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   staticeffect(i, 0x37, 0x6A, 0x09, 0x06);
   tempeffect(currchar[s], i, 2, 0, 0, 0);
   soundeffect2(i, 0x01, 0xE3); 
  }
   else
   {
	sysmessage(s, "You need to find a clearer path.");
   }
  return;
 }
}

void clumsytarget(int s)
{
 int i, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  { 
   npcattacktarget(i, currchar[s]);
   if (checkmagicreflect(i)) i=currchar[s];
   staticeffect(i, 0x37, 0x4A, 0, 15); 
   soundeffect2(i, 0x01, 0xDF);
   if (checkresist(i, 1)) return;
   tempeffect(currchar[s], i, 3, chars[currchar[s]].skill[MAGERY]/100, 0, 0);
  }
   else
   {
	sysmessage(s, "There is something between you and the target.");
   }
   return;
 }
}

void feeblemindtarget(int s)
{
 int i, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  { 
   npcattacktarget(i, currchar[s]);
   if (checkmagicreflect(i)) i=currchar[s];
   staticeffect(i, 0x37, 0x4A, 0, 15); 
   soundeffect2(i, 0x01, 0xE4);     
   if (checkresist(i, 1)) return;
   tempeffect(currchar[s], i, 4, chars[currchar[s]].skill[MAGERY]/100, 0, 0);
  }
   else
   {
	sysmessage(s, "If you want to feeble a mind, start by finding a clear path.");
   }
  return;
 }
}

void weakentarget(int s)
{
 int i, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   npcattacktarget(i, currchar[s]);
   if (checkmagicreflect(i)) i=currchar[s];
   staticeffect(i, 0x37, 0x4A, 0, 15); 
   soundeffect2(i, 0x01, 0xE6);     
   if(checkresist(i, 1)) return;
   tempeffect(currchar[s], i, 5, chars[currchar[s]].skill[MAGERY]/100, 0, 0);
  }
   else
   {
	sysmessage(s, "Your powers are not strong enought to go through what ever is in the way.");
   }
  return;
 }
}

void agilitytarget(int s)
{
 int i, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   staticeffect(i, 0x37, 0x3a, 0, 15); 
   tempeffect(currchar[s], i, 6, chars[currchar[s]].skill[MAGERY]/100, 0, 0);
   soundeffect2(i, 0x01, 0xE7);
  }
   else
   {
	sysmessage(s, "There is something in the way.");
   }
  return;
 }
}

void cunningtarget(int s)
{
 int i, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   staticeffect(i, 0x37, 0x3a, 0, 15); 
   tempeffect(currchar[s], i, 7, chars[currchar[s]].skill[MAGERY]/100, 0, 0);
   soundeffect2(i, 0x01, 0xEB);     
  }
   else
   {
	sysmessage(s, "There is something in the way.");
   }
  return;
 }
}

void strengthtarget(int s)
{
 int i, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   staticeffect(i, 0x37, 0x3a, 0, 15); 
   tempeffect(currchar[s], i, 8, chars[currchar[s]].skill[MAGERY]/100, 0, 0);
   soundeffect2(i, 0x01, 0xEE);     
  }
   else
   {
	sysmessage(s, "There is something in the way.");
   }
  return;
 }
}

char checkmagicreflect(int i)
{
 if (chars[i].priv2&0x40)
 {
  chars[i].priv2=chars[i].priv2&0xBF;
  staticeffect(i, 0x37, 0x3A, 0, 15);
  return 1;
 }
 return 0;
}

char checkresist(int player, int circle)
{
 char i=checkskill(player, MAGICRESISTANCE, 80*circle, 800+(80*circle));;
 int s;
 if (i)
 {
  s=calcSocketFromChar(player);
  if (s!=-1)
  {
   sysmessage(s, "You feel yourself resisting magical energy!");
  }
 }
 return i;
}

void magicdamage(int p, int amount)
{
 int s;
 if ((chars[p].priv2&0x02) && (chars[p].dx>0))
 {
   chars[p].priv2=chars[p].priv2&0xFD;
   s=calcSocketFromChar(p);
   if (s!=-1) sysmessage(calcSocketFromChar(s), "You are no longer frozen.");
 }           
 if ((!(chars[p].priv&0x04))&& (!(region[chars[p].region].priv&0x40)))
 {
  if (chars[p].npc) amount=amount*2;      // double damage against non-players
  chars[p].hp=max(0, chars[p].hp-amount);
  updatestats(p, 0);
  if (chars[p].hp==0)
  {
   deathstuff(p);
  }
 }
}

void poisondamage(int p, int amount)
{
 int s;
 if (chars[p].priv2&0x02)
 {
   chars[p].priv2=chars[p].priv2&0xFD;
   s=calcSocketFromChar(p);
   if (s!=-1) sysmessage(calcSocketFromChar(s), "You are no longer frozen.");
 }           
 if ((!(chars[p].priv&0x04))&& (!(region[chars[p].region].priv&0x40)))
 {
  if (chars[p].npc) amount=amount*2;      // double damage against non-players
  chars[p].poisoned=1;
  if (chars[p].hp==0)
  {
   deathstuff(p);
  }
 }
}

void checkfieldeffects(unsigned int currenttime)
{
 unsigned int i, k;
 if (nextfieldeffecttime<=currenttime)
 {
  for (i=0;i<itemcount;i++)
  {
   if (items[i].id1==0x39 && (items[i].id2==0x96 || items[i].id2==0x8C))
   {//Fire Field
    for (k=0;k<charcount;k++)
    {
     if ((items[i].x==chars[k].x && items[i].y==chars[k].y && items[i].z==chars[k].z)&&(((online(k))||(perm[k]))||(chars[k].npc)))
     {
      if (!checkresist(k, 4))
      {
       magicdamage(k, 1);
      }
      else
      {
       magicdamage(k, 2);
      }
      soundeffect2(k, 2, 8);
     }
    }
   }
   if (items[i].id1==0x39 && (items[i].id2==0x15 || items[i].id2==0x20))
   {//Poison Field
    for (k=0;k<charcount;k++)
    {
     if ((items[i].x==chars[k].x && items[i].y==chars[k].y && items[i].z==chars[k].z)&&(((online(k))||(perm[k]))||(chars[k].npc)))
     {
      if (!checkresist(k, 4))
      {
       poisondamage(k, 1);
      }
      else
      {
       poisondamage(k, 2);
      }
      soundeffect2(k, 2, 8);
     }
    }
   }
     
   if (items[i].id1==0x39 && (items[i].id2==0x79 || items[i].id2==0x67))
   {//Para Field
    for (k=0;k<charcount;k++)
    {
     if ((items[i].x==chars[k].x && items[i].y==chars[k].y && items[i].z==chars[k].z && (!(chars[k].priv2&0x02)) )&&(((online(k))||(perm[k]))||(chars[k].npc)))
     {
      if (!checkresist(k, 4))
      {
       tempeffect(k, k, 1, 0, 0, 0);
      }
      soundeffect2(k, 0x02, 0x04);     
     }   
    }
   }
  }
  nextfieldeffecttime=currenttime+(2*CLOCKS_PER_SEC);
 }
}

void cursetarget(int s)
{
 int i, j,serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 /*for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))*/
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   npcattacktarget(i, currchar[s]);
   if (checkmagicreflect(i)) i=currchar[s];
   staticeffect(i, 0x37, 0x4A, 0, 15); 
   soundeffect2(i, 0x01, 0xE1);     
   if(checkresist(i, 1)) return;
   j=chars[currchar[s]].skill[MAGERY]/100;
   tempeffect(currchar[s], i, 12, j, j, j);
  }
   else
   {
	sysmessage(s, "There seems to be something in the way.");
   }
  return;
 }
}

void poisontarget(int s)
{
 int i,serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 /*for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))*/
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   npcattacktarget(i, currchar[s]);
   if (checkmagicreflect(i)) i=currchar[s];
   staticeffect(i, 0x37, 0x4A, 0, 15); 
   soundeffect2(i, 0x01, 0xE1);     
   if(checkresist(i, 1)) return;
   {
   chars[i].poisoned=2;   
   }
  }
   else
   {
	sysmessage(s, "There seems to be something in the way.");
   }
  return;
 }
}

void curetarget(int s)
{
 int i,serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 /*for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))*/
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   staticeffect(i, 0x37, 0x6A, 0x09, 0x06);
   tempeffect(currchar[s], i, 2, 0, 0, 0);
   soundeffect2(i, 0x01, 0xE3);     
   chars[i].poisoned=0;
  }
   else
   {
	sysmessage(s, "There is something in the way.");
   }
  return;
 }
}


void blesstarget(int s)
{
 int i, j, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 /*for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))*/
 if (i!=-1)
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {
   staticeffect(i, 0x37, 0x3a, 0, 15); 
   j=chars[currchar[s]].skill[MAGERY]/100;
   tempeffect(currchar[s], i, 11, j, j, j);
   soundeffect2(i, 0x01, 0xEA);
  }
   else
   {
	sysmessage(s, "There seems to be something in the way.");
   }
  return;
 }
}

void manadraintarget(int s)
{
 unsigned int i;

 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))
  {
   if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
   {
    npcattacktarget(i, currchar[s]);
    soundeffect2(i, 0x01, 0xF9); 
    staticeffect(i, 0x37, 0x4A, 0, 15);
    if (checkmagicreflect(i)) i=currchar[s];
    if(checkresist(i, 4)) return;
    chars[i].mn-=chars[currchar[s]].skill[MAGERY]/20;
    if (chars[i].mn<0) chars[i].mn=0;
    updatestats(i, 1);
   }
    else
	{
	 sysmessage(s, "There seems to be something in the way.");
	}
   return;
  }
 }
}

void manavampiretarget(int s)
{
 unsigned int i, temp;

 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))
  {
   if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
       (chars[currchar[s]].priv&0x01)))
   { 
    npcattacktarget(i, currchar[s]);
    soundeffect2(i, 0x01, 0xFA); 
    staticeffect(i, 0x37, 0x4A, 0, 15);
    if (checkmagicreflect(i))
    {
	   temp=currchar[s];
	   currchar[s]=i;
	   i=temp;
    }
    if(checkresist(i, 7)) return;
    if (chars[i].mn<40)
    {
	   chars[currchar[s]].mn += chars[i].mn;
	   chars[i].mn=0;
    }
    else
    {
	   chars[i].mn-=40;
	   chars[currchar[s]].mn+=40;
    }
    updatestats(i, 1);
    updatestats(currchar[s], 1);
   }
    else
	{
	 sysmessage(s, "You'll have a better chance at turning into a bat!");
	}
   return;
  }
 }
}

void boxspell(int s, int& x1, int& x2, int& y1, int& y2, int& z1, int& z2)
{

 int x, y, z, lenght;
 
 x=(buffer[s][11]*256)+buffer[s][12];
 y=(buffer[s][13]*256)+buffer[s][14];
 z=buffer[s][16];
 
 lenght=chars[currchar[s]].skill[MAGERY]/200;
 
 x1=x-lenght;
 x2=x+lenght;
 y1=y-lenght;
 y2=y+lenght;
 z1=z;
 z2=z+3;
}

void meteorswarmptarget(int s)
{
	 int  x1=0, x2=0, y1=0, y2=0, z1=0, z2=0;
	unsigned int i;

    boxspell(s, x1, x2, y1, y2, z1, z2);
	for (i=0;i<charcount;i++)
	{
	 if ((online(i)||(chars[i].npc)) && (chars[i].x>=x1&&chars[i].x<=x2)&&
		 (chars[i].y>=y1&&chars[i].y<=y2)&&
		 (chars[i].z>=z1&&chars[i].z<=z2))
	 {
      if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
          (chars[currchar[s]].priv&0x01)))
	  {
	   npcattacktarget(i, currchar[s]);
	   soundeffect2(i, 0x1, 0x60); //sound fix for swarm--Homey
	   movingeffect(currchar[s], i, 0x36, 0xD5, 0x07, 0x00, 0x01);
		if (checkresist(i, 7))
		{
			magicdamage(i, chars[currchar[s]].skill[MAGERY]/80);
		}
		else 
		{
			magicdamage(i, chars[currchar[s]].skill[MAGERY]/40);
		}
	  }
	   else
	   {
	    sysmessage(s, "You cannot see the target well.");
	   }
	 }
	}
}

void chainlightningtarget(int s)
{
	 int  x1=0, x2=0, y1=0, y2=0, z1=0, z2=0;
	unsigned int i;

    boxspell(s, x1, x2, y1, y2, z1, z2);
	for (i=0;i<charcount;i++)
	{
	 if ((online(i)||(chars[i].npc)) && (chars[i].x>=x1&&chars[i].x<=x2)&&
		 (chars[i].y>=y1&&chars[i].y<=y2)&&
		 (chars[i].z>=z1&&chars[i].z<=z2))
	 {
      if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
          (chars[currchar[s]].priv&0x01)))
	  { 
		npcattacktarget(i, currchar[s]);
		bolteffect(i);
		soundeffect2(currchar[s], 0x00, 0x29); //Homey fix for chainlightning sound
		if (checkresist(i, 7))
		{
			magicdamage(i, chars[currchar[s]].skill[MAGERY]/80);
		}
		else 
		{
			magicdamage(i, chars[currchar[s]].skill[MAGERY]/40);
		}
	  }
	   else
	   {
		sysmessage(s, "The Hand of God would like to have been administered, but... the path is not clear.");
	   }
	 }
	}
}

void archcuretarget(int s)
{
	 int  x1=0, x2=0, y1=0, y2=0, z1=0, z2=0;
	unsigned int i;

    boxspell(s, x1, x2, y1, y2, z1, z2);
	for (i=0;i<charcount;i++)
	{
	 if ((online(i)||(chars[i].npc)) && (chars[i].x>=x1&&chars[i].x<=x2)&&
		 (chars[i].y>=y1&&chars[i].y<=y2)&&
		 (chars[i].z>=z1&&chars[i].z<=z2))
	 {
      if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
          (chars[currchar[s]].priv&0x01)))
	  {
	   staticeffect(i, 0x37, 0x6A, 0x09, 0x06);
       tempeffect(currchar[s], i, 2, 0, 0, 0);
       soundeffect2(i, 0x01, 0xE9);     
       chars[i].poisoned=0;
	  }
	   else
	   {
		sprintf(temp,"There seems to be something in the way between you and %s.",chars[i].name);
        sysmessage(s, temp);
	   }
	 }
	}
}

void archprotection(int s)
{
	 int  x1=0, x2=0, y1=0, y2=0, z1=0, z2=0;
	unsigned int i;

    boxspell(s, x1, x2, y1, y2, z1, z2);
	for (i=0;i<charcount;i++)
	{
	 if ((online(i)||(chars[i].npc)) && (chars[i].x>=x1&&chars[i].x<=x2)&&
		 (chars[i].y>=y1&&chars[i].y<=y2)&&
		 (chars[i].z>=z1&&chars[i].z<=z2))
	 {
      if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
          (chars[currchar[s]].priv&0x01)))
	  {
		soundeffect2(i, 0x1, 0xF8);   
		staticeffect(i, 0x37, 0x6A, 0x09, 0x06);
      //tempeffect( pour monter armor temp);
	  }
	   else
	   {
		sprintf(temp,"There seems to be something in the way between you and %s.",chars[i].name);
        sysmessage(s, temp);
	   }
	 }
	}
}

void masscursetarget(int s)
{	
	 int  j, x1=0, x2=0, y1=0, y2=0, z1=0, z2=0;
	unsigned int i;

    boxspell(s, x1, x2, y1, y2, z1, z2);
	for (i=0;i<charcount;i++)
	{
     if ((online(i)||(chars[i].npc)) && (chars[i].x>=x1&&chars[i].x<=x2)&&
        (chars[i].y>=y1&&chars[i].y<=y2)&&
	    (chars[i].z>=z1&&chars[i].z<=z2))
	 {
      if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
          (chars[currchar[s]].priv&0x01)))
	  { 
		npcattacktarget(i, currchar[s]);
		staticeffect(i, 0x37, 0x4A, 0, 15); 
		soundeffect2(i, 0x01, 0xFC);     
		if(checkresist(i, 6)) j=chars[currchar[s]].skill[MAGERY]/200;
		else j=chars[currchar[s]].skill[MAGERY]/75;
		tempeffect(currchar[s], i, 12, j, j, j);
	  }
	   else
	   {
		sprintf(temp,"Try as you might, but you cannot see %s well enough to cover.",chars[i].name);
        sysmessage(s, temp);
	   }
	 }
	}
}

void massdispeltarget(int s)
{
	int x1=0, x2=0, y1=0, y2=0, z1=0, z2=0;
	unsigned int i;

    boxspell(s, x1, x2, y1, y2, z1, z2);
	for (i=0;i<charcount;i++)
	{
	 if ((online(i)||(chars[i].npc)) && (chars[i].priv2&0x20)&&
		 (chars[i].x>=x1&&chars[i].x<=x2)&&
		 (chars[i].y>=y1&&chars[i].y<=y2)&&
		 (chars[i].z>=z1&&chars[i].z<=z2))
	 {
      if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
          (chars[currchar[s]].priv&0x01)))
	  { 
		if(checkresist(i, 6)) 
		{
			npcattacktarget(i, currchar[s]);
			return;
		}
		deathstuff(i);
        soundeffect2(i, 0x02, 0x04);
        staticeffect(i, 0x37, 0x2A, 0x09, 0x06);
	  }
	 }
	}
}
void magiclocktarget(int s)
{
	unsigned int i;
	for (i=0;i<itemcount;i++)  //find what they clicked on
	{
		if ((items[i].ser1==buffer[s][7])&&(items[i].ser2==buffer[s][8])&&
            (items[i].ser3==buffer[s][9])&&(items[i].ser4==buffer[s][10]))
            {
			 if((items[i].type==1 || items[i].type==12 || items[i].type==63)
				 &&( items[i].id1!=0x0E || items[i].id2!=0x75))  
			 {
				switch(items[i].type)
				{
					case 1:  items[i].type=8; break;
					case 12: items[i].type=13; break;
					case 63: items[i].type=64; break;
				}
				soundeffect3(i, 0x02, 0x00);
			 }
			 else sysmessage(currchar[s],"You cannot lock this!!!");
			 break;
			}
	}
}

void magictraptarget(int s)
{
	unsigned int i;
	for (i=0;i<itemcount;i++)  //find what they clicked on
	{
		if ((items[i].ser1==buffer[s][7])&&(items[i].ser2==buffer[s][8])&&
            (items[i].ser3==buffer[s][9])&&(items[i].ser4==buffer[s][10]))
            {
			 if((items[i].type==1 || items[i].type==63 ||
				 items[i].type==8 || items[i].type==64)
				 &&( items[i].id1!=0x0E || items[i].id2!=0x75))  
			 {
			    items[i].moreb1=1;
				items[i].moreb2=chars[currchar[s]].skill[MAGERY]/20;
				items[i].moreb3=chars[currchar[s]].skill[MAGERY]/10;
				soundeffect3(i, 0x01, 0xF0);
			 }
			 else sysmessage(currchar[s],"You cannot trap this!!!");
			 break;
			}
	}
}

void magictrap(int s, int i)
{
    staticeffect(s, 0x36, 0xB0, 0x09, 0x09);
    soundeffect2(s, 0x02, 0x07);   
	if(checkresist(s, 4)) magicdamage(s,items[i].moreb2/2);
	else magicdamage(s,items[i].moreb2/2);
	items[i].moreb1=0;
	items[i].moreb2=0;
	items[i].moreb3=0;
}

void magicuntraptarget(int s)
{
	unsigned int i;
	for (i=0;i<itemcount;i++)  //find what they clicked on
	{
		if ((items[i].ser1==buffer[s][7])&&(items[i].ser2==buffer[s][8])&&
            (items[i].ser3==buffer[s][9])&&(items[i].ser4==buffer[s][10]))
        {
             if((items[i].type==1 || items[i].type==63 ||
			     items[i].type==8 || items[i].type==64))
			 {
              if(items[i].moreb1==1)
			  {
				if(rand()%100<=50+(chars[currchar[s]].skill[MAGERY]/10)-items[i].moreb3)
				{
					items[i].moreb1=0;
					items[i].moreb2=0;
					items[i].moreb3=0;
					soundeffect3(i, 0x01, 0xF1);
					sysmessage(s,"You successful untrap this item!");
				}
				else sysmessage(s,"You miss to untrap this item!");
			  }
			  else sysmessage(s,"This items doesn't seem to be trapped!");
			 }
			 else sysmessage(s,"This items cannot be trapped!");
			 break;
		}
	}
}


void delereagents(int s, int ash, int drake, int garlic, int ginseng, int moss, int pearl, int shade, int silk)
{
 if (chars[s].priv2&0x80) return;
 delequan(s, 0x0F, 0x7A, pearl);
 delequan(s, 0x0F, 0x7B, moss);
 delequan(s, 0x0F, 0x84, garlic);
 delequan(s, 0x0F, 0x85, ginseng);
 delequan(s, 0x0F, 0x86, drake);
 delequan(s, 0x0F, 0x88, shade);
 delequan(s, 0x0F, 0x8C, ash);
 delequan(s, 0x0F, 0x8D, silk);
}

char checkreagents(int s, int ash, int drake, int garlic, int ginseng, int moss, int pearl, int shade, int silk)
{
 if (chars[s].priv2&0x80) return 1;
 int i;
 int reg[8];
 for (i=0;i<8;i++)
 {
  reg[i]=0;
 }
 if (ash!=0 && getamount(s, 0x0F, 0x8C)<ash) {regmsg(s); return 0;}
 if (drake!=0 && getamount(s, 0x0F, 0x86)<drake) {regmsg(s); return 0;}
 if (garlic!=0 && getamount(s, 0x0F, 0x84)<garlic) {regmsg(s); return 0;}
 if (ginseng!=0 && getamount(s, 0x0F, 0x85)<ginseng) {regmsg(s); return 0;}
 if (moss!=0 && getamount(s, 0x0F, 0x7B)<moss) {regmsg(s); return 0;}
 if (pearl!=0 && getamount(s, 0x0F, 0x7A)<pearl) {regmsg(s); return 0;}
 if (shade!=0 && getamount(s, 0x0F, 0x88)<shade) {regmsg(s); return 0;}
 if (silk!=0 && getamount(s, 0x0F, 0x8D)<silk) {regmsg(s); return 0;}
 return 1;
}

void regmsg(int s)
{
 int i=calcSocketFromChar(s);
 if (i!=-1) sysmessage(i, "You do not have enough reagents to cast that spell.");
}

void directdamage(int p, int amount)
{
 int s;
 if (chars[p].priv2&0x02)
 {
   chars[p].priv2=chars[p].priv2&0xFD;
   s=calcSocketFromChar(p);
   if (s!=-1) sysmessage(calcSocketFromChar(s), "You are no longer frozen.");
 }           
 chars[p].hp=max(0, chars[p].hp-amount);
 updatestats(p, 0);
 if (chars[p].hp==0) deathstuff(p);
}

void pfireballtarget(int i, int k, int j) /*j = % dammage*/
{
 int dmg;
 movingeffect(i, k, 0x36, 0xD5, 0x05, 0x00, 0x01);
 soundeffect2(i, 0x1, 0x5E);
 dmg=(int)(((float)chars[i].hp/100) * j);
 /* if (dmg>50) dmg=50; these fireballs could hurt, so this may need to be put back*/
 directdamage(k, dmg);
}

void createfoodtarget(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;
 int c;
	unsigned int k;
 if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,(buffer[s][11]*256)+buffer[s][12],
	                (buffer[s][13]*256)+buffer[s][14],buffer[s][16],WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
     (chars[currchar[s]].priv&0x01)))
 { 
  soundeffect(s, 0x01, 0xE2);

  /*c=memitemfree();

  inititem(c);
  sprintf(items[c].name,"#");
  items[c].ser1=itemcount2/16777216;
  items[c].ser2=itemcount2/65536;
  items[c].ser3=itemcount2/256;
  items[c].ser4=itemcount2;
  items[c].id1=0x09;
  items[c].id2=0xd3;*/
  c=SpawnItem(s,1,"#",0,0x09,0xD3,0,0,0,0);
  items[c].type=14;
  items[c].x=(buffer[s][11]*256)+buffer[s][12];
  items[c].y=(buffer[s][13]*256)+buffer[s][14];
  items[c].z=buffer[s][16];
  for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  /*if (c==itemcount) itemcount++;
  itemcount2++;*/
 }
  else
  {
   sysmessage(s, "You need to find a better place to create your meal.");
  }
}

void spellfail(int s)
{
 staticeffect(currchar[s], 0x37, 0x35, 0, 30);
 soundeffect2(currchar[s], 0x00, 0x5C);
 npcemote(s, currchar[s], "The spell fizzles.");
}

void buildcannon(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;
 int c;
	unsigned int k;

 soundeffect(s, 0x02, 0x45);
 soundeffect(s, 0x02, 0x46);
 
 c=SpawnItem(s,1,"#",0,0x0E,0x91,0,0,0,0);
 items[c].type=15;
 items[c].morex=8;
 items[c].morey=9;
 items[c].morez=0;
 items[c].x=(buffer[s][11]*256)+buffer[s][12];
 items[c].y=(buffer[s][13]*256)+buffer[s][14];
 items[c].z=buffer[s][16];
 for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
}


void resurrecttarget(int s)
{
 int i, serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 {
  if ((line_of_sight(calcSocketFromChar(s),chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z,chars[i].x,chars[i].y,chars[i].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING)||
      (chars[currchar[s]].priv&0x01)))
  {  
   if (chars[i].dead==1)
   {
    npcresurrecttarget(i);
   }
   else sysmessage(s,"That player isn't dead!");
  }else
  {
   sysmessage(s,"T'is too much interference between you and the ghost.");
  }
  return;
 }
 sysmessage(s,"That is not a player!");
}

void npcfireballtarget(int nAttacker, int nDefender)
{
	int src, trg;

	// npcattacktarget(t, s);
	if (checkmagicreflect(nDefender))
	{
		src=nDefender;
		trg=nAttacker;
	}
	else 
	{
		trg=nDefender;
		src=nAttacker;
	}

	subtractmana(nAttacker, 9);
	movingeffect(src, trg, 0x36, 0xD5, 0x07, 0x00, 0x01);
	soundeffect2(src, 0x1, 0x5E);
	if (checkresist(trg, 3))
	{
		magicdamage(trg, chars[nAttacker].skill[MAGERY]/280+1);
		//magicdamage(trg, (2+(rand()%3)+1)*(chars[src].skill[MAGERY]/1000+1));
	}
	else 
	{
		magicdamage(trg, chars[nAttacker].skill[MAGERY]/140+RandomNum(1,4));
		//magicdamage(trg, (3+(rand()%6)+1)*(chars[src].skill[MAGERY]/750+1));  
	}
	return;
}
 
void npclightningtarget(int nAttacker, int nDefender)
{
	int src, trg;

	// npcattacktarget(t, s);
	if (checkmagicreflect(nDefender))
	{
		src=nDefender;
		trg=nAttacker;
	}
	else 
	{
		trg=nDefender;
		src=nAttacker;
	}

 subtractmana(nAttacker, 11);
 bolteffect(trg);
 soundeffect2(trg, 0x00, 0x29);

 if (checkresist(trg, 4))
   {
	magicdamage(trg, chars[nAttacker].skill[MAGERY]/180+RandomNum(1,2));
    //magicdamage(t, (2+(rand()%3)+1)*(chars[currchar[s]].skill[MAGERY]/1000+1));
   }
   else 
   {
	magicdamage(trg, chars[nAttacker].skill[MAGERY]/90+RandomNum(1,5));
	//magicdamage(t, (4+(rand()%5)+2)*(chars[currchar[s]].skill[MAGERY]/750+1));
   }

 return;
}

void npccursetarget(int nAttacker, int nDefender)
{
	int i, src, trg;

	// npcattacktarget(t, s);
	if (checkmagicreflect(nDefender))
	{
		src=nDefender;
		trg=nAttacker;
	}
	else 
	{
		trg=nDefender;
		src=nAttacker;
	}

	subtractmana(nAttacker, 11);
	staticeffect(trg, 0x37, 0x4A, 0, 15); 
	soundeffect2(trg, 0x01, 0xE1);     

	if(checkresist(trg, 1)) return;

	i=chars[nAttacker].skill[MAGERY]/100;
	tempeffect(src, trg, 12, i, i, i);

	return;
}

void npcweakentarget(int s, int t)
{
	//npcattacktarget(t, s);
	if (checkmagicreflect(t)) t=s;
 
	subtractmana(s, 4);
	staticeffect(t, 0x37, 0x4A, 0, 15); 
	soundeffect2(t, 0x01, 0xE6);     
 
	if(checkresist(t, 1)) return;

	tempeffect(s, t, 5, chars[s].skill[MAGERY]/100, 0, 0);

	return;
}

void npcfeeblemindtarget(int s, int t)
{
	//npcattacktarget(t, s);
	if (checkmagicreflect(t)) t=s;

	subtractmana(s, 4);
	staticeffect(t, 0x37, 0x4A, 0, 15); 
	soundeffect2(t, 0x01, 0xE4);     

	if (checkresist(t, 1)) return;

	tempeffect(s, t, 4, chars[s].skill[MAGERY]/100, 0, 0);

	return;
}

void npcclumsytarget(int s, int t)
{
	//npcattacktarget(t, s);
	if (checkmagicreflect(t)) t=s;

	subtractmana(s, 4);
	staticeffect(t, 0x37, 0x4A, 0, 15); 
	soundeffect2(t, 0x01, 0xDF);

	if (checkresist(t, 1)) return;

	tempeffect(s, t, 3, chars[s].skill[MAGERY]/100, 0, 0);

	return;
}

//o---------------------------------------------------------------------------o
//|	Class		:	npcmindblasttarget(int s, int t)
//|	Date		:	Unknown
//|	Programmer	:	Unknown		(Rewrote by Tauriel - Dec 30, 1998)
//o---------------------------------------------------------------------------o
//| Purpose		:	To mindblast the target or himself if target has magic reflect
//o---------------------------------------------------------------------------o
void npcmindblasttarget(int s, int t)
{
	//npcattacktarget(t, s);
	if (!checkmagicreflect(t))
	{
		subtractmana(s, 14);
		staticeffect(t, 0x37, 0x4A, 0, 15);
		soundeffect2(s, 0x02, 0x13);

		if (checkresist(s, 5))
		{
			magicdamage(s, abs(chars[s].in-chars[t].in)/4);
		}
		else
		{
			magicdamage(s, abs(chars[s].in-chars[t].in)/2);
		}

		return;
	} 
	else 
	{
		staticeffect(s, 0x37, 0x4A, 0, 15);
		soundeffect2(t, 0x02, 0x13);

		if (chars[s].in>chars[t].in)
		{
			if (checkresist(t, 5))
			{
				magicdamage(t, (chars[s].in-chars[t].in)/4);
			}
			else
			{
				magicdamage(t, (chars[s].in-chars[t].in)/2);
			}
		}
		else
		{
			if (checkresist(s, 5))
			{
				magicdamage(s, (chars[t].in-chars[s].in)/4);
			}
			else
			{
				magicdamage(s, (chars[t].in-chars[s].in)/2);
			}
		}
		return;
	}
}

void npcmagicarrowtarget(int s, int t)
{
 int src, trg;

 //npcattacktarget(t, s);
 if (checkmagicreflect(t)) 
 {
  src=t;
  trg=s;
 }
 else
 {
  src=s;
  trg=t;
 }
 subtractmana(src, 4);
 movingeffect(src, trg, 0x36, 0xE4, 0x07, 0x00, 0x01); 
 soundeffect2(src, 0x1, 0xE5);

 if (checkresist(trg, 1))
   {
    magicdamage(trg, (2+(rand()%3)+1)*(chars[src].skill[MAGERY]/1000+1));
   }
   else 
   {
    magicdamage(trg, (2+(rand()%3)+2)*(chars[src].skill[MAGERY]/750+1));
   }

 return;
}

void npcharmtarget(int s, int t)
{
 //npcattacktarget(t, s);
 if (checkmagicreflect(t)) t=s;
 subtractmana(s, 6);
 staticeffect(t, 0x37, 0x4A, 0x09, 0x06);
 soundeffect2(t, 0x01, 0xF1);
 if (checkresist(t, 2))
 {
  magicdamage(t, chars[s].skill[MAGERY]/500+1);
  //magicdamage(t, (2+(rand()%3)+1)*(chars[currchar[s]].skill[MAGERY]/1000+1));
 }
 else 
 {
  magicdamage(t, chars[s].skill[MAGERY]/250+RandomNum(1,2));
  //magicdamage(t, (2+(rand()%4)+2)*(chars[currchar[s]].skill[MAGERY]/750+1));
 }
 return;
}

void npcparalyzetarget(int s, int t)
{
 //npcattacktarget(t, s);
 if (checkmagicreflect(t)) t=s;

 subtractmana(s, 14);
 soundeffect2(t, 0x02, 0x04);     

 if (checkresist(t, 5)) return;

 tempeffect(s, t, 1, 0, 0, 0);

 return;
}

void npcebolttarget(int s, int t)
{
 int src, trg;

 //npcattacktarget(t, s);
 if (checkmagicreflect(t))
 {
  src=t;
  trg=s;
 }
 else 
 {
  src=s;
  trg=t;
 }
 subtractmana(src, 20);
 movingeffect(src, t, 0x37, 0x9F, 0x07, 0x00, 0x01);
 soundeffect2(src, 0x2, 0x0A);

 if (checkresist(t, 6))
   {
	magicdamage(t, chars[s].skill[MAGERY]/120);
    //magicdamage(t, (4+(rand()%4)+2)*(chars[currchar[s]].skill[MAGERY]/1000+1));
   }
   else 
   {
	magicdamage(t, chars[s].skill[MAGERY]/35+RandomNum(1,10));
    //magicdamage(t, (8+(rand()%5)+4)*(chars[currchar[s]].skill[MAGERY]/750+1));
   }

 return;
}

void npcexplosiontarget(int s, int t)
{
 unsigned int i;

 if (checkmagicreflect(t)) t=s;

 subtractmana(s, 20);
 staticeffect(t, 0x36, 0xB0, 0x09, 0x09);
 soundeffect2(t, 0x02, 0x07);   

 for (i=0;i<charcount;i++)
 {
  if (chars[i].x==chars[t].x && chars[i].y==chars[t].y && chars[i].z==chars[t].z)
  {
   //npcattacktarget(i, s);
   if (checkresist(i, 6))
   {
	magicdamage(i, chars[s].skill[MAGERY]/120+RandomNum(1,5));
	//magicdamage(i, (2+(rand()%4)+1)*(chars[currchar[s]].skill[MAGERY]/1000+1));
   }
   else 
   {
	magicdamage(i, chars[s].skill[MAGERY]/40+RandomNum(1,10));
    //magicdamage(i, (10+(rand()%5)+2)*(chars[currchar[s]].skill[MAGERY]/750+1));
   }
  }
 }
 return;
}

void npccannontarget(int s, int t)
{
 unsigned int i;

 if (checkmagicreflect(t)) t=s;

 staticeffect(t, 0x36, 0xB0, 0x09, 0x09);
 soundeffect2(t, 0x02, 0x07);   

 for (i=0;i<charcount;i++)
 {
  if (chars[i].x==chars[t].x && chars[i].y==chars[t].y && chars[i].z==chars[t].z)
  {
   //npcattacktarget(i, s);
   if (checkparry(i, 6))
   {
    magicdamage(i, chars[s].skill[TACTICS]/50);
   }
   else
   {
    magicdamage(i, chars[s].skill[TACTICS]/25);
   }
  }
 }
 return;
}

char checkparry(int player, int circle)
{
	char i=checkskill(player, PARRYING, 80*circle, 800+(80*circle));;
	int s;
    if(i)
	{
		s=calcSocketFromChar(player);
		if (s!=-1)
		{
			sysmessage(s, "You have dogged the cannon blast, and have taken less damage.");
		}
	}
	return i;
}


void npcflamestriketarget(int s, int t)
{
 //npcattacktarget(t, s);
 if (checkmagicreflect(t)) t=s;
 
 subtractmana(s, 40);
 staticeffect(t, 0x37, 0x09, 0x09, 0x19);
 soundeffect2(t, 0x02, 0x08);     

 if (checkresist(t, 7))
   {
	magicdamage(t, chars[s].skill[MAGERY]/80);
    //magicdamage(t, (3+(rand()%11)+1)*(chars[currchar[s]].skill[MAGERY]/1000+1));
   }
   else 
   {
	magicdamage(t, chars[s].skill[MAGERY]/40+RandomNum(1,25));
    //magicdamage(t, (10+(rand()%12)+1)*(chars[currchar[s]].skill[MAGERY]/750+1));
   }
 return;
}

void magicarrowspellitem(int attaker, int defender)
{
   int  src;
   if (checkmagicreflect(defender)) 
   {
    src=defender;
    defender=currchar[attaker];
   }
   else
   {
    src=currchar[attaker];
   }
   movingeffect(src, defender, 0x36, 0xE4, 0x05, 0x00, 0x01); 
   soundeffect2(src, 0x1, 0xE5);
   if (checkresist(defender, 1))
   {
    magicdamage(defender, (1+(rand()%1)+1)*(chars[src].skill[MAGERY]/2000+1));
   }
   else 
   {
    magicdamage(defender, (1+(rand()%1)+2)*(chars[src].skill[MAGERY]/1500+1));
   }
   return;
}
void clumsyspellitem(int attaker, int defender)
{
   if (checkmagicreflect(defender)) defender=currchar[attaker];
   staticeffect(defender, 0x37, 0x4A, 0, 15); 
   soundeffect2(defender, 0x01, 0xDF);
   if (checkresist(defender, 1)) return;
   tempeffect(currchar[attaker], defender, 3, chars[currchar[attaker]].skill[MAGERY]/100, 0, 0);
   return;
}
void feeblemindspellitem(int attaker, int defender)
{
   if (checkmagicreflect(defender)) defender=currchar[attaker];
   staticeffect(defender, 0x37, 0x4A, 0, 15); 
   soundeffect2(defender, 0x01, 0xE4);     
   if (checkresist(defender, 1)) return;
   tempeffect(currchar[attaker], defender, 4, chars[currchar[attaker]].skill[MAGERY]/100, 0, 0);
   return;
}
void weakenspellitem(int attaker, int defender)
{
   if (checkmagicreflect(defender)) defender=currchar[attaker];
   staticeffect(defender, 0x37, 0x4A, 0, 15); 
   soundeffect2(defender, 0x01, 0xE6);     
   if(checkresist(defender, 1)) return;
   tempeffect(currchar[attaker], defender, 5, chars[currchar[attaker]].skill[MAGERY]/100, 0, 0);
   return;
}
void harmspellitem(int attaker, int defender)
{
   if (checkmagicreflect(defender)) defender=currchar[attaker];
   staticeffect(defender, 0x37, 0x4A, 0x09, 0x06);
   soundeffect2(defender, 0x01, 0xF1);     
   if (checkresist(defender, 2))
   {
    magicdamage(defender, chars[currchar[attaker]].skill[MAGERY]/500+1);
   }
   else 
   {
    magicdamage(defender, chars[currchar[attaker]].skill[MAGERY]/250+RandomNum(1,2));
   }
   return;
}
void fireballspellitem(int attaker, int defender)
{
   int src;
   if (checkmagicreflect(defender))
   {
    src=defender;
    defender=currchar[attaker];
   }
   else src=currchar[attaker];
   movingeffect(src, defender, 0x36, 0xD5, 0x07, 0x00, 0x01);
   soundeffect2(src, 0x1, 0x5E);
   if (checkresist(defender, 3)) magicdamage(defender, chars[src].skill[MAGERY]/280+1);
   else magicdamage(defender, chars[src].skill[MAGERY]/140+RandomNum(1,4));
   
   return;
}
void cursespellitem(int attaker, int defender)
{
   int j;
   if (checkmagicreflect(defender)) defender=currchar[attaker];
   staticeffect(defender, 0x37, 0x4A, 0, 15); 
   soundeffect2(defender, 0x01, 0xE1);     
   if(checkresist(defender, 1)) return;
   j=chars[currchar[attaker]].skill[MAGERY]/100;
   tempeffect(currchar[attaker], defender, 12, j, j, j);
   return;
}
void lightningspellitem(int attaker, int defender)
{
   if (checkmagicreflect(defender)) defender=currchar[attaker];
   bolteffect(defender);
   soundeffect2(defender, 0x00, 0x29);
   if (checkresist(defender, 4))
   {
    magicdamage(defender, chars[currchar[attaker]].skill[MAGERY]/180+RandomNum(1,2));
   }
   else 
   {
    magicdamage(defender, chars[currchar[attaker]].skill[MAGERY]/90+RandomNum(1,5));
   }
   return;
}
void mindblastspellitem(int attaker, int defender)
{
   
   if (checkmagicreflect(defender))
   {
    //Reflected
    staticeffect(attaker, 0x37, 0x4A, 0, 15);
    soundeffect2(currchar[attaker], 0x02, 0x13);
    if (checkresist(currchar[attaker], 5))
    {
     magicdamage(currchar[attaker], abs(chars[currchar[attaker]].in-chars[defender].in)/4);
    }
    else
    {
     magicdamage(currchar[attaker], abs(chars[currchar[attaker]].in-chars[defender].in)/2);
    }
    return;
   } else {
    //Not Reflected
    staticeffect(defender, 0x37, 0x4A, 0, 15);
    soundeffect2(defender, 0x02, 0x13);
    if (chars[currchar[attaker]].in>chars[defender].in)
    {
     if (checkresist(defender, 5))
     {
      magicdamage(defender, (chars[currchar[attaker]].in-chars[defender].in)/4);
     }
     else
     {
      magicdamage(defender, (chars[currchar[attaker]].in-chars[defender].in)/2);
     }
    }
    else
    {
     if (checkresist(currchar[attaker], 5))
     {
      magicdamage(currchar[attaker], (chars[defender].in-chars[currchar[attaker]].in)/4);
     }
     else
     {
      magicdamage(currchar[attaker], (chars[defender].in-chars[currchar[attaker]].in)/2);
     }
    }
   }
   return;
}
void paralyzespellitem(int attaker, int defender)
{
  if (checkmagicreflect(defender)) defender=currchar[attaker];
   //staticeffect(currchar[s], 0x37, 0x35, 0, 30); //No effect for paralyze?
   soundeffect2(defender, 0x02, 0x04);     
   if (checkresist(defender, 5)) return;
   tempeffect(currchar[attaker], defender, 1, 0, 0, 0);
   return;
  }
void explosionspellitem(int attaker, int defender)
{
   if (checkmagicreflect(defender)) defender=currchar[attaker];
   staticeffect(defender, 0x36, 0xB0, 0x09, 0x09);
   soundeffect2(defender, 0x02, 0x07);   
   if (checkresist(defender, 6))
   {
	magicdamage(defender, chars[currchar[attaker]].skill[MAGERY]/120+RandomNum(1,5));
   }
   else 
   {
    magicdamage(defender, chars[currchar[attaker]].skill[MAGERY]/40+RandomNum(1,10));
   }
   return;
}
void flamestrikespellitem(int attaker, int defender)
{
   if (checkmagicreflect(defender)) defender=currchar[attaker];
   staticeffect(defender, 0x37, 0x09, 0x09, 0x19);
   soundeffect2(defender, 0x02, 0x08);     
   if (checkresist(defender, 7))
   {
	magicdamage(defender, chars[currchar[attaker]].skill[MAGERY]/80);
   }
   else 
   {
    magicdamage(defender, chars[currchar[attaker]].skill[MAGERY]/(40+RandomNum(1,25)));
   }
   return;
}
