/* House code for deed creation by Tal Strake, revised by Cironian */

#include "uox3.h"
#include "debug.h"

#define DBGFILE "house.cpp"

void mtarget(int s, int a1, int a2, int a3, int a4, char b1, char b2, char *txt)
{
 char multitarcrs[27]="\x99\x01\x40\x01\x02\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x00\x00\x00\x00\x00\x00";

 targetok[s]=1; 
 multitarcrs[2]=a1;
 multitarcrs[3]=a2;
 multitarcrs[4]=a3;
 multitarcrs[5]=a4;
 multitarcrs[18]=b1;
 multitarcrs[19]=b2;
 sysmessage(s, txt);
 xsend(s, multitarcrs, 26, 0);
}

void buildhouse(int s, int i)
{
//o---------------------------------------------------------------------------o
//|   Function    -  void buildhouse(int s, int i)
//|   Date        -  UnKnown - Rewrite Date 1/24/99
//|   Programmer  -  UnKnown - Rewrite by Zippy (onlynow@earthlink.net)
//o---------------------------------------------------------------------------o
//|   Purpose     -  Triggered by double clicking a deed-> the deed's moreX is read
//|						for the house section in house.scp. Extra items can be added
//|						using HOUSE ITEM, (this includes all doors!) and locked "LOCK"
//|						Space around the house with SPACEX/Y and CHAR offset CHARX/Y/Z
//o---------------------------------------------------------------------------o
 int x,y,z,house,key;//where they click, and the house/key items
 int sx=0,sy=0;//space around the house needed
 int k,l,tmp;//Temps
 int hitem[100], icount=0;//extra "house items" (up to 100)
 char sect[512];//file reading
 char id1,id2;//house ID
 static int looptimes=0;//for targeting
 long int pos;//for files...
 int cx=0,cy=0,cz=8;//where the char is moved to when they place the house (Inside, on the steps.. etc...)(Offset)

 hitem[0]=0;//avoid problems if there are no HOUSE_ITEMs by initializing the first one as 0
 if (i)
 {
	openscript("house.scp");
	sprintf(sect, "HOUSE %d", i);//and BTW, .find() adds SECTION on there for you....
	if (!(house_script.find(sect)))
	{
	  closescript();
	  return;
	}
	do
	{
		read2();
		if (script1[0]!='}')
		{
			if (!(strcmp(script1,"ID")))
			{
				tmp=hstr2num(script2);
				id1=tmp/256;
				id2=tmp%256;
			}
			if (!(strcmp(script1,"SPACEX")))
			{
				sx=str2num(script2)+1;
			}
			if (!(strcmp(script1,"SPACEY")))
			{
				sy=str2num(script2)+1;
			}
			if (!(strcmp(script1,"CHARX")))
			{
				cx=str2num(script2);
			}
			if (!(strcmp(script1,"CHARY")))
			{
				cy=str2num(script2);
			}
			if (!(strcmp(script1,"CHARZ")))
			{
				cz=str2num(script2);
			}
			if (!(strcmp(script1,"HOUSE_ITEM")))
			{
				hitem[icount]=str2num(script2);
				icount++;
			}
		}
	} while (strcmp(script1,"}"));
	closescript();
	if (!id1)
	{
		printf("ERROR: Bad house script # %i!\n",i);
		return;
	}
	//i=0;
 } //else
 if(!looptimes)
 {
	 if (i)
	 {
		  addid1[s]=0x40;addid2[s]=100;//Used in addtarget
		  mtarget(s, 0, 1, 0, 0, id1-0x40, id2, "Select location for building.");
	 } else {
		  mtarget(s, 0, 1, 0, 0, addid1[s]-0x40, addid2[s], "Select location for building.");
	 }
	 looptimes++;//for when we come back after they target something
	 return;
 }
 if(looptimes)
 {
  looptimes=0;
  x=(buffer[s][11]*256)+buffer[s][12];//where they targeted
  y=(buffer[s][13]*256)+buffer[s][14];
  z=buffer[s][16]+tileheight(buffer[s][17]*256+buffer[s][18]);
  for (k=-sx;k<sx;k++)//check the SPACEX and SPACEY to make sure they are valid locations....
  {
	  for (l=-sy;l<sy;l++)
	  {
		  if ((!validNPCMove(x+k,y+l,z,currchar[s]))&&
			  ((chars[currchar[s]].x!=x+k)&&(chars[currchar[s]].y!=y+l)))
			  /*This will take the char making the house out of the space check, be careful 
			  you don't build a house on top of your self..... this had to be done So you 
			  could extra space around houses, (12+) and they would still be buildable.*/
		  {
			  sysmessage(s, "You cannot build your house there.");
			  return;
			  //printf("Invalid %i,%i [%i,%i]\n",k,l,x+k,y+l);
		  } //else printf("DEBUG: Valid at %i,%i [%i,%i]\n",k,l,x+k,y+l);
	  }
  }

  /*-=For Multi checking=- I couldn't get it working (Sampled from walking()...
  Must make seekmulti public to use. Not to mention itemcount fors are EVIL laggers :-)

  long int pos, pos2, length, fpos;
  FILE *mfile;
  st_multi multi;
  int a,b;
  for (a=0;a<itemcount;a++)
  {
  	if (items[a].id1>=0x40)
	{
		seekmulti((items[a].id1*256+items[a].id2)-0x4000, &mfile, &length);
		length=length/sizeof(st_multi);
		if (length == -1)
		{
               printf("walking() - Bad length in multi file. Avoiding stall.\n");
               length = 0;
		}
		for (b=0;b<length;b++)
		{
			for (k=-sx;k<sx;k++)
			{
				for (l=-sy;l<sy;l++)
				{
					fread(&multi, sizeof(st_multi), 1, mfile);
					if ((x+k==multi.x+x)||(y+l==multi.y+l))
					{
						printf("DEBUG: Error at: %i,%i [Multi: %i,%i]\n",multi.x+x,multi.y+y,multi.x,multi.y);
						sysmessage(s,"A building is blocking that location.");
						return;
					}
				}
			}
		}
	 }
  }*/

  sprintf(temp,"%s's house",chars[currchar[s]].name);//This will make the little deed item you see when you have showhs on say the person's name, thought it might be helpful for GMs.
  house=SpawnItem(s,1,temp,0,id1,id2,NULL,NULL,0,0);

  chars[currchar[s]].making=0;
  if (i)
	deleitem(chars[currchar[s]].fx1); // this will del the deed no matter where it is

  chars[currchar[s]].fx1=-1; //reset fx1 so it does not interfere
  items[house].x=x;
  items[house].y=y;
  items[house].z=z;
  items[house].priv=0;
  
  if (!hitem[0])
  {
	  teleport(currchar[s]);
	  all_items(s);
	  return;//If there's no extra items, we don't really need a key, or anything else do we? ;-)
  }
  //Key...
  if (id2>=112&&id2<=115) key=SpawnItem(s, 1, "a tent key", 0, 0x10, 0x10, 0, 0,1,1);//iron key for tents
  else key=SpawnItem(s, 1, "a house key", 0, 0x10, 0x0F, 0, 0,1,1);//gold key for everything else
  items[key].more1=items[house].ser1;//use the house's serial for the more on the key to keep it unique
  items[key].more2=items[house].ser2;
  items[key].more3=items[house].ser3;
  items[key].more4=items[house].ser4;
  items[key].type=7;

  for (k=0;k<icount;k++)//Loop through the HOUSE_ITEMs
  {
	  openscript("house.scp");
	  sprintf(sect,"HOUSE ITEM %i",hitem[k]);
	  if (!house_script.find(sect))
	  {
		  closescript();
	  } else {
		  do 
		  {
			  read2();
			  if (script1[0]!='}')
			  {
				  if (!(strcmp(script1,"ITEM")))
				  {
					  pos=ftell(scpfile);// To prevent accidental exit of loop.
					  closescript();
					  l=CreateScriptItem(s,str2num(script2),0);//This opens the item script... so we gotta keep track of where we are with the other script.
					  openscript("house.scp");
					  fseek(scpfile, pos, SEEK_SET);
					  sprintf(script1, "ITEM");
					  items[l].magic=2;//Non-Movebale by default
					  items[l].priv=0;//since even things in houses decay, no-decay by default
					  items[l].x=x;
					  items[l].y=y;
					  items[l].z=z;
					  //printf("[%i,%i,%i] Item %i\n",items[l].x,items[l].y,items[l].z,l);
				  }
				  if (!(strcmp(script1,"DECAY")))
				  {
					  items[l].priv=items[l].priv|0x01;
				  }
				  if (!(strcmp(script1,"NODECAY")))
				  {
					  items[l].priv=0;
				  }
				  if (!(strcmp(script1,"PACK")))//put the item in the Builder's Backpack
				  {
					  items[l].cont1=items[packitem(currchar[s])].ser1;
					  items[l].cont2=items[packitem(currchar[s])].ser2;
					  items[l].cont3=items[packitem(currchar[s])].ser3;
					  items[l].cont4=items[packitem(currchar[s])].ser4;
					  items[l].contserial=items[packitem(currchar[s])].serial;
					  items[l].x=rand()%90+31;
					  items[l].y=rand()%90+31;
					  items[l].z=9;
				  }
				  if (!(strcmp(script1,"MOVEABLE")))
				  {
					  items[l].magic=1;
				  }
				  if (!(strcmp(script1,"LOCK")))//lock it with the house key
				  {
					  items[l].more1=items[house].ser1;
					  items[l].more2=items[house].ser2;
					  items[l].more3=items[house].ser3;
					  items[l].more4=items[house].ser4;
				  }
				  if (!(strcmp(script1,"X")))//offset + or - from the center of the house:
				  {
					  items[l].x=x+str2num(script2);
				  }
				  if (!(strcmp(script1,"Y")))
				  { 
					  items[l].y=y+str2num(script2);
				  }
				  if (!(strcmp(script1,"Z")))
				  {
					  items[l].z=z+str2num(script2);
				  }
			  }
		  } while (strcmp(script1,"}"));
		  closescript();
	  }
  }
  all_items(s);//make sure they have all the items Sent....
  chars[currchar[s]].x=x+cx; //move char inside house
  chars[currchar[s]].y=y+cy;
  chars[currchar[s]].dispz=chars[currchar[s]].z=z+cz;
  //printf("Z: %i Offset: %i Char: %i Total: %i\n",z,cz,chars[currchar[s]].z,z+cz);
  teleport(currchar[s]);
 }
  //All the Old house code->
  /*if ((num==100)||(num==102)||(num==104)||(num==106)||(num==108)||(num==110)) // Small houses w/o special furniture
  {
   printf(items[house].name, "small house");
   addid1[s]=0x06;addid2[s]=0xE5; // Door
   x=hx;
   y=hy+3;
   z=hz+7;
   chars[currchar[s]].making=999;
   addthere(s,x,y,z,12);
   door=chars[currchar[s]].making;
   items[door].more1=items[house].ser1;
   items[door].more2=items[house].ser2;
   items[door].more3=items[house].ser3;
   items[door].more4=items[house].ser4;
   items[door].priv=0;
   chars[currchar[s]].making=999; // Key
   key=SpawnItem(s, 1, "a house key", 0, 0x10, 0x0F, 0, 0,1,1);
   //key=chars[currchar[s]].making;
   items[key].more1=items[house].ser1;
   items[key].more2=items[house].ser2;
   items[key].more3=items[house].ser3;
   items[key].more4=items[house].ser4;
   items[key].type=7;
   addid1[s]=0x0B;addid2[s]=0xD2; // Sign
   x=hx+2;
   y=hy+4;
   z=hz+5;
   chars[currchar[s]].making=999;
   addthere(s,x,y,z,0);
   sign=chars[currchar[s]].making;
   items[sign].more1=items[house].ser1;
   items[sign].more2=items[house].ser2;
   items[sign].more3=items[house].ser3;
   items[sign].more4=items[house].ser4;
   items[sign].priv=0;
   sprintf(items[sign].name, "Home of %s", chars[currchar[s]].name);
  }
  else if ((num==112)||(num==114)) // Tents
  {
   printf(items[house].name, "tent");
   addid1[s]=0x0E;addid2[s]=0x43; // Chest
   x=hx;
   y=hy-2;
   z=hz+1;
   chars[currchar[s]].making=999;
   addthere(s,x,y,z,1);
   door=chars[currchar[s]].making;
   items[door].more1=items[house].ser1;
   items[door].more2=items[house].ser2;
   items[door].more3=items[house].ser3;
   items[door].more4=items[house].ser4;
   items[door].priv=0;
   chars[currchar[s]].making=999; // Key
   key=SpawnItem(s, 1, "a tent key", 0, 0x10, 0x0F, 0, 0,1,1);
   //key=chars[currchar[s]].making;
   items[key].more1=items[house].ser1;
   items[key].more2=items[house].ser2;
   items[key].more3=items[house].ser3;
   items[key].more4=items[house].ser4;
   items[key].type=7;
  }
  else if (num==116) // large brick house
  {
   printf(items[house].name, "large brick house");
   chars[currchar[s]].making=999; // Key
   key=SpawnItem(s, 1, "a house key", 0, 0x10, 0x0F, 0, 0,1,1);
   //key=chars[currchar[s]].making;
   items[key].more1=items[house].ser1;
   items[key].more2=items[house].ser2;
   items[key].more3=items[house].ser3;
   items[key].more4=items[house].ser4;
   items[key].type=7;
   addid1[s]=0x0B;addid2[s]=0xD2; // Sign
   x=hx+3;
   y=hy+7;
   z=hz+5;
   chars[currchar[s]].making=999;
   addthere(s,x,y,z,0);
   sign=chars[currchar[s]].making;
   items[sign].more1=items[house].ser1;
   items[sign].more2=items[house].ser2;
   items[sign].more3=items[house].ser3;
   items[sign].more4=items[house].ser4;
   items[sign].priv=0;
   sprintf(items[sign].name, "Home of %s", chars[currchar[s]].name);
   addid1[s]=0x06;addid2[s]=0xE5; // Front left door
   x=hx-1;
   y=hy+6;
   z=hz+7;
   chars[currchar[s]].making=999;
   addthere(s,x,y,z,12);
   door=chars[currchar[s]].making;
   items[door].more1=items[house].ser1;
   items[door].more2=items[house].ser2;
   items[door].more3=items[house].ser3;
   items[door].more4=items[house].ser4;
   items[door].priv=0;
   addid1[s]=0x06;addid2[s]=0xE7; // Front right door
   x=hx;
   y=hy+6;
   z=hz+7;
   chars[currchar[s]].making=999;
   addthere(s,x,y,z,12);
   door=chars[currchar[s]].making;
   items[door].more1=items[house].ser1;
   items[door].more2=items[house].ser2;
   items[door].more3=items[house].ser3;
   items[door].more4=items[house].ser4;
   items[door].priv=0;
   addid1[s]=0x06;addid2[s]=0xA5; // Back left door
   x=hx-3;
   y=hy-1;
   z=hz+7;
   chars[currchar[s]].making=999;
   addthere(s,x,y,z,12);
   door=chars[currchar[s]].making;
   items[door].priv=0;
   addid1[s]=0x06;addid2[s]=0xA5; // Back right door
   x=hx+3;
   y=hy-1;
   z=hz+7;
   chars[currchar[s]].making=999;
   addthere(s,x,y,z,12);
   door=chars[currchar[s]].making;
   items[door].priv=0;
  }
  chars[currchar[s]].making=999;*/
}

void addthere(int s, int xx, int yy, int zz, int t)
{
 int c;
	unsigned int j;
//printf("addthere!x=%d y=%d z=%d\n",xx,yy,zz);
 tile_st tile;

/* c=memitemfree();
 
 inititem(c);
 sprintf(items[c].name,"#");*/
 c=SpawnItem(s,1,"#",0,addid1[s],addid2[s],0,0,0,0);
/* items[c].ser1=itemcount2/16777216;
 items[c].ser2=itemcount2/65536;
 items[c].ser3=itemcount2/256;
 items[c].ser4=itemcount2;
 items[c].id1=addid1[s];
 items[c].id2=addid2[s];*/
 items[c].x=xx;
 items[c].y=yy;
 items[c].z=zz;
 items[c].amount=1;
 items[c].doordir=0;
 items[c].type=t;
 seektile((items[c].id1*256)+items[c].id2, &tile);
 if(chars[currchar[s]].making==999) chars[currchar[s]].making=c; // store item #
 if(tile.flag2&0x08) items[c].pileable=1;
 for (j=0;j<now;j++) if (perm[j]) senditem(j,c);
/* if (c==itemcount) itemcount++;
 itemcount2++;*/
 addid1[s]=0;
 addid2[s]=0;
}

