#include "uox3.h"
#include "debug.h"

#define DBGFILE "combat.cpp"

int getbowtype(int i)
{
  int j,serial,serhash,ci;
  serial=chars[i].serial;
  serhash=serial%256;
  /*for(j=0;j<itemcount;j++)
  {
    if ((items[j].cont1==chars[i].ser1)&&(items[j].cont2==chars[i].ser2)&&(items[j].cont3==chars[i].ser3)&&
        (items[j].cont4==chars[i].ser4)*/
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    j=contsp[serhash].pointer[ci];
    if ((j!=-1) && (items[j].contserial==serial) && ((items[j].layer==1) || (items[j].layer==2)))
    {
      if ((items[j].id1==0x13)&&(items[j].id2==0xB1)) return(1); // Bows
      if ((items[j].id1==0x13)&&(items[j].id2==0xB2)) return(1);
      if ((items[j].id1==0x0F)&&(items[j].id2==0x4F)) return(2); // Crossbows
      if ((items[j].id1==0x0F)&&(items[j].id2==0x50)) return(2);
      if ((items[j].id1==0x13)&&(items[j].id2==0xFC)) return(3); // Heavy Crossbows
      if ((items[j].id1==0x13)&&(items[j].id2==0xFD)) return(3);
    }
  }
  return 0;
}

void combat(int i, unsigned int currenttime)
{
	int x, k, c, combathit, fightskill, damage, spattacks, spattackbit, basedamage, arrowsquant, bowtype=0, spamanachecking;//, tmp;
	char t[120];
  int splitcount=0, ifsplit=0, splitnum=0;
	int j, los;


	if ((i < 0) || (i >= MAXCHARS))
	{
		LogMessage("combat() - bad attacker (%i)\n"_ i);
		return;
	}
	if (((chars[i].npc)||(online(i)))&&(chars[i].targ!=-1))
	{
		k=-1;
		for (j=0;j<charcount;j++)
			if (j==chars[i].targ)
		  {
			  k=j;
			  break;
		  }
		if (k!=-1)
		if ((chars[k].npc) || (online(k)))
		{
			if (chardist(i,k)>=13)
			{
				if ((chars[i].npcaitype==0x40)&&((region[chars[i].region].priv&0x01 == 1)))
				{
					printf("HALT: %s, %s\n",chars[i].name,chars[k].name);
					chars[i].x=chars[k].x+1;
					chars[i].y=chars[k].y;
					chars[i].dispz=chars[i].z=chars[k].z;
					teleport(i);
					soundeffect(i, 0x01, 0xFE);
					staticeffect(i, 0x37, 0x2A, 0x09, 0x06);
					npctalkall(i,"Halt, scoundrel!");
				}
				else
				{
					chars[i].targ=-1;
					chars[i].timeout=0;
					chars[chars[i].attacker].attacker=-1;
					chars[chars[i].attacker].attackfirst=0;
					chars[i].attacker=-1;
					chars[i].attackfirst=0;
					if (chars[i].npc && chars[i].war) npcToggleCombat(i);
				}
			}
			if (chardist(i,k)<=12)
			{
				if (chars[k].targ==-1)
				{
					npcsimpleattacktarget(i,k);
					x=(((100-chars[i].dx)*CLOCKS_PER_SEC)/25)+(1*CLOCKS_PER_SEC); //Yet another attempt.
					chars[i].timeout=currenttime+x;
				}
				if (timerok(i))
				{
					fightskill=getcombatskill(i);
					x=0;
					if (fightskill==ARCHERY)
					{
					 if (los=line_of_sight(calcSocketFromChar(i),chars[i].x,chars[i].y,chars[i].z,chars[k].x,chars[k].y,chars[k].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING))
					 {
						bowtype=getbowtype(i);
						if (bowtype==1) arrowsquant=getamount(i, 0x0F, 0x3F);
						else arrowsquant=getamount(i, 0x1B, 0xFB);
						if (arrowsquant>0) x=1;
					 }
					}
					if ((chardist(i,k)<2)&&(fightskill!=ARCHERY)) x=1;
					if (x)
					{
						x=(chars[i].id1*256)+chars[i].id2;
						if (x<0x0190)
						{
							npcaction(i, 4+(rand()%3));
							playmonstersound(i, chars[i].id1, chars[i].id2, SND_ATTACK);
						}
						else if (chars[i].onhorse)
						{
							//combatonhorse(i) determines weapon in hand and runs animation
							combatonhorse(i); //kolours - single inline function (09/19/98)
						}
						else
						{
							//combatonfoot(i) determines weapon in hand and runs animation
							combatonfoot(i); //kolours - single inline function (09/19/98)
						}
						if (fightskill==ARCHERY)
						{
						 if (los)
						 {
							if (bowtype==1)
							{
								delequan(i, 0x0F, 0x3F, 1);
								movingeffect(i, k, 0x0F, 0x42, 0x08, 0x00, 0x00);
							}
							else
							{
								delequan(i, 0x1B, 0xFB, 1);
								movingeffect(i, k, 0x1B, 0xFE, 0x08, 0x00, 0x00);
							}
						 }
						}
						// Formulas take from OSI's combat formulas
						// attack speed should be determined here.
						// attack speed = 15000 / ((DEX+100) * weapon speed)
						if (((chardist(i,k)<2)||(fightskill==ARCHERY))&&!(chars[i].npcaitype==0x40))
                        {
						 if (los)
						 {
						  npcsimpleattacktarget(i,k);
						 }
						}
						checkskill(i, fightskill, 0, 1000);  // increase fighting skill for attacker and defender
						if (chars[k].skill[fightskill]>500)
							x=(int)(100*(chars[i].skill[fightskill]/500.0)/((chars[k].skill[fightskill]/500.0)*2.0));  // Chance to hit
						else x=(int)(100*(chars[i].skill[fightskill]/500.0));  // defender has no fightskill
						if ((rand()%100)<=x) combathit=1;
						else combathit=0;
						if (combathit==0)
						{
							if ((fightskill==ARCHERY)&&(los))
							{
								if (chars[i].npc==0) soundeffect2(i, 0x2, 0x38);
								x=RandomNum(1,3);
								if (x==1)
								 {
                  /*c=memitemfree();

									inititem(c);*/
                  c=SpawnItem(calcSocketFromChar(i),1,"#",1,0x0E,0x75,0,0,0,0);
									/*sprintf(items[c].name,"#");
									items[c].ser1=itemcount2/16777216;
									items[c].ser2=itemcount2/65536;
									items[c].ser3=itemcount2/256;
									items[c].ser4=itemcount2;*/
									if (bowtype==1) items[c].id1=0x0F; else items[c].id1=0x1B;
									if (bowtype==1) items[c].id2=0x3F; else items[c].id2=0xFB;
									//items[c].pileable=1;
									items[c].x=chars[k].x;
									items[c].y=chars[k].y;
									items[c].z=chars[k].z;
									//items[c].priv=items[c].priv|0x01;
								  for (j=0;j<now;j++) if (perm[j]) senditem(j,c);
									/*if (c==itemcount) itemcount++;
									itemcount2++;*/
								}
							}
							else if (chars[i].npc==0) soundeffect2(i, 0x2, 0x38);
						}
						if (combathit==1)
						{
							if (!(chars[k].priv&4))
							{
								checkskill(i, TACTICS, 0, 1000);
								if (chars[k].xid2==0x91) soundeffect2(k,0x01,0x4b);
								if (chars[k].xid2==0x90) soundeffect2(k,0x01,0x56);
								playmonstersound(k, chars[k].id1, chars[k].id2, SND_DEFEND);
								//Algaran 11-24-98 chars[k].priv2=chars[k].priv2&0xFD;
                if ((chars[k].dx>0))
                {
                  chars[k].priv2=chars[k].priv2&0xFD;
                }
								if (fightskill!=WRESTLING || fightskill!=ARCHERY)
								{
								 if (los=line_of_sight(calcSocketFromChar(i),chars[i].x,chars[i].y,chars[i].z,chars[k].x,chars[k].y,chars[k].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING))
								 {
								  itemspell(i, k);
								 }
								}
								
								if ((chars[k].poison)&&(chars[i].poisoned<chars[k].poison))
								{
									x=RandomNum(1,3);
									if (x==1)
									{
										chars[i].poisoned=chars[k].poison;
										sprintf(t,"*%s has poisoned %s!*",chars[k].name,chars[i].name);
										npctalkall(i,t);
									}
								}
								if (fightskill!=WRESTLING || chars[i].npc==1) basedamage=calcatt(i); // Calc base damage
								else
								{
									if ((chars[i].skill[WRESTLING]/100) > 0) basedamage=rand()%(chars[i].skill[WRESTLING]/100);
									else basedamage=rand()%2;
								}
								damage=(int)(basedamage*((chars[i].skill[TACTICS]+500.0)/1000.0)); // Add Tactical bonus
								damage=damage+(int)((basedamage*(chars[i].st/500.0))); // Add Strength bonus
								j=getshield(k);
								if(j>0)
								{
									checkskill(k, PARRYING, 0, 1000);// increase parrying skill
									if (rand()%100<=(chars[k].skill[PARRYING]/2.0))// chance to block with shield
									{
										//Algaran 11-24-98 damage-=rand()%(items[j].def/2)+items[j].def/2;  // damage absorbed by shield
                    damage-=rand()%(items[j].def);  // damage absorbed by shield
										if((rand()%2)==0) items[j].hp--; //Take off a hit point
										if(items[j].hp<=0)
										{
											sysmessage(calcSocketFromChar(k),"Your shield has been destroyed");
											deleitem(j);
										}
									}
								}
								x=rand()%100;// determine area of body hit
								if (server_data.combathitmessage!=1)
								{
									if (x<=44) x=1; // body
									else if (x<=58) x=2; // arms
									else if (x<=72) x=3; // head
									else if (x<=86) x=4; // legs
									else if (x<=93) x=5; // neck
									else x=6; // hands
								}
								if (server_data.combathitmessage==1)
								{
									int hitin;
									int player;
									player=calcSocketFromChar(k);
									if ((chars[k].npc==0)&&(player != -1))
									{
										hitin = rand()%2;
										if (x<=44)
										{
											x=1;       // body
											switch (hitin)
											{
											case 1:
												//later take into account dir facing attacker during battle
												if (damage < 10) sprintf(temp,"Hit in your Chest!");
												if (damage >=10) sprintf(temp,"Terrible blow to your Chest!");
												break;
											case 2:
												if (damage < 10) sprintf(temp,"Blow to your Stomach!");
												if (damage >=10) sprintf(temp,"You get the wind knocked out of you!");
												break;
											default:
												if (damage < 10) sprintf(temp,"Hit in your Ribs!");
												if (damage >=10) sprintf(temp,"Was that a Rib that broke?!");
												break;
											}
										}
										else if (x<=58)
										{
											x=2;  // arms
											switch (hitin)
											{
											case 1:
												if (damage > 1) sprintf(temp,"Hit in Left Arm!");
												break;
											case 2:
												if (damage > 1) sprintf(temp,"Hit in Right Arm!");
												break;
											default:
												if (damage > 1) sprintf(temp,"Hit in Right Arm!");
												break;
											}
										}
										else if (x<=72)
										{
											x=3;  // head
											switch (hitin)
											{
											case 1:
												if (damage < 10) sprintf(temp,"Hit you straight in the Face!");
												if (damage >=10) sprintf(temp,"Stunning blow to your Head!");
												break;
											case 2:
												if (damage < 10) sprintf(temp,"Hit to your Head!"); //kolours - (09/19/98)
												if (damage >=10) sprintf(temp,"Smashing blow across your Face!");
												break;
											default:
												if (damage < 10) sprintf(temp,"Hit you square in the Jaw!");
												if (damage >=10) sprintf(temp,"Terrible hit to your Temple!");
												break;
											}
										}
										else if (x<=86) 
										{
											x=4;  // legs
											switch (hitin)
											{
											case 1:
												sprintf(temp,"Hit in Left Thigh!");
												break;
											case 2:
												sprintf(temp,"Hit in Right Thigh!");
												break;
											default:
												sprintf(temp,"Hit in Groin!");
												break;
											}
										}
										else if (x<=93)
										{
											x=5;  // neck
											sprintf(temp,"Hit to your Throat!");
										}
										else
										{
											x=6;  // hands
											switch (hitin)
											{
											case 1:
												if (damage > 1) sprintf(temp,"Hit in Left Hand!");
												break;
											case 2:
												if (damage > 1) sprintf(temp,"Hit in Right Hand!");
												break;
											default:
												if (damage > 1) sprintf(temp,"Hit in Right Hand!");
												break;
											}
										}
										if (chars[k].npc == 0) sysmessage(player, temp); //kolours -- hit display
									}
								}
								j=calcdef(k,x);
								//Algaran 11-24-98 if (j>=2) damage=damage - (j-(rand()%(j/2)));   // subtract armor absorbtion
                if (j>=2) damage=1 + (damage / (((j+40)*(j+40))/1600));   // subtract armor absorbtion
								if (chars[k].npc==0) damage=damage/2;             // halve damage against other players
								if(damage>0)
                {
                  if (chars[k].ra) // For reactive armor spell
								  {
									  int damage1;
									  damage1=(int)( damage*(chars[currchar[k]].skill[MAGERY]/2000.0));
									  chars[k].hp -= damage-damage1;
									  if (chars[k].npc==1) damage1 = damage1 * 2;
									  chars[i].hp -= damage1;
								  }

                  else chars[k].hp-=damage;                 // Remove damage
								  /////////  For Splitting NPCs ///  McCleod
                  if ((chars[k].split>0)&&(chars[k].hp>=1))
                  {
                    ifsplit=rand()%100;
                    if (ifsplit<=chars[k].splitchnc)
                    {
                      splitnum=RandomNum(1,chars[k].split);
                      if (chars[k].split==1) splitnum=1;
                      for (splitcount=1;splitcount<=splitnum;splitcount++)
                      {
                        split(k);
                      }
                      if (splitnum==1) sprintf(temp,"You see %s split once.",chars[k].name);
                      if (splitnum>1) sprintf(temp,"You see %s split into %i .",chars[k].name,splitnum);
                      if (chars[i].npc == 0) sysmessage(calcSocketFromChar(i), temp);
                    }
                  }
                  ////////      End of spliting NPCs
                }
								if (chars[i].npc==0)
								{
									if ((fightskill==ARCHERY)&&(los)) soundeffect2(i, 0x2, 0x34);
									else if ((fightskill!=WRESTLING)&&(fightskill!=ARCHERY)) soundeffect2(i, 0x2, 0x3B);
								}
								if (chars[k].hp<0) chars[k].hp=0;
								updatestats(k, 0);
								x=(chars[k].id1*256)+chars[k].id2;
								if (x>=0x0190)
								{
									if (!chars[k].onhorse) npcaction(k, 0x14);
								}
							}
						}
  		    }
					j = getweapon(i); //Get the number of the weapon
					if (items[j].spd==0) items[j].spd=35;
					if (!(j==-1))
						x = (15000 / ((chars[i].dx+100) * items[j].spd)*CLOCKS_PER_SEC); //Calculate combat delay
					
					if (j==-1)
					{
						j=30;
						if(chars[i].skill[WRESTLING]>200) j=35;
						if(chars[i].skill[WRESTLING]>400) j=40;
						if(chars[i].skill[WRESTLING]>600) j=45;
						if(chars[i].skill[WRESTLING]>800) j=50;
						x = (15000 / ((chars[i].dx+100) * j)*CLOCKS_PER_SEC);
					}
					chars[i].timeout=getclock()+x;
				}
			}
			if (chars[k].hp<1)
			{
				Karma(i,k,(0-(chars[k].karma)));
				Fame(i,chars[k].fame);
				if(chars[k].npc!=1)
					chars[i].kills++;
				deathstuff(k);
				if (!(chars[i].npc)&&(!chars[k].npc))//log PvP combat
				{
					sprintf(temp,"%s was killed by %s!\n",chars[k].name,chars[i].name);
					savelog(temp,"PvP.log");
				}
			}
			if (!(chars[k].priv&4))
			{
				if (chars[i].spatimer<=getclock())
				{
					if ((!chars[k].dead)&&(chardist(i,k)<15)&&( numbitsset( chars[i].spattack) > 0 ))
					{
					 if (los=line_of_sight(calcSocketFromChar(i),chars[i].x,chars[i].y,chars[i].z,chars[k].x,chars[k].y,chars[k].z,WALLS_CHIMNEYS+DOORS+FLOORS_FLAT_ROOFING))
					 {
						spattacks = numbitsset( chars[i].spattack );
						spamanachecking=1;
						do
						{
							spattackbit=rand()%(spattacks) + 1;
							switch(whichbit(chars[i].spattack, spattackbit))
							{
							case 1:
								if (chars[i].mn>=4)
								{
									npcaction(i, 6);
									npcmagicarrowtarget(i,k);
									spamanachecking=0;
									break;
								}
							case 2:
								if (chars[i].mn>=6)
								{
									npcaction(i, 6);
									npcharmtarget(i,k);
									spamanachecking=0;
									break;
								}
							case 3:
								if (chars[i].mn>=4)
								{
									npcaction(i, 6);
									npcclumsytarget(i,k);
									spamanachecking=0;
									break;
								}
							case 4:
								if (chars[i].mn>=4)
								{
									npcaction(i, 6);
									npcfeeblemindtarget(i,k);
									spamanachecking=0;
									break;
								}
							case 5:
								if (chars[i].mn>=4)
								{
									npcaction(i, 6);
									npcweakentarget(i,k);
									spamanachecking=0;
									break;
								}
							case 6:
								if (chars[i].mn>=9)
								{
									npcaction(i, 6);
									npcfireballtarget(i,k);
									spamanachecking=0;
									break;
								}
							case 7:
								if (chars[i].mn>=11)
								{
									npcaction(i, 6);
									npccursetarget(i,k);
									spamanachecking=0;
									break;
								}
							case 8:
								if (chars[i].mn>=11)
								{
									npcaction(i, 6);
									npclightningtarget(i,k);
									spamanachecking=0;
									break;
								}
							case 9:
								if (chars[i].mn>=14)
								{
									npcaction(i, 6);
									npcparalyzetarget(i,k);
									spamanachecking=0;
									break;
								}
							case 10:
								if (chars[i].mn>=14)
								{
									npcaction(i, 6);
									npcmindblasttarget(i,k);
									spamanachecking=0;
									break;
								}
							case 11:
								if (chars[i].mn>=20)
								{
									npcaction(i, 6);
									npcebolttarget(i,k);
									spamanachecking=0;
									break;
								}
							case 12:
								if (chars[i].mn>=20)
								{
									npcaction(i, 6);
									npcexplosiontarget(i,k);
									spamanachecking=0;
									break;
								}
							case 13:
								if (chars[i].mn>=40)
								{
									npcaction(i, 6);
									npcflamestriketarget(i,k);
									spamanachecking=0;
									break;
								}
							case 14:
								npcaction(i, 6);
								pfireballtarget(i, k, 10);
								spamanachecking=0;
								break;
							case 15:
								npcaction(i, 6);
								pfireballtarget(i, k, 20);
								spamanachecking=0;
								break;
							case 16:
								npcaction(i, 6);
								pfireballtarget(i, k, 40);
								spamanachecking=0;
								break;
							}
						}
						while(spamanachecking);
					 }
					}
					chars[i].spatimer=getclock()+(chars[i].spadelay*CLOCKS_PER_SEC);
				}
			}
		}
	}
}

int calcatt(int p) // Calculate total attack powerer
{
	char p1, p2, p3, p4;
	int total=0, i, j,serial,serhash,ci;

	if(chars[p].npc==1) 
	{
		//Compatibility for use with older scripts
		if((chars[p].lodamage==0)&&(chars[p].hidamage==0)) return(chars[p].att);

		//Code for new script commands
		if(chars[p].lodamage==chars[p].hidamage) //Avoids divide by zero error
		{
			return(chars[p].lodamage);
		}
		if(!(chars[p].hidamage<=2))
		{
			j=chars[p].hidamage-chars[p].lodamage;
			total=(rand()%(j))+chars[p].lodamage;
		}
		
		if(total<1) total=1;
		return(total);
	}

	p1=chars[p].ser1;
	p2=chars[p].ser2;
	p3=chars[p].ser3;
	p4=chars[p].ser4;
  serial=chars[p].serial;
  serhash=serial%256;
	/*for (i=0;i<itemcount;i++)
		if ((items[i].cont1==p1)&&(items[i].cont2==p2)&&(items[i].cont3==p3)&&(items[i].cont4==p4)&&
		(items[i].layer==1 || items[i].layer==2))*/
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial) && ((items[i].layer==1) || (items[i].layer==2)))
	  {
		  if ((items[i].lodamage>0)&&(items[i].hidamage>0))
		  {
			  total+=(rand()%(items[i].hidamage-items[i].lodamage))+(items[i].lodamage);
		  }
		  else if ((items[i].lodamage==0)&&(items[i].hidamage==0)) total+=items[i].att;
	  }
  }
	if (total<1) total=1;
	return total;
}

int calcdef(int p,int x) // Calculate total defense power
{
	char p1, p2, p3, p4;
	int i=-1, j=-1, k,serial,serhash,ci;
	int total;
	tile_st tile;

	total=chars[p].def;
	p1=chars[p].ser1;
	p2=chars[p].ser2;
	p3=chars[p].ser3;
	p4=chars[p].ser4;
  serial=chars[p].serial;
  serhash=serial%256;
	/*for (i=0;i<itemcount;i++)
		if ((items[i].cont1==p1)&&(items[i].cont2==p2)&&(items[i].cont3==p3)&&(items[i].cont4==p4)&&
		(items[i].layer>1)&&(items[i].layer<25))*/
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial) && (items[i].layer>1) && (items[i].layer<25))
	  {
		  if (x==0) total+=items[i].def;
		  else
		  {
			  switch (items[i].layer)
			  {
			  case 5:
			  case 13:
			  case 17:
			  case 20:
			  case 22: if (x==1 && items[i].def>total) 
					 {
						 total=items[i].def;
						 j=i;
					 }
				   break;
			  case 19: if (x==2 && items[i].def>total)
					 {
						 total=items[i].def;
						 j=i;
					 }
				   break;
			  case 6:  if (x==3 && items[i].def>total) 
					 {
						 total=items[i].def; 
						 j=i;
					 }
				   break;
			  case 3:
			  case 4:
			  case 12:
			  case 23:
			  case 24: if (x==4 && items[i].def>total) 
					 {
						 total=items[i].def;
						 j=i;
					 }
				   break;
			  case 10: if (x==5 && items[i].def>total) 
					 {
						 total=items[i].def;
						 j=i;
					 }
				   break;
			  case 7:  if (x==6 && items[i].def>total) 
					 {
						 total=items[i].def; 
						 j=i;
					 }
				   break;
			  default:
				   break;
			  }
		  }
    }
	}
	k=calcSocketFromChar(p);
	if (j!=-1 && k!=-1)
	{
		if((rand()%2)==0) items[j].hp--; //Take off a hit point
		if(items[j].hp<=0)
		{
			if (items[i].name[0]!='#')
			{
				sprintf(temp,"Your %s has been destroyed",items[j].name);
			}
			else
			{
				seektile((items[j].id1*256)+items[j].id2, &tile);
				sprintf(temp,"Your %s has been destroyed",tile.name);
			}
			sysmessage(k,temp);
			deleitem(j);
		}
		statwindow(k,currchar[k]);
	}
	if (total<2) total=2;
	return total;
}

int timerok(int c)
{
	int d=0;
	if (chars[c].timeout<getclock()) d=1;
	if (overflow) d=1;
	return d;
}

inline int getweapon(int i)
{
	int j,serial,serhash,ci;

  serial=chars[i].serial;
  serhash=serial%256;
  /*for(j=0;j<itemcount;j++)
	{  
		if ((items[j].cont1==chars[i].ser1)&&(items[j].cont2==chars[i].ser2)&&(items[j].cont3==chars[i].ser3)&&(items[j].cont4==chars[i].ser4)&&
      ((items[j].layer==1)||(items[j].layer==2)))*/
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    j=contsp[serhash].pointer[ci];
    if ((j!=-1) && (items[j].contserial==serial) && ((items[j].layer==1) || (items[j].layer==2)))
		{
			return(j);
		}
	}
	return(-1);
}

//play animation for weapon in hand during combat on a horse //kolours - modularized (09/20/98)
void combatonhorse(int i)
{
	int j;

	//      if (chars[i].npc != 0) return; //return if char is not a player

	j = getweapon(i); //find out which weapon the player is holding

	if ((items[j].id1==0x13)&&(items[j].id2==0xB2))
	{
		npcaction(i, 0x1B); //bow
		return;
	}
	if ((items[j].id1==0x0F)&&(items[j].id2==0x4F) || //xbow 
		(items[j].id1==0x13)&&(items[j].id2==0xFD)  ) //hxbow
	{
		npcaction(i, 0x1C); //crossbow - regular
		return;
	}
	if ((items[j].id1==0x13)&&(items[j].id2>=0xB5)&&(items[j].id2<=0xBA) || //swords 
		(items[j].id1==0x0E)&&(items[j].id2>=0xC1)&&(items[j].id2<=0xC5) || //swords
		(items[j].id1==0x0F)&&(items[j].id2>=0x5E)&&(items[j].id2<=0x61) || //swords
		(items[j].id1==0x13)&&(items[j].id2==0xFA)||(items[j].id2==0xFB) || //swords
		(items[j].id1==0x13)&&(items[j].id2==0xFE)||(items[j].id2==0xFF) || //swords
		(items[j].id1==0x0D)&&(items[j].id2>=0xF0)&&(items[j].id2<=0xF5) || //maces
		(items[j].id1==0x14)&&(items[j].id2>=0x38)&&(items[j].id2<0x3C)  || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xB3)||(items[j].id2==0xB4) || //maces
		(items[j].id1==0x0F)&&(items[j].id2==0x5C)||(items[j].id2==0x5D) || //maces
		(items[j].id1==0x0F)&&(items[j].id2==0xB4)||(items[j].id2==0xB5) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xAF)||(items[j].id2==0xB0) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xE3)||(items[j].id2==0xE4) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xF4)||(items[j].id2==0xF5) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xF8)||(items[j].id2==0xF9) || //maces
		(items[j].id1==0x14)&&(items[j].id2==0x3C)||                        //maces - hammer pick
		(items[j].id1==0x14)&&(items[j].id2==0x06)||(items[j].id2==0x07) || //maces - 1H war mace
		(items[j].id1==0x0E)&&(items[j].id2==0x81)||(items[j].id2==0x82) || //maces
		(items[j].id1==0x0E)&&(items[j].id2==0x89)||(items[j].id2==0x8A) || //maces
		(items[j].id1==0x14)&&(items[j].id2<=0x05) || //fencing
		(items[j].id1==0x0F)&&(items[j].id2==0x51)||(items[j].id2==0x52)  ) //fencing - kryss
	{
		npcaction(i, 0x1A);
		return;
	}
	if ((items[j].id1==0x0F)&&(items[j].id2>=0x43)&&(items[j].id2<=0x4E) || //2H axes 
		(items[j].id1==0x14)&&(items[j].id2>=0x3E)&&(items[j].id2<=0x43) || //halberd
		(items[j].id1==0x0F)&&(items[j].id2==0x62)||(items[j].id2==0x63) || //fencing - spear
		(items[j].id1==0x0E)&&(items[j].id2==0x87)||(items[j].id2==0x88)  ) //fencing - pitchfork
	{
		npcaction(i, 0x1D); //2H axes
		return;
	}
	else
	{
		npcaction(i, 0x1A); //fist fighting
		return;
	}

}

//play animation for weapon in hand for combat on foot //kolours - (09/20/98)
void combatonfoot(int i)
{
	int j;
	int m;

	//      if (chars[i].npc != 0) return; //return if char is not a player

	j = getweapon(i); //identify the weapon the player is holding
	m = rand()%4; //randomize the animation sequence

	if ((items[j].id1==0x13)&&(items[j].id2==0xB2)) 
	{
		npcaction(i, 0x12); //bow
		return;
	}
	if ((items[j].id1==0x0F)&&(items[j].id2==0x4F) || //xbow
		(items[j].id1==0x13)&&(items[j].id2==0xFD)  ) //xhbow
	{
		npcaction(i, 0x13); //crossbow - regular
		return;
	}
	if ((items[j].id1==0x13)&&(items[j].id2>=0xB5)&&(items[j].id2<=0xBA) || //1H swords 
		(items[j].id1==0x0F)&&(items[j].id2>=0x5E)&&(items[j].id2<=0x61) || //1H swords
		(items[j].id1==0x0E)&&(items[j].id2>=0xC1)&&(items[j].id2<=0xC5) || //1H swords
		(items[j].id1==0x13)&&(items[j].id2==0xFA)||						//1H swords
		(items[j].id1==0x13)&&(items[j].id2==0xFE)||(items[j].id2==0xFF)  ) //1H swords
	{
		switch (m) //swords
		{
		case 0:
			npcaction(i, 0x0D); //side swing
			return;
		case 1:
			npcaction(i, 0x0A); //poke
			return;
		default:
			npcaction(i, 0x09); //top-down swing
			return;
		}
	}
	if ((items[j].id1==0x0D)&&(items[j].id2>=0xF0)&&(items[j].id2<=0xF5) || //maces 
		(items[j].id1==0x13)&&(items[j].id2==0xB3)||(items[j].id2==0xB4) || //maces
		(items[j].id1==0x0F)&&(items[j].id2==0x5C)||(items[j].id2==0x5D) || //maces
		(items[j].id1==0x0F)&&(items[j].id2==0xB4)||(items[j].id2==0xB5) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xAF)||(items[j].id2==0xB0) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xE3)||(items[j].id2==0xE4) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xF4)||(items[j].id2==0xF5) || //maces
		(items[j].id1==0x13)&&(items[j].id2==0xF8)||(items[j].id2==0xF9) || //maces
		(items[j].id1==0x14)&&(items[j].id2==0x3C)||						//maces - hammer pick
		(items[j].id1==0x14)&&(items[j].id2==0x06)||(items[j].id2==0x07) || //maces
		(items[j].id1==0x0E)&&(items[j].id2==0x81)||(items[j].id2==0x82) || //maces
		(items[j].id1==0x0E)&&(items[j].id2==0x89)||(items[j].id2==0x8A)  ) //maces
	{
		switch (m) //maces
		{
		case 0:
			npcaction(i, 0x0D); //side swing
			return;
		default:
			npcaction(i, 0x09); //top-down swing
			return;
		}
	}
	if ((items[j].id1==0x14)&&(items[j].id2>=0x38)&&(items[j].id2<0x3C) || //2H maces - 2H war hammer
		(items[j].id1==0x14)&&(items[j].id2>=0x3E)&&(items[j].id2<=0x43)|| //Halberd
		(items[j].id1==0x13)&&(items[j].id2==0xFB)||					   //War Axe
		(items[j].id1==0x0F)&&(items[j].id2>=0x43)&&(items[j].id2<=0x4E) ) //2H Axes
	{
		switch (m)
		{
		case 0:
			npcaction(i, 0x0D); //2H top-down
			return;
		case 1:
			npcaction(i, 0x0C); //2H swing
			return;
		default:
			npcaction(i, 0x0D); //2H top-down
			return;
		}
	}
	if ((items[j].id1==0x14)&&(items[j].id2<0x05) || //kryss - fencing
		(items[j].id1==0x0F)&&(items[j].id2==0x51)||(items[j].id2==0x52)|| //fencing
		(items[j].id1==0x14)&&(items[j].id2==0x05)) //fencing
	{
		switch (m) //fencing
		{
		case 0:
			npcaction(i, 0x09); //top-down
			return;
		case 1:
			npcaction(i, 0x0D); //side-swipe
			return;
		default:
			npcaction(i, 0x0A); //default: poke
			return;
		}
	}
	if ((items[j].id1==0x0E)&&(items[j].id2==0x87)||(items[j].id2==0x88) || //pitchfork 
		(items[j].id1==0x0F)&&(items[j].id2==0x62)||(items[j].id2==0x63)  ) //spear
	{
		switch (m) //pitchfork
		{
		case 0:
			npcaction(i, 0x0D); //top-down
			return;
		default:
			npcaction(i, 0x0E); //default: 2-handed poke
			return;
		}
	}
	else
	{
		switch (m) //fist fighting
		{
		case 0:
			npcaction(i, 0x0a); //fist straight-punch
			return;
		case 1:
			npcaction(i, 0x09); //fist top-down
			return;
		default:
			npcaction(i, 0x1F); //default: //fist over-head
			return;
		}
	}
}

void spawnguard(int s, int i, int x, int y, int z)
{
	int t,c;
	i=chars[i].region;
	if(!(chars[s].priv&4))
	{
		//t=RandomNum(1000,1001);
		t=region[i].guardnum[(rand()%10)+1];
		//printf("DEBUG: Guard NPC #%i added",t);
		c=addnpcxyz(s, t, 0, x, y, z); 
		chars[c].npcaitype=0x40; // CITY GUARD
		chars[c].attackfirst=1;
		chars[c].attacker=s;
		chars[c].targ = s;
    chars[c].npcWander=2;  //set wander mode Tauriel
		npcToggleCombat(c);
		chars[c].npcmovetime=(int)(getclock()+(NPCSPEED*CLOCKS_PER_SEC));
		
			soundeffect2(c, 0x01, 0xFE);  //Tauriel 1-9-99 changed to stop crashing used to call soundeffect (expeted socket)
			staticeffect(c, 0x37, 0x2A, 0x09, 0x06);
		
		updatechar(c);
		npctalkall(c,"Thou shalt regret thine actions, swine!");
	}
}

void itemspell(int attaker, int defender)
{
	int i,serial,serhash,ci;
	currentSpellType[attaker]=2;
/*	for (i=0; i < itemcount; i++)
	{
		
		if ((items[i].cont1==chars[attaker].ser1)&&(items[i].cont2==chars[attaker].ser2)&&
        (items[i].cont3==chars[attaker].ser3)&&(items[i].cont4==chars[attaker].ser4))
    {
			if (items[i].layer==2 || (items[i].layer==1 && items[i].type!=9))*/
  serial=chars[attaker].serial;
    serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial) && 
        ((items[i].layer==1 && items[i].type!=9) || (items[i].layer==2)))
			{
				if (items[i].offspell && (items[i].att||items[i].hidamage) && items[i].type == 15)
				{
					switch(items[i].offspell)
					{
					case 1:
						{
							clumsyspellitem(attaker,defender);
							break;
						}
					case 2:
						{
							feeblemindspellitem(attaker,defender);
							break;
						}
					case 3:
						{
							magicarrowspellitem(attaker,defender);
							break;
						}
					case 4:
						{
							weakenspellitem(attaker,defender);
							break;
						}
					case 5:
						{
							harmspellitem(attaker,defender);
							break;
						}
					case 6:
						{
							fireballspellitem(attaker,defender);
							break;
						}
					case 8:
						{
							cursespellitem(attaker,defender);
							break;
						}
					case 9:
						{
							lightningspellitem(attaker,defender);
							break;
						}
					case 11:
						{
							mindblastspellitem(attaker,defender);
							break;
						}
					case 12:
						{
							paralyzespellitem(attaker,defender);
							break;
						}
					case 14:
						{
							explosionspellitem(attaker,defender);
							break;
						}
					case 15:
						{
							flamestrikespellitem(attaker,defender);
							break;
						}
						
					}
					items[i].morez--;
					if (items[i].morez == 0)
					{
						items[i].type = items[i].type2;
						items[i].morex = 0;
						items[i].morey = 0;
						items[i].offspell = 0;
					}
				}
        return;
			}
    }
}
