#!/usr/bin/env python

from distutils.core import setup

long_description = '''
Includes an augmented TestCase class with improved (stricter and more
informative) assert methods; test autodiscovery; utility functions for running
tests and combining TestCase classes into suites and  prettier verbose test
output. For convenience, also includes a copy of Michael Foord's Mock module.
'''[1:-1].replace('\n', ' ')

setup(
    name='unittestplus',
    version='1.1.1',
    description='Test utilities built on unittest, including test autodiscovery',
    long_description=long_description,
    url='http://code.google.com/p/unittestplus/',
    author='Jonathan Hartley',
    author_email='tartley@tartley.com',
    provides=['unittestplus'],
    scripts=['run_all_tests.py'],
    packages=['unittestplus', 'unittestplus.tests'],
)

