#!/usr/bin/env python

import os
import sys
import string
import getopt
import ConfigParser
import smtplib
from email.MIMEText import MIMEText
import time

class TicketReminder(object):

	env = None

	def __init__(self, env, parameters):
		self.env = env
		self.db = None
		self.recipients = []

	def start(self):
		self.db = self.env.get_db_cnx()
		cursor = self.db.cursor()
		sql = "select time,summary,owner,id from ticket where status = 'new' order by time DESC;"
		cursor.execute(sql)
		ntickets = cursor.fetchall()
		sql = """select time,summary,owner,status,id from ticket where status != 'new' 
		         and status != 'closed' order by time DESC;"""
		cursor.execute(sql)
		otickets = cursor.fetchall()
		msg = "Report open Tickets on Trac " + self.env.project_name + ":\n\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n\n"
		msg = msg + "New tickets:\n\n"
		for nt in ntickets:
			msg = msg + "Date: " + self.ts2date(nt[0]) + "\n"
			msg = msg + "Summary: " + nt[1] + "\n"
			if nt[2] != None:
				msg = msg + "Owner: " + nt[2] + "\n"
			msg = msg + "Url: " + self.env.project_url + "ticket/" + str(nt[3]) + "\n"
			msg = msg + "------------------------------\n"
		msg = msg + "\n\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n\n"
		msg = msg + "Active Tickets:\n\n"
		for ot in otickets:
			msg = msg + "Date: " + self.ts2date(ot[0]) + "\n"
			msg = msg + "Summary: " + ot[1] + "\n"
			if ot[2] != None:
				msg = msg + "Owner: " + ot[2] + "\n"
			msg = msg + "State: " + ot[3] + "\n"
			msg = msg + "Url: " + self.env.project_url + "ticket/" + str(ot[4]) + "\n"
			msg = msg + "------------------------------\n"
		mailmsg = MIMEText(msg)
		mailmsg['Subject'] = "Report open Tickets on Trac " + self.env.project_name + " " + self.ts2date(time.time())
		mailmsg['From'] = 'advisor@trac.nexlab.it'
		mailmsg['To'] = settings['sendto'].split(',')[0]
		cc = None
		for addr in settings['sendto'].split(',')[1:]:
			if cc == None:
				cc = addr.replace(" ", "") 
			else:
				cc = cc + "," + addr.replace(" ", "")
		if cc:
			mailmsg['Cc'] = cc
		s = smtplib.SMTP()
		s.connect()
		s.sendmail(mailmsg['From'], mailmsg['To'], mailmsg.as_string())
		s.close()

	def ts2date(self, ts):
		return time.strftime('%d-%m-%y %H:%M', time.localtime(ts))




def ReadConfig(name, config):
   """
   Parse the config file
   """
     # Use given project name else use defaults
     #
   if name:
      if not config.has_section(name):
         print "Not a valid project name: %s" %name
         print "Valid names: %s" %config.sections()
         sys.exit(1)

      project =  dict()
      for option in  config.options(name):
         project[option] = config.get(name, option)

   else:
      project = config.defaults()

   return project

def GetConfigSections(file):
   if not os.path.isfile(file):
      print 'File %s does not exist' %file
      sys.exit(1)
   config = ConfigParser.ConfigParser()
   try:
      config.read(file)
   except ConfigParser.MissingSectionHeaderError,detail:
      print detail
      sys.exit(1)

   return [config, config.sections()]

if __name__ == '__main__':
   # Default config file
   #
   configfile = '/etc/tracremind.conf'
   project = ''
   component = ''
   ENABLE_SYSLOG = 0

   try:
      opts, args = getopt.getopt(sys.argv[1:], 'f:p:', ['file=', 'project='])
   except getopt.error,detail:
      print __doc__
      print detail
      sys.exit(1)


   projects_name = []
   for opt,value in opts:
      if opt in ['-f', '--file']:
         configfile = value
      elif opt in ['-p', '--project']:
         projects_name = [value]
   if len(projects_name) == 0:
	   projects_name = [None]

   config, allprojects = GetConfigSections(configfile)

   if projects_name[0] == 'all':
      projects_name = allprojects

   for pname in projects_name:
      settings = ReadConfig(pname, config)
      if not settings.has_key('project'):
         print __doc__
         print 'No Trac project is defined in the tracremind config file.'
         sys.exit(1)
      print pname
      try:
         from trac.env import Environment
         from trac.ticket import Ticket
         from trac.web.href import Href
         from trac import util

         env = Environment(settings['project'], create=0)
         tktremind = TicketReminder(env, settings)
         tktremind.start()

      except:
		   sys.exit(1)
