/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.logging.impl.FileLogging;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IAdditionalActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionLogging
implements UISWTConfigSection {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final String CFG_PREFIX = "ConfigView.section.logging.";
    private static final int[] logFileSizes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 25, 30, 40, 50, 75, 100, 200, 300, 500};

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "logging";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(final Composite parent) {
        Image imgOpenFolder = ImageRepository.getImage("openFolderButton");
        Composite gLogging = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        gLogging.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        gLogging.setLayout((Layout)layout);
        BooleanParameter enable_logger = new BooleanParameter(gLogging, "Logger.Enabled", "ConfigView.section.logging.loggerenable");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enable_logger.setLayoutData(gridData);
        final BooleanParameter enableLogging = new BooleanParameter(gLogging, "Logging Enable", "ConfigView.section.logging.enable");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enableLogging.setLayoutData(gridData);
        Composite cArea = new Composite(gLogging, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        cArea.setLayout((Layout)layout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        cArea.setLayoutData((Object)gridData);
        Label lStatsPath = new Label(cArea, 0);
        Messages.setLanguageText((Widget)lStatsPath, "ConfigView.section.logging.logdir");
        gridData = new GridData();
        gridData.widthHint = 150;
        final StringParameter pathParameter = new StringParameter(cArea, "Logging Dir");
        pathParameter.setLayoutData(gridData);
        Button browse = new Button(cArea, 8);
        browse.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(browse.getBackground());
        browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        browse.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                dialog.setFilterPath(pathParameter.getValue());
                dialog.setText(MessageText.getString("ConfigView.section.logging.choosedefaultsavepath"));
                String path = dialog.open();
                if (path != null) {
                    pathParameter.setValue(path);
                }
            }
        });
        Label lMaxLog = new Label(cArea, 0);
        Messages.setLanguageText((Widget)lMaxLog, "ConfigView.section.logging.maxsize");
        String[] lmLabels = new String[logFileSizes.length];
        int[] lmValues = new int[logFileSizes.length];
        for (int i = 0; i < logFileSizes.length; ++i) {
            int num = logFileSizes[i];
            lmLabels[i] = " " + num + " MB";
            lmValues[i] = num;
        }
        IntListParameter paramMaxSize = new IntListParameter(cArea, "Logging Max Size", lmLabels, lmValues);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        paramMaxSize.setLayoutData(gridData);
        String sFilterPrefix = "ConfigView.section.logging.filter";
        Group gLogIDs = new Group(gLogging, 0);
        Messages.setLanguageText((Widget)gLogIDs, "ConfigView.section.logging.filter");
        layout = new GridLayout();
        layout.numColumns = 2;
        gLogIDs.setLayout((Layout)layout);
        gridData = new GridData(1, 1, true, true);
        gridData.horizontalSpan = 2;
        gLogIDs.setLayoutData((Object)gridData);
        final List listLogTypes = new List((Composite)gLogIDs, 2564);
        gridData = new GridData(0, 1, false, false);
        listLogTypes.setLayoutData((Object)gridData);
        final int[] logTypes = new int[]{0, 1, 3};
        for (int i = 0; i < logTypes.length; ++i) {
            listLogTypes.add(MessageText.getString("ConfigView.section.logging.log" + i + "type"));
        }
        listLogTypes.select(0);
        LogIDs[] logIDs = FileLogging.configurableLOGIDs;
        final Table tableLogIDs = new Table((Composite)gLogIDs, 67620);
        gridData = new GridData(1808);
        tableLogIDs.setLayoutData((Object)gridData);
        tableLogIDs.setLinesVisible(false);
        tableLogIDs.setHeaderVisible(false);
        TableColumn column = new TableColumn(tableLogIDs, 0);
        for (int i = 0; i < logIDs.length; ++i) {
            TableItem item = new TableItem(tableLogIDs, 0);
            item.setText(0, MessageText.getString("ConfigView.section.logging.filter." + logIDs[i], logIDs[i].toString()));
            item.setData((Object)logIDs[i]);
            boolean checked = COConfigurationManager.getBooleanParameter("bLog." + logTypes[0] + "." + logIDs[i], true);
            item.setChecked(checked);
        }
        column.pack();
        listLogTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = listLogTypes.getSelectionIndex();
                if (index < 0 || index >= logTypes.length) {
                    return;
                }
                TableItem[] items = tableLogIDs.getItems();
                for (int i = 0; i < items.length; ++i) {
                    boolean checked = COConfigurationManager.getBooleanParameter("bLog." + logTypes[index] + "." + items[i].getData(), true);
                    items[i].setChecked(checked);
                }
            }
        });
        tableLogIDs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 32) {
                    return;
                }
                int index = listLogTypes.getSelectionIndex();
                if (index < 0 || index >= logTypes.length) {
                    return;
                }
                TableItem item = (TableItem)e.item;
                COConfigurationManager.setParameter("bLog." + logTypes[index] + "." + item.getData(), item.getChecked());
            }
        });
        Control[] controls_main = new Control[]{cArea, gLogIDs};
        ChangeSelectionActionPerformer perf2 = new ChangeSelectionActionPerformer(controls_main);
        enableLogging.setAdditionalActionPerformer(perf2);
        enable_logger.setAdditionalActionPerformer(new IAdditionalActionPerformer(){
            ChangeSelectionActionPerformer p1;
            {
                this.p1 = new ChangeSelectionActionPerformer(new Control[]{enableLogging.getControl()});
            }

            public void performAction() {
                this.p1.performAction();
            }

            public void setSelected(boolean selected) {
                this.p1.setSelected(selected);
                if (!selected && enableLogging.isSelected()) {
                    enableLogging.setSelected(false);
                }
            }

            public void setIntValue(int value) {
            }

            public void setStringValue(String value) {
            }
        });
        BooleanParameter udp_transport = new BooleanParameter(gLogging, "Logging Enable UDP Transport", "ConfigView.section.logging.udptransport");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        udp_transport.setLayoutData(gridData);
        Label generate_info = new Label(gLogging, 0);
        Messages.setLanguageText((Widget)generate_info, "ConfigView.section.logging.generatediagnostics.info");
        Button generate_button = new Button(gLogging, 8);
        Messages.setLanguageText((Widget)generate_button, "ConfigView.section.logging.generatediagnostics");
        generate_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                AEDiagnostics.generateEvidence(pw);
                pw.close();
                String evidence = sw.toString();
                ClipboardCopy.copyToClipBoard(evidence);
                Logger.log(new LogEvent(LOGID, "Evidence Generation:\n" + evidence));
            }
        });
        return gLogging;
    }
}

