/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionFileTorrents
implements UISWTConfigSection {
    public String configSectionGetParentSection() {
        return "files";
    }

    public String configSectionGetName() {
        return "torrents";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(final Composite parent) {
        Image imgOpenFolder = ImageRepository.getImage("openFolderButton");
        Composite cTorrent = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cTorrent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        cTorrent.setLayout((Layout)layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        BooleanParameter saveTorrents = new BooleanParameter(cTorrent, "Save Torrent Files", true, "ConfigView.label.savetorrents");
        Composite gSaveTorrents = new Composite(cTorrent, 0);
        gridData = new GridData(768);
        gridData.horizontalIndent = 25;
        gridData.horizontalSpan = 2;
        gSaveTorrents.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 4;
        layout.numColumns = 3;
        gSaveTorrents.setLayout((Layout)layout);
        Label lSaveDir = new Label(gSaveTorrents, 0);
        Messages.setLanguageText((Widget)lSaveDir, "ConfigView.label.savedirectory");
        gridData = new GridData(768);
        final StringParameter torrentPathParameter = new StringParameter(gSaveTorrents, "General_sDefaultTorrent_Directory");
        torrentPathParameter.setLayoutData(gridData);
        Button browse2 = new Button(gSaveTorrents, 8);
        browse2.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(browse2.getBackground());
        browse2.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        browse2.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                dialog.setFilterPath(torrentPathParameter.getValue());
                dialog.setText(MessageText.getString("ConfigView.dialog.choosedefaulttorrentpath"));
                String path = dialog.open();
                if (path != null) {
                    torrentPathParameter.setValue(path);
                }
            }
        });
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(gSaveTorrents, "Save Torrent Backup", false, "ConfigView.label.savetorrentbackup").setLayoutData(gridData);
        Control[] controls = new Control[]{gSaveTorrents};
        ChangeSelectionActionPerformer grayPathAndButton1 = new ChangeSelectionActionPerformer(controls);
        saveTorrents.setAdditionalActionPerformer(grayPathAndButton1);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(cTorrent, "Default Start Torrents Stopped", false, "ConfigView.label.defaultstarttorrentsstopped").setLayoutData(gridData);
        BooleanParameter watchFolder = new BooleanParameter(cTorrent, "Watch Torrent Folder", false, "ConfigView.label.watchtorrentfolder");
        Composite gWatchFolder = new Composite(cTorrent, 0);
        gridData = new GridData(768);
        gridData.horizontalIndent = 25;
        gridData.horizontalSpan = 2;
        gWatchFolder.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 4;
        layout.numColumns = 3;
        gWatchFolder.setLayout((Layout)layout);
        Label lImportDir = new Label(gWatchFolder, 0);
        Messages.setLanguageText((Widget)lImportDir, "ConfigView.label.importdirectory");
        gridData = new GridData(768);
        final StringParameter watchFolderPathParameter = new StringParameter(gWatchFolder, "Watch Torrent Folder Path", "");
        watchFolderPathParameter.setLayoutData(gridData);
        Button browse4 = new Button(gWatchFolder, 8);
        browse4.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(browse4.getBackground());
        browse4.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        browse4.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                dialog.setFilterPath(watchFolderPathParameter.getValue());
                dialog.setText(MessageText.getString("ConfigView.dialog.choosewatchtorrentfolderpath"));
                String path = dialog.open();
                if (path != null) {
                    watchFolderPathParameter.setValue(path);
                }
            }
        });
        Label lWatchTorrentFolderInterval = new Label(gWatchFolder, 0);
        Messages.setLanguageText((Widget)lWatchTorrentFolderInterval, "ConfigView.label.watchtorrentfolderinterval");
        String min = " " + MessageText.getString("ConfigView.section.stats.minutes");
        String hr = " " + MessageText.getString("ConfigView.section.stats.hours");
        int[] watchTorrentFolderIntervalValues = new int[]{1, 2, 3, 4, 5, 10, 15, 30, 60, 120, 240, 360, 480, 720, 960, 1200, 1440};
        String[] watchTorrentFolderIntervalLabels = new String[watchTorrentFolderIntervalValues.length];
        for (int i = 0; i < watchTorrentFolderIntervalValues.length; ++i) {
            int mins = watchTorrentFolderIntervalValues[i];
            int hrs = mins / 60;
            watchTorrentFolderIntervalLabels[i] = " " + (hrs == 0 ? mins + min : hrs + hr);
        }
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new IntListParameter(gWatchFolder, "Watch Torrent Folder Interval", 1, watchTorrentFolderIntervalLabels, watchTorrentFolderIntervalValues).setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        new BooleanParameter(gWatchFolder, "Start Watched Torrents Stopped", false, "ConfigView.label.startwatchedtorrentsstopped").setLayoutData(gridData);
        controls = new Control[]{gWatchFolder};
        watchFolder.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(controls));
        if (userMode > 0) {
            Label lIgnoreFiles = new Label(cTorrent, 0);
            Messages.setLanguageText((Widget)lIgnoreFiles, "ConfigView.section.file.torrent.ignorefiles");
            gridData = new GridData(768);
            new StringParameter(cTorrent, "File.Torrent.IgnoreFiles", ".DS_Store;Thumbs.db;desktop.ini").setLayoutData(gridData);
        }
        return cTorrent;
    }
}

