/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class MessageBoxShell {
    private static final String REGEX_URLHTML = "<A HREF=\"(.+?)\">(.+?)</A>";
    private static final int MIN_SIZE_X = 300;
    private static final int MIN_SIZE_Y = 200;

    public static int open(final Shell parent, final String title, final String text, final String[] buttons, final int defaultOption) {
        final int[] result = new int[]{-1};
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MessageBoxShell messageBoxShell = new MessageBoxShell();
                result[0] = messageBoxShell._open(parent, title, text, buttons, defaultOption);
            }
        }, false);
        return result[0];
    }

    private int _open(Shell parent, String title, String text, String[] buttons, int defaultOption) {
        Link linkControl;
        Display display = parent.getDisplay();
        final int[] result = new int[]{-1};
        final Shell shell = new Shell(parent, 67680);
        GridLayout gridLayout = new GridLayout();
        shell.setLayout((Layout)gridLayout);
        try {
            Link linkLabel;
            linkControl = linkLabel = new Link((Composite)shell, 64);
            linkLabel.setForeground(display.getSystemColor(2));
            linkLabel.setText(text);
            linkLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.text.endsWith(".torrent")) {
                        TorrentOpener.openTorrent(e.text);
                    } else {
                        Program.launch((String)e.text);
                    }
                }
            });
            Matcher matcher = Pattern.compile(REGEX_URLHTML, 2).matcher(text);
            String tooltip = null;
            while (matcher.find()) {
                tooltip = tooltip == null ? "" : tooltip + "\n";
                tooltip = tooltip + matcher.group(2) + ": " + matcher.group(1);
            }
            linkLabel.setToolTipText(tooltip);
        }
        catch (Throwable t) {
            Label linkLabel = new Label((Composite)shell, 64);
            linkControl = linkLabel;
            text = Pattern.compile(REGEX_URLHTML, 2).matcher(text).replaceAll("$2 ($1)");
            linkLabel.setForeground(display.getSystemColor(2));
            linkLabel.setText(text);
        }
        GridData gridData = new GridData(1808);
        linkControl.setLayoutData((Object)gridData);
        Composite cButtons = new Composite((Composite)shell, 0);
        FormLayout layout = new FormLayout();
        cButtons.setLayout((Layout)layout);
        gridData = new GridData(64);
        cButtons.setLayoutData((Object)gridData);
        Button lastButton = null;
        Listener buttonListener = new Listener(){

            public void handleEvent(Event event2) {
                result[0] = (Integer)event2.widget.getData();
                shell.dispose();
            }
        };
        for (int i = 0; i < buttons.length; ++i) {
            Button button = new Button(cButtons, 8);
            button.setData((Object)new Integer(i));
            button.setText(buttons[i]);
            button.addListener(13, buttonListener);
            FormData formData = new FormData();
            if (lastButton != null) {
                formData.left = new FormAttachment(lastButton, 5);
            }
            button.setLayoutData((Object)formData);
            if (i == defaultOption) {
                shell.setDefaultButton(button);
            }
            lastButton = button;
        }
        shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event2) {
                if (event2.detail == 2) {
                    shell.dispose();
                }
            }
        });
        shell.pack();
        Point size = shell.getSize();
        if (size.x < 300) {
            size.x = 300;
            shell.setSize(size);
        }
        if (size.y < 200) {
            size.y = 200;
            shell.setSize(size);
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return result[0];
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 1264);
        shell.open();
        System.out.println(MessageBoxShell.open(shell, "Title", "Test\nA <A HREF=\"Link\">link</A> for <A HREF=\"http://moo.com\">you</a>", new String[]{"Okay", "Cancy", "Maybe"}, 1));
    }
}

