/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import java.util.StringTokenizer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class GCStringPrinter {
    public static boolean printString(GC gc, String string, Rectangle printArea) {
        return GCStringPrinter.printString(gc, string, printArea, false, false);
    }

    public static boolean printString(GC gc, String string, Rectangle printArea, boolean skipClip, boolean fullLinesOnly) {
        return GCStringPrinter.printString(gc, string, printArea, skipClip, fullLinesOnly, 192);
    }

    public static boolean printString(GC gc, String string, Rectangle printArea, boolean skipClip, boolean fullLinesOnly, int flags) {
        try {
            return GCStringPrinter._printString(gc, string, printArea, skipClip, fullLinesOnly, flags);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean _printString(GC gc, String string, Rectangle printArea, boolean skipClip, boolean fullLinesOnly, int flags) {
        if (printArea.isEmpty()) {
            return false;
        }
        boolean wrap = (flags & 0x40) > 0;
        Rectangle rectDraw = new Rectangle(printArea.x, printArea.y, printArea.width, printArea.height);
        int height = 0;
        Rectangle oldClipping = null;
        try {
            if (!skipClip) {
                oldClipping = gc.getClipping();
                gc.setClipping(printArea);
            }
            String sTabsReplaced = string.replaceAll("\t", "  ");
            StringBuffer outputLine = new StringBuffer();
            StringTokenizer stLine = new StringTokenizer(sTabsReplaced, "\n");
            while (stLine.hasMoreElements()) {
                int iLineHeight = 0;
                String sLine = stLine.nextToken();
                if (gc.stringExtent((String)sLine).x > printArea.width) {
                    StringTokenizer stWord = new StringTokenizer(sLine, " ");
                    String space = "";
                    int iLineLength = 0;
                    iLineHeight = gc.stringExtent((String)" ").y;
                    while (stWord.hasMoreElements()) {
                        String word = stWord.nextToken();
                        if (!wrap) {
                            word = sLine;
                        }
                        Point ptWordSize = gc.stringExtent(word + " ");
                        while (ptWordSize.x > printArea.width && word.length() > 1) {
                            int endIndex = word.length() - 1;
                            do {
                                ptWordSize = gc.stringExtent(word.substring(0, --endIndex) + " ");
                            } while (endIndex > 3 && ptWordSize.x + iLineLength > printArea.width);
                            if (fullLinesOnly && (height += ptWordSize.y) > printArea.height) {
                                boolean bl = false;
                                return bl;
                            }
                            if (outputLine.length() > 0) {
                                outputLine.append(space);
                            }
                            outputLine.append(word.substring(0, endIndex));
                            if (!wrap) {
                                outputLine.replace(outputLine.length() - 1, outputLine.length(), "..");
                            }
                            GCStringPrinter.drawLine(gc, outputLine, flags, rectDraw);
                            outputLine.setLength(0);
                            if (!wrap) {
                                boolean bl = false;
                                return bl;
                            }
                            word = word.substring(endIndex);
                            ptWordSize = gc.stringExtent(word + " ");
                            iLineLength = 0;
                        }
                        if ((iLineLength += ptWordSize.x) > printArea.width) {
                            boolean bl;
                            iLineLength = ptWordSize.x;
                            iLineHeight = ptWordSize.y;
                            if (fullLinesOnly && (height += iLineHeight) > printArea.height) {
                                bl = false;
                                return bl;
                            }
                            space = "";
                            if (!wrap) {
                                outputLine.replace(outputLine.length() - 1, outputLine.length(), "..");
                            }
                            GCStringPrinter.drawLine(gc, outputLine, flags, rectDraw);
                            outputLine.setLength(0);
                            if (!wrap) {
                                bl = false;
                                return bl;
                            }
                        }
                        if (outputLine.length() > 0) {
                            outputLine.append(space);
                        }
                        outputLine.append(word);
                        space = " ";
                    }
                } else {
                    outputLine.append(sLine);
                    iLineHeight = gc.stringExtent((String)sLine).y;
                }
                if (fullLinesOnly && (height += iLineHeight) > printArea.height) {
                    boolean bl = false;
                    return bl;
                }
                if (!wrap && stLine.hasMoreElements()) {
                    outputLine.replace(outputLine.length() - 1, outputLine.length(), "..");
                }
                GCStringPrinter.drawLine(gc, outputLine, flags, rectDraw);
                outputLine.setLength(0);
                if (wrap) continue;
                boolean bl = stLine.hasMoreElements();
                return bl;
            }
        }
        finally {
            if (!skipClip) {
                gc.setClipping(oldClipping);
            }
        }
        return height <= printArea.height;
    }

    private static void drawLine(GC gc, StringBuffer outputLine, int flags, Rectangle printArea) {
        String sOutputLine = outputLine.toString();
        Point drawSize = gc.textExtent(sOutputLine);
        int x0 = (flags & 0x20000) > 0 ? printArea.x + printArea.width - drawSize.x : ((flags & 0x1000000) > 0 ? printArea.x + (printArea.width - drawSize.x) / 2 : printArea.x);
        int y0 = (flags & 0x480) == 0 ? printArea.y + (printArea.height - drawSize.y) / 2 : printArea.y;
        gc.drawText(sOutputLine, x0, y0, true);
        printArea.y += drawSize.y;
    }

    private static int getAdvanceWidth(GC gc, String s) {
        int result = 0;
        for (int i = 0; i < s.length(); ++i) {
            result += gc.getAdvanceWidth(s.charAt(i)) - 1;
        }
        return result;
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        final Shell shell = new Shell(display, 1264);
        shell.setSize(500, 500);
        shell.addListener(9, new Listener(){

            public void handleEvent(Event event2) {
                int x = 0;
                int y = 0;
                GC gc = new GC((Drawable)shell);
                GCStringPrinter.printString(gc, "This is a test of the string printer averlongwordthisisyesindeed you rule", new Rectangle(x, y, 100, 19), true, true, 131136);
                GCStringPrinter.printString(gc, "This is a test of the string printer averlongwordthisisyesindeed you rule", new Rectangle(x += 110, y, 100, 19), true, false, 16448);
                GCStringPrinter.printString(gc, "This is a test of the string printer averlongwordthisisyesindeed you rule", new Rectangle(x += 110, y, 100, 19), true, false, 0x1000040);
                x = 0;
                GCStringPrinter.printString(gc, "FLO is a test of the string printer averlongwordthisisyesindeed you rule", new Rectangle(x, y += 50, 100, 50), true, true, 131136);
                GCStringPrinter.printString(gc, "This is a test of the string printer averlongwordthisisyesindeed you rule", new Rectangle(x += 110, y, 100, 50), true, false, 16448);
                GCStringPrinter.printString(gc, "This is a test of the string printer averlongwordthisisyesindeed you rule", new Rectangle(x += 110, y, 100, 50), true, false, 0x1000040);
                x = 0;
                GCStringPrinter.printString(gc, "This is a test of the string printer averlongwordthisisyesindeed you rule", new Rectangle(x, y += 100, 100, 50), true, true, 131072);
                GCStringPrinter.printString(event2.gc, "This is a test of the string printer averlongwordthisisyesindeed you rule", new Rectangle(x += 110, y, 100, 50), true, false, 16384);
                GCStringPrinter.printString(gc, "This is a test of the string printer averlongwordthisisyesindeed you rule", new Rectangle(x += 110, y, 100, 50), true, false, 0x1000000);
                x = 0;
                gc.drawRectangle(x, y += 100, 100, 100);
                GCStringPrinter.printString(gc, "Hello", new Rectangle(++x, ++y, 98, 98), true, true, 0x1000000);
                gc.drawRectangle(x += 110, y, 100, 100);
                GCStringPrinter.printString(gc, "Hello", new Rectangle(++x, ++y, 98, 98), true, true, 0x1000080);
                gc.drawRectangle(x += 110, y, 100, 100);
                GCStringPrinter.printString(gc, "Hello", new Rectangle(++x, ++y, 98, 98), true, true, 128);
                gc.drawRectangle(x += 110, y, 50, 50);
                GCStringPrinter.printString(gc, "Hello There", new Rectangle(++x, ++y, 48, 48), true, true, 0);
                gc.dispose();
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

