/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsinstaller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.pluginsinstaller.IPWInstallModePanel;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class IPWListPanel
extends AbstractWizardPanel {
    Table pluginList;
    StyledText txtDescription;

    public IPWListPanel(Wizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        this.wizard.setTitle(MessageText.getString("installPluginsWizard.list.title"));
        this.wizard.setErrorMessage("");
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        final Label lblStatus = new Label(panel, 0);
        GridData data = new GridData(768);
        lblStatus.setLayoutData((Object)data);
        Messages.setLanguageText((Widget)lblStatus, "installPluginsWizard.list.loading");
        this.pluginList = new Table(panel, 68132);
        this.pluginList.setHeaderVisible(true);
        data = new GridData(768);
        data.heightHint = 120;
        this.pluginList.setLayoutData((Object)data);
        TableColumn tcName = new TableColumn(this.pluginList, 16384);
        Messages.setLanguageText((Widget)tcName, "installPluginsWizard.list.name");
        tcName.setWidth(200);
        TableColumn tcVersion = new TableColumn(this.pluginList, 16384);
        Messages.setLanguageText((Widget)tcVersion, "installPluginsWizard.list.version");
        tcVersion.setWidth(150);
        Label lblDescription = new Label(panel, 0);
        Messages.setLanguageText((Widget)lblDescription, "installPluginsWizard.list.description");
        this.txtDescription = new StyledText(panel, 2824);
        this.txtDescription.setWordWrap(true);
        this.txtDescription.setEditable(false);
        data = new GridData(768);
        data.heightHint = 100;
        this.txtDescription.setLayoutData((Object)data);
        AEThread listLoader = new AEThread("Plugin List Loader"){

            public void runSupport() {
                StandardPlugin[] plugins;
                try {
                    plugins = ((InstallPluginWizard)IPWListPanel.this.wizard).getStandardPlugins();
                    Arrays.sort(plugins, new Comparator(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public int compare(Object o1, Object o2) {
                            return ((StandardPlugin)o1).getName().compareToIgnoreCase(((StandardPlugin)o2).getName());
                        }
                    });
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    IPWListPanel.this.wizard.getDisplay().asyncExec((Runnable)new AERunnable(this, e){
                        private final /* synthetic */ Exception val$e;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$e = val$e;
                        }

                        public void runSupport() {
                            1.access$100(this.this$1).txtDescription.setText(Debug.getNestedExceptionMessage(this.val$e));
                        }
                    });
                    return;
                }
                IPWListPanel.this.wizard.getDisplay().asyncExec((Runnable)new AERunnable(this, plugins){
                    private final /* synthetic */ StandardPlugin[] val$plugins;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$plugins = val$plugins;
                    }

                    public void runSupport() {
                        1.access$400(this.this$1).setText(((InstallPluginWizard)IPWListPanel.access$300(1.access$100(this.this$1))).getListTitleText());
                        List selected_plugins = ((InstallPluginWizard)IPWListPanel.access$500(1.access$100(this.this$1))).getPluginList();
                        for (int i = 0; i < this.val$plugins.length; ++i) {
                            StandardPlugin plugin = this.val$plugins[i];
                            if (plugin.getAlreadyInstalledPlugin() != null) continue;
                            if (1.access$100(this.this$1).pluginList == null || 1.access$100(this.this$1).pluginList.isDisposed()) {
                                return;
                            }
                            TableItem item = new TableItem(1.access$100(this.this$1).pluginList, 0);
                            item.setData((Object)plugin);
                            item.setText(0, plugin.getName());
                            boolean selected = false;
                            for (int j = 0; j < selected_plugins.size(); ++j) {
                                if (((StandardPlugin)selected_plugins.get(j)).getId() != plugin.getId()) continue;
                                selected = true;
                            }
                            item.setChecked(selected);
                            item.setText(1, plugin.getVersion());
                        }
                        if (this.val$plugins.length == 1 && 1.access$100(this.this$1).pluginList.getItemCount() > 0) {
                            1.access$100(this.this$1).pluginList.select(0);
                            1.access$100(this.this$1).loadPluginDetails(1.access$100(this.this$1).pluginList.getItem(0));
                        }
                    }
                });
            }

            static /* synthetic */ IPWListPanel access$100(1 x0) {
                return x0.IPWListPanel.this;
            }

            static /* synthetic */ Label access$400(1 x0) {
                return x0.lblStatus;
            }
        };
        listLoader.setDaemon(true);
        listLoader.start();
        this.pluginList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (IPWListPanel.this.pluginList.getSelectionCount() > 0) {
                    IPWListPanel.this.loadPluginDetails(IPWListPanel.this.pluginList.getSelection()[0]);
                }
                IPWListPanel.this.updateList();
            }
        });
    }

    protected void loadPluginDetails(final TableItem selected_item) {
        this.txtDescription.setText(MessageText.getString("installPluginsWizard.details.loading"));
        final StandardPlugin plugin = (StandardPlugin)selected_item.getData();
        AEThread detailsLoader = new AEThread("Detail Loader"){

            public void runSupport() {
                String description = HTMLUtils.convertListToString(HTMLUtils.convertHTMLToText(plugin.getDescription(), ""));
                IPWListPanel.this.wizard.getDisplay().asyncExec((Runnable)new AERunnable(this, description){
                    private final /* synthetic */ String val$description;
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$description = val$description;
                    }

                    public void runSupport() {
                        if (6.access$700(this.this$1).pluginList == null || 6.access$700(this.this$1).pluginList.isDisposed() || 6.access$700(this.this$1).pluginList.getSelectionCount() == 0) {
                            return;
                        }
                        if (6.access$700(this.this$1).pluginList.getSelection()[0] != 6.access$800(this.this$1)) {
                            return;
                        }
                        if (6.access$700(this.this$1).txtDescription == null || 6.access$700(this.this$1).txtDescription.isDisposed()) {
                            return;
                        }
                        6.access$700(this.this$1).txtDescription.setText(this.val$description);
                    }
                });
            }

            static /* synthetic */ IPWListPanel access$700(6 x0) {
                return x0.IPWListPanel.this;
            }

            static /* synthetic */ TableItem access$800(6 x0) {
                return x0.selected_item;
            }
        };
        detailsLoader.setDaemon(true);
        detailsLoader.start();
    }

    public boolean isNextEnabled() {
        return ((InstallPluginWizard)this.wizard).getPluginList().size() > 0;
    }

    public IWizardPanel getNextPanel() {
        return new IPWInstallModePanel(this.wizard, this);
    }

    public void updateList() {
        ArrayList<Object> list = new ArrayList<Object>();
        TableItem[] items = this.pluginList.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getChecked()) continue;
            list.add(items[i].getData());
        }
        ((InstallPluginWizard)this.wizard).setPluginList(list);
        ((InstallPluginWizard)this.wizard).setNextEnabled(this.isNextEnabled());
    }

    static /* synthetic */ Wizard access$300(IPWListPanel x0) {
        return x0.wizard;
    }

    static /* synthetic */ Wizard access$500(IPWListPanel x0) {
        return x0.wizard;
    }
}

