/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.gudy.azureus2.ui.swt.components.BufferedTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;

public abstract class BufferedTableItemImpl
implements BufferedTableItem {
    protected BufferedTableRow row;
    private int position;
    private Color ourFGColor = null;
    private String text = "";

    public BufferedTableItemImpl(BufferedTableRow row, int position) {
        this.row = row;
        this.position = position;
    }

    public String getText() {
        if (this.position != -1) {
            return this.row.getText(this.position);
        }
        return "";
    }

    public boolean setText(String text) {
        if (this.position != -1) {
            return this.row.setText(this.position, text);
        }
        return false;
    }

    public void setImage(Image img) {
        if (this.position != -1) {
            this.row.setImage(this.position, img);
        }
    }

    public void setRowForeground(Color color) {
        this.row.setForeground(color);
    }

    public boolean setForeground(Color color) {
        boolean ok;
        if (this.position == -1) {
            return false;
        }
        if (this.ourFGColor != null) {
            ok = this.row.setForeground(this.position, color);
            if (ok) {
                if (!color.isDisposed()) {
                    color.dispose();
                }
                this.ourFGColor = null;
            }
        } else {
            ok = this.row.setForeground(this.position, color);
        }
        return ok;
    }

    public Color getForeground() {
        if (this.position == -1) {
            return null;
        }
        return this.row.getForeground(this.position);
    }

    public boolean setForeground(int red, int green, int blue) {
        if (this.position == -1) {
            return false;
        }
        Color oldColor = this.row.getForeground(this.position);
        RGB newRGB = new RGB(red, green, blue);
        if (oldColor != null && oldColor.getRGB().equals((Object)newRGB)) {
            return false;
        }
        Color newColor = new Color((Device)this.row.getTable().getDisplay(), newRGB);
        boolean ok = this.row.setForeground(this.position, newColor);
        if (ok) {
            if (this.ourFGColor != null && !this.ourFGColor.isDisposed()) {
                this.ourFGColor.dispose();
            }
            this.ourFGColor = newColor;
        } else if (!newColor.isDisposed()) {
            newColor.dispose();
        }
        return ok;
    }

    public Color getBackground() {
        return this.row.getBackground();
    }

    public Rectangle getBounds() {
        if (this.position != -1) {
            return this.row.getBounds(this.position);
        }
        return null;
    }

    public Table getTable() {
        return this.row.getTable();
    }

    public void dispose() {
        if (this.ourFGColor != null && !this.ourFGColor.isDisposed()) {
            this.ourFGColor.dispose();
        }
    }

    public boolean isShown() {
        return true;
    }

    public boolean needsPainting() {
        return false;
    }

    public void doPaint(GC gc) {
    }

    public void locationChanged() {
    }

    public int getPosition() {
        return this.position;
    }

    public Image getBackgroundImage() {
        Table table = this.row.getTable();
        Rectangle bounds = this.getBounds();
        if (bounds.isEmpty()) {
            return null;
        }
        Image image = new Image((Device)table.getDisplay(), bounds.width, bounds.height);
        GC gc = new GC((Drawable)table);
        gc.copyArea(image, bounds.x, bounds.y);
        gc.dispose();
        return image;
    }
}

