/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console;

import java.io.File;
import java.net.URL;
import org.apache.log4j.Logger;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderFactory;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIException;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIInstanceFactory;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerEvent;
import org.gudy.azureus2.plugins.ui.UIManagerEventListener;
import org.gudy.azureus2.ui.common.IUserInterface;
import org.gudy.azureus2.ui.common.UIConst;
import org.gudy.azureus2.ui.common.UITemplateHeadless;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.multiuser.UserManager;
import org.gudy.azureus2.ui.console.multiuser.commands.UserCommand;

public class UI
extends UITemplateHeadless
implements IUserInterface,
UIInstanceFactory,
UIInstance,
UIManagerEventListener {
    private ConsoleInput console = null;

    public void init(boolean first, boolean others) {
        super.init(first, others);
        System.setProperty("java.awt.headless", "true");
    }

    public String[] processArgs(String[] args) {
        return args;
    }

    public void startUI() {
        super.startUI();
        PluginInterface pi = UIConst.getAzureusCore().getPluginManager().getDefaultPluginInterface();
        UIManager ui_manager = pi.getUIManager();
        ui_manager.addUIEventListener(this);
        try {
            ui_manager.attachUI(this);
        }
        catch (UIException e) {
            e.printStackTrace();
        }
        TorrentDownloaderFactory.initManager(UIConst.getGlobalManager(), true, true, COConfigurationManager.getStringParameter("Default save path"));
        if (!this.isStarted() || this.console == null || !this.console.isAlive()) {
            System.out.println();
            this.console = new ConsoleInput("Main", UIConst.getAzureusCore(), System.in, System.out, Boolean.TRUE);
            if (System.getProperty("azureus.console.multiuser") != null) {
                UserManager manager = UserManager.getInstance(pi);
                this.console.registerCommand(new UserCommand(manager));
            }
            this.console.printconsolehelp();
        }
    }

    public void openRemoteTorrent(String url) {
        if (this.console != null) {
            this.console.downloadRemoteTorrent(url);
            return;
        }
        System.out.println("Downloading torrent from url: " + url);
        TorrentDownloaderFactory.downloadManaged(url);
    }

    public void openTorrent(String fileName) {
        if (this.console != null) {
            this.console.downloadTorrent(fileName);
            return;
        }
        if (fileName.toUpperCase().startsWith("HTTP://")) {
            System.out.println("Downloading torrent from url: " + fileName);
            TorrentDownloaderFactory.downloadManaged(fileName);
            return;
        }
        try {
            if (!TorrentUtils.isTorrentFile(fileName)) {
                Logger.getLogger((String)"azureus2.ui.console").error((Object)(fileName + " doesn't seem to be a torrent file. Not added."));
                return;
            }
        }
        catch (Exception e) {
            Logger.getLogger((String)"azureus2.ui.console").error((Object)("Something is wrong with " + fileName + ". Not added. (Reason: " + e.getMessage() + ")"));
            return;
        }
        if (UIConst.getGlobalManager() != null) {
            try {
                String downloadDir = COConfigurationManager.getDirectoryParameter("Default save path");
                System.out.println("Adding torrent: " + fileName + " and saving to " + downloadDir);
                UIConst.getGlobalManager().addDownloadManager(fileName, downloadDir);
            }
            catch (Exception e) {
                Logger.getLogger((String)"azureus2.ui.console").error((Object)("The torrent " + fileName + " could not be added."), (Throwable)e);
            }
        }
    }

    public UIInstance getInstance(PluginInterface plugin_interface) {
        return this;
    }

    public void detach() throws UIException {
    }

    public boolean eventOccurred(UIManagerEvent event2) {
        Object data = event2.getData();
        switch (event2.getType()) {
            case 1: {
                String[] bits = (String[])data;
                for (int i = 0; i < bits.length; ++i) {
                    this.console.out.println(bits[i]);
                }
                break;
            }
            case 2: {
                this.openTorrent(((File)data).toString());
                break;
            }
            case 3: {
                this.openRemoteTorrent(((URL)((Object[])data)[0]).toExternalForm());
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                return false;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                event2.setResult(new Boolean(false));
                break;
            }
            default: {
                this.console.out.println("Unrecognised UI event '" + event2.getType() + "'");
            }
        }
        return true;
    }

    public int promptUser(String title, String text, String[] options, int defaultOption) {
        this.console.out.println("Prompt: " + title);
        this.console.out.println(text);
        String sOptions = "Options: ";
        for (int i = 0; i < options.length; ++i) {
            if (i != 0) {
                sOptions = sOptions + ", ";
            }
            sOptions = sOptions + "[" + i + "]" + options[i];
        }
        this.console.out.println(sOptions);
        this.console.out.println("WARNING: Option [" + defaultOption + "] automatically selected. " + "Console UI devs need to implement this function!");
        return defaultOption;
    }
}

