/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessage;

public class GenericMessageDecoder
implements MessageStreamDecoder {
    public static final int MAX_MESSAGE_LENGTH = 65536;
    private final ByteBuffer length_buffer = ByteBuffer.allocate(4);
    private final ByteBuffer[] buffers = new ByteBuffer[]{this.length_buffer, null};
    private final String msg_type;
    private final String msg_desc;
    private List messages = new ArrayList();
    private int protocol_bytes_last_read = 0;
    private int data_bytes_last_read = 0;
    private volatile boolean destroyed;

    protected GenericMessageDecoder(String _msg_type, String _msg_desc) {
        this.msg_type = _msg_type;
        this.msg_desc = _msg_desc;
    }

    public int performStreamDecode(Transport transport, int max_bytes) throws IOException {
        long total_read;
        long bytes_read;
        this.protocol_bytes_last_read = 0;
        this.data_bytes_last_read = 0;
        for (total_read = 0L; total_read < (long)max_bytes; total_read += bytes_read) {
            ByteBuffer payload_buffer = this.buffers[1];
            if (payload_buffer == null) {
                bytes_read = transport.read(this.buffers, 0, 1);
                this.protocol_bytes_last_read = (int)((long)this.protocol_bytes_last_read + bytes_read);
                if (this.length_buffer.hasRemaining()) break;
                this.length_buffer.flip();
                int size = this.length_buffer.getInt();
                if (size > 65536) {
                    Debug.out("Message too large for generic payload");
                    throw new IOException("message too large");
                }
                this.buffers[1] = ByteBuffer.allocate(size);
                this.length_buffer.flip();
                continue;
            }
            bytes_read = transport.read(this.buffers, 1, 1);
            this.data_bytes_last_read = (int)((long)this.data_bytes_last_read + bytes_read);
            if (payload_buffer.hasRemaining()) break;
            payload_buffer.flip();
            this.messages.add(new GenericMessage(this.msg_type, this.msg_desc, new DirectByteBuffer(payload_buffer), false));
            this.buffers[1] = null;
        }
        if (this.destroyed) {
            throw new IOException("decoder has been destroyed");
        }
        return (int)total_read;
    }

    public Message[] removeDecodedMessages() {
        if (this.messages.isEmpty()) {
            return null;
        }
        Message[] msgs = this.messages.toArray(new Message[this.messages.size()]);
        this.messages.clear();
        return msgs;
    }

    public int getProtocolBytesDecoded() {
        return this.protocol_bytes_last_read;
    }

    public int getDataBytesDecoded() {
        return this.data_bytes_last_read;
    }

    public int getPercentDoneOfCurrentMessage() {
        return 0;
    }

    public void pauseDecoding() {
    }

    public void resumeDecoding() {
    }

    public ByteBuffer destroy() {
        this.destroyed = true;
        return null;
    }
}

