/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessage;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionAdapter;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageDecoder;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEncoder;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEndpointImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class GenericMessageConnectionDirect
implements GenericMessageConnectionAdapter,
LimitedRateGroup {
    public static final int MAX_MESSAGE_SIZE = 65536;
    private GenericMessageConnectionImpl owner;
    private String msg_id;
    private String msg_desc;
    private int stream_crypto;
    private byte[] shared_secret;
    private GenericMessageEndpointImpl endpoint;
    private NetworkConnection connection;
    private volatile boolean connected;
    private volatile boolean closed;

    protected static GenericMessageConnectionDirect receive(GenericMessageEndpointImpl endpoint, String msg_id, String msg_desc, int stream_crypto, byte[] shared_secret) {
        GenericMessageConnectionDirect direct_connection = new GenericMessageConnectionDirect(msg_id, msg_desc, endpoint, stream_crypto, shared_secret);
        return direct_connection;
    }

    protected GenericMessageConnectionDirect(String _msg_id, String _msg_desc, GenericMessageEndpointImpl _endpoint, int _stream_crypto, byte[] _shared_secret) {
        this.msg_id = _msg_id;
        this.msg_desc = _msg_desc;
        this.endpoint = _endpoint;
        this.stream_crypto = _stream_crypto;
        this.shared_secret = _shared_secret;
    }

    public void setOwner(GenericMessageConnectionImpl _owner) {
        this.owner = _owner;
    }

    public int getMaximumMessageSize() {
        return 65536;
    }

    protected void connect(NetworkConnection _connection) {
        this.connection = _connection;
        this.connection.connect(new NetworkConnection.ConnectionListener(){

            public void connectStarted() {
            }

            public void connectSuccess(ByteBuffer remaining_initial_data) {
                GenericMessageConnectionDirect.this.connected = true;
            }

            public void connectFailure(Throwable failure_msg) {
                GenericMessageConnectionDirect.this.owner.reportFailed(failure_msg);
                GenericMessageConnectionDirect.this.connection.close();
            }

            public void exceptionThrown(Throwable error) {
                GenericMessageConnectionDirect.this.owner.reportFailed(error);
                GenericMessageConnectionDirect.this.connection.close();
            }
        });
    }

    public void accepted() {
        this.startProcessing();
    }

    public GenericMessageEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void connect(ByteBuffer upper_initial_data, final GenericMessageConnectionAdapter.ConnectionListener listener) {
        if (this.connected) {
            return;
        }
        this.connection = NetworkManager.getSingleton().createConnection(this.endpoint.getConnectionEndpoint(), new GenericMessageEncoder(), new GenericMessageDecoder(this.msg_id, this.msg_desc), this.stream_crypto != 1, this.stream_crypto != 3, this.shared_secret);
        ByteBuffer initial_data = ByteBuffer.wrap(this.msg_id.getBytes());
        if (upper_initial_data != null) {
            GenericMessage gm = new GenericMessage(this.msg_id, this.msg_desc, new DirectByteBuffer(upper_initial_data), false);
            DirectByteBuffer[] payload = new GenericMessageEncoder().encodeMessage(gm).getRawData();
            int size = initial_data.remaining();
            for (int i = 0; i < payload.length; ++i) {
                size += payload[i].remaining((byte)11);
            }
            ByteBuffer temp = ByteBuffer.allocate(size);
            temp.put(initial_data);
            for (int i = 0; i < payload.length; ++i) {
                temp.put(payload[i].getBuffer((byte)11));
            }
            temp.rewind();
            initial_data = temp;
        }
        this.connection.connect(initial_data, new NetworkConnection.ConnectionListener(){

            public void connectStarted() {
            }

            public void connectSuccess(ByteBuffer remaining_initial_data) {
                GenericMessageConnectionDirect.this.connected = true;
                try {
                    if (remaining_initial_data != null && remaining_initial_data.remaining() > 0) {
                        GenericMessageConnectionDirect.this.connection.getOutgoingMessageQueue().addMessage(new GenericMessage(GenericMessageConnectionDirect.this.msg_id, GenericMessageConnectionDirect.this.msg_desc, new DirectByteBuffer(remaining_initial_data), true), false);
                    }
                    listener.connectSuccess();
                    GenericMessageConnectionDirect.this.startProcessing();
                }
                catch (Throwable e) {
                    this.connectFailure(e);
                }
            }

            public void connectFailure(Throwable failure_msg) {
                listener.connectFailure(failure_msg);
                GenericMessageConnectionDirect.this.connection.close();
            }

            public void exceptionThrown(Throwable error) {
                listener.connectFailure(error);
                GenericMessageConnectionDirect.this.connection.close();
            }
        });
    }

    protected void startProcessing() {
        this.connection.getIncomingMessageQueue().registerQueueListener(new IncomingMessageQueue.MessageQueueListener(){

            public boolean messageReceived(Message _message) {
                GenericMessage message = (GenericMessage)_message;
                GenericMessageConnectionDirect.this.owner.receive(message);
                return true;
            }

            public void protocolBytesReceived(int byte_count) {
            }

            public void dataBytesReceived(int byte_count) {
            }
        });
        this.connection.getOutgoingMessageQueue().registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

            public boolean messageAdded(Message message) {
                return true;
            }

            public void messageQueued(Message message) {
            }

            public void messageRemoved(Message message) {
            }

            public void messageSent(Message message) {
            }

            public void protocolBytesSent(int byte_count) {
            }

            public void dataBytesSent(int byte_count) {
            }
        });
        this.connection.startMessageProcessing(this, this);
    }

    public void send(PooledByteBuffer data) throws MessageException {
        if (!this.connected) {
            throw new MessageException("not connected");
        }
        PooledByteBufferImpl impl = (PooledByteBufferImpl)data;
        try {
            this.connection.getOutgoingMessageQueue().addMessage(new GenericMessage(this.msg_id, this.msg_desc, impl.getBuffer(), false), false);
        }
        catch (Throwable e) {
            throw new MessageException("send failed", e);
        }
    }

    public void close() throws MessageException {
        if (!this.connected) {
            throw new MessageException("not connected");
        }
        if (!this.closed) {
            this.closed = true;
            this.connection.close();
        }
    }

    public int getRateLimitBytesPerSecond() {
        return 0;
    }
}

