/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.installer;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.installer.FilePluginInstaller;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.PluginInstallerListener;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.FailedPlugin;
import org.gudy.azureus2.pluginsimpl.local.installer.FilePluginInstallerImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.InstallablePluginImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.StandardPluginImpl;
import org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsException;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;

public class PluginInstallerImpl
implements PluginInstaller {
    protected static PluginInstallerImpl singleton;
    private PluginManager manager;
    private List listeners = new ArrayList();

    public static PluginInstallerImpl getSingleton(PluginManager _manager) {
        if (singleton == null) {
            singleton = new PluginInstallerImpl(_manager);
        }
        return singleton;
    }

    protected PluginInstallerImpl(PluginManager _manager) {
        this.manager = _manager;
    }

    protected PluginManager getPluginManager() {
        return this.manager;
    }

    public StandardPlugin[] getStandardPlugins() throws PluginException {
        try {
            SFPluginDetailsLoader loader = SFPluginDetailsLoaderFactory.getSingleton();
            SFPluginDetails[] details = loader.getPluginDetails();
            ArrayList<StandardPluginImpl> res = new ArrayList<StandardPluginImpl>();
            for (int i = 0; i < details.length; ++i) {
                SFPluginDetails detail = details[i];
                String name = detail.getId();
                String version = "";
                if (Constants.isCVSVersion()) {
                    version = detail.getCVSVersion();
                }
                if (version == null || version.length() == 0 || !Character.isDigit(version.charAt(0))) {
                    version = detail.getVersion();
                } else {
                    String non_cvs_version = detail.getVersion();
                    if (version.equals(non_cvs_version + "_CVS")) {
                        version = non_cvs_version;
                    }
                }
                if (name.startsWith("azplatform") || name.equals("azupdater") || version == null || version.length() == 0 || !Character.isDigit(version.charAt(0)) || detail.getCategory().equalsIgnoreCase("hidden")) continue;
                res.add(new StandardPluginImpl(this, details[i], version));
            }
            StandardPlugin[] res_a = new StandardPlugin[res.size()];
            res.toArray(res_a);
            return res_a;
        }
        catch (SFPluginDetailsException e) {
            throw new PluginException("Failed to load standard plugin details", e);
        }
    }

    public FilePluginInstaller installFromFile(File file) throws PluginException {
        return new FilePluginInstallerImpl(this, file);
    }

    public void install(InstallablePlugin installable_plugin, boolean shared) throws PluginException {
        this.install(new InstallablePlugin[]{installable_plugin}, shared);
    }

    public void install(InstallablePlugin[] plugins, boolean shared) throws PluginException {
        PluginUpdatePlugin pup = (PluginUpdatePlugin)this.manager.getPluginInterfaceByClass(PluginUpdatePlugin.class).getPlugin();
        UpdateManager uman = this.manager.getDefaultPluginInterface().getUpdateManager();
        UpdateCheckInstance inst = uman.createEmptyUpdateCheckInstance(1, "update.instance.install");
        try {
            for (int i = 0; i < plugins.length; ++i) {
                InstallablePlugin plugin = plugins[i];
                String plugin_id = plugin.getId();
                PluginInterface existing_plugin_interface = this.manager.getPluginInterfaceByID(plugin_id);
                Plugin existing_plugin = null;
                if (existing_plugin_interface != null) {
                    existing_plugin = existing_plugin_interface.getPlugin();
                    String old_version = existing_plugin_interface.getPluginVersion();
                    if (old_version != null) {
                        int res = Constants.compareVersions(plugin.getVersion(), old_version);
                        if (res < 0) {
                            throw new PluginException("A higher version (" + old_version + ") of Plugin '" + plugin_id + "' is already installed");
                        }
                        if (res == 0) {
                            throw new PluginException("Version (" + old_version + ") of Plugin '" + plugin_id + "' is already installed");
                        }
                    }
                }
                String target_dir = shared ? FileUtil.getApplicationFile("plugins").toString() : FileUtil.getUserFile("plugins").toString();
                target_dir = target_dir + File.separator + plugin_id;
                new File(target_dir).mkdir();
                if (existing_plugin == null) {
                    final FailedPlugin dummy_plugin = new FailedPlugin(plugin_id, target_dir);
                    PluginManager.registerPlugin(dummy_plugin, plugin_id);
                    PluginInterface dummy_plugin_interface = this.manager.getPluginInterfaceByID(plugin_id);
                    ((InstallablePluginImpl)((Object)plugin)).addUpdate(inst, pup, dummy_plugin, dummy_plugin_interface);
                    inst.addListener(new UpdateCheckInstanceListener(){

                        public void cancelled(UpdateCheckInstance instance) {
                            dummy_plugin.requestUnload();
                        }

                        public void complete(UpdateCheckInstance instance) {
                            dummy_plugin.requestUnload();
                        }
                    });
                    continue;
                }
                ((InstallablePluginImpl)((Object)plugin)).addUpdate(inst, pup, existing_plugin, existing_plugin_interface);
            }
            inst.start();
        }
        catch (Throwable e) {
            inst.cancel();
            if (e instanceof PluginException) {
                throw (PluginException)e;
            }
            throw new PluginException("Failed to create installer", e);
        }
    }

    public void uninstall(InstallablePlugin standard_plugin) throws PluginException {
        PluginInterface pi = standard_plugin.getAlreadyInstalledPlugin();
        if (pi == null) {
            throw new PluginException(" Plugin '" + standard_plugin.getId() + "' is not installed");
        }
        pi.uninstall();
    }

    public void uninstall(PluginInterface pi) throws PluginException {
        this.uninstall(new PluginInterface[]{pi});
    }

    public void uninstall(PluginInterface[] pis) throws PluginException {
        for (int i = 0; i < pis.length; ++i) {
            PluginInterface pi = pis[i];
            if (pi.isMandatory()) {
                throw new PluginException("Plugin '" + pi.getPluginID() + "' is mandatory, can't uninstall");
            }
            if (pi.isBuiltIn()) {
                throw new PluginException("Plugin '" + pi.getPluginID() + "' is built-in, can't uninstall");
            }
            String plugin_dir = pi.getPluginDirectoryName();
            if (plugin_dir != null && new File(plugin_dir).exists()) continue;
            throw new PluginException("Plugin '" + pi.getPluginID() + "' is not loaded from the file system, can't uninstall");
        }
        try {
            UpdateManager uman = this.manager.getDefaultPluginInterface().getUpdateManager();
            UpdateCheckInstance inst = uman.createEmptyUpdateCheckInstance(3, "update.instance.uninstall");
            for (int i = 0; i < pis.length; ++i) {
                final PluginInterface pi = pis[i];
                final String plugin_dir = pi.getPluginDirectoryName();
                inst.addUpdatableComponent(new UpdatableComponent(){

                    public String getName() {
                        return pi.getPluginName();
                    }

                    public int getMaximumCheckTime() {
                        return 0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void checkForUpdate(UpdateChecker checker) {
                        try {
                            ResourceDownloader rd = PluginInstallerImpl.this.manager.getDefaultPluginInterface().getUtilities().getResourceDownloaderFactory().create(new File(plugin_dir));
                            rd.addListener(new ResourceDownloaderAdapter(this, checker){
                                private final /* synthetic */ UpdateChecker val$checker;
                                private final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$checker = val$checker;
                                }

                                public boolean completed(ResourceDownloader downloader, InputStream data) {
                                    try {
                                        if (2.access$100(this.this$1).isUnloadable()) {
                                            2.access$100(this.this$1).unload();
                                            FileUtil.recursiveDelete(new File(2.access$200(this.this$1)));
                                        } else {
                                            UpdateInstaller installer = this.val$checker.createInstaller();
                                            installer.addRemoveAction(new File(2.access$200(this.this$1)).getCanonicalPath());
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                        Logger.log(new LogAlert(true, "Plugin uninstall failed", e));
                                    }
                                    return true;
                                }

                                public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                                    if (!downloader.isCancelled()) {
                                        Logger.log(new LogAlert(true, "Plugin uninstall failed", e));
                                    }
                                }
                            });
                            String update_name = "";
                            PluginInterface[] ifs = PluginInstallerImpl.this.manager.getPluginInterfaces();
                            Arrays.sort(ifs, new Comparator(this){
                                private final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public int compare(Object o1, Object o2) {
                                    return ((PluginInterface)o1).getPluginName().compareTo(((PluginInterface)o2).getPluginName());
                                }
                            });
                            for (int i = 0; i < ifs.length; ++i) {
                                if (!ifs[i].getPluginID().equals(pi.getPluginID())) continue;
                                update_name = update_name + (update_name.length() == 0 ? "" : ",") + ifs[i].getPluginName();
                            }
                            checker.addUpdate(update_name, new String[]{"Uninstall: " + plugin_dir}, pi.getPluginVersion(), rd, pi.isUnloadable() ? 1 : 2);
                        }
                        finally {
                            checker.completed();
                        }
                    }

                    static /* synthetic */ PluginInterface access$100(2 x0) {
                        return x0.pi;
                    }

                    static /* synthetic */ String access$200(2 x0) {
                        return x0.plugin_dir;
                    }
                }, false);
            }
            inst.start();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected PluginInterface getAlreadyInstalledPlugin(String id) {
        return this.getPluginManager().getPluginInterfaceByID(id);
    }

    public void requestInstall(String reason, InstallablePlugin plugin) throws PluginException {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!((PluginInstallerListener)this.listeners.get(i)).installRequest(reason, plugin)) continue;
            return;
        }
        throw new PluginException("No listeners registered to perform installation of '" + plugin.getName() + " (" + reason + ")");
    }

    public void addListener(PluginInstallerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(PluginInstallerListener l) {
        this.listeners.remove(l);
    }
}

