/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.plugins.clientid.ClientIDManager;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.logging.Logger;
import org.gudy.azureus2.plugins.messaging.MessageManager;
import org.gudy.azureus2.plugins.network.ConnectionManager;
import org.gudy.azureus2.plugins.peers.protocol.PeerProtocolManager;
import org.gudy.azureus2.plugins.platform.PlatformManager;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ConfigSection;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.PluginConfigUIFactory;
import org.gudy.azureus2.plugins.ui.tables.mytorrents.PluginMyTorrentsItemFactory;
import org.gudy.azureus2.plugins.ui.tables.peers.PluginPeerItemFactory;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.ShortCuts;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.PluginInstallerImpl;
import org.gudy.azureus2.pluginsimpl.local.ipc.IPCInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPFilterImpl;
import org.gudy.azureus2.pluginsimpl.local.logging.LoggerImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.network.ConnectionManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.protocol.PeerProtocolManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ConfigSectionRepository;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterRepository;
import org.gudy.azureus2.pluginsimpl.local.ui.config.PluginConfigUIFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.ShortCutsImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class PluginInterfaceImpl
implements PluginInterface {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    private Plugin plugin;
    private PluginInitializer initialiser;
    private Object initialiser_key;
    private ClassLoader class_loader;
    private List listeners = new ArrayList();
    private List event_listeners = new ArrayList();
    private String key;
    private String pluginConfigKey;
    private Properties props;
    private String pluginDir;
    private PluginConfig config;
    private String plugin_id;
    private String plugin_version;
    private boolean operational;
    private boolean disabled;
    private Logger logger;
    private IPCInterface ipc_interface;
    private List children = new ArrayList();

    public PluginInterfaceImpl(Plugin _plugin, PluginInitializer _initialiser, Object _initialiser_key, ClassLoader _class_loader, String _key, Properties _props, String _pluginDir, String _plugin_id, String _plugin_version) {
        this.plugin = _plugin;
        this.initialiser = _initialiser;
        this.initialiser_key = _initialiser_key;
        this.class_loader = _class_loader;
        this.key = _key;
        this.pluginConfigKey = "Plugin." + _key;
        this.props = new propertyWrapper(_props);
        this.pluginDir = _pluginDir;
        this.config = new PluginConfigImpl(this, this.pluginConfigKey);
        this.plugin_id = _plugin_id;
        this.plugin_version = _plugin_version;
        this.ipc_interface = new IPCInterfaceImpl(this.plugin);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    protected void setOperational(boolean b) {
        this.operational = b;
    }

    public boolean isOperational() {
        return this.operational;
    }

    public Object getInitializerKey() {
        return this.initialiser_key;
    }

    public PluginManager getPluginManager() {
        return this.initialiser.getPluginManager();
    }

    public String getAzureusName() {
        return "Azureus";
    }

    public String getAzureusVersion() {
        return "2.5.0.0";
    }

    public void addView(PluginView view) {
        this.getUIManager().getSWTManager().addView(view);
    }

    public void addConfigSection(ConfigSection section) {
        ConfigSectionRepository.getInstance().addConfigSection(section);
    }

    public void removeConfigSection(ConfigSection section) {
        ConfigSectionRepository.getInstance().removeConfigSection(section);
    }

    public void openTorrentFile(String fileName) {
        try {
            this.getDownloadManager().addDownload(new File(fileName));
        }
        catch (DownloadException e) {
            throw new RuntimeException(e);
        }
    }

    public void openTorrentURL(String url) {
        try {
            this.getDownloadManager().addDownload(new URL(url));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void setPluginName(String name) {
        this.props.put("plugin.name", name);
    }

    public String getPluginName() {
        String name = null;
        if (this.props != null) {
            name = (String)this.props.get("plugin.name");
        }
        if (name == null) {
            try {
                name = new File(this.pluginDir).getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (name == null || name.length() == 0) {
            name = this.plugin.getClass().getName();
        }
        return name;
    }

    public void setPluginVersion(String version) {
        this.props.put("plugin.version", version);
    }

    public String getPluginVersion() {
        String version = (String)this.props.get("plugin.version");
        if (version == null) {
            version = this.plugin_version;
        }
        return version;
    }

    public String getPluginID() {
        String id = (String)this.props.get("plugin.id");
        if (id == null) {
            id = this.plugin_id;
        }
        return id == null ? "<none>" : id;
    }

    public boolean isMandatory() {
        String mand = this.getPluginProperties().getProperty("plugin.mandatory");
        return mand != null && mand.trim().toLowerCase().equals("true");
    }

    public boolean isBuiltIn() {
        return this.getPluginDirectoryName().length() == 0 || this.getPluginID().equals("azupdater");
    }

    public void setDisabled(boolean _disabled) {
        this.disabled = _disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public Properties getPluginProperties() {
        return this.props;
    }

    public String getPluginDirectoryName() {
        return this.pluginDir;
    }

    public void setPluginDirectoryName(String name) {
        this.initialiser_key = new File(name);
        this.pluginDir = name;
    }

    public void addConfigUIParameters(Parameter[] parameters, String displayName) {
        ParameterRepository.getInstance().addPlugin(parameters, displayName);
    }

    public PluginConfig getPluginconfig() {
        return this.config;
    }

    public PluginConfigUIFactory getPluginConfigUIFactory() {
        return new PluginConfigUIFactoryImpl(this.config, this.pluginConfigKey);
    }

    public String getPluginConfigKey() {
        return this.pluginConfigKey;
    }

    public void addColumnToPeersTable(String columnName, PluginPeerItemFactory item) {
        Debug.out("Method PluginInterface::addColumnToPeersTable deprecated. Use getUIManager().getTableManager().createColumn");
    }

    public void addColumnToMyTorrentsTable(String columnName, PluginMyTorrentsItemFactory item) {
        Debug.out("Method PluginInterface::addColumnToMyTorrentsTable deprecated. Use getUIManager().getTableManager().createColumn");
    }

    public Tracker getTracker() {
        return TrackerImpl.getSingleton();
    }

    public ShareManager getShareManager() throws ShareException {
        return ShareManagerImpl.getSingleton();
    }

    public DownloadManager getDownloadManager() {
        return DownloadManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    public TorrentManager getTorrentManager() {
        return TorrentManagerImpl.getSingleton().specialise(this);
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = new LoggerImpl(this);
        }
        return this.logger;
    }

    public IPFilter getIPFilter() {
        return new IPFilterImpl();
    }

    public Utilities getUtilities() {
        return new UtilitiesImpl(this.initialiser.getAzureusCore(), this);
    }

    public ShortCuts getShortCuts() {
        return new ShortCutsImpl(this);
    }

    public UIManager getUIManager() {
        return new UIManagerImpl(this);
    }

    public UpdateManager getUpdateManager() {
        return UpdateManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    public PeerProtocolManager getPeerProtocolManager() {
        return PeerProtocolManagerImpl.getSingleton();
    }

    public boolean isUnloadable() {
        int i;
        String dir = this.getPluginDirectoryName();
        if (dir == null || dir.length() == 0) {
            return this.getPlugin() instanceof UnloadablePlugin;
        }
        List pis = PluginInitializer.getPluginInterfaces();
        for (i = 0; i < pis.size(); ++i) {
            PluginInterface pi = (PluginInterface)pis.get(i);
            String other_dir = pi.getPluginDirectoryName();
            if (other_dir == null || other_dir.length() == 0 || !dir.equals(other_dir) || pi.getPlugin() instanceof UnloadablePlugin) continue;
            return false;
        }
        for (i = 0; i < this.children.size(); ++i) {
            if (((PluginInterface)this.children.get(i)).isUnloadable()) continue;
            return false;
        }
        return true;
    }

    public void unload() throws PluginException {
        if (!this.isUnloadable()) {
            throw new PluginException("Plugin isn't unloadable");
        }
        String dir = this.getPluginDirectoryName();
        if (dir == null || dir.length() == 0) {
            ((UnloadablePlugin)this.getPlugin()).unload();
            this.initialiser.unloadPlugin(this);
        } else {
            ArrayList pis = new ArrayList(PluginInitializer.getPluginInterfaces());
            for (int i = 0; i < pis.size(); ++i) {
                PluginInterfaceImpl pi = (PluginInterfaceImpl)pis.get(i);
                String other_dir = pi.getPluginDirectoryName();
                if (other_dir == null || other_dir.length() == 0 || !dir.equals(other_dir)) continue;
                ((UnloadablePlugin)pi.getPlugin()).unload();
                this.initialiser.unloadPlugin(pi);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((PluginInterface)this.children.get(i)).unload();
        }
        this.setOperational(false);
        this.class_loader = null;
    }

    public void reload() throws PluginException {
        this.unload();
        this.initialiser.reloadPlugin(this);
    }

    public void uninstall() throws PluginException {
        PluginInstallerImpl.getSingleton(this.getPluginManager()).uninstall(this);
    }

    public ClientIDManager getClientIDManager() {
        return ClientIDManagerImpl.getSingleton();
    }

    public ConnectionManager getConnectionManager() {
        return ConnectionManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    public MessageManager getMessageManager() {
        return MessageManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    public DistributedDatabase getDistributedDatabase() {
        return DDBaseImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    public PlatformManager getPlatformManager() {
        return PlatformManagerFactory.getPlatformManager();
    }

    protected void initialisationComplete() {
        int i;
        for (i = 0; i < this.listeners.size(); ++i) {
            try {
                ((PluginListener)this.listeners.get(i)).initializationComplete();
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        for (i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).initialisationComplete();
        }
    }

    protected void closedownInitiated() {
        int i;
        for (i = 0; i < this.listeners.size(); ++i) {
            try {
                ((PluginListener)this.listeners.get(i)).closedownInitiated();
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        for (i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).closedownInitiated();
        }
    }

    protected void closedownComplete() {
        int i;
        for (i = 0; i < this.listeners.size(); ++i) {
            try {
                ((PluginListener)this.listeners.get(i)).closedownComplete();
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        for (i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).closedownComplete();
        }
    }

    public void firePluginEvent(PluginEvent event2) {
        int i;
        for (i = 0; i < this.event_listeners.size(); ++i) {
            try {
                ((PluginEventListener)this.event_listeners.get(i)).handleEvent(event2);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        for (i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).firePluginEvent(event2);
        }
    }

    public ClassLoader getPluginClassLoader() {
        return this.class_loader;
    }

    public PluginInterface getLocalPluginInterface(Class plugin_class, String id) throws PluginException {
        try {
            Plugin p = (Plugin)plugin_class.newInstance();
            PluginInterfaceImpl pi = new PluginInterfaceImpl(p, this.initialiser, this.initialiser_key, this.class_loader, this.key + "." + id, this.props, this.pluginDir, this.plugin_id + "." + id, this.plugin_version);
            p.initialize(pi);
            this.children.add(pi);
            return pi;
        }
        catch (Throwable e) {
            if (e instanceof PluginException) {
                throw (PluginException)e;
            }
            throw new PluginException("Local initialisation fails", e);
        }
    }

    public IPCInterface getIPC() {
        return this.ipc_interface;
    }

    public void addListener(PluginListener l) {
        this.listeners.add(l);
        if (this.initialiser.isInitialisationComplete()) {
            l.initializationComplete();
        }
    }

    public void removeListener(PluginListener l) {
        this.listeners.remove(l);
    }

    public void addEventListener(PluginEventListener l) {
        this.event_listeners.add(l);
    }

    public void removeEventListener(PluginEventListener l) {
        this.event_listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateEvidence(IndentWriter writer) {
        writer.println(this.getPluginName());
        try {
            writer.indent();
            writer.println("id:" + this.getPluginID() + ",version:" + this.getPluginVersion());
            String user_dir = FileUtil.getUserFile("plugins").toString();
            String shared_dir = FileUtil.getApplicationFile("plugins").toString();
            String plugin_dir = this.getPluginDirectoryName();
            String type = plugin_dir.startsWith(shared_dir) ? "shared" : (plugin_dir.startsWith(user_dir) ? "per-user" : "built-in");
            writer.println("type:" + type + ",enabled:" + !this.isDisabled() + ",operational:" + this.isOperational());
        }
        finally {
            writer.exdent();
        }
    }

    protected class propertyWrapper
    extends Properties {
        protected boolean initialising = true;

        protected propertyWrapper(Properties _props) {
            Iterator<Object> it = _props.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                this.put(key, _props.get(key));
            }
            this.initialising = false;
        }

        public Object setProperty(String str, String val) {
            if (!PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("org.gudy") && !PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("com.aelitis.") && (str.equalsIgnoreCase("plugin.id") || str.equalsIgnoreCase("plugin.version"))) {
                if (org.gudy.azureus2.core3.logging.Logger.isEnabled()) {
                    org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(LOGID, 1, "Plugin '" + PluginInterfaceImpl.this.getPluginName() + "' tried to set property '" + str + "' - action ignored"));
                }
                return null;
            }
            return super.setProperty(str, val);
        }

        public Object put(Object key, Object value) {
            String k_str;
            if (!PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("org.gudy") && !PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("com.aelitis.") && !this.initialising && key instanceof String && ((k_str = (String)key).equalsIgnoreCase("plugin.id") || k_str.equalsIgnoreCase("plugin.version"))) {
                if (org.gudy.azureus2.core3.logging.Logger.isEnabled()) {
                    org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(LOGID, 1, "Plugin '" + PluginInterfaceImpl.this.getPluginName() + "' tried to set property '" + k_str + "' - action ignored"));
                }
                return null;
            }
            return super.put(key, value);
        }

        public Object get(Object key) {
            return super.get(key);
        }
    }
}

