/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.macosx.access.cocoa;

import com.apple.cocoa.foundation.NSAppleEventDescriptor;
import com.apple.cocoa.foundation.NSAppleScript;
import com.apple.cocoa.foundation.NSAutoreleasePool;
import com.apple.cocoa.foundation.NSMutableDictionary;
import java.io.File;
import java.text.MessageFormat;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.macosx.NativeInvocationBridge;

public final class CocoaJavaBridge
extends NativeInvocationBridge {
    protected static final String CLASS_PATH = "/system/library/java";
    private static final String PF_SCRIPT_SRC = "tell application \"System Events\" to exists process \"Path Finder\"";
    private final NSAppleScript PF_SCRIPT;
    private final boolean USE_PF;
    private static final String REVEAL_SCRIPT_FORMAT = "tell application \"System Events\"\ntell application \"{0}\"\nactivate\nreveal (posix file \"{1}\" as alias)\nend tell\nend tell";
    private static final String DEL_SCRIPT_FORMAT = "tell application \"Finder\" to move (posix file \"{0}\" as alias) to the trash";
    private int mainPool;
    protected AEMonitor classMon = new AEMonitor("CocoaJavaBridge:C");
    private AEMonitor scriptMon = new AEMonitor("CocoaJavaBridge:S");
    protected boolean isDisposed = false;
    protected RunnableDispatcher scriptDispatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CocoaJavaBridge() {
        try {
            this.classMon.enter();
            this.mainPool = NSAutoreleasePool.push();
            this.PF_SCRIPT = new NSAppleScript(PF_SCRIPT_SRC);
            this.USE_PF = this.PF_SCRIPT.compile(new NSMutableDictionary());
            this.scriptDispatcher = new RunnableDispatcher();
        }
        finally {
            this.classMon.exit();
        }
    }

    protected boolean performRecoverableFileDelete(File path) {
        if (!path.exists()) {
            return false;
        }
        NSAppleEventDescriptor result = this.executeScriptWithAsync(DEL_SCRIPT_FORMAT, new Object[]{path.getAbsolutePath()});
        return result != null;
    }

    protected boolean showInFinder(File path) {
        NSAppleEventDescriptor result;
        if (!path.exists()) {
            return false;
        }
        int pool = NSAutoreleasePool.push();
        String fb = "Finder";
        if (this.USE_PF && (result = this.PF_SCRIPT.execute(new NSMutableDictionary())) != null && result.booleanValue()) {
            fb = "Path Finder";
        }
        result = this.executeScriptWithAsync(REVEAL_SCRIPT_FORMAT, new Object[]{fb, path.getAbsolutePath()});
        NSAutoreleasePool.pop((int)pool);
        return result != null;
    }

    protected boolean isEnabled() {
        return System.getProperty("java.class.path").toLowerCase().indexOf(CLASS_PATH) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NSAppleEventDescriptor executeScript(String scriptFormat, Object[] params) {
        try {
            this.scriptMon.enter();
            int pool = NSAutoreleasePool.push();
            long start = System.currentTimeMillis();
            String src = params == null || params.length == 0 ? scriptFormat : MessageFormat.format(scriptFormat, params);
            Debug.outNoStack("Executing: \n" + src);
            NSAppleScript scp = new NSAppleScript(src);
            NSAppleEventDescriptor result = scp.execute(new NSMutableDictionary());
            Debug.outNoStack(MessageFormat.format("Elapsed time: {0}ms\n", new Long(System.currentTimeMillis() - start)));
            NSAutoreleasePool.pop((int)pool);
            NSAppleEventDescriptor nSAppleEventDescriptor = result;
            return nSAppleEventDescriptor;
        }
        finally {
            this.scriptMon.exit();
        }
    }

    protected final NSAppleEventDescriptor executeScriptWithNewThread(final String scriptFormat, final Object[] params) {
        AEThread worker = new AEThread("ScriptObject", true){

            public void runSupport() {
                int pool = NSAutoreleasePool.push();
                long start = System.currentTimeMillis();
                String src = params == null || params.length == 0 ? scriptFormat : MessageFormat.format(scriptFormat, params);
                Debug.outNoStack("Executing: \n" + src);
                NSMutableDictionary errorInfo = new NSMutableDictionary();
                if (new NSAppleScript(src).execute(errorInfo) == null) {
                    Debug.out(String.valueOf(errorInfo.objectForKey((Object)"NSAppleScriptErrorMessage")));
                }
                Debug.outNoStack(MessageFormat.format("Elapsed time: {0}ms\n", new Long(System.currentTimeMillis() - start)));
                NSAutoreleasePool.pop((int)pool);
            }
        };
        worker.setPriority(4);
        worker.start();
        return NSAppleEventDescriptor.descriptorWithBoolean((boolean)true);
    }

    protected final NSAppleEventDescriptor executeScriptWithAsync(final String scriptFormat, final Object[] params) {
        final AERunnable worker = new AERunnable(){

            public void runSupport() {
                int pool = NSAutoreleasePool.push();
                long start = System.currentTimeMillis();
                String src = params == null || params.length == 0 ? scriptFormat : MessageFormat.format(scriptFormat, params);
                Debug.outNoStack("Executing: \n" + src);
                NSMutableDictionary errorInfo = new NSMutableDictionary();
                if (new NSAppleScript(src).execute(errorInfo) == null) {
                    Debug.out(String.valueOf(errorInfo.objectForKey((Object)"NSAppleScriptErrorMessage")));
                }
                Debug.outNoStack(MessageFormat.format("Elapsed time: {0}ms\n", new Long(System.currentTimeMillis() - start)));
                NSAutoreleasePool.pop((int)pool);
            }
        };
        AEThread t = new AEThread("ScriptObject", true){

            public void runSupport() {
                CocoaJavaBridge.this.scriptDispatcher.exec(worker);
            }
        };
        t.setPriority(4);
        t.start();
        return NSAppleEventDescriptor.descriptorWithBoolean((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logWarning(String message) {
        try {
            this.classMon.enter();
            Logger.log(new LogAlert(false, 1, message));
        }
        finally {
            this.classMon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        try {
            this.classMon.enter();
            if (!this.isDisposed) {
                Debug.outNoStack("Disposing Native PlatformManager...");
                NSAutoreleasePool.pop((int)this.mainPool);
                this.isDisposed = true;
                Debug.outNoStack("Done");
            }
        }
        finally {
            this.classMon.exit();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private static class RunnableDispatcher {
        private RunnableDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exec(Runnable runnable) {
            RunnableDispatcher runnableDispatcher = this;
            synchronized (runnableDispatcher) {
                runnable.run();
            }
        }
    }
}

