/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class TrackersUtil {
    private List trackers = new ArrayList();
    private Map multiTrackers = new HashMap();
    private static TrackersUtil instance;
    private static AEMonitor class_mon;

    private TrackersUtil() {
        this.loadList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrackersUtil getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new TrackersUtil();
            }
            TrackersUtil trackersUtil = instance;
            return trackersUtil;
        }
        finally {
            class_mon.exit();
        }
    }

    public List getTrackersList() {
        if (this.trackers != null) {
            return new ArrayList(this.trackers);
        }
        return null;
    }

    public void addTracker(String trackerAnnounceUrl) {
        if (this.trackers.contains(trackerAnnounceUrl)) {
            return;
        }
        this.trackers.add(0, trackerAnnounceUrl);
        this.saveList();
    }

    public void addMultiTracker(String configName, List groups) {
        this.multiTrackers.put(configName, groups);
        this.saveList();
    }

    public void removeMultiTracker(String configName) {
        this.multiTrackers.remove(configName);
        this.saveList();
    }

    public Map getMultiTrackers() {
        return new HashMap(this.multiTrackers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadList() {
        block26: {
            File fTrackers = FileUtil.getUserFile("trackers.config");
            if (fTrackers.exists() && fTrackers.isFile()) {
                Throwable e222;
                BufferedInputStream bin;
                FileInputStream fin;
                block24: {
                    Map mapMT;
                    fin = null;
                    bin = null;
                    fin = new FileInputStream(fTrackers);
                    bin = new BufferedInputStream(fin, 8192);
                    Map map = BDecoder.decode(bin);
                    List list = (List)map.get("trackers");
                    if (list != null) {
                        Iterator iter = list.iterator();
                        while (iter.hasNext()) {
                            String tracker = new String((byte[])iter.next());
                            this.trackers.add(tracker);
                        }
                    }
                    if ((mapMT = (Map)map.get("multi-trackers")) != null) {
                        Iterator iter = mapMT.keySet().iterator();
                        while (iter.hasNext()) {
                            String configName = (String)iter.next();
                            List groups = (List)mapMT.get(configName);
                            ArrayList resGroups = new ArrayList(groups.size());
                            Iterator iterGroups = groups.iterator();
                            while (iterGroups.hasNext()) {
                                List theseTrackers = (List)iterGroups.next();
                                ArrayList<String> resTrackers = new ArrayList<String>(theseTrackers.size());
                                Iterator iterTrackers = theseTrackers.iterator();
                                while (iterTrackers.hasNext()) {
                                    String tracker = new String((byte[])iterTrackers.next());
                                    resTrackers.add(tracker);
                                }
                                resGroups.add(resTrackers);
                            }
                            this.multiTrackers.put(configName, resGroups);
                        }
                    }
                    Object var17_17 = null;
                    if (bin == null) break block24;
                    try {
                        bin.close();
                    }
                    catch (Throwable e222) {
                        // empty catch block
                    }
                }
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Throwable e222) {}
                }
                break block26;
                {
                    catch (Exception e3) {
                        Throwable e222;
                        Debug.printStackTrace(e3);
                        Object var17_18 = null;
                        if (bin != null) {
                            try {
                                bin.close();
                            }
                            catch (Throwable e222) {
                                // empty catch block
                            }
                        }
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (Throwable e222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    Throwable e222;
                    Object var17_19 = null;
                    if (bin != null) {
                        try {
                            bin.close();
                        }
                        catch (Throwable e222) {
                            // empty catch block
                        }
                    }
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (Throwable e222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveList() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("trackers", this.trackers);
        map.put("multi-trackers", this.multiTrackers);
        FileOutputStream fos = null;
        File fTrackers = FileUtil.getUserFile("trackers.config");
        fos = new FileOutputStream(fTrackers);
        fos.write(BEncoder.encode(map));
        fos.close();
        Object var5_5 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (Throwable e2) {}
        return;
        {
            catch (Exception e) {
                Debug.printStackTrace(e);
                Object var5_6 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (Throwable e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (Throwable e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static {
        class_mon = new AEMonitor("TrackersUtil:class");
    }
}

