/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.List;

public class ByteArrayHashMap {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry[] table;
    private int size;
    private int threshold;
    final float loadFactor;

    public ByteArrayHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
    }

    public ByteArrayHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ByteArrayHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object get(byte[] key, int offset, int len) {
        byte[] k = new byte[len];
        System.arraycopy(key, offset, k, 0, len);
        return this.get(k);
    }

    public Object get(byte[] key) {
        int hash = ByteArrayHashMap.hash(key);
        int i = ByteArrayHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && ByteArrayHashMap.eq(key, e.key)) {
                return e.value;
            }
            e = e.next;
        }
        return e;
    }

    public boolean containsKey(byte[] key) {
        int hash = ByteArrayHashMap.hash(key);
        int i = ByteArrayHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && ByteArrayHashMap.eq(key, e.key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object put(byte[] key, Object value) {
        int hash = ByteArrayHashMap.hash(key);
        int i = ByteArrayHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && ByteArrayHashMap.eq(key, e.key)) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        this.addEntry(hash, key, value, i);
        return null;
    }

    public Object remove(byte[] key) {
        Entry e = this.removeEntryForKey(key);
        return e == null ? e : e.value;
    }

    public void clear() {
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    public List keys() {
        ArrayList<byte[]> res = new ArrayList<byte[]>();
        for (int j = 0; j < this.table.length; ++j) {
            Entry e = this.table[j];
            while (e != null) {
                res.add(e.key);
                e = e.next;
            }
        }
        return res;
    }

    public List values() {
        ArrayList<Object> res = new ArrayList<Object>();
        for (int j = 0; j < this.table.length; ++j) {
            Entry e = this.table[j];
            while (e != null) {
                res.add(e.value);
                e = e.next;
            }
        }
        return res;
    }

    public ByteArrayHashMap duplicate() {
        ByteArrayHashMap res = new ByteArrayHashMap(this.size, this.loadFactor);
        for (int j = 0; j < this.table.length; ++j) {
            Entry e = this.table[j];
            while (e != null) {
                res.put(e.key, e.value);
                e = e.next;
            }
        }
        return res;
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = ByteArrayHashMap.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    Entry removeEntryForKey(byte[] key) {
        Entry prev;
        int hash = ByteArrayHashMap.hash(key);
        int i = ByteArrayHashMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && ByteArrayHashMap.eq(key, e.key)) {
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    void addEntry(int hash, byte[] key, Object value, int bucketIndex) {
        this.table[bucketIndex] = new Entry(hash, key, value, this.table[bucketIndex]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, byte[] key, Object value, int bucketIndex) {
        this.table[bucketIndex] = new Entry(hash, key, value, this.table[bucketIndex]);
        ++this.size;
    }

    private static final int hash(byte[] x) {
        int hash = 0;
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            hash = 31 * hash + x[i];
        }
        return hash;
    }

    private static final boolean eq(byte[] x, byte[] y) {
        if (x == y) {
            return true;
        }
        int len = x.length;
        if (len != y.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (x[i] == y[i]) continue;
            return false;
        }
        return true;
    }

    private static final int indexFor(int h, int length) {
        return h & length - 1;
    }

    static class Entry {
        final byte[] key;
        Object value;
        final int hash;
        Entry next;

        Entry(int h, byte[] k, Object v, Entry n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        public byte[] getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

