/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;

public class AddressUtils {
    public static final byte LAN_LOCAL_MAYBE = 0;
    public static final byte LAN_LOCAL_YES = 1;
    public static final byte LAN_LOCAL_NO = 2;
    private static AZInstanceManager instance_manager;

    public static URL adjustURL(URL url) {
        url = AEProxyFactory.getAddressMapper().internalise(url);
        return url;
    }

    public static InetSocketAddress adjustDHTAddress(InetSocketAddress address, boolean ext_to_lan) {
        if (instance_manager == null) {
            try {
                instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (instance_manager == null || !instance_manager.isInitialized()) {
            return address;
        }
        InetSocketAddress adjusted_address = ext_to_lan ? instance_manager.getLANAddress(address, 3) : instance_manager.getExternalAddress(address, 3);
        if (adjusted_address == null) {
            adjusted_address = address;
        }
        return adjusted_address;
    }

    public static byte isLANLocalAddress(InetSocketAddress socket_address) {
        InetAddress address = socket_address.getAddress();
        return AddressUtils.isLANLocalAddress(address);
    }

    public static byte isLANLocalAddress(InetAddress address) {
        if (address == null) {
            return 2;
        }
        if (instance_manager == null) {
            try {
                instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (instance_manager == null || !instance_manager.isInitialized()) {
            return 0;
        }
        return instance_manager.isLANAddress(address) ? (byte)1 : 2;
    }

    public static byte isLANLocalAddress(String address) {
        byte is_lan_local = 0;
        try {
            is_lan_local = AddressUtils.isLANLocalAddress(HostNameToIPResolver.syncResolve(address));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return is_lan_local;
    }
}

