/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.syrah.nc;

import edu.harvard.syrah.nc.Coordinate;
import edu.harvard.syrah.nc.WindowStatistic;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteState<T> {
    protected static double SAMPLE_PERCENTILE = 0.125;
    public static int MAX_SAMPLE_SIZE = 16;
    public static int MIN_SAMPLE_SIZE = 4;
    protected final T addr;
    protected final WindowStatistic ping_samples;
    protected Coordinate last_coords;
    protected double last_error;
    protected long last_update_time;

    public RemoteState(T _addr) {
        this.addr = _addr;
        this.ping_samples = new WindowStatistic(MAX_SAMPLE_SIZE);
        this.last_coords = null;
        this.last_error = 0.0;
        this.last_update_time = -1L;
    }

    public void assign(Coordinate _last_coords, double _last_error, long _curr_time) {
        this.last_coords = _last_coords;
        this.last_error = _last_error;
        this.last_update_time = _curr_time;
    }

    public void addSample(double sample_rtt, long sample_age, Coordinate r_coord, double r_error, long curr_time) {
        this.ping_samples.add(sample_rtt);
        this.last_coords = r_coord;
        this.last_error = r_error;
        this.last_update_time = sample_age > 0L ? curr_time - sample_age : curr_time;
    }

    public boolean isValid(long curr_time) {
        if (this.getLastError() <= 0.0 || this.last_update_time <= 0L || this.last_coords.atOrigin()) {
            return false;
        }
        if (this.getSampleSize() >= MIN_SAMPLE_SIZE && this.getSample() > 0.0) {
            return true;
        }
        return this.getSampleSize() >= 2 && this.ping_samples.withinVariance(0.1);
    }

    public double getSample() {
        return this.ping_samples.getPercentile(SAMPLE_PERCENTILE);
    }

    public int getSampleSize() {
        return this.ping_samples.getSize();
    }

    public Coordinate getLastCoordinate() {
        return this.last_coords;
    }

    public double getLastError() {
        return this.last_error;
    }

    public long getLastUpdateTime() {
        return this.last_update_time;
    }

    public static void main(String[] args) {
        System.out.println("Testing Remote State Object");
        String sampleFile = args[0];
        RemoteState<String> rs = new RemoteState<String>(sampleFile);
        BufferedReader sampleReader = null;
        try {
            sampleReader = new BufferedReader(new FileReader(new File(sampleFile)));
        }
        catch (FileNotFoundException ex) {
            System.err.println("Cannot open file " + sampleFile + ": " + ex);
            System.exit(-1);
        }
        long sample_age = 0L;
        Coordinate r_coord = null;
        double r_error = 0.0;
        try {
            String sampleLine = sampleReader.readLine();
            while (sampleLine != null) {
                StringTokenizer sampleTokenizer = new StringTokenizer(sampleLine);
                long curr_time = Long.parseLong((String)sampleTokenizer.nextElement());
                int rawRTT = Integer.parseInt((String)sampleTokenizer.nextElement());
                sampleLine = sampleReader.readLine();
                rs.addSample(rawRTT, sample_age, r_coord, r_error, curr_time);
                double smoothedRTT = rs.getSample();
                System.out.println(curr_time + " raw " + rawRTT + " smooth " + smoothedRTT);
            }
        }
        catch (Exception ex) {
            System.err.println("Problem parsing " + sampleFile + ": " + ex);
            System.exit(-1);
        }
    }
}

