/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.vivaldi.ver2.SyrahPosition;
import com.aelitis.azureus.vivaldi.ver2.VivaldiV2PositionProvider;
import edu.harvard.syrah.nc.Coordinate;
import java.io.DataInputStream;
import java.io.IOException;

class RemotePosition
extends SyrahPosition {
    private Coordinate coords;
    private float error;
    private long age;

    protected RemotePosition(DataInputStream dis) throws IOException {
        this.coords = new Coordinate(5, dis);
        this.error = dis.readFloat();
        this.age = dis.readLong();
    }

    public Coordinate getCoords() {
        return this.coords;
    }

    public Coordinate getStableCoords() {
        return this.coords;
    }

    public float getError() {
        return this.error;
    }

    public long getAge() {
        return this.age;
    }

    public float estimateRTT(DHTNetworkPosition other) {
        SyrahPosition sp = (SyrahPosition)other;
        return (float)this.coords.distanceTo(sp.getCoords());
    }

    public void update(byte[] other_id, DHTNetworkPosition other, float rtt) {
        VivaldiV2PositionProvider.doLog("method update invoked on a remote position");
    }
}

