/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.vivaldi.ver2.SyrahPosition;
import edu.harvard.syrah.nc.Coordinate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class DeserializedPosition
extends SyrahPosition {
    private Coordinate coords;
    private float error;
    private long age;

    protected DeserializedPosition(DataInputStream dis) throws IOException {
        this.coords = new Coordinate(5, dis);
        this.error = dis.readFloat();
        this.age = dis.readLong();
    }

    public Coordinate getCoords() {
        return this.coords;
    }

    public Coordinate getStableCoords() {
        return this.coords;
    }

    public float getError() {
        return this.error;
    }

    public long getAge() {
        return this.age;
    }

    public float estimateRTT(DHTNetworkPosition other) {
        SyrahPosition sp = (SyrahPosition)other;
        return (float)this.coords.distanceTo(sp.getCoords());
    }

    public void update(byte[] other_id, DHTNetworkPosition other, float rtt) {
        SyrahPosition sp = (SyrahPosition)other;
        this.coords = sp.getCoords();
        this.error = sp.getError();
        this.age = sp.getAge();
    }

    public void serialise(DataOutputStream dos) throws IOException {
        this.coords.toSerialized(dos);
        dos.writeFloat(this.error);
        dos.writeLong(this.age);
    }
}

