/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class OutgoingMessageQueue {
    private final LinkedList queue = new LinkedList();
    private final AEMonitor queue_mon = new AEMonitor("OutgoingMessageQueue:queue");
    private final ArrayList delayed_notifications = new ArrayList();
    private final AEMonitor delayed_notifications_mon = new AEMonitor("OutgoingMessageQueue:DN");
    private volatile ArrayList listeners = new ArrayList();
    private final AEMonitor listeners_mon = new AEMonitor("OutgoingMessageQueue:L");
    private int total_size = 0;
    private RawMessage urgent_message = null;
    private boolean destroyed = false;
    private MessageStreamEncoder stream_encoder;
    private Transport transport;
    private int percent_complete = -1;
    private static final boolean TRACE_HISTORY = true;
    private static final int MAX_HISTORY_TRACES = 30;
    private final LinkedList prev_sent = new LinkedList();

    public OutgoingMessageQueue(MessageStreamEncoder stream_encoder) {
        this.stream_encoder = stream_encoder;
    }

    public void setTransport(Transport _transport) {
        this.transport = _transport;
    }

    public int getMssSize() {
        return this.transport == null ? NetworkManager.getMinMssSize() : this.transport.getMssSize();
    }

    public void setEncoder(MessageStreamEncoder stream_encoder) {
        this.stream_encoder = stream_encoder;
    }

    public int getPercentDoneOfCurrentMessage() {
        return this.percent_complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroyed = true;
        try {
            this.queue_mon.enter();
            while (!this.queue.isEmpty()) {
                ((RawMessage)this.queue.remove(0)).destroy();
            }
        }
        finally {
            this.queue_mon.exit();
        }
        this.total_size = 0;
    }

    public int getTotalSize() {
        return this.total_size;
    }

    public boolean hasUrgentMessage() {
        return this.urgent_message != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Message message, boolean manual_listener_notify) {
        boolean allowed = true;
        ArrayList list_ref = this.listeners;
        for (int i = 0; i < list_ref.size(); ++i) {
            MessageQueueListener listener = (MessageQueueListener)list_ref.get(i);
            allowed = allowed && listener.messageAdded(message);
        }
        if (!allowed) {
            return;
        }
        RawMessage rmesg = this.stream_encoder.encodeMessage(message);
        if (this.destroyed) {
            rmesg.destroy();
            return;
        }
        this.removeMessagesOfType(rmesg.messagesToRemove(), manual_listener_notify);
        try {
            this.queue_mon.enter();
            int pos = 0;
            Iterator i = this.queue.iterator();
            while (i.hasNext()) {
                RawMessage msg = (RawMessage)i.next();
                if (rmesg.getPriority() > msg.getPriority() && msg.getRawData()[0].position((byte)5) == 0) break;
                ++pos;
            }
            if (rmesg.isNoDelay()) {
                this.urgent_message = rmesg;
            }
            this.queue.add(pos, rmesg);
            DirectByteBuffer[] payload = rmesg.getRawData();
            for (int i2 = 0; i2 < payload.length; ++i2) {
                this.total_size += payload[i2].remaining((byte)5);
            }
        }
        finally {
            this.queue_mon.exit();
        }
        if (manual_listener_notify) {
            NotificationItem item = new NotificationItem(0);
            item.message = rmesg;
            try {
                this.delayed_notifications_mon.enter();
                this.delayed_notifications.add(item);
            }
            finally {
                this.delayed_notifications_mon.exit();
            }
        } else {
            ArrayList listeners_ref = this.listeners;
            for (int i = 0; i < listeners_ref.size(); ++i) {
                MessageQueueListener listener = (MessageQueueListener)listeners_ref.get(i);
                listener.messageQueued(rmesg.getBaseMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessagesOfType(Message[] message_types, boolean manual_listener_notify) {
        if (message_types == null) {
            return;
        }
        ArrayList<RawMessage> messages_removed = null;
        try {
            this.queue_mon.enter();
            Iterator i = this.queue.iterator();
            block6: while (i.hasNext()) {
                RawMessage msg = (RawMessage)i.next();
                for (int t = 0; t < message_types.length; ++t) {
                    boolean same_type = message_types[t].getID().equals(msg.getID());
                    if (!same_type || msg.getRawData()[0].position((byte)5) != 0) continue;
                    if (msg == this.urgent_message) {
                        this.urgent_message = null;
                    }
                    DirectByteBuffer[] payload = msg.getRawData();
                    for (int x = 0; x < payload.length; ++x) {
                        this.total_size -= payload[x].remaining((byte)5);
                    }
                    if (manual_listener_notify) {
                        NotificationItem item = new NotificationItem(1);
                        item.message = msg;
                        try {
                            this.delayed_notifications_mon.enter();
                            this.delayed_notifications.add(item);
                        }
                        finally {
                            this.delayed_notifications_mon.exit();
                        }
                    } else {
                        if (messages_removed == null) {
                            messages_removed = new ArrayList<RawMessage>();
                        }
                        messages_removed.add(msg);
                    }
                    i.remove();
                    continue block6;
                }
            }
        }
        finally {
            this.queue_mon.exit();
        }
        if (!manual_listener_notify && messages_removed != null) {
            ArrayList listeners_ref = this.listeners;
            for (int x = 0; x < messages_removed.size(); ++x) {
                RawMessage msg = (RawMessage)messages_removed.get(x);
                for (int i = 0; i < listeners_ref.size(); ++i) {
                    MessageQueueListener listener = (MessageQueueListener)listeners_ref.get(i);
                    listener.messageRemoved(msg.getBaseMessage());
                }
                msg.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMessage(Message message, boolean manual_listener_notify) {
        Message msg_removed = null;
        try {
            this.queue_mon.enter();
            Iterator it = this.queue.iterator();
            while (it.hasNext()) {
                RawMessage raw = (RawMessage)it.next();
                if (!message.equals(raw.getBaseMessage())) continue;
                if (raw.getRawData()[0].position((byte)5) == 0) {
                    if (raw == this.urgent_message) {
                        this.urgent_message = null;
                    }
                    DirectByteBuffer[] payload = raw.getRawData();
                    for (int x = 0; x < payload.length; ++x) {
                        this.total_size -= payload[x].remaining((byte)5);
                    }
                    this.queue.remove(raw);
                    msg_removed = raw;
                }
                break;
            }
        }
        finally {
            this.queue_mon.exit();
        }
        if (msg_removed != null) {
            if (manual_listener_notify) {
                NotificationItem item = new NotificationItem(1);
                item.message = msg_removed;
                try {
                    this.delayed_notifications_mon.enter();
                    this.delayed_notifications.add(item);
                }
                finally {
                    this.delayed_notifications_mon.exit();
                }
            } else {
                ArrayList listeners_ref = this.listeners;
                for (int i = 0; i < listeners_ref.size(); ++i) {
                    MessageQueueListener listener = (MessageQueueListener)listeners_ref.get(i);
                    listener.messageRemoved(msg_removed.getBaseMessage());
                }
                msg_removed.destroy();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deliverToTransport(int max_bytes, boolean manual_listener_notify) throws IOException {
        if (max_bytes < 1) {
            Debug.out("max_bytes < 1: " + max_bytes);
            return 0;
        }
        if (this.transport == null) {
            throw new IOException("not ready to deliver data");
        }
        int data_written = 0;
        int protocol_written = 0;
        ArrayList<RawMessage> messages_sent = null;
        try {
            this.queue_mon.enter();
            if (!this.queue.isEmpty()) {
                ArrayList<ByteBuffer> raw_buffers = new ArrayList<ByteBuffer>();
                ArrayList<Integer> orig_positions = new ArrayList<Integer>();
                int total_sofar = 0;
                Iterator i = this.queue.iterator();
                while (i.hasNext()) {
                    DirectByteBuffer[] payloads = ((RawMessage)i.next()).getRawData();
                    boolean stop = false;
                    for (int x = 0; x < payloads.length; ++x) {
                        ByteBuffer buff = payloads[x].getBuffer((byte)5);
                        raw_buffers.add(buff);
                        orig_positions.add(new Integer(buff.position()));
                        if ((total_sofar += buff.remaining()) < max_bytes) continue;
                        stop = true;
                        break;
                    }
                    if (!stop) continue;
                    break;
                }
                int num_raw = raw_buffers.size();
                ByteBuffer last_buff = (ByteBuffer)raw_buffers.get(num_raw - 1);
                int orig_last_limit = last_buff.limit();
                if (total_sofar > max_bytes) {
                    last_buff.limit(orig_last_limit - (total_sofar - max_bytes));
                }
                ByteBuffer[] buffs = new ByteBuffer[num_raw];
                raw_buffers.toArray(buffs);
                this.transport.write(buffs, 0, num_raw);
                last_buff.limit(orig_last_limit);
                int pos = 0;
                boolean stop = false;
                block14: while (!this.queue.isEmpty() && !stop) {
                    RawMessage msg = (RawMessage)this.queue.get(0);
                    DirectByteBuffer[] payloads = msg.getRawData();
                    for (int x = 0; x < payloads.length; ++x) {
                        ByteBuffer bb = payloads[x].getBuffer((byte)5);
                        int bytes_written = bb.limit() - bb.remaining() - (Integer)orig_positions.get(pos);
                        this.total_size -= bytes_written;
                        if (x > 0 && msg.getType() == 1) {
                            data_written += bytes_written;
                        } else {
                            protocol_written += bytes_written;
                        }
                        if (bb.hasRemaining()) {
                            stop = true;
                            int message_size = 0;
                            int written = 0;
                            for (int i2 = 0; i2 < payloads.length; ++i2) {
                                ByteBuffer buff = payloads[i2].getBuffer((byte)5);
                                message_size += buff.limit();
                                if (i2 < x) {
                                    written += buff.limit();
                                    continue;
                                }
                                if (i2 != x) continue;
                                written += buff.position();
                            }
                            this.percent_complete = written * 100 / message_size;
                            continue block14;
                        }
                        if (x == payloads.length - 1) {
                            if (msg == this.urgent_message) {
                                this.urgent_message = null;
                            }
                            this.queue.remove(0);
                            this.prev_sent.addLast(msg);
                            if (this.prev_sent.size() > 30) {
                                this.prev_sent.removeFirst();
                            }
                            this.percent_complete = -1;
                            if (manual_listener_notify) {
                                NotificationItem item = new NotificationItem(2);
                                item.message = msg;
                                try {
                                    this.delayed_notifications_mon.enter();
                                    this.delayed_notifications.add(item);
                                }
                                finally {
                                    this.delayed_notifications_mon.exit();
                                }
                            } else {
                                if (messages_sent == null) {
                                    messages_sent = new ArrayList<RawMessage>();
                                }
                                messages_sent.add(msg);
                            }
                        }
                        if (++pos < num_raw) continue;
                        stop = true;
                        continue block14;
                    }
                }
            }
        }
        finally {
            this.queue_mon.exit();
        }
        if (data_written + protocol_written > 0) {
            if (manual_listener_notify) {
                NotificationItem item;
                if (data_written > 0) {
                    item = new NotificationItem(3);
                    item.byte_count = data_written;
                    try {
                        this.delayed_notifications_mon.enter();
                        this.delayed_notifications.add(item);
                    }
                    finally {
                        this.delayed_notifications_mon.exit();
                    }
                }
                if (protocol_written > 0) {
                    item = new NotificationItem(4);
                    item.byte_count = protocol_written;
                    try {
                        this.delayed_notifications_mon.enter();
                        this.delayed_notifications.add(item);
                    }
                    finally {
                        this.delayed_notifications_mon.exit();
                    }
                }
            } else {
                ArrayList listeners_ref = this.listeners;
                int num_listeners = listeners_ref.size();
                for (int i = 0; i < num_listeners; ++i) {
                    MessageQueueListener listener = (MessageQueueListener)listeners_ref.get(i);
                    if (data_written > 0) {
                        listener.dataBytesSent(data_written);
                    }
                    if (protocol_written > 0) {
                        listener.protocolBytesSent(protocol_written);
                    }
                    if (messages_sent == null) continue;
                    for (int x = 0; x < messages_sent.size(); ++x) {
                        RawMessage msg = (RawMessage)messages_sent.get(x);
                        listener.messageSent(msg.getBaseMessage());
                        if (i != num_listeners - 1) continue;
                        msg.destroy();
                    }
                }
            }
        }
        return data_written + protocol_written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doListenerNotifications() {
        ArrayList notifications_copy;
        try {
            this.delayed_notifications_mon.enter();
            if (this.delayed_notifications.size() == 0) {
                return;
            }
            notifications_copy = new ArrayList(this.delayed_notifications);
            this.delayed_notifications.clear();
        }
        finally {
            this.delayed_notifications_mon.exit();
        }
        ArrayList listeners_ref = this.listeners;
        block11: for (int j = 0; j < notifications_copy.size(); ++j) {
            NotificationItem item = (NotificationItem)notifications_copy.get(j);
            switch (item.type) {
                case 0: {
                    MessageQueueListener listener;
                    int i;
                    for (i = 0; i < listeners_ref.size(); ++i) {
                        listener = (MessageQueueListener)listeners_ref.get(i);
                        listener.messageQueued(item.message.getBaseMessage());
                    }
                    continue block11;
                }
                case 1: {
                    MessageQueueListener listener;
                    int i;
                    for (i = 0; i < listeners_ref.size(); ++i) {
                        listener = (MessageQueueListener)listeners_ref.get(i);
                        listener.messageRemoved(item.message.getBaseMessage());
                    }
                    item.message.destroy();
                    continue block11;
                }
                case 2: {
                    MessageQueueListener listener;
                    int i;
                    for (i = 0; i < listeners_ref.size(); ++i) {
                        listener = (MessageQueueListener)listeners_ref.get(i);
                        listener.messageSent(item.message.getBaseMessage());
                    }
                    item.message.destroy();
                    continue block11;
                }
                case 4: {
                    MessageQueueListener listener;
                    int i;
                    for (i = 0; i < listeners_ref.size(); ++i) {
                        listener = (MessageQueueListener)listeners_ref.get(i);
                        listener.protocolBytesSent(item.byte_count);
                    }
                    continue block11;
                }
                case 3: {
                    MessageQueueListener listener;
                    int i;
                    for (i = 0; i < listeners_ref.size(); ++i) {
                        listener = (MessageQueueListener)listeners_ref.get(i);
                        listener.dataBytesSent(item.byte_count);
                    }
                    continue block11;
                }
                default: {
                    Debug.out("NotificationItem.type unknown :" + item.type);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueueTrace() {
        StringBuffer trace = new StringBuffer();
        trace.append("**** OUTGOING QUEUE TRACE ****\n");
        try {
            this.queue_mon.enter();
            int i = 0;
            Iterator it = this.prev_sent.iterator();
            while (it.hasNext()) {
                RawMessage raw = (RawMessage)it.next();
                trace.append("[#h" + i + "]: ").append(raw.getID()).append(" [").append(raw.getDescription()).append("]").append("\n");
                ++i;
            }
            int position = this.queue.size() - 1;
            Iterator it2 = this.queue.iterator();
            while (it2.hasNext()) {
                RawMessage raw = (RawMessage)it2.next();
                int pos = raw.getRawData()[0].position((byte)5);
                int length = raw.getRawData()[0].limit((byte)5);
                trace.append("[#").append(position).append(" ").append(pos).append(":").append(length).append("]: ").append(raw.getID()).append(" [").append(raw.getDescription()).append("]").append("\n");
                --position;
            }
        }
        finally {
            this.queue_mon.exit();
        }
        return trace.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerQueueListener(MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList<MessageQueueListener> new_list = new ArrayList<MessageQueueListener>(this.listeners.size() + 1);
            new_list.addAll(this.listeners);
            new_list.add(listener);
            this.listeners = new_list;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQueueListener(MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList new_list = new ArrayList(this.listeners);
            new_list.remove(listener);
            this.listeners = new_list;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void notifyOfExternallySentMessage(Message message) {
        int i;
        ArrayList listeners_ref = this.listeners;
        DirectByteBuffer[] buffs = message.getData();
        int size = 0;
        for (i = 0; i < buffs.length; ++i) {
            size += buffs[i].remaining((byte)5);
        }
        for (i = 0; i < listeners_ref.size(); ++i) {
            MessageQueueListener listener = (MessageQueueListener)listeners_ref.get(i);
            listener.messageSent(message);
            if (message.getType() == 1) {
                listener.dataBytesSent(size);
                continue;
            }
            listener.protocolBytesSent(size);
        }
    }

    private static class NotificationItem {
        private static final int MESSAGE_ADDED = 0;
        private static final int MESSAGE_REMOVED = 1;
        private static final int MESSAGE_SENT = 2;
        private static final int DATA_BYTES_SENT = 3;
        private static final int PROTOCOL_BYTES_SENT = 4;
        private final int type;
        private RawMessage message;
        private int byte_count = 0;

        private NotificationItem(int notification_type) {
            this.type = notification_type;
        }
    }

    public static interface MessageQueueListener {
        public boolean messageAdded(Message var1);

        public void messageQueued(Message var1);

        public void messageRemoved(Message var1);

        public void messageSent(Message var1);

        public void protocolBytesSent(int var1);

        public void dataBytesSent(int var1);
    }
}

