/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreLifecycleListener;
import com.aelitis.azureus.core.AzureusCoreListener;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationListener;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerFactory;
import com.aelitis.azureus.core.nat.NATTraverser;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.download.session.TorrentSessionManager;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraverser;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerAdapter;
import com.aelitis.azureus.core.speedmanager.SpeedManagerFactory;
import com.aelitis.azureus.core.update.AzureusRestarterFactory;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManagerFactory;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.global.GlobalMangerProgressListener;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostFactory;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.platform.PlatformManagerListener;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginManagerDefaults;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class AzureusCoreImpl
implements AzureusCore {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected static AzureusCore singleton;
    protected static AEMonitor class_mon;
    private PluginInitializer pi;
    private GlobalManager global_manager;
    private AZInstanceManager instance_manager;
    private SpeedManager speed_manager;
    private CryptoManager crypto_manager;
    private NATTraverser nat_traverser;
    private boolean started;
    private boolean stopped;
    private List listeners = new ArrayList();
    private List lifecycle_listeners = new ArrayList();
    private List operation_listeners = new ArrayList();
    private AESemaphore stopping_sem = new AESemaphore("AzureusCore::stopping");
    private AEMonitor this_mon = new AEMonitor("AzureusCore");
    private AzureusCoreOperation initialisation_op = this.createOperation(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AzureusCore create() throws AzureusCoreException {
        try {
            class_mon.enter();
            if (singleton != null) {
                throw new AzureusCoreException("Azureus core already instantiated");
            }
            AzureusCore azureusCore = singleton = new AzureusCoreImpl();
            return azureusCore;
        }
        finally {
            class_mon.exit();
        }
    }

    public static boolean isCoreAvailable() {
        return singleton != null;
    }

    public static AzureusCore getSingleton() throws AzureusCoreException {
        if (singleton == null) {
            throw new AzureusCoreException("core not instantiated");
        }
        return singleton;
    }

    protected AzureusCoreImpl() {
        COConfigurationManager.initialise();
        MessageText.loadBundle();
        AEDiagnostics.startup();
        AEDiagnostics.markDirty();
        AETemporaryFileHandler.startup();
        AEThread.setOurThread();
        this.crypto_manager = CryptoManagerFactory.getSingleton();
        PlatformManagerFactory.getPlatformManager().addListener(new PlatformManagerListener(){

            public void eventOccurred(int type) {
                if (type == 1) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Platform manager requested shutdown"));
                    }
                    AzureusCoreImpl.this.stop();
                }
            }
        });
        NetworkManager.getSingleton();
        PeerManager.getSingleton();
        TorrentSessionManager.getSingleton().init();
        this.pi = PluginInitializer.getSingleton(this, this.initialisation_op);
        this.instance_manager = AZInstanceManagerFactory.getSingleton(this);
        this.speed_manager = SpeedManagerFactory.createSpeedManager(this, new SpeedManagerAdapter(){

            public int getCurrentProtocolUploadSpeed() {
                if (AzureusCoreImpl.this.global_manager != null) {
                    GlobalManagerStats stats = AzureusCoreImpl.this.global_manager.getStats();
                    return stats.getProtocolSendRateNoLAN();
                }
                return 0;
            }

            public int getCurrentDataUploadSpeed() {
                if (AzureusCoreImpl.this.global_manager != null) {
                    GlobalManagerStats stats = AzureusCoreImpl.this.global_manager.getStats();
                    return stats.getDataSendRateNoLAN();
                }
                return 0;
            }

            public int getCurrentUploadLimit() {
                String key = TransferSpeedValidator.getActiveUploadParameter(AzureusCoreImpl.this.global_manager);
                int k_per_second = COConfigurationManager.getIntParameter(key);
                int bytes_per_second = k_per_second == 0 ? Integer.MAX_VALUE : k_per_second * 1024;
                return bytes_per_second;
            }

            public void setCurrentUploadLimit(int bytes_per_second) {
                if (bytes_per_second != this.getCurrentUploadLimit()) {
                    String key = TransferSpeedValidator.getActiveUploadParameter(AzureusCoreImpl.this.global_manager);
                    int k_per_second = bytes_per_second == Integer.MAX_VALUE ? 0 : bytes_per_second / 1024;
                    COConfigurationManager.setParameter(key, k_per_second);
                }
            }

            public void setCurrentDownloadLimit(int bytes_per_second) {
                COConfigurationManager.setParameter(TransferSpeedValidator.getDownloadParameter(), bytes_per_second / 1024);
            }
        });
        this.nat_traverser = new NATTraverser(this);
        PeerNATTraverser.initialise(this);
    }

    public LocaleUtil getLocaleUtil() {
        return LocaleUtil.getSingleton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws AzureusCoreException {
        AEThread.setOurThread();
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new AzureusCoreException("Core: already started");
            }
            if (this.stopped) {
                throw new AzureusCoreException("Core: already stopped");
            }
            this.started = true;
        }
        finally {
            this.this_mon.exit();
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Loading of Plugins starts"));
        }
        this.pi.loadPlugins(this, false);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Loading of Plugins complete"));
        }
        this.global_manager = GlobalManagerFactory.create(new GlobalMangerProgressListener(){

            public void reportCurrentTask(String currentTask) {
                AzureusCoreImpl.this.initialisation_op.reportCurrentTask(currentTask);
            }

            public void reportPercent(int percent) {
                AzureusCoreImpl.this.initialisation_op.reportPercent(percent);
            }
        }, 0L);
        this.triggerLifeCycleComponentCreated(this.global_manager);
        this.pi.initialisePlugins();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Initializing Plugins complete"));
        }
        try {
            PluginInterface dht_pi = this.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi != null) {
                dht_pi.addEventListener(new PluginEventListener(){
                    private boolean first_dht = true;

                    public void handleEvent(PluginEvent ev) {
                        if (ev.getType() == 1024 && this.first_dht) {
                            this.first_dht = false;
                            DHT dht = (DHT)ev.getValue();
                            AzureusCoreImpl.this.speed_manager.setSpeedTester(dht.getSpeedTester());
                            AzureusCoreImpl.this.global_manager.addListener(new GlobalManagerAdapter(this){
                                private final /* synthetic */ 4 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void seedingStatusChanged(boolean seeding_only_mode) {
                                    this.this$1.checkConfig();
                                }
                            });
                            COConfigurationManager.addAndFireParameterListeners(new String[]{"Auto Upload Speed Enabled", "Auto Upload Speed Seeding Enabled"}, new ParameterListener(this){
                                private final /* synthetic */ 4 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void parameterChanged(String parameterName) {
                                    this.this$1.checkConfig();
                                }
                            });
                        }
                    }

                    protected void checkConfig() {
                        String key = TransferSpeedValidator.getActiveAutoUploadParameter(AzureusCoreImpl.this.global_manager);
                        AzureusCoreImpl.this.speed_manager.setEnabled(COConfigurationManager.getBooleanParameter(key));
                    }
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        new AEThread("Plugin Init Complete"){

            public void runSupport() {
                AzureusCoreImpl.this.pi.initialisationComplete();
                for (int i = 0; i < AzureusCoreImpl.this.lifecycle_listeners.size(); ++i) {
                    try {
                        ((AzureusCoreLifecycleListener)AzureusCoreImpl.this.lifecycle_listeners.get(i)).started(AzureusCoreImpl.this);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }.start();
        NetworkManager.getSingleton().initialize();
        this.instance_manager.initialize();
        Runtime.getRuntime().addShutdownHook(new AEThread("Shutdown Hook"){

            public void runSupport() {
                Logger.log(new LogEvent(LOGID, "Shutdown hook triggered"));
                AzureusCoreImpl.this.stop();
            }
        });
        this.checkBadNatives();
    }

    public void triggerLifeCycleComponentCreated(AzureusCoreComponent component) {
        for (int i = 0; i < this.lifecycle_listeners.size(); ++i) {
            try {
                ((AzureusCoreLifecycleListener)this.lifecycle_listeners.get(i)).componentCreated(this, component);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void checkBadNatives() {
        PlatformManager p_man = PlatformManagerFactory.getPlatformManager();
        if (p_man.getPlatformType() == 1 && p_man.hasCapability(PlatformManagerCapabilities.TestNativeAvailability)) {
            String[] dlls = new String[]{"niphk", "nvappfilter", "netdog", "vlsp", "imon", "sarah"};
            for (int i = 0; i < dlls.length; ++i) {
                String dll = dlls[i];
                if (COConfigurationManager.getBooleanParameter("platform.win32.dll_found." + dll, false)) continue;
                try {
                    if (!p_man.testNativeAvailability(dll + ".dll")) continue;
                    COConfigurationManager.setParameter("platform.win32.dll_found." + dll, true);
                    String detail = MessageText.getString("platform.win32.baddll." + dll);
                    Logger.logTextResource(new LogAlert(true, 1, "platform.win32.baddll.info"), new String[]{dll + ".dll", detail});
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    private void runNonDaemon(final Runnable r) throws AzureusCoreException {
        if (!Thread.currentThread().isDaemon()) {
            r.run();
        } else {
            final AESemaphore sem = new AESemaphore("AzureusCore:runNonDaemon");
            final Throwable[] error = new Throwable[]{null};
            new AEThread("AzureusCore:runNonDaemon"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    try {
                        r.run();
                    }
                    catch (Throwable e) {
                        error[0] = e;
                    }
                    finally {
                        sem.release();
                    }
                }
            }.start();
            sem.reserve();
            if (error[0] != null) {
                if (error[0] instanceof AzureusCoreException) {
                    throw (AzureusCoreException)error[0];
                }
                throw new AzureusCoreException("Operation failed", error[0]);
            }
        }
    }

    public void stop() throws AzureusCoreException {
        this.runNonDaemon(new AERunnable(){

            public void runSupport() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Stop operation starts"));
                }
                AzureusCoreImpl.this.stopSupport(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSupport(boolean apply_updates) throws AzureusCoreException {
        int i;
        try {
            this.this_mon.enter();
            if (this.stopped) {
                COConfigurationManager.save();
                Logger.log(new LogEvent(LOGID, "Waiting for stop to complete"));
                this.stopping_sem.reserve();
                return;
            }
            this.stopped = true;
            if (!this.started) {
                Logger.log(new LogEvent(LOGID, "Core not started"));
                this.stopping_sem.releaseForever();
                return;
            }
        }
        finally {
            this.this_mon.exit();
        }
        ArrayList<AzureusCoreLifecycleListener> sync_listeners = new ArrayList<AzureusCoreLifecycleListener>();
        ArrayList<AzureusCoreLifecycleListener> async_listeners = new ArrayList<AzureusCoreLifecycleListener>();
        for (i = 0; i < this.lifecycle_listeners.size(); ++i) {
            AzureusCoreLifecycleListener l = (AzureusCoreLifecycleListener)this.lifecycle_listeners.get(i);
            if (l.syncInvokeRequired()) {
                sync_listeners.add(l);
                continue;
            }
            async_listeners.add(l);
        }
        try {
            for (i = 0; i < sync_listeners.size(); ++i) {
                try {
                    ((AzureusCoreLifecycleListener)sync_listeners.get(i)).stopping(this);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            ListenerManager.dispatchWithTimeout(async_listeners, new ListenerManagerDispatcher(){

                public void dispatch(Object listener, int type, Object value) {
                    ((AzureusCoreLifecycleListener)listener).stopping(AzureusCoreImpl.this);
                }
            }, 10000L);
            this.global_manager.stopGlobalManager();
            for (i = 0; i < sync_listeners.size(); ++i) {
                try {
                    ((AzureusCoreLifecycleListener)sync_listeners.get(i)).stopped(this);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            ListenerManager.dispatchWithTimeout(async_listeners, new ListenerManagerDispatcher(){

                public void dispatch(Object listener, int type, Object value) {
                    ((AzureusCoreLifecycleListener)listener).stopped(AzureusCoreImpl.this);
                }
            }, 10000L);
            NonDaemonTaskRunner.waitUntilIdle();
            AEDiagnostics.markClean();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Stop operation completes"));
            }
            if (apply_updates && this.getPluginManager().getDefaultPluginInterface().getUpdateManager().getInstallers().length > 0) {
                AzureusRestarterFactory.create(this).restart(true);
            }
            try {
                ThreadGroup tg = Thread.currentThread().getThreadGroup();
                Thread[] threads = new Thread[tg.activeCount() + 32];
                tg.enumerate(threads);
                for (int i2 = 0; i2 < threads.length; ++i2) {
                    final Thread t = threads[i2];
                    if (t == null || t == Thread.currentThread() || t.isDaemon() || AEThread.isOurThread(t)) continue;
                    new AEThread("VMKiller", true){

                        public void runSupport() {
                            try {
                                Thread.sleep(10000L);
                                Debug.out("Non-daemon thread found '" + t.getName() + "', force closing VM");
                                SESecurityManager.exitVM(0);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }.start();
                    break;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        finally {
            this.stopping_sem.releaseForever();
        }
    }

    public void requestStop() throws AzureusCoreException {
        if (this.stopped) {
            return;
        }
        this.runNonDaemon(new AERunnable(){

            public void runSupport() {
                for (int i = 0; i < AzureusCoreImpl.this.lifecycle_listeners.size(); ++i) {
                    if (((AzureusCoreLifecycleListener)AzureusCoreImpl.this.lifecycle_listeners.get(i)).stopRequested(AzureusCoreImpl.this)) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Request to stop the core has been denied"));
                    }
                    return;
                }
                AzureusCoreImpl.this.stop();
            }
        });
    }

    public void restart() throws AzureusCoreException {
        this.runNonDaemon(new AERunnable(){

            public void runSupport() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Restart operation starts"));
                }
                AzureusCoreImpl.this.checkRestartSupported();
                AzureusCoreImpl.this.stopSupport(false);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Restart operation: stop complete,restart initiated"));
                }
                AzureusRestarterFactory.create(AzureusCoreImpl.this).restart(false);
            }
        });
    }

    public void requestRestart() throws AzureusCoreException {
        this.runNonDaemon(new AERunnable(){

            public void runSupport() {
                AzureusCoreImpl.this.checkRestartSupported();
                for (int i = 0; i < AzureusCoreImpl.this.lifecycle_listeners.size(); ++i) {
                    AzureusCoreLifecycleListener l = (AzureusCoreLifecycleListener)AzureusCoreImpl.this.lifecycle_listeners.get(i);
                    if (l.restartRequested(AzureusCoreImpl.this)) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Request to restart the core has been denied"));
                    }
                    return;
                }
                AzureusCoreImpl.this.restart();
            }
        });
    }

    public void checkRestartSupported() throws AzureusCoreException {
        if (this.getPluginManager().getPluginInterfaceByClass("org.gudy.azureus2.update.UpdaterPatcher") == null) {
            Logger.log(new LogAlert(true, 3, "Can't restart without the 'azupdater' plugin installed"));
            throw new AzureusCoreException("Can't restart without the 'azupdater' plugin installed");
        }
    }

    public GlobalManager getGlobalManager() throws AzureusCoreException {
        if (this.global_manager == null) {
            throw new AzureusCoreException("Core not running");
        }
        return this.global_manager;
    }

    public TRHost getTrackerHost() throws AzureusCoreException {
        return TRHostFactory.getSingleton();
    }

    public PluginManagerDefaults getPluginManagerDefaults() throws AzureusCoreException {
        return PluginManager.getDefaults();
    }

    public PluginManager getPluginManager() throws AzureusCoreException {
        return PluginInitializer.getDefaultInterface().getPluginManager();
    }

    public IpFilterManager getIpFilterManager() throws AzureusCoreException {
        return IpFilterManagerFactory.getSingleton();
    }

    public AZInstanceManager getInstanceManager() {
        return this.instance_manager;
    }

    public SpeedManager getSpeedManager() {
        return this.speed_manager;
    }

    public CryptoManager getCryptoManager() {
        return this.crypto_manager;
    }

    public NATTraverser getNATTraverser() {
        return this.nat_traverser;
    }

    public AzureusCoreOperation createOperation(final int type) {
        AzureusCoreOperation op = new AzureusCoreOperation(){

            public int getOperationType() {
                return type;
            }

            public AzureusCoreOperationTask getTask() {
                return null;
            }

            public void reportCurrentTask(String task2) {
                AzureusCoreImpl.this.reportCurrentTask(this, task2);
            }

            public void reportPercent(int percent) {
                AzureusCoreImpl.this.reportPercent(this, percent);
            }
        };
        for (int i = 0; i < this.operation_listeners.size(); ++i) {
            try {
                ((AzureusCoreOperationListener)this.operation_listeners.get(i)).operationCreated(op);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return op;
    }

    public void createOperation(final int type, AzureusCoreOperationTask task2) {
        final AzureusCoreOperationTask[] f_task = new AzureusCoreOperationTask[]{task2};
        AzureusCoreOperation op = new AzureusCoreOperation(){

            public int getOperationType() {
                return type;
            }

            public AzureusCoreOperationTask getTask() {
                return f_task[0];
            }

            public void reportCurrentTask(String task2) {
                AzureusCoreImpl.this.reportCurrentTask(this, task2);
            }

            public void reportPercent(int percent) {
                AzureusCoreImpl.this.reportPercent(this, percent);
            }
        };
        for (int i = 0; i < this.operation_listeners.size(); ++i) {
            if (!((AzureusCoreOperationListener)this.operation_listeners.get(i)).operationCreated(op)) continue;
            f_task[0] = null;
        }
        if (f_task[0] != null) {
            task2.run(op);
        }
    }

    protected void reportCurrentTask(AzureusCoreOperation op, String currentTask) {
        if (op.getOperationType() == 1) {
            PluginInitializer.fireEvent(3, currentTask);
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AzureusCoreListener)this.listeners.get(i)).reportCurrentTask(op, currentTask);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void reportPercent(AzureusCoreOperation op, int percent) {
        if (op.getOperationType() == 1) {
            PluginInitializer.fireEvent(4, new Integer(percent));
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AzureusCoreListener)this.listeners.get(i)).reportPercent(op, percent);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void addLifecycleListener(AzureusCoreLifecycleListener l) {
        this.lifecycle_listeners.add(l);
    }

    public void removeLifecycleListener(AzureusCoreLifecycleListener l) {
        this.lifecycle_listeners.remove(l);
    }

    public void addListener(AzureusCoreListener l) {
        this.listeners.add(l);
    }

    public void removeListener(AzureusCoreListener l) {
        this.listeners.remove(l);
    }

    public void addOperationListener(AzureusCoreOperationListener l) {
        this.operation_listeners.add(l);
    }

    public void removeOperationListener(AzureusCoreOperationListener l) {
        this.operation_listeners.remove(l);
    }

    static {
        class_mon = new AEMonitor("AzureusCore:class");
    }
}

