/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccess;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class FMFileAccessLinear
implements FMFileAccess {
    private static final int WRITE_RETRY_LIMIT = 10;
    private static final int WRITE_RETRY_DELAY = 100;
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_VERBOSE = false;
    private FMFileImpl owner;

    protected FMFileAccessLinear(FMFileImpl _owner) {
        this.owner = _owner;
    }

    public long getLength(RandomAccessFile raf) throws FMFileManagerException {
        try {
            return raf.length();
        }
        catch (Throwable e) {
            throw new FMFileManagerException("getLength fails", e);
        }
    }

    public void setLength(RandomAccessFile raf, long length) throws FMFileManagerException {
        try {
            raf.setLength(length);
        }
        catch (Throwable e) {
            throw new FMFileManagerException("setLength fails", e);
        }
    }

    public void read(RandomAccessFile raf, DirectByteBuffer buffer, long offset) throws FMFileManagerException {
        if (raf == null) {
            throw new FMFileManagerException("read: raf is null");
        }
        FileChannel fc = raf.getChannel();
        if (!fc.isOpen()) {
            Debug.out("FileChannel is closed: " + this.owner.getName());
            throw new FMFileManagerException("read - file is closed");
        }
        long lRemainingBeforeRead = buffer.remaining((byte)4);
        try {
            fc.position(offset);
            while (fc.position() < fc.size() && buffer.hasRemaining((byte)4)) {
                buffer.read((byte)4, fc);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            throw new FMFileManagerException("read fails", e);
        }
    }

    public void write(RandomAccessFile raf, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        block13: {
            if (raf == null) {
                throw new FMFileManagerException("write fails: raf is null");
            }
            FileChannel fc = raf.getChannel();
            try {
                if (fc.isOpen()) {
                    long expected_write = 0L;
                    long actual_write = 0L;
                    boolean partial_write = false;
                    for (int i = 0; i < buffers.length; ++i) {
                        expected_write += (long)(buffers[i].limit((byte)4) - buffers[i].position((byte)4));
                    }
                    fc.position(position);
                    ByteBuffer[] bbs = new ByteBuffer[buffers.length];
                    Buffer last_bb = null;
                    for (int i = 0; i < bbs.length; ++i) {
                        bbs[i] = buffers[i].getBuffer((byte)4);
                        if (bbs[i].position() == bbs[i].limit()) continue;
                        last_bb = bbs[i];
                    }
                    if (last_bb != null) {
                        int loop = 0;
                        while (last_bb.position() != last_bb.limit()) {
                            long written = fc.write(bbs);
                            actual_write += written;
                            if (written > 0L) {
                                loop = 0;
                                if (last_bb.position() == last_bb.limit()) continue;
                                partial_write = true;
                                continue;
                            }
                            if (++loop == 10) {
                                Debug.out("FMFile::write: zero length write - abandoning");
                                throw new FMFileManagerException("write fails: retry limit exceeded");
                            }
                            try {
                                Thread.sleep(100 * loop);
                            }
                            catch (InterruptedException e) {
                                throw new FMFileManagerException("write fails: interrupted");
                            }
                        }
                    }
                    if (expected_write != actual_write) {
                        Debug.out("FMFile::write: **** partial write **** failed: expected = " + expected_write + ", actual = " + actual_write);
                        throw new FMFileManagerException("write fails: expected write/actual write mismatch");
                    }
                    if (!partial_write) break block13;
                }
                throw new FMFileManagerException("write fails, channel not open");
            }
            catch (Exception e) {
                throw new FMFileManagerException("write fails", e);
            }
        }
    }

    public void flush() throws FMFileManagerException {
    }

    public String getString() {
        return "linear";
    }
}

