/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.ext_viewer.jgoodies.looks.plastic;

import com.tonicsystems.ext_viewer.jgoodies.looks.LookUtils;
import com.tonicsystems.ext_viewer.jgoodies.looks.common.ButtonMarginListener;
import com.tonicsystems.ext_viewer.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import javax.swing.text.View;

public class PlasticToggleButtonUI
extends MetalToggleButtonUI {
    private static final PlasticToggleButtonUI INSTANCE = new PlasticToggleButtonUI();
    protected static final String HTML_KEY = "html";
    private boolean borderPaintsFocus;
    private PropertyChangeListener buttonMarginListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return INSTANCE;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        LookUtils.installNarrowMargin(abstractButton, this.getPropertyPrefix());
        this.borderPaintsFocus = Boolean.TRUE.equals(UIManager.get("ToggleButton.borderPaintsFocus"));
    }

    public void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        if (this.buttonMarginListener == null) {
            this.buttonMarginListener = new ButtonMarginListener(this.getPropertyPrefix());
        }
        abstractButton.addPropertyChangeListener("jgoodies.isNarrow", this.buttonMarginListener);
    }

    public void uninstallListeners(AbstractButton abstractButton) {
        super.uninstallListeners(abstractButton);
        abstractButton.removePropertyChangeListener(this.buttonMarginListener);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (jComponent.isOpaque()) {
            if (this.isToolBarButton(abstractButton)) {
                jComponent.setOpaque(false);
            } else if (abstractButton.isContentAreaFilled()) {
                graphics.setColor(jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
                if (this.is3D(abstractButton)) {
                    Rectangle rectangle = new Rectangle(1, 1, jComponent.getWidth() - 2, jComponent.getHeight() - 1);
                    PlasticUtils.add3DEffekt(graphics, rectangle);
                }
            }
        }
        this.paint(graphics, jComponent);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (this.borderPaintsFocus) {
            return;
        }
        boolean bl = false;
        int n2 = bl ? 3 : 2;
        int n3 = abstractButton.getWidth() - 1 - n2 * 2;
        int n4 = abstractButton.getHeight() - 1 - n2 * 2;
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(n2, n2, n3 - 1, n4 - 1);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Dimension dimension = abstractButton.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(dimension);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        graphics.setColor(abstractButton.getBackground());
        if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, abstractButton, rectangle2);
        }
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty(HTML_KEY);
            if (view != null) {
                view.paint(graphics, rectangle3);
            } else {
                this.paintText(graphics, jComponent, rectangle3, string);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, rectangle, rectangle3, rectangle2);
        }
    }

    protected boolean isToolBarButton(AbstractButton abstractButton) {
        Container container = abstractButton.getParent();
        return container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar);
    }

    protected boolean is3D(AbstractButton abstractButton) {
        if (PlasticUtils.force3D(abstractButton)) {
            return true;
        }
        if (PlasticUtils.forceFlat(abstractButton)) {
            return false;
        }
        ButtonModel buttonModel = abstractButton.getModel();
        return PlasticUtils.is3D("ToggleButton.") && abstractButton.isBorderPainted() && buttonModel.isEnabled() && !buttonModel.isPressed() && !(abstractButton.getBorder() instanceof EmptyBorder);
    }
}

