/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.ext_viewer.jgoodies.looks.plastic;

import com.tonicsystems.ext_viewer.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.tonicsystems.ext_viewer.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

final class PlasticIconFactory {
    private static Icon checkBoxIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuArrowIcon;
    private static Icon expandedTreeIcon;
    private static Icon collapsedTreeIcon;

    private PlasticIconFactory() {
    }

    private static void drawCheck(Graphics graphics, int n2, int n3) {
        graphics.translate(n2, n3);
        graphics.drawLine(3, 5, 3, 5);
        graphics.fillRect(3, 6, 2, 2);
        graphics.drawLine(4, 8, 9, 3);
        graphics.drawLine(5, 8, 9, 4);
        graphics.drawLine(5, 9, 9, 5);
        graphics.translate(-n2, -n3);
    }

    static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    static Icon getExpandedTreeIcon() {
        if (expandedTreeIcon == null) {
            expandedTreeIcon = new ExpandedTreeIcon();
        }
        return expandedTreeIcon;
    }

    static Icon getCollapsedTreeIcon() {
        if (collapsedTreeIcon == null) {
            collapsedTreeIcon = new CollapsedTreeIcon();
        }
        return collapsedTreeIcon;
    }

    static Icon getComboBoxButtonIcon() {
        return new ComboBoxButtonIcon();
    }

    private static class ComboBoxButtonIcon
    implements Icon,
    Serializable {
        private ComboBoxButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JComponent jComponent = (JComponent)component;
            int n4 = this.getIconWidth();
            graphics.translate(n2, n3);
            graphics.setColor(jComponent.isEnabled() ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlShadow());
            graphics.drawLine(0, 0, n4 - 1, 0);
            graphics.drawLine(1, 1, 1 + (n4 - 3), 1);
            graphics.drawLine(2, 2, 2 + (n4 - 5), 2);
            graphics.drawLine(3, 3, 3 + (n4 - 7), 3);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 8;
        }

        public int getIconHeight() {
            return 4;
        }
    }

    private static class CollapsedTreeIcon
    extends ExpandedTreeIcon {
        private CollapsedTreeIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            super.paintIcon(component, graphics, n2, n3);
            graphics.drawLine(n2 + 4, n3 + 2, n2 + 4, n3 + 6);
        }
    }

    private static class ExpandedTreeIcon
    implements Icon,
    Serializable {
        protected static final int SIZE = 9;
        protected static final int HALF_SIZE = 4;

        private ExpandedTreeIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Color color = component.getBackground();
            graphics.setColor(color != null ? color : Color.WHITE);
            graphics.fillRect(n2, n3, 8, 8);
            graphics.setColor(Color.GRAY);
            graphics.drawRect(n2, n3, 8, 8);
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n2 + 2, n3 + 4, n2 + 6, n3 + 4);
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int WIDTH = 4;
        private static final int HEIGHT = 8;

        private MenuArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JMenuItem jMenuItem = (JMenuItem)component;
            graphics.translate(n2, n3);
            if (PlasticUtils.isLeftToRight(jMenuItem)) {
                graphics.drawLine(0, 0, 0, 7);
                graphics.drawLine(1, 1, 1, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(3, 3, 3, 4);
            } else {
                graphics.drawLine(4, 0, 4, 7);
                graphics.drawLine(3, 1, 3, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(1, 3, 1, 4);
            }
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = 13;

        private RadioButtonMenuItemIcon() {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JMenuItem jMenuItem = (JMenuItem)component;
            if (jMenuItem.isSelected()) {
                this.drawDot(graphics, n2, n3);
            }
        }

        private void drawDot(Graphics graphics, int n2, int n3) {
            graphics.translate(n2, n3);
            graphics.drawLine(5, 4, 8, 4);
            graphics.fillRect(4, 5, 6, 4);
            graphics.drawLine(5, 9, 8, 9);
            graphics.translate(-n2, -n3);
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = 13;

        private CheckBoxMenuItemIcon() {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JMenuItem jMenuItem = (JMenuItem)component;
            if (jMenuItem.isSelected()) {
                PlasticIconFactory.drawCheck(graphics, n2, n3 + 1);
            }
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = 13;

        private CheckBoxIcon() {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            if (buttonModel.isEnabled()) {
                if (jCheckBox.isBorderPaintedFlat()) {
                    graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(n2, n3, 11, 11);
                    graphics.setColor(PlasticLookAndFeel.getControlHighlight());
                    graphics.fillRect(n2 + 1, n3 + 1, 10, 10);
                } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.fillRect(n2, n3, 12, 12);
                    PlasticUtils.drawPressed3DBorder(graphics, n2, n3, 13, 13);
                } else {
                    PlasticUtils.drawFlush3DBorder(graphics, n2, n3, 13, 13);
                }
                graphics.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(n2, n3, 11, 11);
            }
            if (buttonModel.isSelected()) {
                PlasticIconFactory.drawCheck(graphics, n2, n3);
            }
        }
    }
}

