/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.ext_viewer.jgoodies.looks.plastic;

import com.tonicsystems.ext_viewer.jgoodies.looks.plastic.BumpBuffer;
import com.tonicsystems.ext_viewer.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;

final class PlasticBumps
implements Icon {
    protected int xBumps;
    protected int yBumps;
    protected Color topColor;
    protected Color shadowColor;
    protected Color backColor;
    protected static Vector buffers = new Vector();
    protected BumpBuffer buffer;

    public PlasticBumps(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    public PlasticBumps(int n2, int n3) {
        this(n2, n3, PlasticLookAndFeel.getPrimaryControlHighlight(), PlasticLookAndFeel.getPrimaryControlDarkShadow(), PlasticLookAndFeel.getPrimaryControlShadow());
    }

    public PlasticBumps(int n2, int n3, Color color, Color color2, Color color3) {
        this.setBumpArea(n2, n3);
        this.setBumpColors(color, color2, color3);
    }

    private BumpBuffer getBuffer(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
        if (this.buffer != null && this.buffer.hasSameConfiguration(graphicsConfiguration, color, color2, color3)) {
            return this.buffer;
        }
        BumpBuffer bumpBuffer = null;
        Enumeration enumeration = buffers.elements();
        while (enumeration.hasMoreElements()) {
            BumpBuffer bumpBuffer2 = (BumpBuffer)enumeration.nextElement();
            if (!bumpBuffer2.hasSameConfiguration(graphicsConfiguration, color, color2, color3)) continue;
            bumpBuffer = bumpBuffer2;
            break;
        }
        if (bumpBuffer == null) {
            bumpBuffer = new BumpBuffer(graphicsConfiguration, this.topColor, this.shadowColor, this.backColor);
            buffers.addElement(bumpBuffer);
        }
        return bumpBuffer;
    }

    public void setBumpArea(Dimension dimension) {
        this.setBumpArea(dimension.width, dimension.height);
    }

    public void setBumpArea(int n2, int n3) {
        this.xBumps = n2 / 2;
        this.yBumps = n3 / 2;
    }

    public void setBumpColors(Color color, Color color2, Color color3) {
        this.topColor = color;
        this.shadowColor = color2;
        this.backColor = color3;
    }

    public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        GraphicsConfiguration graphicsConfiguration = graphics instanceof Graphics2D ? ((Graphics2D)graphics).getDeviceConfiguration() : null;
        this.buffer = this.getBuffer(graphicsConfiguration, this.topColor, this.shadowColor, this.backColor);
        int n4 = this.buffer.getImageSize().width;
        int n5 = this.buffer.getImageSize().height;
        int n6 = this.getIconWidth();
        int n7 = this.getIconHeight();
        int n8 = n2 + n6;
        int n9 = n3 + n7;
        int n10 = n2;
        while (n3 < n9) {
            int n11 = Math.min(n9 - n3, n5);
            for (n2 = n10; n2 < n8; n2 += n4) {
                int n12 = Math.min(n8 - n2, n4);
                graphics.drawImage(this.buffer.getImage(), n2, n3, n2 + n12, n3 + n11, 0, 0, n12, n11, null);
            }
            n3 += n5;
        }
    }

    public int getIconWidth() {
        return this.xBumps * 2;
    }

    public int getIconHeight() {
        return this.yBumps * 2;
    }
}

