/*
Copyright (c) 2006-2007, Tom Thielicke IT Solutions

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.
*/

/****************************************************************
**
** Definition of the TrainingPage, DatabasePage and
** OtherPage class
** File name: settingspages.h
**
****************************************************************/

#ifndef SETTINGPAGES_H
#define SETTINGPAGES_H

#include <QWidget>
#include <QLabel>
#include <QSpinBox>
#include <QPushButton>
#include <QGroupBox>
#include <QRadioButton>
#include <QCheckBox>
#include <QComboBox>
#include <QLineEdit>
#include <QFont>
#include <QString>

class TrainingPage : public QWidget {
	Q_OBJECT

	public:
		TrainingPage(QWidget *parent = 0);

		//! Writes all user settings to hard disk.
		void writeSettings();

	public slots:

		//! Slot, shows the font setting window.
		/*!
			After the user clicked the font button, this function creates
			a QFontDialog and sets the new font if user has choosen one.
		*/
		void setFont();

		void toggleLayout(int index);

	private:
		//! Creates a radiobutton with windows and mac keyboard layout items.
		void createGroupKeyboardLayout();

    	//! Creates a ticker font button and the ticker speed spin box.
		void createGroupTickerFont();

    	//! Creates a group with the sound output selection.
		void createGroupSoundOutput();

		//! Creates the layout of the complete class.
		void createLayout();

		//! Sets the name of the font button.
		void setFontButtonLabel();

		//! Reads all user settings.
		void readSettings();

		QLabel *labelTickerFont;
		QLabel *labelTickerSpeed;
		QLabel *labelDatabasePath;
		QSpinBox *spinTickerSpeed;
		QGroupBox *groupKeyboardLayout;
		QGroupBox *groupTickerFont;
		QGroupBox *groupSoundOutput;
		QComboBox *comboLayout;
		QComboBox *comboLayoutOs;
		QComboBox *comboLayoutCh;
		QPushButton *buttonSetFont;
		QFont tickerFont;
		QRadioButton *radioSoundcard;
		QRadioButton *radioSpeaker;
};

class DatabasePage : public QWidget {
	Q_OBJECT

	public:
		DatabasePage(QWidget *parent = 0);

		//! Writes all user settings to hard disk.
		void writeSettings();

	private slots:

		//! Slot, deletes the content of the user lessons table.
		/*!
			After the user clicked the reset user data button, this function
			deletes the content data of the user lesson table over
			StartSql class.

			@see StartSql
		*/
		void deleteUserLessonList();

		//! Slot, deletes the content of the user chars table.
		/*!
			After the user clicked the reset user data button, this function
			deletes the content data of the user chars table over
			StartSql class.

			@see StartSql
		*/
		void deleteUserChars();

		//! Slot, opens and cheks the database path file dialog.
		/*!
			After the user clicked the browse button, this function
			shows a file dialog. After that, the exist of the file
			is checked.
		*/
		void setDatabasePath();

	private:

    	//! Creates two user data reset buttons.
		void createGroupUserReset();

    	//! Creates a database path control.
		void createGroupDatabase();

		//! Creates the layout of the complete class.
		void createLayout();

		//! Reads all user settings.
		void readSettings();

		QLabel *labelDatabasePath;
		QLabel *labelDatabaseExplain;
		QLineEdit *lineDatabasePath;
		QGroupBox *groupUserReset;
		QGroupBox *groupDatabase;
		QPushButton *buttonLessonsReset;
		QPushButton *buttonCharsReset;
		QPushButton *buttonDatabasePath;
		QString currentDatabasePath;
};

class OtherPage : public QWidget {
	Q_OBJECT

	public:
		OtherPage(QWidget *parent = 0);

		//! Writes all user settings to hard disk.
		void writeSettings();

	private:

    	//! Creates a group with check boxes to en-/disable info dialogs.
		void createGroupDialogCheck();

    	//! Creates a group with check boxes to en-/disable info dialogs.
		void createGroupAdaptation();

		//! Creates the layout of the complete class.
		void createLayout();

		//! Reads all user settings.
		void readSettings();

		QGroupBox *groupDialogCheck;
		QGroupBox *groupAdaptation;
		QCheckBox *checkIllustration;
		QCheckBox *checkIntelligence;
		QCheckBox *checkLimitLesson;
		QCheckBox *checkDbUpdate;
		QCheckBox *checkLessonPublish;
};

#endif
